// ##### ENDFILE "RangedIntegerFormValueWrap.cpp"


// ##### BEGINFILE "ChoiceFormValueWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IChoiceFormValue.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_CHOICEFORMVALUE

#include "ChoiceFormValueWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(ChoiceFormValueWrap)

//
// IFormValue properties
//

STDMETHODIMP ChoiceFormValueWrap::COMGETTER(Type)(FormValueType_T *aType)
{
    LogRelFlow(("{%p} %s: enter aType=%p\n", this, "ChoiceFormValue::getType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_TYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getType(aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_TYPE_RETURN(this, hrc, 0 /*normal*/,*aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aType=%RU32 hrc=%Rhrc\n", this, "ChoiceFormValue::getType", *aType, hrc));
    return hrc;
}

STDMETHODIMP ChoiceFormValueWrap::COMGETTER(Generation)(LONG *aGeneration)
{
    LogRelFlow(("{%p} %s: enter aGeneration=%p\n", this, "ChoiceFormValue::getGeneration", aGeneration));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGeneration);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_GENERATION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGeneration(aGeneration);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_GENERATION_RETURN(this, hrc, 0 /*normal*/,*aGeneration);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_GENERATION_RETURN(this, hrc, 1 /*hrc exception*/,*aGeneration);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_GENERATION_RETURN(this, hrc, 9 /*unhandled exception*/,*aGeneration);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aGeneration=%RI32 hrc=%Rhrc\n", this, "ChoiceFormValue::getGeneration", *aGeneration, hrc));
    return hrc;
}

STDMETHODIMP ChoiceFormValueWrap::COMGETTER(Enabled)(BOOL *aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%p\n", this, "ChoiceFormValue::getEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_ENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEnabled(aEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_ENABLED_RETURN(this, hrc, 0 /*normal*/,*aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEnabled=%RTbool hrc=%Rhrc\n", this, "ChoiceFormValue::getEnabled", *aEnabled, hrc));
    return hrc;
}

STDMETHODIMP ChoiceFormValueWrap::COMGETTER(Visible)(BOOL *aVisible)
{
    LogRelFlow(("{%p} %s: enter aVisible=%p\n", this, "ChoiceFormValue::getVisible", aVisible));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVisible);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_VISIBLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVisible(aVisible);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_VISIBLE_RETURN(this, hrc, 0 /*normal*/,*aVisible != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_VISIBLE_RETURN(this, hrc, 1 /*hrc exception*/,*aVisible != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_VISIBLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aVisible != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVisible=%RTbool hrc=%Rhrc\n", this, "ChoiceFormValue::getVisible", *aVisible, hrc));
    return hrc;
}

STDMETHODIMP ChoiceFormValueWrap::COMGETTER(Label)(BSTR *aLabel)
{
    LogRelFlow(("{%p} %s: enter aLabel=%p\n", this, "ChoiceFormValue::getLabel", aLabel));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLabel);
        BSTROutConverter TmpLabel(aLabel);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_LABEL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLabel(TmpLabel.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_LABEL_RETURN(this, hrc, 0 /*normal*/,TmpLabel.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_LABEL_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_LABEL_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLabel=%ls hrc=%Rhrc\n", this, "ChoiceFormValue::getLabel", *aLabel, hrc));
    return hrc;
}

STDMETHODIMP ChoiceFormValueWrap::COMGETTER(Description)(BSTR *aDescription)
{
    LogRelFlow(("{%p} %s: enter aDescription=%p\n", this, "ChoiceFormValue::getDescription", aDescription));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDescription);
        BSTROutConverter TmpDescription(aDescription);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_DESCRIPTION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDescription(TmpDescription.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_DESCRIPTION_RETURN(this, hrc, 0 /*normal*/,TmpDescription.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_DESCRIPTION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_DESCRIPTION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDescription=%ls hrc=%Rhrc\n", this, "ChoiceFormValue::getDescription", *aDescription, hrc));
    return hrc;
}

STDMETHODIMP ChoiceFormValueWrap::COMGETTER(Help)(BSTR *aHelp)
{
    LogRelFlow(("{%p} %s: enter aHelp=%p\n", this, "ChoiceFormValue::getHelp", aHelp));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHelp);
        BSTROutConverter TmpHelp(aHelp);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_HELP_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHelp(TmpHelp.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_HELP_RETURN(this, hrc, 0 /*normal*/,TmpHelp.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_HELP_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_HELP_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHelp=%ls hrc=%Rhrc\n", this, "ChoiceFormValue::getHelp", *aHelp, hrc));
    return hrc;
}

STDMETHODIMP ChoiceFormValueWrap::COMGETTER(InternalAndReservedAttribute1IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ChoiceFormValueWrap::COMGETTER(InternalAndReservedAttribute2IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ChoiceFormValueWrap::COMGETTER(InternalAndReservedAttribute3IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ChoiceFormValueWrap::COMGETTER(InternalAndReservedAttribute4IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ChoiceFormValueWrap::COMGETTER(InternalAndReservedAttribute5IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ChoiceFormValueWrap::COMGETTER(InternalAndReservedAttribute6IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ChoiceFormValueWrap::COMGETTER(InternalAndReservedAttribute7IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ChoiceFormValueWrap::COMGETTER(InternalAndReservedAttribute8IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

//
// IChoiceFormValue properties
//

STDMETHODIMP ChoiceFormValueWrap::COMGETTER(Values)(ComSafeArrayOut(BSTR, aValues))
{
    LogRelFlow(("{%p} %s: enter aValues=%p\n", this, "ChoiceFormValue::getValues", aValues));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValues);
        ArrayBSTROutConverter TmpValues(ComSafeArrayOutArg(aValues));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_VALUES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getValues(TmpValues.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_VALUES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpValues.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_VALUES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GET_VALUES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aValues=%zu hrc=%Rhrc\n", this, "ChoiceFormValue::getValues", ComSafeArraySize(*aValues), hrc));
    return hrc;
}

STDMETHODIMP ChoiceFormValueWrap::COMGETTER(InternalAndReservedAttribute1IChoiceFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ChoiceFormValueWrap::COMGETTER(InternalAndReservedAttribute2IChoiceFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ChoiceFormValueWrap::COMGETTER(InternalAndReservedAttribute3IChoiceFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ChoiceFormValueWrap::COMGETTER(InternalAndReservedAttribute4IChoiceFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IFormValue methods
//

STDMETHODIMP ChoiceFormValueWrap::InternalAndReservedMethod1IFormValue()
{
    return E_NOTIMPL;
}

STDMETHODIMP ChoiceFormValueWrap::InternalAndReservedMethod2IFormValue()
{
    return E_NOTIMPL;
}

STDMETHODIMP ChoiceFormValueWrap::InternalAndReservedMethod3IFormValue()
{
    return E_NOTIMPL;
}

STDMETHODIMP ChoiceFormValueWrap::InternalAndReservedMethod4IFormValue()
{
    return E_NOTIMPL;
}

//
// IChoiceFormValue methods
//

STDMETHODIMP ChoiceFormValueWrap::GetSelectedIndex(LONG *aIndex)
{
    LogRelFlow(("{%p} %s:enter aIndex=%p\n", this, "ChoiceFormValue::getSelectedIndex", aIndex));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIndex);


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GETSELECTEDINDEX_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSelectedIndex(aIndex);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GETSELECTEDINDEX_RETURN(this, hrc, 0 /*normal*/, *aIndex);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GETSELECTEDINDEX_RETURN(this, hrc, 1 /*hrc exception*/, *aIndex);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_GETSELECTEDINDEX_RETURN(this, hrc, 9 /*unhandled exception*/, *aIndex);
#endif
    }

    LogRelFlow(("{%p} %s: leave aIndex=%RI32 hrc=%Rhrc\n", this, "ChoiceFormValue::getSelectedIndex", *aIndex, hrc));
    return hrc;
}

STDMETHODIMP ChoiceFormValueWrap::SetSelectedIndex(LONG aIndex,
                                                   IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aIndex=%RI32 aProgress=%p\n", this, "ChoiceFormValue::setSelectedIndex", aIndex, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_SETSELECTEDINDEX_ENTER(this, aIndex);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setSelectedIndex(aIndex,
                                   TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_SETSELECTEDINDEX_RETURN(this, hrc, 0 /*normal*/, aIndex, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_SETSELECTEDINDEX_RETURN(this, hrc, 1 /*hrc exception*/, aIndex, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CHOICEFORMVALUE_SETSELECTEDINDEX_RETURN(this, hrc, 9 /*unhandled exception*/, aIndex, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "ChoiceFormValue::setSelectedIndex", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP ChoiceFormValueWrap::InternalAndReservedMethod1IChoiceFormValue()
{
    return E_NOTIMPL;
}

STDMETHODIMP ChoiceFormValueWrap::InternalAndReservedMethod2IChoiceFormValue()
{
    return E_NOTIMPL;
}

STDMETHODIMP ChoiceFormValueWrap::InternalAndReservedMethod3IChoiceFormValue()
{
    return E_NOTIMPL;
}

STDMETHODIMP ChoiceFormValueWrap::InternalAndReservedMethod4IChoiceFormValue()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(ChoiceFormValueWrap)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(ChoiceFormValueWrap, IChoiceFormValue, IFormValue)
#endif // VBOX_WITH_XPCOM

