// ##### ENDFILE "FileWrap.cpp"


// ##### BEGINFILE "FsObjInfoWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IFsObjInfo.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_FSOBJINFO

#include "FsObjInfoWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(FsObjInfoWrap)

//
// IFsObjInfo properties
//

STDMETHODIMP FsObjInfoWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "FsObjInfo::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "FsObjInfo::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP FsObjInfoWrap::COMGETTER(Type)(FsObjType_T *aType)
{
    LogRelFlow(("{%p} %s: enter aType=%p\n", this, "FsObjInfo::getType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_TYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getType(aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_TYPE_RETURN(this, hrc, 0 /*normal*/,*aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aType=%RU32 hrc=%Rhrc\n", this, "FsObjInfo::getType", *aType, hrc));
    return hrc;
}

STDMETHODIMP FsObjInfoWrap::COMGETTER(FileAttributes)(BSTR *aFileAttributes)
{
    LogRelFlow(("{%p} %s: enter aFileAttributes=%p\n", this, "FsObjInfo::getFileAttributes", aFileAttributes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFileAttributes);
        BSTROutConverter TmpFileAttributes(aFileAttributes);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_FILEATTRIBUTES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFileAttributes(TmpFileAttributes.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_FILEATTRIBUTES_RETURN(this, hrc, 0 /*normal*/,TmpFileAttributes.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_FILEATTRIBUTES_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_FILEATTRIBUTES_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFileAttributes=%ls hrc=%Rhrc\n", this, "FsObjInfo::getFileAttributes", *aFileAttributes, hrc));
    return hrc;
}

STDMETHODIMP FsObjInfoWrap::COMGETTER(ObjectSize)(LONG64 *aObjectSize)
{
    LogRelFlow(("{%p} %s: enter aObjectSize=%p\n", this, "FsObjInfo::getObjectSize", aObjectSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aObjectSize);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_OBJECTSIZE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getObjectSize(aObjectSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_OBJECTSIZE_RETURN(this, hrc, 0 /*normal*/,*aObjectSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_OBJECTSIZE_RETURN(this, hrc, 1 /*hrc exception*/,*aObjectSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_OBJECTSIZE_RETURN(this, hrc, 9 /*unhandled exception*/,*aObjectSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aObjectSize=%RI64 hrc=%Rhrc\n", this, "FsObjInfo::getObjectSize", *aObjectSize, hrc));
    return hrc;
}

STDMETHODIMP FsObjInfoWrap::COMGETTER(AllocatedSize)(LONG64 *aAllocatedSize)
{
    LogRelFlow(("{%p} %s: enter aAllocatedSize=%p\n", this, "FsObjInfo::getAllocatedSize", aAllocatedSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAllocatedSize);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_ALLOCATEDSIZE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAllocatedSize(aAllocatedSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_ALLOCATEDSIZE_RETURN(this, hrc, 0 /*normal*/,*aAllocatedSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_ALLOCATEDSIZE_RETURN(this, hrc, 1 /*hrc exception*/,*aAllocatedSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_ALLOCATEDSIZE_RETURN(this, hrc, 9 /*unhandled exception*/,*aAllocatedSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAllocatedSize=%RI64 hrc=%Rhrc\n", this, "FsObjInfo::getAllocatedSize", *aAllocatedSize, hrc));
    return hrc;
}

STDMETHODIMP FsObjInfoWrap::COMGETTER(AccessTime)(LONG64 *aAccessTime)
{
    LogRelFlow(("{%p} %s: enter aAccessTime=%p\n", this, "FsObjInfo::getAccessTime", aAccessTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAccessTime);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_ACCESSTIME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAccessTime(aAccessTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_ACCESSTIME_RETURN(this, hrc, 0 /*normal*/,*aAccessTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_ACCESSTIME_RETURN(this, hrc, 1 /*hrc exception*/,*aAccessTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_ACCESSTIME_RETURN(this, hrc, 9 /*unhandled exception*/,*aAccessTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAccessTime=%RI64 hrc=%Rhrc\n", this, "FsObjInfo::getAccessTime", *aAccessTime, hrc));
    return hrc;
}

STDMETHODIMP FsObjInfoWrap::COMGETTER(BirthTime)(LONG64 *aBirthTime)
{
    LogRelFlow(("{%p} %s: enter aBirthTime=%p\n", this, "FsObjInfo::getBirthTime", aBirthTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBirthTime);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_BIRTHTIME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getBirthTime(aBirthTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_BIRTHTIME_RETURN(this, hrc, 0 /*normal*/,*aBirthTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_BIRTHTIME_RETURN(this, hrc, 1 /*hrc exception*/,*aBirthTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_BIRTHTIME_RETURN(this, hrc, 9 /*unhandled exception*/,*aBirthTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aBirthTime=%RI64 hrc=%Rhrc\n", this, "FsObjInfo::getBirthTime", *aBirthTime, hrc));
    return hrc;
}

STDMETHODIMP FsObjInfoWrap::COMGETTER(ChangeTime)(LONG64 *aChangeTime)
{
    LogRelFlow(("{%p} %s: enter aChangeTime=%p\n", this, "FsObjInfo::getChangeTime", aChangeTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aChangeTime);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_CHANGETIME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getChangeTime(aChangeTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_CHANGETIME_RETURN(this, hrc, 0 /*normal*/,*aChangeTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_CHANGETIME_RETURN(this, hrc, 1 /*hrc exception*/,*aChangeTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_CHANGETIME_RETURN(this, hrc, 9 /*unhandled exception*/,*aChangeTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aChangeTime=%RI64 hrc=%Rhrc\n", this, "FsObjInfo::getChangeTime", *aChangeTime, hrc));
    return hrc;
}

STDMETHODIMP FsObjInfoWrap::COMGETTER(ModificationTime)(LONG64 *aModificationTime)
{
    LogRelFlow(("{%p} %s: enter aModificationTime=%p\n", this, "FsObjInfo::getModificationTime", aModificationTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aModificationTime);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_MODIFICATIONTIME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getModificationTime(aModificationTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_MODIFICATIONTIME_RETURN(this, hrc, 0 /*normal*/,*aModificationTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_MODIFICATIONTIME_RETURN(this, hrc, 1 /*hrc exception*/,*aModificationTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_MODIFICATIONTIME_RETURN(this, hrc, 9 /*unhandled exception*/,*aModificationTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aModificationTime=%RI64 hrc=%Rhrc\n", this, "FsObjInfo::getModificationTime", *aModificationTime, hrc));
    return hrc;
}

STDMETHODIMP FsObjInfoWrap::COMGETTER(UID)(LONG *aUID)
{
    LogRelFlow(("{%p} %s: enter aUID=%p\n", this, "FsObjInfo::getUID", aUID));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUID);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_UID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUID(aUID);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_UID_RETURN(this, hrc, 0 /*normal*/,*aUID);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_UID_RETURN(this, hrc, 1 /*hrc exception*/,*aUID);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_UID_RETURN(this, hrc, 9 /*unhandled exception*/,*aUID);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUID=%RI32 hrc=%Rhrc\n", this, "FsObjInfo::getUID", *aUID, hrc));
    return hrc;
}

STDMETHODIMP FsObjInfoWrap::COMGETTER(UserName)(BSTR *aUserName)
{
    LogRelFlow(("{%p} %s: enter aUserName=%p\n", this, "FsObjInfo::getUserName", aUserName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUserName);
        BSTROutConverter TmpUserName(aUserName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_USERNAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUserName(TmpUserName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_USERNAME_RETURN(this, hrc, 0 /*normal*/,TmpUserName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_USERNAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_USERNAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUserName=%ls hrc=%Rhrc\n", this, "FsObjInfo::getUserName", *aUserName, hrc));
    return hrc;
}

STDMETHODIMP FsObjInfoWrap::COMGETTER(GID)(LONG *aGID)
{
    LogRelFlow(("{%p} %s: enter aGID=%p\n", this, "FsObjInfo::getGID", aGID));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGID);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_GID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGID(aGID);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_GID_RETURN(this, hrc, 0 /*normal*/,*aGID);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_GID_RETURN(this, hrc, 1 /*hrc exception*/,*aGID);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_GID_RETURN(this, hrc, 9 /*unhandled exception*/,*aGID);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aGID=%RI32 hrc=%Rhrc\n", this, "FsObjInfo::getGID", *aGID, hrc));
    return hrc;
}

STDMETHODIMP FsObjInfoWrap::COMGETTER(GroupName)(BSTR *aGroupName)
{
    LogRelFlow(("{%p} %s: enter aGroupName=%p\n", this, "FsObjInfo::getGroupName", aGroupName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGroupName);
        BSTROutConverter TmpGroupName(aGroupName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_GROUPNAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGroupName(TmpGroupName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_GROUPNAME_RETURN(this, hrc, 0 /*normal*/,TmpGroupName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_GROUPNAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_GROUPNAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aGroupName=%ls hrc=%Rhrc\n", this, "FsObjInfo::getGroupName", *aGroupName, hrc));
    return hrc;
}

STDMETHODIMP FsObjInfoWrap::COMGETTER(NodeId)(LONG64 *aNodeId)
{
    LogRelFlow(("{%p} %s: enter aNodeId=%p\n", this, "FsObjInfo::getNodeId", aNodeId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNodeId);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_NODEID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNodeId(aNodeId);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_NODEID_RETURN(this, hrc, 0 /*normal*/,*aNodeId);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_NODEID_RETURN(this, hrc, 1 /*hrc exception*/,*aNodeId);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_NODEID_RETURN(this, hrc, 9 /*unhandled exception*/,*aNodeId);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNodeId=%RI64 hrc=%Rhrc\n", this, "FsObjInfo::getNodeId", *aNodeId, hrc));
    return hrc;
}

STDMETHODIMP FsObjInfoWrap::COMGETTER(NodeIdDevice)(ULONG *aNodeIdDevice)
{
    LogRelFlow(("{%p} %s: enter aNodeIdDevice=%p\n", this, "FsObjInfo::getNodeIdDevice", aNodeIdDevice));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNodeIdDevice);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_NODEIDDEVICE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNodeIdDevice(aNodeIdDevice);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_NODEIDDEVICE_RETURN(this, hrc, 0 /*normal*/,*aNodeIdDevice);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_NODEIDDEVICE_RETURN(this, hrc, 1 /*hrc exception*/,*aNodeIdDevice);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_NODEIDDEVICE_RETURN(this, hrc, 9 /*unhandled exception*/,*aNodeIdDevice);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNodeIdDevice=%RU32 hrc=%Rhrc\n", this, "FsObjInfo::getNodeIdDevice", *aNodeIdDevice, hrc));
    return hrc;
}

STDMETHODIMP FsObjInfoWrap::COMGETTER(HardLinks)(ULONG *aHardLinks)
{
    LogRelFlow(("{%p} %s: enter aHardLinks=%p\n", this, "FsObjInfo::getHardLinks", aHardLinks));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHardLinks);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_HARDLINKS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHardLinks(aHardLinks);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_HARDLINKS_RETURN(this, hrc, 0 /*normal*/,*aHardLinks);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_HARDLINKS_RETURN(this, hrc, 1 /*hrc exception*/,*aHardLinks);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_HARDLINKS_RETURN(this, hrc, 9 /*unhandled exception*/,*aHardLinks);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHardLinks=%RU32 hrc=%Rhrc\n", this, "FsObjInfo::getHardLinks", *aHardLinks, hrc));
    return hrc;
}

STDMETHODIMP FsObjInfoWrap::COMGETTER(DeviceNumber)(ULONG *aDeviceNumber)
{
    LogRelFlow(("{%p} %s: enter aDeviceNumber=%p\n", this, "FsObjInfo::getDeviceNumber", aDeviceNumber));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDeviceNumber);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_DEVICENUMBER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDeviceNumber(aDeviceNumber);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_DEVICENUMBER_RETURN(this, hrc, 0 /*normal*/,*aDeviceNumber);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_DEVICENUMBER_RETURN(this, hrc, 1 /*hrc exception*/,*aDeviceNumber);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_DEVICENUMBER_RETURN(this, hrc, 9 /*unhandled exception*/,*aDeviceNumber);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDeviceNumber=%RU32 hrc=%Rhrc\n", this, "FsObjInfo::getDeviceNumber", *aDeviceNumber, hrc));
    return hrc;
}

STDMETHODIMP FsObjInfoWrap::COMGETTER(GenerationId)(ULONG *aGenerationId)
{
    LogRelFlow(("{%p} %s: enter aGenerationId=%p\n", this, "FsObjInfo::getGenerationId", aGenerationId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGenerationId);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_GENERATIONID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGenerationId(aGenerationId);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_GENERATIONID_RETURN(this, hrc, 0 /*normal*/,*aGenerationId);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_GENERATIONID_RETURN(this, hrc, 1 /*hrc exception*/,*aGenerationId);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_GENERATIONID_RETURN(this, hrc, 9 /*unhandled exception*/,*aGenerationId);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aGenerationId=%RU32 hrc=%Rhrc\n", this, "FsObjInfo::getGenerationId", *aGenerationId, hrc));
    return hrc;
}

STDMETHODIMP FsObjInfoWrap::COMGETTER(UserFlags)(ULONG *aUserFlags)
{
    LogRelFlow(("{%p} %s: enter aUserFlags=%p\n", this, "FsObjInfo::getUserFlags", aUserFlags));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUserFlags);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_USERFLAGS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUserFlags(aUserFlags);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_USERFLAGS_RETURN(this, hrc, 0 /*normal*/,*aUserFlags);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_USERFLAGS_RETURN(this, hrc, 1 /*hrc exception*/,*aUserFlags);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FSOBJINFO_GET_USERFLAGS_RETURN(this, hrc, 9 /*unhandled exception*/,*aUserFlags);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUserFlags=%RU32 hrc=%Rhrc\n", this, "FsObjInfo::getUserFlags", *aUserFlags, hrc));
    return hrc;
}

STDMETHODIMP FsObjInfoWrap::COMGETTER(InternalAndReservedAttribute1IFsObjInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP FsObjInfoWrap::COMGETTER(InternalAndReservedAttribute2IFsObjInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP FsObjInfoWrap::COMGETTER(InternalAndReservedAttribute3IFsObjInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP FsObjInfoWrap::COMGETTER(InternalAndReservedAttribute4IFsObjInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP FsObjInfoWrap::COMGETTER(InternalAndReservedAttribute5IFsObjInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP FsObjInfoWrap::COMGETTER(InternalAndReservedAttribute6IFsObjInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP FsObjInfoWrap::COMGETTER(InternalAndReservedAttribute7IFsObjInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP FsObjInfoWrap::COMGETTER(InternalAndReservedAttribute8IFsObjInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IFsObjInfo methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(FsObjInfoWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(FsObjInfoWrap, IFsObjInfo)
#endif // VBOX_WITH_XPCOM

