// ##### ENDFILE "HostUpdateWrap.cpp"


// ##### BEGINFILE "GuestOSTypeWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IGuestOSType.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_GUESTOSTYPE

#include "GuestOSTypeWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(GuestOSTypeWrap)

//
// IGuestOSType properties
//

STDMETHODIMP GuestOSTypeWrap::COMGETTER(FamilyId)(BSTR *aFamilyId)
{
    LogRelFlow(("{%p} %s: enter aFamilyId=%p\n", this, "GuestOSType::getFamilyId", aFamilyId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFamilyId);
        BSTROutConverter TmpFamilyId(aFamilyId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_FAMILYID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFamilyId(TmpFamilyId.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_FAMILYID_RETURN(this, hrc, 0 /*normal*/,TmpFamilyId.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_FAMILYID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_FAMILYID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFamilyId=%ls hrc=%Rhrc\n", this, "GuestOSType::getFamilyId", *aFamilyId, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(FamilyDescription)(BSTR *aFamilyDescription)
{
    LogRelFlow(("{%p} %s: enter aFamilyDescription=%p\n", this, "GuestOSType::getFamilyDescription", aFamilyDescription));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFamilyDescription);
        BSTROutConverter TmpFamilyDescription(aFamilyDescription);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_FAMILYDESCRIPTION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFamilyDescription(TmpFamilyDescription.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_FAMILYDESCRIPTION_RETURN(this, hrc, 0 /*normal*/,TmpFamilyDescription.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_FAMILYDESCRIPTION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_FAMILYDESCRIPTION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFamilyDescription=%ls hrc=%Rhrc\n", this, "GuestOSType::getFamilyDescription", *aFamilyDescription, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(Id)(BSTR *aId)
{
    LogRelFlow(("{%p} %s: enter aId=%p\n", this, "GuestOSType::getId", aId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aId);
        BSTROutConverter TmpId(aId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_ID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getId(TmpId.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_ID_RETURN(this, hrc, 0 /*normal*/,TmpId.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_ID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_ID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aId=%ls hrc=%Rhrc\n", this, "GuestOSType::getId", *aId, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(Description)(BSTR *aDescription)
{
    LogRelFlow(("{%p} %s: enter aDescription=%p\n", this, "GuestOSType::getDescription", aDescription));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDescription);
        BSTROutConverter TmpDescription(aDescription);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_DESCRIPTION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDescription(TmpDescription.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_DESCRIPTION_RETURN(this, hrc, 0 /*normal*/,TmpDescription.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_DESCRIPTION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_DESCRIPTION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDescription=%ls hrc=%Rhrc\n", this, "GuestOSType::getDescription", *aDescription, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(Is64Bit)(BOOL *aIs64Bit)
{
    LogRelFlow(("{%p} %s: enter aIs64Bit=%p\n", this, "GuestOSType::getIs64Bit", aIs64Bit));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIs64Bit);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_IS64BIT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIs64Bit(aIs64Bit);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_IS64BIT_RETURN(this, hrc, 0 /*normal*/,*aIs64Bit != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_IS64BIT_RETURN(this, hrc, 1 /*hrc exception*/,*aIs64Bit != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_IS64BIT_RETURN(this, hrc, 9 /*unhandled exception*/,*aIs64Bit != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIs64Bit=%RTbool hrc=%Rhrc\n", this, "GuestOSType::getIs64Bit", *aIs64Bit, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(RecommendedIOAPIC)(BOOL *aRecommendedIOAPIC)
{
    LogRelFlow(("{%p} %s: enter aRecommendedIOAPIC=%p\n", this, "GuestOSType::getRecommendedIOAPIC", aRecommendedIOAPIC));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommendedIOAPIC);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDIOAPIC_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommendedIOAPIC(aRecommendedIOAPIC);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDIOAPIC_RETURN(this, hrc, 0 /*normal*/,*aRecommendedIOAPIC != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDIOAPIC_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommendedIOAPIC != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDIOAPIC_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommendedIOAPIC != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommendedIOAPIC=%RTbool hrc=%Rhrc\n", this, "GuestOSType::getRecommendedIOAPIC", *aRecommendedIOAPIC, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(RecommendedVirtEx)(BOOL *aRecommendedVirtEx)
{
    LogRelFlow(("{%p} %s: enter aRecommendedVirtEx=%p\n", this, "GuestOSType::getRecommendedVirtEx", aRecommendedVirtEx));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommendedVirtEx);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDVIRTEX_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommendedVirtEx(aRecommendedVirtEx);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDVIRTEX_RETURN(this, hrc, 0 /*normal*/,*aRecommendedVirtEx != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDVIRTEX_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommendedVirtEx != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDVIRTEX_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommendedVirtEx != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommendedVirtEx=%RTbool hrc=%Rhrc\n", this, "GuestOSType::getRecommendedVirtEx", *aRecommendedVirtEx, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(RecommendedRAM)(ULONG *aRecommendedRAM)
{
    LogRelFlow(("{%p} %s: enter aRecommendedRAM=%p\n", this, "GuestOSType::getRecommendedRAM", aRecommendedRAM));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommendedRAM);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDRAM_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommendedRAM(aRecommendedRAM);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDRAM_RETURN(this, hrc, 0 /*normal*/,*aRecommendedRAM);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDRAM_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommendedRAM);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDRAM_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommendedRAM);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommendedRAM=%RU32 hrc=%Rhrc\n", this, "GuestOSType::getRecommendedRAM", *aRecommendedRAM, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(RecommendedGraphicsController)(GraphicsControllerType_T *aRecommendedGraphicsController)
{
    LogRelFlow(("{%p} %s: enter aRecommendedGraphicsController=%p\n", this, "GuestOSType::getRecommendedGraphicsController", aRecommendedGraphicsController));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommendedGraphicsController);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDGRAPHICSCONTROLLER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommendedGraphicsController(aRecommendedGraphicsController);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDGRAPHICSCONTROLLER_RETURN(this, hrc, 0 /*normal*/,*aRecommendedGraphicsController);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDGRAPHICSCONTROLLER_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommendedGraphicsController);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDGRAPHICSCONTROLLER_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommendedGraphicsController);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommendedGraphicsController=%RU32 hrc=%Rhrc\n", this, "GuestOSType::getRecommendedGraphicsController", *aRecommendedGraphicsController, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(RecommendedVRAM)(ULONG *aRecommendedVRAM)
{
    LogRelFlow(("{%p} %s: enter aRecommendedVRAM=%p\n", this, "GuestOSType::getRecommendedVRAM", aRecommendedVRAM));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommendedVRAM);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDVRAM_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommendedVRAM(aRecommendedVRAM);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDVRAM_RETURN(this, hrc, 0 /*normal*/,*aRecommendedVRAM);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDVRAM_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommendedVRAM);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDVRAM_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommendedVRAM);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommendedVRAM=%RU32 hrc=%Rhrc\n", this, "GuestOSType::getRecommendedVRAM", *aRecommendedVRAM, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(Recommended2DVideoAcceleration)(BOOL *aRecommended2DVideoAcceleration)
{
    LogRelFlow(("{%p} %s: enter aRecommended2DVideoAcceleration=%p\n", this, "GuestOSType::getRecommended2DVideoAcceleration", aRecommended2DVideoAcceleration));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommended2DVideoAcceleration);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDED2DVIDEOACCELERATION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommended2DVideoAcceleration(aRecommended2DVideoAcceleration);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDED2DVIDEOACCELERATION_RETURN(this, hrc, 0 /*normal*/,*aRecommended2DVideoAcceleration != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDED2DVIDEOACCELERATION_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommended2DVideoAcceleration != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDED2DVIDEOACCELERATION_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommended2DVideoAcceleration != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommended2DVideoAcceleration=%RTbool hrc=%Rhrc\n", this, "GuestOSType::getRecommended2DVideoAcceleration", *aRecommended2DVideoAcceleration, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(Recommended3DAcceleration)(BOOL *aRecommended3DAcceleration)
{
    LogRelFlow(("{%p} %s: enter aRecommended3DAcceleration=%p\n", this, "GuestOSType::getRecommended3DAcceleration", aRecommended3DAcceleration));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommended3DAcceleration);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDED3DACCELERATION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommended3DAcceleration(aRecommended3DAcceleration);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDED3DACCELERATION_RETURN(this, hrc, 0 /*normal*/,*aRecommended3DAcceleration != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDED3DACCELERATION_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommended3DAcceleration != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDED3DACCELERATION_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommended3DAcceleration != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommended3DAcceleration=%RTbool hrc=%Rhrc\n", this, "GuestOSType::getRecommended3DAcceleration", *aRecommended3DAcceleration, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(RecommendedHDD)(LONG64 *aRecommendedHDD)
{
    LogRelFlow(("{%p} %s: enter aRecommendedHDD=%p\n", this, "GuestOSType::getRecommendedHDD", aRecommendedHDD));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommendedHDD);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDHDD_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommendedHDD(aRecommendedHDD);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDHDD_RETURN(this, hrc, 0 /*normal*/,*aRecommendedHDD);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDHDD_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommendedHDD);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDHDD_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommendedHDD);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommendedHDD=%RI64 hrc=%Rhrc\n", this, "GuestOSType::getRecommendedHDD", *aRecommendedHDD, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(AdapterType)(NetworkAdapterType_T *aAdapterType)
{
    LogRelFlow(("{%p} %s: enter aAdapterType=%p\n", this, "GuestOSType::getAdapterType", aAdapterType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAdapterType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_ADAPTERTYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAdapterType(aAdapterType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_ADAPTERTYPE_RETURN(this, hrc, 0 /*normal*/,*aAdapterType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_ADAPTERTYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aAdapterType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_ADAPTERTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aAdapterType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAdapterType=%RU32 hrc=%Rhrc\n", this, "GuestOSType::getAdapterType", *aAdapterType, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(RecommendedPAE)(BOOL *aRecommendedPAE)
{
    LogRelFlow(("{%p} %s: enter aRecommendedPAE=%p\n", this, "GuestOSType::getRecommendedPAE", aRecommendedPAE));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommendedPAE);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDPAE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommendedPAE(aRecommendedPAE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDPAE_RETURN(this, hrc, 0 /*normal*/,*aRecommendedPAE != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDPAE_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommendedPAE != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDPAE_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommendedPAE != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommendedPAE=%RTbool hrc=%Rhrc\n", this, "GuestOSType::getRecommendedPAE", *aRecommendedPAE, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(RecommendedDVDStorageController)(StorageControllerType_T *aRecommendedDVDStorageController)
{
    LogRelFlow(("{%p} %s: enter aRecommendedDVDStorageController=%p\n", this, "GuestOSType::getRecommendedDVDStorageController", aRecommendedDVDStorageController));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommendedDVDStorageController);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDDVDSTORAGECONTROLLER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommendedDVDStorageController(aRecommendedDVDStorageController);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDDVDSTORAGECONTROLLER_RETURN(this, hrc, 0 /*normal*/,*aRecommendedDVDStorageController);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDDVDSTORAGECONTROLLER_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommendedDVDStorageController);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDDVDSTORAGECONTROLLER_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommendedDVDStorageController);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommendedDVDStorageController=%RU32 hrc=%Rhrc\n", this, "GuestOSType::getRecommendedDVDStorageController", *aRecommendedDVDStorageController, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(RecommendedDVDStorageBus)(StorageBus_T *aRecommendedDVDStorageBus)
{
    LogRelFlow(("{%p} %s: enter aRecommendedDVDStorageBus=%p\n", this, "GuestOSType::getRecommendedDVDStorageBus", aRecommendedDVDStorageBus));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommendedDVDStorageBus);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDDVDSTORAGEBUS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommendedDVDStorageBus(aRecommendedDVDStorageBus);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDDVDSTORAGEBUS_RETURN(this, hrc, 0 /*normal*/,*aRecommendedDVDStorageBus);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDDVDSTORAGEBUS_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommendedDVDStorageBus);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDDVDSTORAGEBUS_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommendedDVDStorageBus);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommendedDVDStorageBus=%RU32 hrc=%Rhrc\n", this, "GuestOSType::getRecommendedDVDStorageBus", *aRecommendedDVDStorageBus, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(RecommendedHDStorageController)(StorageControllerType_T *aRecommendedHDStorageController)
{
    LogRelFlow(("{%p} %s: enter aRecommendedHDStorageController=%p\n", this, "GuestOSType::getRecommendedHDStorageController", aRecommendedHDStorageController));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommendedHDStorageController);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDHDSTORAGECONTROLLER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommendedHDStorageController(aRecommendedHDStorageController);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDHDSTORAGECONTROLLER_RETURN(this, hrc, 0 /*normal*/,*aRecommendedHDStorageController);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDHDSTORAGECONTROLLER_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommendedHDStorageController);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDHDSTORAGECONTROLLER_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommendedHDStorageController);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommendedHDStorageController=%RU32 hrc=%Rhrc\n", this, "GuestOSType::getRecommendedHDStorageController", *aRecommendedHDStorageController, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(RecommendedHDStorageBus)(StorageBus_T *aRecommendedHDStorageBus)
{
    LogRelFlow(("{%p} %s: enter aRecommendedHDStorageBus=%p\n", this, "GuestOSType::getRecommendedHDStorageBus", aRecommendedHDStorageBus));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommendedHDStorageBus);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDHDSTORAGEBUS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommendedHDStorageBus(aRecommendedHDStorageBus);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDHDSTORAGEBUS_RETURN(this, hrc, 0 /*normal*/,*aRecommendedHDStorageBus);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDHDSTORAGEBUS_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommendedHDStorageBus);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDHDSTORAGEBUS_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommendedHDStorageBus);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommendedHDStorageBus=%RU32 hrc=%Rhrc\n", this, "GuestOSType::getRecommendedHDStorageBus", *aRecommendedHDStorageBus, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(RecommendedFirmware)(FirmwareType_T *aRecommendedFirmware)
{
    LogRelFlow(("{%p} %s: enter aRecommendedFirmware=%p\n", this, "GuestOSType::getRecommendedFirmware", aRecommendedFirmware));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommendedFirmware);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDFIRMWARE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommendedFirmware(aRecommendedFirmware);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDFIRMWARE_RETURN(this, hrc, 0 /*normal*/,*aRecommendedFirmware);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDFIRMWARE_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommendedFirmware);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDFIRMWARE_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommendedFirmware);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommendedFirmware=%RU32 hrc=%Rhrc\n", this, "GuestOSType::getRecommendedFirmware", *aRecommendedFirmware, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(RecommendedUSBHID)(BOOL *aRecommendedUSBHID)
{
    LogRelFlow(("{%p} %s: enter aRecommendedUSBHID=%p\n", this, "GuestOSType::getRecommendedUSBHID", aRecommendedUSBHID));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommendedUSBHID);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDUSBHID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommendedUSBHID(aRecommendedUSBHID);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDUSBHID_RETURN(this, hrc, 0 /*normal*/,*aRecommendedUSBHID != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDUSBHID_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommendedUSBHID != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDUSBHID_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommendedUSBHID != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommendedUSBHID=%RTbool hrc=%Rhrc\n", this, "GuestOSType::getRecommendedUSBHID", *aRecommendedUSBHID, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(RecommendedHPET)(BOOL *aRecommendedHPET)
{
    LogRelFlow(("{%p} %s: enter aRecommendedHPET=%p\n", this, "GuestOSType::getRecommendedHPET", aRecommendedHPET));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommendedHPET);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDHPET_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommendedHPET(aRecommendedHPET);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDHPET_RETURN(this, hrc, 0 /*normal*/,*aRecommendedHPET != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDHPET_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommendedHPET != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDHPET_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommendedHPET != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommendedHPET=%RTbool hrc=%Rhrc\n", this, "GuestOSType::getRecommendedHPET", *aRecommendedHPET, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(RecommendedUSBTablet)(BOOL *aRecommendedUSBTablet)
{
    LogRelFlow(("{%p} %s: enter aRecommendedUSBTablet=%p\n", this, "GuestOSType::getRecommendedUSBTablet", aRecommendedUSBTablet));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommendedUSBTablet);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDUSBTABLET_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommendedUSBTablet(aRecommendedUSBTablet);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDUSBTABLET_RETURN(this, hrc, 0 /*normal*/,*aRecommendedUSBTablet != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDUSBTABLET_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommendedUSBTablet != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDUSBTABLET_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommendedUSBTablet != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommendedUSBTablet=%RTbool hrc=%Rhrc\n", this, "GuestOSType::getRecommendedUSBTablet", *aRecommendedUSBTablet, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(RecommendedRTCUseUTC)(BOOL *aRecommendedRTCUseUTC)
{
    LogRelFlow(("{%p} %s: enter aRecommendedRTCUseUTC=%p\n", this, "GuestOSType::getRecommendedRTCUseUTC", aRecommendedRTCUseUTC));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommendedRTCUseUTC);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDRTCUSEUTC_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommendedRTCUseUTC(aRecommendedRTCUseUTC);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDRTCUSEUTC_RETURN(this, hrc, 0 /*normal*/,*aRecommendedRTCUseUTC != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDRTCUSEUTC_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommendedRTCUseUTC != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDRTCUSEUTC_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommendedRTCUseUTC != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommendedRTCUseUTC=%RTbool hrc=%Rhrc\n", this, "GuestOSType::getRecommendedRTCUseUTC", *aRecommendedRTCUseUTC, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(RecommendedChipset)(ChipsetType_T *aRecommendedChipset)
{
    LogRelFlow(("{%p} %s: enter aRecommendedChipset=%p\n", this, "GuestOSType::getRecommendedChipset", aRecommendedChipset));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommendedChipset);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDCHIPSET_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommendedChipset(aRecommendedChipset);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDCHIPSET_RETURN(this, hrc, 0 /*normal*/,*aRecommendedChipset);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDCHIPSET_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommendedChipset);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDCHIPSET_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommendedChipset);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommendedChipset=%RU32 hrc=%Rhrc\n", this, "GuestOSType::getRecommendedChipset", *aRecommendedChipset, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(RecommendedAudioController)(AudioControllerType_T *aRecommendedAudioController)
{
    LogRelFlow(("{%p} %s: enter aRecommendedAudioController=%p\n", this, "GuestOSType::getRecommendedAudioController", aRecommendedAudioController));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommendedAudioController);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDAUDIOCONTROLLER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommendedAudioController(aRecommendedAudioController);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDAUDIOCONTROLLER_RETURN(this, hrc, 0 /*normal*/,*aRecommendedAudioController);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDAUDIOCONTROLLER_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommendedAudioController);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDAUDIOCONTROLLER_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommendedAudioController);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommendedAudioController=%RU32 hrc=%Rhrc\n", this, "GuestOSType::getRecommendedAudioController", *aRecommendedAudioController, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(RecommendedAudioCodec)(AudioCodecType_T *aRecommendedAudioCodec)
{
    LogRelFlow(("{%p} %s: enter aRecommendedAudioCodec=%p\n", this, "GuestOSType::getRecommendedAudioCodec", aRecommendedAudioCodec));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommendedAudioCodec);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDAUDIOCODEC_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommendedAudioCodec(aRecommendedAudioCodec);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDAUDIOCODEC_RETURN(this, hrc, 0 /*normal*/,*aRecommendedAudioCodec);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDAUDIOCODEC_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommendedAudioCodec);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDAUDIOCODEC_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommendedAudioCodec);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommendedAudioCodec=%RU32 hrc=%Rhrc\n", this, "GuestOSType::getRecommendedAudioCodec", *aRecommendedAudioCodec, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(RecommendedFloppy)(BOOL *aRecommendedFloppy)
{
    LogRelFlow(("{%p} %s: enter aRecommendedFloppy=%p\n", this, "GuestOSType::getRecommendedFloppy", aRecommendedFloppy));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommendedFloppy);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDFLOPPY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommendedFloppy(aRecommendedFloppy);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDFLOPPY_RETURN(this, hrc, 0 /*normal*/,*aRecommendedFloppy != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDFLOPPY_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommendedFloppy != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDFLOPPY_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommendedFloppy != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommendedFloppy=%RTbool hrc=%Rhrc\n", this, "GuestOSType::getRecommendedFloppy", *aRecommendedFloppy, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(RecommendedUSB)(BOOL *aRecommendedUSB)
{
    LogRelFlow(("{%p} %s: enter aRecommendedUSB=%p\n", this, "GuestOSType::getRecommendedUSB", aRecommendedUSB));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommendedUSB);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDUSB_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommendedUSB(aRecommendedUSB);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDUSB_RETURN(this, hrc, 0 /*normal*/,*aRecommendedUSB != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDUSB_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommendedUSB != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDUSB_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommendedUSB != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommendedUSB=%RTbool hrc=%Rhrc\n", this, "GuestOSType::getRecommendedUSB", *aRecommendedUSB, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(RecommendedUSB3)(BOOL *aRecommendedUSB3)
{
    LogRelFlow(("{%p} %s: enter aRecommendedUSB3=%p\n", this, "GuestOSType::getRecommendedUSB3", aRecommendedUSB3));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommendedUSB3);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDUSB3_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommendedUSB3(aRecommendedUSB3);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDUSB3_RETURN(this, hrc, 0 /*normal*/,*aRecommendedUSB3 != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDUSB3_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommendedUSB3 != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDUSB3_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommendedUSB3 != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommendedUSB3=%RTbool hrc=%Rhrc\n", this, "GuestOSType::getRecommendedUSB3", *aRecommendedUSB3, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(RecommendedTFReset)(BOOL *aRecommendedTFReset)
{
    LogRelFlow(("{%p} %s: enter aRecommendedTFReset=%p\n", this, "GuestOSType::getRecommendedTFReset", aRecommendedTFReset));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommendedTFReset);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDTFRESET_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommendedTFReset(aRecommendedTFReset);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDTFRESET_RETURN(this, hrc, 0 /*normal*/,*aRecommendedTFReset != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDTFRESET_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommendedTFReset != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDTFRESET_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommendedTFReset != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommendedTFReset=%RTbool hrc=%Rhrc\n", this, "GuestOSType::getRecommendedTFReset", *aRecommendedTFReset, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(RecommendedX2APIC)(BOOL *aRecommendedX2APIC)
{
    LogRelFlow(("{%p} %s: enter aRecommendedX2APIC=%p\n", this, "GuestOSType::getRecommendedX2APIC", aRecommendedX2APIC));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommendedX2APIC);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDX2APIC_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommendedX2APIC(aRecommendedX2APIC);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDX2APIC_RETURN(this, hrc, 0 /*normal*/,*aRecommendedX2APIC != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDX2APIC_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommendedX2APIC != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDX2APIC_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommendedX2APIC != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommendedX2APIC=%RTbool hrc=%Rhrc\n", this, "GuestOSType::getRecommendedX2APIC", *aRecommendedX2APIC, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(RecommendedCPUCount)(ULONG *aRecommendedCPUCount)
{
    LogRelFlow(("{%p} %s: enter aRecommendedCPUCount=%p\n", this, "GuestOSType::getRecommendedCPUCount", aRecommendedCPUCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecommendedCPUCount);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDCPUCOUNT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecommendedCPUCount(aRecommendedCPUCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDCPUCOUNT_RETURN(this, hrc, 0 /*normal*/,*aRecommendedCPUCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDCPUCOUNT_RETURN(this, hrc, 1 /*hrc exception*/,*aRecommendedCPUCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTOSTYPE_GET_RECOMMENDEDCPUCOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecommendedCPUCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecommendedCPUCount=%RU32 hrc=%Rhrc\n", this, "GuestOSType::getRecommendedCPUCount", *aRecommendedCPUCount, hrc));
    return hrc;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(InternalAndReservedAttribute1IGuestOSType)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(InternalAndReservedAttribute2IGuestOSType)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(InternalAndReservedAttribute3IGuestOSType)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(InternalAndReservedAttribute4IGuestOSType)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(InternalAndReservedAttribute5IGuestOSType)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(InternalAndReservedAttribute6IGuestOSType)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(InternalAndReservedAttribute7IGuestOSType)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(InternalAndReservedAttribute8IGuestOSType)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(InternalAndReservedAttribute9IGuestOSType)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(InternalAndReservedAttribute10IGuestOSType)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(InternalAndReservedAttribute11IGuestOSType)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(InternalAndReservedAttribute12IGuestOSType)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(InternalAndReservedAttribute13IGuestOSType)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(InternalAndReservedAttribute14IGuestOSType)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestOSTypeWrap::COMGETTER(InternalAndReservedAttribute15IGuestOSType)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IGuestOSType methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestOSTypeWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(GuestOSTypeWrap, IGuestOSType)
#endif // VBOX_WITH_XPCOM

