// ##### ENDFILE "FsObjInfoWrap.cpp"


// ##### BEGINFILE "GuestWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IGuest.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_GUEST

#include "GuestWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(GuestWrap)

//
// IGuest properties
//

STDMETHODIMP GuestWrap::COMGETTER(OSTypeId)(BSTR *aOSTypeId)
{
    LogRelFlow(("{%p} %s: enter aOSTypeId=%p\n", this, "Guest::getOSTypeId", aOSTypeId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOSTypeId);
        BSTROutConverter TmpOSTypeId(aOSTypeId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_OSTYPEID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getOSTypeId(TmpOSTypeId.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_OSTYPEID_RETURN(this, hrc, 0 /*normal*/,TmpOSTypeId.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_OSTYPEID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_OSTYPEID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aOSTypeId=%ls hrc=%Rhrc\n", this, "Guest::getOSTypeId", *aOSTypeId, hrc));
    return hrc;
}

STDMETHODIMP GuestWrap::COMGETTER(AdditionsRunLevel)(AdditionsRunLevelType_T *aAdditionsRunLevel)
{
    LogRelFlow(("{%p} %s: enter aAdditionsRunLevel=%p\n", this, "Guest::getAdditionsRunLevel", aAdditionsRunLevel));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAdditionsRunLevel);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_ADDITIONSRUNLEVEL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAdditionsRunLevel(aAdditionsRunLevel);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_ADDITIONSRUNLEVEL_RETURN(this, hrc, 0 /*normal*/,*aAdditionsRunLevel);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_ADDITIONSRUNLEVEL_RETURN(this, hrc, 1 /*hrc exception*/,*aAdditionsRunLevel);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_ADDITIONSRUNLEVEL_RETURN(this, hrc, 9 /*unhandled exception*/,*aAdditionsRunLevel);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAdditionsRunLevel=%RU32 hrc=%Rhrc\n", this, "Guest::getAdditionsRunLevel", *aAdditionsRunLevel, hrc));
    return hrc;
}

STDMETHODIMP GuestWrap::COMGETTER(AdditionsVersion)(BSTR *aAdditionsVersion)
{
    LogRelFlow(("{%p} %s: enter aAdditionsVersion=%p\n", this, "Guest::getAdditionsVersion", aAdditionsVersion));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAdditionsVersion);
        BSTROutConverter TmpAdditionsVersion(aAdditionsVersion);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_ADDITIONSVERSION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAdditionsVersion(TmpAdditionsVersion.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_ADDITIONSVERSION_RETURN(this, hrc, 0 /*normal*/,TmpAdditionsVersion.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_ADDITIONSVERSION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_ADDITIONSVERSION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAdditionsVersion=%ls hrc=%Rhrc\n", this, "Guest::getAdditionsVersion", *aAdditionsVersion, hrc));
    return hrc;
}

STDMETHODIMP GuestWrap::COMGETTER(AdditionsRevision)(ULONG *aAdditionsRevision)
{
    LogRelFlow(("{%p} %s: enter aAdditionsRevision=%p\n", this, "Guest::getAdditionsRevision", aAdditionsRevision));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAdditionsRevision);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_ADDITIONSREVISION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAdditionsRevision(aAdditionsRevision);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_ADDITIONSREVISION_RETURN(this, hrc, 0 /*normal*/,*aAdditionsRevision);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_ADDITIONSREVISION_RETURN(this, hrc, 1 /*hrc exception*/,*aAdditionsRevision);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_ADDITIONSREVISION_RETURN(this, hrc, 9 /*unhandled exception*/,*aAdditionsRevision);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAdditionsRevision=%RU32 hrc=%Rhrc\n", this, "Guest::getAdditionsRevision", *aAdditionsRevision, hrc));
    return hrc;
}

STDMETHODIMP GuestWrap::COMGETTER(DnDSource)(IGuestDnDSource **aDnDSource)
{
    LogRelFlow(("{%p} %s: enter aDnDSource=%p\n", this, "Guest::getDnDSource", aDnDSource));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDnDSource);
        ComTypeOutConverter<IGuestDnDSource> TmpDnDSource(aDnDSource);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_DNDSOURCE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDnDSource(TmpDnDSource.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_DNDSOURCE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpDnDSource.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_DNDSOURCE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_DNDSOURCE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDnDSource=%p hrc=%Rhrc\n", this, "Guest::getDnDSource", *aDnDSource, hrc));
    return hrc;
}

STDMETHODIMP GuestWrap::COMGETTER(DnDTarget)(IGuestDnDTarget **aDnDTarget)
{
    LogRelFlow(("{%p} %s: enter aDnDTarget=%p\n", this, "Guest::getDnDTarget", aDnDTarget));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDnDTarget);
        ComTypeOutConverter<IGuestDnDTarget> TmpDnDTarget(aDnDTarget);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_DNDTARGET_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDnDTarget(TmpDnDTarget.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_DNDTARGET_RETURN(this, hrc, 0 /*normal*/,(void *)TmpDnDTarget.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_DNDTARGET_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_DNDTARGET_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDnDTarget=%p hrc=%Rhrc\n", this, "Guest::getDnDTarget", *aDnDTarget, hrc));
    return hrc;
}

STDMETHODIMP GuestWrap::COMGETTER(EventSource)(IEventSource **aEventSource)
{
    LogRelFlow(("{%p} %s: enter aEventSource=%p\n", this, "Guest::getEventSource", aEventSource));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEventSource);
        ComTypeOutConverter<IEventSource> TmpEventSource(aEventSource);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_EVENTSOURCE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEventSource(TmpEventSource.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_EVENTSOURCE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpEventSource.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_EVENTSOURCE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_EVENTSOURCE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEventSource=%p hrc=%Rhrc\n", this, "Guest::getEventSource", *aEventSource, hrc));
    return hrc;
}

STDMETHODIMP GuestWrap::COMGETTER(Facilities)(ComSafeArrayOut(IAdditionsFacility *, aFacilities))
{
    LogRelFlow(("{%p} %s: enter aFacilities=%p\n", this, "Guest::getFacilities", aFacilities));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFacilities);
        ArrayComTypeOutConverter<IAdditionsFacility> TmpFacilities(ComSafeArrayOutArg(aFacilities));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_FACILITIES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFacilities(TmpFacilities.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_FACILITIES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpFacilities.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_FACILITIES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_FACILITIES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFacilities=%zu hrc=%Rhrc\n", this, "Guest::getFacilities", ComSafeArraySize(*aFacilities), hrc));
    return hrc;
}

STDMETHODIMP GuestWrap::COMGETTER(Sessions)(ComSafeArrayOut(IGuestSession *, aSessions))
{
    LogRelFlow(("{%p} %s: enter aSessions=%p\n", this, "Guest::getSessions", aSessions));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSessions);
        ArrayComTypeOutConverter<IGuestSession> TmpSessions(ComSafeArrayOutArg(aSessions));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_SESSIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSessions(TmpSessions.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_SESSIONS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSessions.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_SESSIONS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_SESSIONS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSessions=%zu hrc=%Rhrc\n", this, "Guest::getSessions", ComSafeArraySize(*aSessions), hrc));
    return hrc;
}

STDMETHODIMP GuestWrap::COMGETTER(MemoryBalloonSize)(ULONG *aMemoryBalloonSize)
{
    LogRelFlow(("{%p} %s: enter aMemoryBalloonSize=%p\n", this, "Guest::getMemoryBalloonSize", aMemoryBalloonSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMemoryBalloonSize);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_MEMORYBALLOONSIZE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMemoryBalloonSize(aMemoryBalloonSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_MEMORYBALLOONSIZE_RETURN(this, hrc, 0 /*normal*/,*aMemoryBalloonSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_MEMORYBALLOONSIZE_RETURN(this, hrc, 1 /*hrc exception*/,*aMemoryBalloonSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_MEMORYBALLOONSIZE_RETURN(this, hrc, 9 /*unhandled exception*/,*aMemoryBalloonSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMemoryBalloonSize=%RU32 hrc=%Rhrc\n", this, "Guest::getMemoryBalloonSize", *aMemoryBalloonSize, hrc));
    return hrc;
}

STDMETHODIMP GuestWrap::COMSETTER(MemoryBalloonSize)(ULONG aMemoryBalloonSize)
{
    LogRelFlow(("{%p} %s: enter aMemoryBalloonSize=%RU32\n", this, "Guest::setMemoryBalloonSize", aMemoryBalloonSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_SET_MEMORYBALLOONSIZE_ENTER(this, aMemoryBalloonSize);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setMemoryBalloonSize(aMemoryBalloonSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_SET_MEMORYBALLOONSIZE_RETURN(this, hrc, 0 /*normal*/,aMemoryBalloonSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_SET_MEMORYBALLOONSIZE_RETURN(this, hrc, 1 /*hrc exception*/,aMemoryBalloonSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_SET_MEMORYBALLOONSIZE_RETURN(this, hrc, 9 /*unhandled exception*/,aMemoryBalloonSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Guest::setMemoryBalloonSize", hrc));
    return hrc;
}

STDMETHODIMP GuestWrap::COMGETTER(StatisticsUpdateInterval)(ULONG *aStatisticsUpdateInterval)
{
    LogRelFlow(("{%p} %s: enter aStatisticsUpdateInterval=%p\n", this, "Guest::getStatisticsUpdateInterval", aStatisticsUpdateInterval));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aStatisticsUpdateInterval);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_STATISTICSUPDATEINTERVAL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getStatisticsUpdateInterval(aStatisticsUpdateInterval);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_STATISTICSUPDATEINTERVAL_RETURN(this, hrc, 0 /*normal*/,*aStatisticsUpdateInterval);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_STATISTICSUPDATEINTERVAL_RETURN(this, hrc, 1 /*hrc exception*/,*aStatisticsUpdateInterval);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GET_STATISTICSUPDATEINTERVAL_RETURN(this, hrc, 9 /*unhandled exception*/,*aStatisticsUpdateInterval);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aStatisticsUpdateInterval=%RU32 hrc=%Rhrc\n", this, "Guest::getStatisticsUpdateInterval", *aStatisticsUpdateInterval, hrc));
    return hrc;
}

STDMETHODIMP GuestWrap::COMSETTER(StatisticsUpdateInterval)(ULONG aStatisticsUpdateInterval)
{
    LogRelFlow(("{%p} %s: enter aStatisticsUpdateInterval=%RU32\n", this, "Guest::setStatisticsUpdateInterval", aStatisticsUpdateInterval));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_SET_STATISTICSUPDATEINTERVAL_ENTER(this, aStatisticsUpdateInterval);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setStatisticsUpdateInterval(aStatisticsUpdateInterval);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_SET_STATISTICSUPDATEINTERVAL_RETURN(this, hrc, 0 /*normal*/,aStatisticsUpdateInterval);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_SET_STATISTICSUPDATEINTERVAL_RETURN(this, hrc, 1 /*hrc exception*/,aStatisticsUpdateInterval);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_SET_STATISTICSUPDATEINTERVAL_RETURN(this, hrc, 9 /*unhandled exception*/,aStatisticsUpdateInterval);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Guest::setStatisticsUpdateInterval", hrc));
    return hrc;
}

STDMETHODIMP GuestWrap::COMGETTER(InternalAndReservedAttribute1IGuest)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestWrap::COMGETTER(InternalAndReservedAttribute2IGuest)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestWrap::COMGETTER(InternalAndReservedAttribute3IGuest)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestWrap::COMGETTER(InternalAndReservedAttribute4IGuest)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestWrap::COMGETTER(InternalAndReservedAttribute5IGuest)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestWrap::COMGETTER(InternalAndReservedAttribute6IGuest)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestWrap::COMGETTER(InternalAndReservedAttribute7IGuest)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestWrap::COMGETTER(InternalAndReservedAttribute8IGuest)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestWrap::COMGETTER(InternalAndReservedAttribute9IGuest)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestWrap::COMGETTER(InternalAndReservedAttribute10IGuest)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestWrap::COMGETTER(InternalAndReservedAttribute11IGuest)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestWrap::COMGETTER(InternalAndReservedAttribute12IGuest)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestWrap::COMGETTER(InternalAndReservedAttribute13IGuest)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestWrap::COMGETTER(InternalAndReservedAttribute14IGuest)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestWrap::COMGETTER(InternalAndReservedAttribute15IGuest)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestWrap::COMGETTER(InternalAndReservedAttribute16IGuest)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IGuest methods
//

STDMETHODIMP GuestWrap::InternalGetStatistics(ULONG *aCpuUser,
                                              ULONG *aCpuKernel,
                                              ULONG *aCpuIdle,
                                              ULONG *aMemTotal,
                                              ULONG *aMemFree,
                                              ULONG *aMemBalloon,
                                              ULONG *aMemShared,
                                              ULONG *aMemCache,
                                              ULONG *aPagedTotal,
                                              ULONG *aMemAllocTotal,
                                              ULONG *aMemFreeTotal,
                                              ULONG *aMemBalloonTotal,
                                              ULONG *aMemSharedTotal)
{
    LogRelFlow(("{%p} %s:enter aCpuUser=%p aCpuKernel=%p aCpuIdle=%p aMemTotal=%p aMemFree=%p aMemBalloon=%p aMemShared=%p aMemCache=%p aPagedTotal=%p aMemAllocTotal=%p aMemFreeTotal=%p aMemBalloonTotal=%p aMemSharedTotal=%p\n", this, "Guest::internalGetStatistics", aCpuUser, aCpuKernel, aCpuIdle, aMemTotal, aMemFree, aMemBalloon, aMemShared, aMemCache, aPagedTotal, aMemAllocTotal, aMemFreeTotal, aMemBalloonTotal, aMemSharedTotal));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCpuUser);
        CheckComArgOutPointerValidThrow(aCpuKernel);
        CheckComArgOutPointerValidThrow(aCpuIdle);
        CheckComArgOutPointerValidThrow(aMemTotal);
        CheckComArgOutPointerValidThrow(aMemFree);
        CheckComArgOutPointerValidThrow(aMemBalloon);
        CheckComArgOutPointerValidThrow(aMemShared);
        CheckComArgOutPointerValidThrow(aMemCache);
        CheckComArgOutPointerValidThrow(aPagedTotal);
        CheckComArgOutPointerValidThrow(aMemAllocTotal);
        CheckComArgOutPointerValidThrow(aMemFreeTotal);
        CheckComArgOutPointerValidThrow(aMemBalloonTotal);
        CheckComArgOutPointerValidThrow(aMemSharedTotal);


        
        
        
        
        
        
        
        
        
        
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_INTERNALGETSTATISTICS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = internalGetStatistics(aCpuUser,
                                        aCpuKernel,
                                        aCpuIdle,
                                        aMemTotal,
                                        aMemFree,
                                        aMemBalloon,
                                        aMemShared,
                                        aMemCache,
                                        aPagedTotal,
                                        aMemAllocTotal,
                                        aMemFreeTotal,
                                        aMemBalloonTotal,
                                        aMemSharedTotal);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_INTERNALGETSTATISTICS_RETURN(this, hrc, 0 /*normal*/, *aCpuUser, *aCpuKernel, *aCpuIdle, *aMemTotal, *aMemFree, *aMemBalloon, *aMemShared, *aMemCache, *aPagedTotal, *aMemAllocTotal, *aMemFreeTotal, *aMemBalloonTotal, *aMemSharedTotal);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_INTERNALGETSTATISTICS_RETURN(this, hrc, 1 /*hrc exception*/, *aCpuUser, *aCpuKernel, *aCpuIdle, *aMemTotal, *aMemFree, *aMemBalloon, *aMemShared, *aMemCache, *aPagedTotal, *aMemAllocTotal, *aMemFreeTotal, *aMemBalloonTotal, *aMemSharedTotal);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_INTERNALGETSTATISTICS_RETURN(this, hrc, 9 /*unhandled exception*/, *aCpuUser, *aCpuKernel, *aCpuIdle, *aMemTotal, *aMemFree, *aMemBalloon, *aMemShared, *aMemCache, *aPagedTotal, *aMemAllocTotal, *aMemFreeTotal, *aMemBalloonTotal, *aMemSharedTotal);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCpuUser=%RU32 *aCpuKernel=%RU32 *aCpuIdle=%RU32 *aMemTotal=%RU32 *aMemFree=%RU32 *aMemBalloon=%RU32 *aMemShared=%RU32 *aMemCache=%RU32 *aPagedTotal=%RU32 *aMemAllocTotal=%RU32 *aMemFreeTotal=%RU32 *aMemBalloonTotal=%RU32 *aMemSharedTotal=%RU32 hrc=%Rhrc\n", this, "Guest::internalGetStatistics", *aCpuUser, *aCpuKernel, *aCpuIdle, *aMemTotal, *aMemFree, *aMemBalloon, *aMemShared, *aMemCache, *aPagedTotal, *aMemAllocTotal, *aMemFreeTotal, *aMemBalloonTotal, *aMemSharedTotal, hrc));
    return hrc;
}

STDMETHODIMP GuestWrap::GetFacilityStatus(AdditionsFacilityType_T aFacility,
                                          LONG64 *aTimestamp,
                                          AdditionsFacilityStatus_T *aStatus)
{
    LogRelFlow(("{%p} %s:enter aFacility=%RU32 aTimestamp=%p aStatus=%p\n", this, "Guest::getFacilityStatus", aFacility, aTimestamp, aStatus));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTimestamp);
        CheckComArgOutPointerValidThrow(aStatus);


        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GETFACILITYSTATUS_ENTER(this, aFacility);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFacilityStatus(aFacility,
                                    aTimestamp,
                                    aStatus);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GETFACILITYSTATUS_RETURN(this, hrc, 0 /*normal*/, aFacility, *aTimestamp, *aStatus);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GETFACILITYSTATUS_RETURN(this, hrc, 1 /*hrc exception*/, aFacility, *aTimestamp, *aStatus);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GETFACILITYSTATUS_RETURN(this, hrc, 9 /*unhandled exception*/, aFacility, *aTimestamp, *aStatus);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTimestamp=%RI64 aStatus=%RU32 hrc=%Rhrc\n", this, "Guest::getFacilityStatus", *aTimestamp, *aStatus, hrc));
    return hrc;
}

STDMETHODIMP GuestWrap::GetAdditionsStatus(AdditionsRunLevelType_T aLevel,
                                           BOOL *aActive)
{
    LogRelFlow(("{%p} %s:enter aLevel=%RU32 aActive=%p\n", this, "Guest::getAdditionsStatus", aLevel, aActive));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aActive);


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GETADDITIONSSTATUS_ENTER(this, aLevel);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAdditionsStatus(aLevel,
                                     aActive);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GETADDITIONSSTATUS_RETURN(this, hrc, 0 /*normal*/, aLevel, *aActive != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GETADDITIONSSTATUS_RETURN(this, hrc, 1 /*hrc exception*/, aLevel, *aActive != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_GETADDITIONSSTATUS_RETURN(this, hrc, 9 /*unhandled exception*/, aLevel, *aActive != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aActive=%RTbool hrc=%Rhrc\n", this, "Guest::getAdditionsStatus", *aActive, hrc));
    return hrc;
}

STDMETHODIMP GuestWrap::SetCredentials(IN_BSTR aUserName,
                                       IN_BSTR aPassword,
                                       IN_BSTR aDomain,
                                       BOOL aAllowInteractiveLogon)
{
    LogRelFlow(("{%p} %s:enter aUserName=%ls aPassword=%ls aDomain=%ls aAllowInteractiveLogon=%RTbool\n", this, "Guest::setCredentials", aUserName, aPassword, aDomain, aAllowInteractiveLogon));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpUserName(aUserName);
        BSTRInConverter TmpPassword(aPassword);
        BSTRInConverter TmpDomain(aDomain);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_SETCREDENTIALS_ENTER(this, TmpUserName.str().c_str(), TmpPassword.str().c_str(), TmpDomain.str().c_str(), aAllowInteractiveLogon != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setCredentials(TmpUserName.str(),
                                 TmpPassword.str(),
                                 TmpDomain.str(),
                                 aAllowInteractiveLogon != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_SETCREDENTIALS_RETURN(this, hrc, 0 /*normal*/, TmpUserName.str().c_str(), TmpPassword.str().c_str(), TmpDomain.str().c_str(), aAllowInteractiveLogon != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_SETCREDENTIALS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, aAllowInteractiveLogon != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_SETCREDENTIALS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, aAllowInteractiveLogon != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Guest::setCredentials", hrc));
    return hrc;
}

STDMETHODIMP GuestWrap::CreateSession(IN_BSTR aUser,
                                      IN_BSTR aPassword,
                                      IN_BSTR aDomain,
                                      IN_BSTR aSessionName,
                                      IGuestSession **aGuestSession)
{
    LogRelFlow(("{%p} %s:enter aUser=%ls aPassword=%ls aDomain=%ls aSessionName=%ls aGuestSession=%p\n", this, "Guest::createSession", aUser, aPassword, aDomain, aSessionName, aGuestSession));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGuestSession);


        BSTRInConverter TmpUser(aUser);
        BSTRInConverter TmpPassword(aPassword);
        BSTRInConverter TmpDomain(aDomain);
        BSTRInConverter TmpSessionName(aSessionName);
        ComTypeOutConverter<IGuestSession> TmpGuestSession(aGuestSession);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_CREATESESSION_ENTER(this, TmpUser.str().c_str(), TmpPassword.str().c_str(), TmpDomain.str().c_str(), TmpSessionName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = createSession(TmpUser.str(),
                                TmpPassword.str(),
                                TmpDomain.str(),
                                TmpSessionName.str(),
                                TmpGuestSession.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_CREATESESSION_RETURN(this, hrc, 0 /*normal*/, TmpUser.str().c_str(), TmpPassword.str().c_str(), TmpDomain.str().c_str(), TmpSessionName.str().c_str(), (void *)TmpGuestSession.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_CREATESESSION_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_CREATESESSION_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aGuestSession=%p hrc=%Rhrc\n", this, "Guest::createSession", *aGuestSession, hrc));
    return hrc;
}

STDMETHODIMP GuestWrap::FindSession(IN_BSTR aSessionName,
                                    ComSafeArrayOut(IGuestSession *, aSessions))
{
    LogRelFlow(("{%p} %s:enter aSessionName=%ls aSessions=%p\n", this, "Guest::findSession", aSessionName, aSessions));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSessions);


        BSTRInConverter TmpSessionName(aSessionName);
        ArrayComTypeOutConverter<IGuestSession> TmpSessions(ComSafeArrayOutArg(aSessions));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_FINDSESSION_ENTER(this, TmpSessionName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = findSession(TmpSessionName.str(),
                              TmpSessions.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_FINDSESSION_RETURN(this, hrc, 0 /*normal*/, TmpSessionName.str().c_str(), (uint32_t)TmpSessions.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_FINDSESSION_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_FINDSESSION_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aSessions=%zu hrc=%Rhrc\n", this, "Guest::findSession", ComSafeArraySize(*aSessions), hrc));
    return hrc;
}

STDMETHODIMP GuestWrap::UpdateGuestAdditions(IN_BSTR aSource,
                                             ComSafeArrayIn(IN_BSTR, aArguments),
                                             ComSafeArrayIn(AdditionsUpdateFlag_T, aFlags),
                                             IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aSource=%ls aArguments=%zu aFlags=%zu aProgress=%p\n", this, "Guest::updateGuestAdditions", aSource, aArguments, aFlags, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpSource(aSource);
        ArrayBSTRInConverter TmpArguments(ComSafeArrayInArg(aArguments));
        ArrayInConverter<AdditionsUpdateFlag_T> TmpFlags(ComSafeArrayInArg(aFlags));
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_UPDATEGUESTADDITIONS_ENTER(this, TmpSource.str().c_str(), (uint32_t)TmpArguments.array().size(), NULL /*for now*/, (uint32_t)TmpFlags.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = updateGuestAdditions(TmpSource.str(),
                                       TmpArguments.array(),
                                       TmpFlags.array(),
                                       TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_UPDATEGUESTADDITIONS_RETURN(this, hrc, 0 /*normal*/, TmpSource.str().c_str(), (uint32_t)TmpArguments.array().size(), NULL /*for now*/, (uint32_t)TmpFlags.array().size(), NULL /*for now*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_UPDATEGUESTADDITIONS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUEST_UPDATEGUESTADDITIONS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Guest::updateGuestAdditions", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP GuestWrap::InternalAndReservedMethod1IGuest()
{
    return E_NOTIMPL;
}

STDMETHODIMP GuestWrap::InternalAndReservedMethod2IGuest()
{
    return E_NOTIMPL;
}

STDMETHODIMP GuestWrap::InternalAndReservedMethod3IGuest()
{
    return E_NOTIMPL;
}

STDMETHODIMP GuestWrap::InternalAndReservedMethod4IGuest()
{
    return E_NOTIMPL;
}

STDMETHODIMP GuestWrap::InternalAndReservedMethod5IGuest()
{
    return E_NOTIMPL;
}

STDMETHODIMP GuestWrap::InternalAndReservedMethod6IGuest()
{
    return E_NOTIMPL;
}

STDMETHODIMP GuestWrap::InternalAndReservedMethod7IGuest()
{
    return E_NOTIMPL;
}

STDMETHODIMP GuestWrap::InternalAndReservedMethod8IGuest()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(GuestWrap, IGuest)
#endif // VBOX_WITH_XPCOM

