// ##### ENDFILE "BIOSSettingsWrap.cpp"


// ##### BEGINFILE "RecordingSettingsWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IRecordingSettings.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_RECORDINGSETTINGS

#include "RecordingSettingsWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(RecordingSettingsWrap)

//
// IRecordingSettings properties
//

STDMETHODIMP RecordingSettingsWrap::COMGETTER(Enabled)(BOOL *aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%p\n", this, "RecordingSettings::getEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GET_ENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEnabled(aEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GET_ENABLED_RETURN(this, hrc, 0 /*normal*/,*aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEnabled=%RTbool hrc=%Rhrc\n", this, "RecordingSettings::getEnabled", *aEnabled, hrc));
    return hrc;
}

STDMETHODIMP RecordingSettingsWrap::COMSETTER(Enabled)(BOOL aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%RTbool\n", this, "RecordingSettings::setEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_SET_ENABLED_ENTER(this, aEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setEnabled(aEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_SET_ENABLED_RETURN(this, hrc, 0 /*normal*/,aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_SET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_SET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "RecordingSettings::setEnabled", hrc));
    return hrc;
}

STDMETHODIMP RecordingSettingsWrap::COMGETTER(Screens)(ComSafeArrayOut(IRecordingScreenSettings *, aScreens))
{
    LogRelFlow(("{%p} %s: enter aScreens=%p\n", this, "RecordingSettings::getScreens", aScreens));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aScreens);
        ArrayComTypeOutConverter<IRecordingScreenSettings> TmpScreens(ComSafeArrayOutArg(aScreens));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GET_SCREENS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getScreens(TmpScreens.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GET_SCREENS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpScreens.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GET_SCREENS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GET_SCREENS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aScreens=%zu hrc=%Rhrc\n", this, "RecordingSettings::getScreens", ComSafeArraySize(*aScreens), hrc));
    return hrc;
}


//
// IRecordingSettings methods
//

STDMETHODIMP RecordingSettingsWrap::GetScreenSettings(ULONG aScreenId,
                                                      IRecordingScreenSettings **aRecordScreenSettings)
{
    LogRelFlow(("{%p} %s:enter aScreenId=%RU32 aRecordScreenSettings=%p\n", this, "RecordingSettings::getScreenSettings", aScreenId, aRecordScreenSettings));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecordScreenSettings);


        
        ComTypeOutConverter<IRecordingScreenSettings> TmpRecordScreenSettings(aRecordScreenSettings);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GETSCREENSETTINGS_ENTER(this, aScreenId);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getScreenSettings(aScreenId,
                                    TmpRecordScreenSettings.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GETSCREENSETTINGS_RETURN(this, hrc, 0 /*normal*/, aScreenId, (void *)TmpRecordScreenSettings.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GETSCREENSETTINGS_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSETTINGS_GETSCREENSETTINGS_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aRecordScreenSettings=%p hrc=%Rhrc\n", this, "RecordingSettings::getScreenSettings", *aRecordScreenSettings, hrc));
    return hrc;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(RecordingSettingsWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(RecordingSettingsWrap, IRecordingSettings)
#endif // VBOX_WITH_XPCOM

