/*
 * \brief  Runtime state of the RAM file system
 * \author Norman Feske
 * \date   2018-05-15
 */

/*
 * Copyright (C) 2018 Genode Labs GmbH
 *
 * This file is part of the Genode OS framework, which is distributed
 * under the terms of the GNU Affero General Public License version 3.
 */

#ifndef _MODEL__RAM_FS_STATE_H_
#define _MODEL__RAM_FS_STATE_H_

/* local includes */
#include <types.h>
#include <model/child_state.h>
#include <model/partition.h>

namespace Sculpt { struct Ram_fs_state; }

struct Sculpt::Ram_fs_state : Child_state, File_system
{
	/*
	 * Use Priority::LEITZENTRALE for the RAM file system to make the
	 * inspect view available even in conditions when a malfunctioning
	 * high-priority driver is spinning.
	 */

	Ram_fs_state(Registry<Child_state> &registry, Start_name const &name)
	:
		Child_state(registry, { .name      = name,
		                        .priority  = Priority::LEITZENTRALE,
		                        .cpu_quota = 0,
		                        .location  = { },
		                        .initial   = { Ram_quota{1024*1024}, Cap_quota{300} },
		                        .max       = { Ram_quota{2*1024*1024*1024UL}, { } } }),
		File_system(File_system::UNKNOWN)
	{ }
};

#endif /* _MODEL__RAM_FS_STATE_H_ */
