/********************************************************************/
/*                                                                  */
/*  s7   Seed7 interpreter                                          */
/*  Copyright (C) 1990 - 2000  Thomas Mertes                        */
/*                                                                  */
/*  This program is free software; you can redistribute it and/or   */
/*  modify it under the terms of the GNU General Public License as  */
/*  published by the Free Software Foundation; either version 2 of  */
/*  the License, or (at your option) any later version.             */
/*                                                                  */
/*  This program is distributed in the hope that it will be useful, */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of  */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the   */
/*  GNU General Public License for more details.                    */
/*                                                                  */
/*  You should have received a copy of the GNU General Public       */
/*  License along with this program; if not, write to the           */
/*  Free Software Foundation, Inc., 51 Franklin Street,             */
/*  Fifth Floor, Boston, MA  02110-1301, USA.                       */
/*                                                                  */
/*  Module: Analyzer - Main                                         */
/*  File: seed7/src/analyze.h                                       */
/*  Changes: 1991, 1992, 1993, 1994  Thomas Mertes                  */
/*  Content: Main function of the analysis phase.                   */
/*                                                                  */
/********************************************************************/

progType analyzeFile (const const_striType sourceFileArgument, uintType options,
    const const_rtlArrayType libraryDirs, const fileType errorFile,
    errInfoType *err_info);
progType analyze (const const_striType sourceFileArgument, uintType options,
    const const_rtlArrayType libraryDirs, const const_striType protFileName);
progType analyzeBString (const bstriType input_bstri, uintType options,
    const const_rtlArrayType libraryDirs, const fileType errorFile,
    errInfoType *err_info);
progType analyzeString (const const_striType input_string, uintType options,
    const const_rtlArrayType libraryDirs, const fileType errorFile,
    errInfoType *err_info);
