/********************************************************************/
/*                                                                  */
/*  bln_rtl.c     Primitive actions for the boolean type.           */
/*  Copyright (C) 1989 - 2006, 2008, 2016  Thomas Mertes            */
/*                                                                  */
/*  This file is part of the Seed7 Runtime Library.                 */
/*                                                                  */
/*  The Seed7 Runtime Library is free software; you can             */
/*  redistribute it and/or modify it under the terms of the GNU     */
/*  Lesser General Public License as published by the Free Software */
/*  Foundation; either version 2.1 of the License, or (at your      */
/*  option) any later version.                                      */
/*                                                                  */
/*  The Seed7 Runtime Library is distributed in the hope that it    */
/*  will be useful, but WITHOUT ANY WARRANTY; without even the      */
/*  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR */
/*  PURPOSE.  See the GNU Lesser General Public License for more    */
/*  details.                                                        */
/*                                                                  */
/*  You should have received a copy of the GNU Lesser General       */
/*  Public License along with this program; if not, write to the    */
/*  Free Software Foundation, Inc., 51 Franklin Street,             */
/*  Fifth Floor, Boston, MA  02110-1301, USA.                       */
/*                                                                  */
/*  Module: Seed7 Runtime Library                                   */
/*  File: seed7/src/bln_rtl.c                                       */
/*  Changes: 1999, 2005  Thomas Mertes                              */
/*  Content: Primitive actions for the boolean type.                */
/*                                                                  */
/********************************************************************/

#include "version.h"

#include "stdlib.h"
#include "stdio.h"

#include "common.h"
#include "data_rtl.h"

#undef EXTERN
#define EXTERN
#include "bln_rtl.h"



/**
 *  Reinterpret the generic parameters as boolType and assign source to dest.
 *  Function pointers in C programs generated by the Seed7 compiler
 *  may point to this function. This assures correct behaviour even
 *  if sizeof(genericType) != sizeof(boolType).
 */
void blnCpyGeneric (genericType *const dest, const genericType source)

  { /* blnCpyGeneric */
    ((rtlObjectType *) dest)->value.boolValue =
        ((const_rtlObjectType *) &source)->value.boolValue;
  } /* blnCpyGeneric */
