/********************************************************************/
/*                                                                  */
/*  s7   Seed7 interpreter                                          */
/*  Copyright (C) 1990 - 2021  Thomas Mertes                        */
/*                                                                  */
/*  This program is free software; you can redistribute it and/or   */
/*  modify it under the terms of the GNU General Public License as  */
/*  published by the Free Software Foundation; either version 2 of  */
/*  the License, or (at your option) any later version.             */
/*                                                                  */
/*  This program is distributed in the hope that it will be useful, */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of  */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the   */
/*  GNU General Public License for more details.                    */
/*                                                                  */
/*  You should have received a copy of the GNU General Public       */
/*  License along with this program; if not, write to the           */
/*  Free Software Foundation, Inc., 51 Franklin Street,             */
/*  Fifth Floor, Boston, MA  02110-1301, USA.                       */
/*                                                                  */
/*  Module: Main                                                    */
/*  File: seed7/src/primitiv.c                                      */
/*  Changes: 1992, 1993, 1994, 2004 - 2021  Thomas Mertes           */
/*  Content: Table definitions for all primitive actions.           */
/*                                                                  */
/********************************************************************/

#include "version.h"

#include "stdio.h"

#include "common.h"
#include "data.h"
#include "actutl.h"
#include "actlib.h"
#include "arrlib.h"
#include "biglib.h"
#include "binlib.h"
#include "blnlib.h"
#include "bstlib.h"
#include "chrlib.h"
#include "cmdlib.h"
#include "conlib.h"
#include "dcllib.h"
#include "drwlib.h"
#include "enulib.h"
#include "fillib.h"
#include "fltlib.h"
#include "hshlib.h"
#include "intlib.h"
#include "itflib.h"
#include "kbdlib.h"
#include "lstlib.h"
#include "pcslib.h"
#include "pollib.h"
#include "prclib.h"
#include "prglib.h"
#include "reflib.h"
#include "rfllib.h"
#include "sctlib.h"
#include "sellib.h"
#include "setlib.h"
#include "soclib.h"
#include "sqllib.h"
#include "strlib.h"
#include "timlib.h"
#include "typlib.h"
#include "ut8lib.h"

#undef EXTERN
#define EXTERN
#include "primitiv.h"


static const actEntryRecord actEntryTable[] = {
    { "ACT_ILLEGAL",                  act_illegal,                  },

    { "ACT_CPY",                      act_cpy,                      },
    { "ACT_CREATE",                   act_create,                   },
    { "ACT_EQ",                       act_eq,                       },
    { "ACT_GEN",                      act_gen,                      },
    { "ACT_ICONV1",                   act_iconv1,                   },
    { "ACT_ICONV3",                   act_iconv3,                   },
    { "ACT_NE",                       act_ne,                       },
    { "ACT_ORD",                      act_ord,                      },
    { "ACT_STR",                      act_str,                      },
    { "ACT_VALUE",                    act_value,                    },

    { "ARR_APPEND",                   arr_append,                   },
    { "ARR_ARRLIT",                   arr_arrlit,                   },
    { "ARR_ARRLIT2",                  arr_arrlit2,                  },
    { "ARR_BASELIT",                  arr_baselit,                  },
    { "ARR_BASELIT2",                 arr_baselit2,                 },
    { "ARR_CAT",                      arr_cat,                      },
    { "ARR_CONV",                     arr_conv,                     },
    { "ARR_CPY",                      arr_cpy,                      },
    { "ARR_CREATE",                   arr_create,                   },
    { "ARR_DESTR",                    arr_destr,                    },
    { "ARR_EMPTY",                    arr_empty,                    },
    { "ARR_EXTEND",                   arr_extend,                   },
    { "ARR_GEN",                      arr_gen,                      },
    { "ARR_HEAD",                     arr_head,                     },
    { "ARR_IDX",                      arr_idx,                      },
    { "ARR_INSERT",                   arr_insert,                   },
    { "ARR_INSERT_ARRAY",             arr_insert_array,             },
    { "ARR_LNG",                      arr_lng,                      },
    { "ARR_MAXIDX",                   arr_maxidx,                   },
    { "ARR_MINIDX",                   arr_minidx,                   },
    { "ARR_PUSH",                     arr_push,                     },
    { "ARR_RANGE",                    arr_range,                    },
    { "ARR_REMOVE",                   arr_remove,                   },
    { "ARR_REMOVE_ARRAY",             arr_remove_array,             },
    { "ARR_SORT",                     arr_sort,                     },
    { "ARR_SORT_REVERSE",             arr_sort_reverse,             },
    { "ARR_SUBARR",                   arr_subarr,                   },
    { "ARR_TAIL",                     arr_tail,                     },
    { "ARR_TIMES",                    arr_times,                    },

    { "BIG_ABS",                      big_abs,                      },
    { "BIG_ADD",                      big_add,                      },
    { "BIG_ADD_ASSIGN",               big_add_assign,               },
    { "BIG_BIT_LENGTH",               big_bit_length,               },
    { "BIG_CMP",                      big_cmp,                      },
    { "BIG_CONV",                     big_conv,                     },
    { "BIG_CPY",                      big_cpy,                      },
    { "BIG_CREATE",                   big_create,                   },
    { "BIG_DECR",                     big_decr,                     },
    { "BIG_DESTR",                    big_destr,                    },
    { "BIG_DIV",                      big_div,                      },
    { "BIG_DIV_REM",                  big_div_rem,                  },
    { "BIG_EQ",                       big_eq,                       },
    { "BIG_FROM_BSTRI_BE",            big_from_bstri_be,            },
    { "BIG_FROM_BSTRI_LE",            big_from_bstri_le,            },
    { "BIG_GCD",                      big_gcd,                      },
    { "BIG_GE",                       big_ge,                       },
    { "BIG_GT",                       big_gt,                       },
    { "BIG_HASHCODE",                 big_hashcode,                 },
    { "BIG_ICONV1",                   big_iconv1,                   },
    { "BIG_ICONV3",                   big_iconv3,                   },
    { "BIG_INCR",                     big_incr,                     },
    { "BIG_IPOW",                     big_ipow,                     },
    { "BIG_LE",                       big_le,                       },
    { "BIG_LOG10",                    big_log10,                    },
    { "BIG_LOG2",                     big_log2,                     },
    { "BIG_LOWEST_SET_BIT",           big_lowest_set_bit,           },
    { "BIG_LSHIFT",                   big_lshift,                   },
    { "BIG_LSHIFT_ASSIGN",            big_lshift_assign,            },
    { "BIG_LT",                       big_lt,                       },
    { "BIG_MDIV",                     big_mdiv,                     },
    { "BIG_MOD",                      big_mod,                      },
    { "BIG_MULT",                     big_mult,                     },
    { "BIG_MULT_ASSIGN",              big_mult_assign,              },
    { "BIG_NE",                       big_ne,                       },
    { "BIG_NEGATE",                   big_negate,                   },
    { "BIG_ODD",                      big_odd,                      },
    { "BIG_ORD",                      big_ord,                      },
    { "BIG_PARSE1",                   big_parse1,                   },
    { "BIG_PARSE_BASED",              big_parse_based,              },
    { "BIG_PLUS",                     big_plus,                     },
    { "BIG_PRED",                     big_pred,                     },
    { "BIG_RADIX",                    big_RADIX,                    },
    { "BIG_RAND",                     big_rand,                     },
    { "BIG_REM",                      big_rem,                      },
    { "BIG_RSHIFT",                   big_rshift,                   },
    { "BIG_RSHIFT_ASSIGN",            big_rshift_assign,            },
    { "BIG_SBTR",                     big_sbtr,                     },
    { "BIG_SBTR_ASSIGN",              big_sbtr_assign,              },
    { "BIG_STR",                      big_str,                      },
    { "BIG_SUCC",                     big_succ,                     },
    { "BIG_TO_BSTRI_BE",              big_to_bstri_be,              },
    { "BIG_TO_BSTRI_LE",              big_to_bstri_le,              },
    { "BIG_VALUE",                    big_value,                    },
    { "BIG_radix",                    big_radix,                    },

    { "BIN_AND",                      bin_and,                      },
    { "BIN_AND_ASSIGN",               bin_and_assign,               },
    { "BIN_BIG",                      bin_big,                      },
    { "BIN_BINARY",                   bin_binary,                   },
    { "BIN_BIT_LENGTH",               bin_bit_length,               },
    { "BIN_BYTES_BE_2_UINT",          bin_bytes_be_2_uint,          },
    { "BIN_BYTES_LE_2_UINT",          bin_bytes_le_2_uint,          },
    { "BIN_CARD",                     bin_card,                     },
    { "BIN_CMP",                      bin_cmp,                      },
    { "BIN_GET_BINARY_FROM_SET",      bin_get_binary_from_set,      },
    { "BIN_LOWEST_SET_BIT",           bin_lowest_set_bit,           },
    { "BIN_LSHIFT",                   bin_lshift,                   },
    { "BIN_LSHIFT_ASSIGN",            bin_lshift_assign,            },
    { "BIN_N_BYTES_BE",               bin_n_bytes_be,               },
    { "BIN_N_BYTES_LE",               bin_n_bytes_le,               },
    { "BIN_OR",                       bin_or,                       },
    { "BIN_OR_ASSIGN",                bin_or_assign,                },
    { "BIN_RADIX",                    bin_RADIX,                    },
    { "BIN_RSHIFT",                   bin_rshift,                   },
    { "BIN_RSHIFT_ASSIGN",            bin_rshift_assign,            },
    { "BIN_STR",                      bin_str,                      },
    { "BIN_XOR",                      bin_xor,                      },
    { "BIN_XOR_ASSIGN",               bin_xor_assign,               },
    { "BIN_radix",                    bin_radix,                    },

    { "BLN_AND",                      bln_and,                      },
    { "BLN_AND_ASSIGN",               bln_and_assign,               },
    { "BLN_CPY",                      bln_cpy,                      },
    { "BLN_CREATE",                   bln_create,                   },
    { "BLN_EQ",                       bln_eq,                       },
    { "BLN_GE",                       bln_ge,                       },
    { "BLN_GT",                       bln_gt,                       },
    { "BLN_ICONV1",                   bln_iconv1,                   },
    { "BLN_ICONV3",                   bln_iconv3,                   },
    { "BLN_LE",                       bln_le,                       },
    { "BLN_LT",                       bln_lt,                       },
    { "BLN_NE",                       bln_ne,                       },
    { "BLN_NOT",                      bln_not,                      },
    { "BLN_OR",                       bln_or,                       },
    { "BLN_ORD",                      bln_ord,                      },
    { "BLN_OR_ASSIGN",                bln_or_assign,                },
    { "BLN_PRED",                     bln_pred,                     },
    { "BLN_SUCC",                     bln_succ,                     },
    { "BLN_TERNARY",                  bln_ternary,                  },
    { "BLN_VALUE",                    bln_value,                    },
    { "BLN_XOR_ASSIGN",               bln_xor_assign,               },

    { "BST_APPEND",                   bst_append,                   },
    { "BST_CAT",                      bst_cat,                      },
    { "BST_CMP",                      bst_cmp,                      },
    { "BST_CPY",                      bst_cpy,                      },
    { "BST_CREATE",                   bst_create,                   },
    { "BST_DESTR",                    bst_destr,                    },
    { "BST_EMPTY",                    bst_empty,                    },
    { "BST_EQ",                       bst_eq,                       },
    { "BST_HASHCODE",                 bst_hashcode,                 },
    { "BST_IDX",                      bst_idx,                      },
    { "BST_LNG",                      bst_lng,                      },
    { "BST_NE",                       bst_ne,                       },
    { "BST_PARSE1",                   bst_parse1,                   },
    { "BST_STR",                      bst_str,                      },
    { "BST_VALUE",                    bst_value,                    },

    { "CHR_CLIT",                     chr_clit,                     },
    { "CHR_CMP",                      chr_cmp,                      },
    { "CHR_CPY",                      chr_cpy,                      },
    { "CHR_CREATE",                   chr_create,                   },
    { "CHR_DECR",                     chr_decr,                     },
    { "CHR_EQ",                       chr_eq,                       },
    { "CHR_GE",                       chr_ge,                       },
    { "CHR_GT",                       chr_gt,                       },
    { "CHR_HASHCODE",                 chr_hashcode,                 },
    { "CHR_ICONV1",                   chr_iconv1,                   },
    { "CHR_ICONV3",                   chr_iconv3,                   },
    { "CHR_INCR",                     chr_incr,                     },
    { "CHR_IS_LETTER",                chr_is_letter,                },
    { "CHR_LE",                       chr_le,                       },
    { "CHR_LOW",                      chr_low,                      },
    { "CHR_LT",                       chr_lt,                       },
    { "CHR_NE",                       chr_ne,                       },
    { "CHR_ORD",                      chr_ord,                      },
    { "CHR_PRED",                     chr_pred,                     },
    { "CHR_STR",                      chr_str,                      },
    { "CHR_SUCC",                     chr_succ,                     },
    { "CHR_UP",                       chr_up,                       },
    { "CHR_VALUE",                    chr_value,                    },
    { "CHR_WIDTH",                    chr_width,                    },

    { "CMD_BIG_FILESIZE",             cmd_big_filesize,             },
    { "CMD_CHDIR",                    cmd_chdir,                    },
    { "CMD_CLONE_FILE",               cmd_clone_file,               },
    { "CMD_CONFIG_VALUE",             cmd_config_value,             },
    { "CMD_COPY_FILE",                cmd_copy_file,                },
    { "CMD_ENVIRONMENT",              cmd_environment,              },
    { "CMD_FILESIZE",                 cmd_filesize,                 },
    { "CMD_FILETYPE",                 cmd_filetype,                 },
    { "CMD_FILETYPE_SL",              cmd_filetype_sl,              },
    { "CMD_FINAL_PATH",               cmd_final_path,               },
    { "CMD_GETCWD",                   cmd_getcwd,                   },
    { "CMD_GETENV",                   cmd_getenv,                   },
    { "CMD_GET_ATIME",                cmd_get_atime,                },
    { "CMD_GET_ATIME_OF_SYMLINK",     cmd_get_atime_of_symlink,     },
    { "CMD_GET_CTIME",                cmd_get_ctime,                },
    { "CMD_GET_FILE_MODE",            cmd_get_file_mode,            },
    { "CMD_GET_FILE_MODE_OF_SYMLINK", cmd_get_file_mode_of_symlink, },
    { "CMD_GET_GROUP",                cmd_get_group,                },
    { "CMD_GET_GROUP_OF_SYMLINK",     cmd_get_group_of_symlink,     },
    { "CMD_GET_MTIME",                cmd_get_mtime,                },
    { "CMD_GET_MTIME_OF_SYMLINK",     cmd_get_mtime_of_symlink,     },
    { "CMD_GET_OWNER",                cmd_get_owner,                },
    { "CMD_GET_OWNER_OF_SYMLINK",     cmd_get_owner_of_symlink,     },
    { "CMD_GET_SEARCH_PATH",          cmd_get_search_path,          },
    { "CMD_HOME_DIR",                 cmd_home_dir,                 },
    { "CMD_MAKE_DIR",                 cmd_make_dir,                 },
    { "CMD_MAKE_LINK",                cmd_make_link,                },
    { "CMD_MOVE",                     cmd_move,                     },
    { "CMD_READ_DIR",                 cmd_read_dir,                 },
    { "CMD_READ_LINK",                cmd_read_link,                },
    { "CMD_READ_LINK_ABSOLUTE",       cmd_read_link_absolute,       },
    { "CMD_REMOVE_FILE",              cmd_remove_file,              },
    { "CMD_REMOVE_TREE",              cmd_remove_tree,              },
    { "CMD_SETENV",                   cmd_setenv,                   },
    { "CMD_SET_ATIME",                cmd_set_atime,                },
    { "CMD_SET_FILE_MODE",            cmd_set_file_mode,            },
    { "CMD_SET_GROUP",                cmd_set_group,                },
    { "CMD_SET_GROUP_OF_SYMLINK",     cmd_set_group_of_symlink,     },
    { "CMD_SET_MTIME",                cmd_set_mtime,                },
    { "CMD_SET_MTIME_OF_SYMLINK",     cmd_set_mtime_of_symlink,     },
    { "CMD_SET_OWNER",                cmd_set_owner,                },
    { "CMD_SET_OWNER_OF_SYMLINK",     cmd_set_owner_of_symlink,     },
    { "CMD_SET_SEARCH_PATH",          cmd_set_search_path,          },
    { "CMD_SHELL",                    cmd_shell,                    },
    { "CMD_SHELL_ESCAPE",             cmd_shell_escape,             },
    { "CMD_TO_OS_PATH",               cmd_to_os_path,               },
    { "CMD_UNSETENV",                 cmd_unsetenv,                 },

    { "CON_CLEAR",                    con_clear,                    },
    { "CON_COLUMN",                   con_column,                   },
    { "CON_CURSOR",                   con_cursor,                   },
    { "CON_FLUSH",                    con_flush,                    },
    { "CON_HEIGHT",                   con_height,                   },
    { "CON_H_SCL",                    con_h_scl,                    },
    { "CON_LINE",                     con_line,                     },
    { "CON_OPEN",                     con_open,                     },
    { "CON_SETPOS",                   con_setpos,                   },
    { "CON_V_SCL",                    con_v_scl,                    },
    { "CON_WIDTH",                    con_width,                    },
    { "CON_WRITE",                    con_write,                    },

    { "DCL_ATTR",                     dcl_attr,                     },
    { "DCL_CONST",                    dcl_const,                    },
    { "DCL_ELEMENTS",                 dcl_elements,                 },
    { "DCL_FWD",                      dcl_fwd,                      },
    { "DCL_FWDVAR",                   dcl_fwdvar,                   },
    { "DCL_GETFUNC",                  dcl_getfunc,                  },
    { "DCL_GETOBJ",                   dcl_getobj,                   },
    { "DCL_GLOBAL",                   dcl_global,                   },
    { "DCL_IN1",                      dcl_in1,                      },
    { "DCL_IN1VAR",                   dcl_in1var,                   },
    { "DCL_IN2",                      dcl_in2,                      },
    { "DCL_IN2VAR",                   dcl_in2var,                   },
    { "DCL_INOUT1",                   dcl_inout1,                   },
    { "DCL_INOUT2",                   dcl_inout2,                   },
    { "DCL_PARAM_ATTR",               dcl_param_attr,               },
    { "DCL_REF1",                     dcl_ref1,                     },
    { "DCL_REF2",                     dcl_ref2,                     },
    { "DCL_SYMB",                     dcl_symb,                     },
    { "DCL_SYNTAX",                   dcl_syntax,                   },
    { "DCL_VAL1",                     dcl_val1,                     },
    { "DCL_VAL2",                     dcl_val2,                     },
    { "DCL_VAR",                      dcl_var,                      },

#if WITH_DRAW
    { "DRW_BORDER",                   drw_border,                   },
    { "DRW_CAPTURE",                  drw_capture,                  },
    { "DRW_CLEAR",                    drw_clear,                    },
    { "DRW_CMP",                      drw_cmp,                      },
    { "DRW_CONV_POINT_LIST",          drw_conv_point_list,          },
    { "DRW_COPYAREA",                 drw_copyarea,                 },
    { "DRW_CPY",                      drw_cpy,                      },
    { "DRW_CREATE",                   drw_create,                   },
    { "DRW_DESTR",                    drw_destr,                    },
    { "DRW_EMPTY",                    drw_empty,                    },
    { "DRW_EQ",                       drw_eq,                       },
    { "DRW_FLUSH",                    drw_flush,                    },
    { "DRW_FPOLY_LINE",               drw_fpoly_line,               },
    { "DRW_GEN_POINT_LIST",           drw_gen_point_list,           },
    { "DRW_GET_IMAGE_PIXEL",          drw_get_image_pixel,          },
    { "DRW_GET_PIXEL",                drw_get_pixel,                },
    { "DRW_GET_PIXEL_ARRAY",          drw_get_pixel_array,          },
    { "DRW_GET_PIXEL_DATA",           drw_get_pixel_data,           },
    { "DRW_GET_PIXEL_DATA_FROM_ARRAY",drw_get_pixel_data_from_array,},
    { "DRW_GET_PIXMAP",               drw_get_pixmap,               },
    { "DRW_GET_PIXMAP_FROM_PIXELS",   drw_get_pixmap_from_pixels,   },
    { "DRW_HASHCODE",                 drw_hashcode,                 },
    { "DRW_HEIGHT",                   drw_height,                   },
    { "DRW_NE",                       drw_ne,                       },
    { "DRW_NEW_PIXMAP",               drw_new_pixmap,               },
    { "DRW_OPEN",                     drw_open,                     },
    { "DRW_OPEN_SUB_WINDOW",          drw_open_sub_window,          },
    { "DRW_PARC",                     drw_parc,                     },
    { "DRW_PCIRCLE",                  drw_pcircle,                  },
    { "DRW_PFARC",                    drw_pfarc,                    },
    { "DRW_PFARCCHORD",               drw_pfarcchord,               },
    { "DRW_PFARCPIESLICE",            drw_pfarcpieslice,            },
    { "DRW_PFCIRCLE",                 drw_pfcircle,                 },
    { "DRW_PFELLIPSE",                drw_pfellipse,                },
    { "DRW_PIXEL_TO_RGB",             drw_pixel_to_rgb,             },
    { "DRW_PLINE",                    drw_pline,                    },
    { "DRW_POINTER_XPOS",             drw_pointer_xpos,             },
    { "DRW_POINTER_YPOS",             drw_pointer_ypos,             },
    { "DRW_POLY_LINE",                drw_poly_line,                },
    { "DRW_PPOINT",                   drw_ppoint,                   },
    { "DRW_PRECT",                    drw_prect,                    },
    { "DRW_PUT",                      drw_put,                      },
    { "DRW_PUT_SCALED",               drw_put_scaled,               },
    { "DRW_RGBCOL",                   drw_rgbcol,                   },
 /* { "DRW_ROT",                      drw_rot,                      }, */
 /* { "DRW_SCALE",                    drw_scale,                    }, */
    { "DRW_SCREEN_HEIGHT",            drw_screen_height,            },
    { "DRW_SCREEN_WIDTH",             drw_screen_width,             },
    { "DRW_SET_CONTENT",              drw_set_content,              },
    { "DRW_SET_CURSOR_VISIBLE",       drw_set_cursor_visible,       },
    { "DRW_SET_POINTER_POS",          drw_set_pointer_pos,          },
    { "DRW_SET_POS",                  drw_set_pos,                  },
    { "DRW_SET_SIZE",                 drw_set_size,                 },
    { "DRW_SET_TRANSPARENT_COLOR",    drw_set_transparent_color,    },
    { "DRW_SET_WINDOW_NAME",          drw_set_window_name,          },
    { "DRW_TEXT",                     drw_text,                     },
    { "DRW_TO_BOTTOM",                drw_to_bottom,                },
    { "DRW_TO_TOP",                   drw_to_top,                   },
    { "DRW_VALUE",                    drw_value,                    },
    { "DRW_WIDTH",                    drw_width,                    },
    { "DRW_XPOS",                     drw_xpos,                     },
    { "DRW_YPOS",                     drw_ypos,                     },
#endif

    { "ENU_CONV",                     enu_conv,                     },
    { "ENU_CPY",                      enu_cpy,                      },
    { "ENU_CREATE",                   enu_create,                   },
    { "ENU_EQ",                       enu_eq,                       },
    { "ENU_GENLIT",                   enu_genlit,                   },
    { "ENU_ICONV2",                   enu_iconv2,                   },
    { "ENU_LIT",                      enu_lit,                      },
    { "ENU_NE",                       enu_ne,                       },
    { "ENU_ORD2",                     enu_ord2,                     },
    { "ENU_VALUE",                    enu_value,                    },

    { "FIL_BIG_LNG",                  fil_big_lng,                  },
    { "FIL_BIG_SEEK",                 fil_big_seek,                 },
    { "FIL_BIG_TELL",                 fil_big_tell,                 },
    { "FIL_CLOSE",                    fil_close,                    },
    { "FIL_CPY",                      fil_cpy,                      },
    { "FIL_CREATE",                   fil_create,                   },
    { "FIL_DESTR",                    fil_destr,                    },
    { "FIL_EMPTY",                    fil_empty,                    },
    { "FIL_EOF",                      fil_eof,                      },
    { "FIL_EQ",                       fil_eq,                       },
    { "FIL_ERR",                      fil_err,                      },
    { "FIL_FLUSH",                    fil_flush,                    },
    { "FIL_GETC",                     fil_getc,                     },
    { "FIL_GETS",                     fil_gets,                     },
    { "FIL_HAS_NEXT",                 fil_has_next,                 },
    { "FIL_IN",                       fil_in,                       },
    { "FIL_INPUT_READY",              fil_input_ready,              },
    { "FIL_LINE_READ",                fil_line_read,                },
    { "FIL_LIT",                      fil_lit,                      },
    { "FIL_LNG",                      fil_lng,                      },
    { "FIL_NE",                       fil_ne,                       },
    { "FIL_OPEN",                     fil_open,                     },
    { "FIL_OPEN_NULL_DEVICE",         fil_open_null_device,         },
    { "FIL_OUT",                      fil_out,                      },
    { "FIL_PCLOSE",                   fil_pclose,                   },
    { "FIL_PIPE",                     fil_pipe,                     },
    { "FIL_POPEN",                    fil_popen,                    },
    { "FIL_PRINT",                    fil_print,                    },
    { "FIL_SEEK",                     fil_seek,                     },
    { "FIL_SEEKABLE",                 fil_seekable,                 },
    { "FIL_SETBUF",                   fil_setbuf,                   },
    { "FIL_TELL",                     fil_tell,                     },
    { "FIL_TERMINATED_READ",          fil_terminated_read,          },
    { "FIL_TRUNCATE",                 fil_truncate,                 },
    { "FIL_VALUE",                    fil_value,                    },
    { "FIL_WORD_READ",                fil_word_read,                },
    { "FIL_WRITE",                    fil_write,                    },

#if WITH_FLOAT
    { "FLT_ABS",                      flt_abs,                      },
    { "FLT_ACOS",                     flt_acos,                     },
    { "FLT_ADD",                      flt_add,                      },
    { "FLT_ADD_ASSIGN",               flt_add_assign,               },
    { "FLT_ASIN",                     flt_asin,                     },
    { "FLT_ATAN",                     flt_atan,                     },
    { "FLT_ATAN2",                    flt_atan2,                    },
    { "FLT_BITS2DOUBLE",              flt_bits2double,              },
    { "FLT_BITS2SINGLE",              flt_bits2single,              },
    { "FLT_CEIL",                     flt_ceil,                     },
    { "FLT_CMP",                      flt_cmp,                      },
    { "FLT_COS",                      flt_cos,                      },
    { "FLT_COSH",                     flt_cosh,                     },
    { "FLT_CPY",                      flt_cpy,                      },
    { "FLT_CREATE",                   flt_create,                   },
    { "FLT_DECOMPOSE",                flt_decompose,                },
    { "FLT_DGTS",                     flt_dgts,                     },
    { "FLT_DIV",                      flt_div,                      },
    { "FLT_DIV_ASSIGN",               flt_div_assign,               },
    { "FLT_DOUBLE2BITS",              flt_double2bits,              },
    { "FLT_EQ",                       flt_eq,                       },
    { "FLT_EXP",                      flt_exp,                      },
    { "FLT_EXPM1",                    flt_expm1,                    },
    { "FLT_FLOOR",                    flt_floor,                    },
    { "FLT_GE",                       flt_ge,                       },
    { "FLT_GT",                       flt_gt,                       },
    { "FLT_HASHCODE",                 flt_hashcode,                 },
    { "FLT_ICONV1",                   flt_iconv1,                   },
    { "FLT_ICONV3",                   flt_iconv3,                   },
    { "FLT_IPOW",                     flt_ipow,                     },
    { "FLT_ISNAN",                    flt_isnan,                    },
    { "FLT_ISNEGATIVEZERO",           flt_isnegativezero,           },
    { "FLT_LE",                       flt_le,                       },
    { "FLT_LOG",                      flt_log,                      },
    { "FLT_LOG10",                    flt_log10,                    },
    { "FLT_LOG1P",                    flt_log1p,                    },
    { "FLT_LOG2",                     flt_log2,                     },
    { "FLT_LSHIFT",                   flt_lshift,                   },
    { "FLT_LT",                       flt_lt,                       },
    { "FLT_MOD",                      flt_mod,                      },
    { "FLT_MULT",                     flt_mult,                     },
    { "FLT_MULT_ASSIGN",              flt_mult_assign,              },
    { "FLT_NE",                       flt_ne,                       },
    { "FLT_NEGATE",                   flt_negate,                   },
    { "FLT_PARSE1",                   flt_parse1,                   },
    { "FLT_PLUS",                     flt_plus,                     },
    { "FLT_POW",                      flt_pow,                      },
    { "FLT_RAND",                     flt_rand,                     },
    { "FLT_REM",                      flt_rem,                      },
    { "FLT_ROUND",                    flt_round,                    },
    { "FLT_RSHIFT",                   flt_rshift,                   },
    { "FLT_SBTR",                     flt_sbtr,                     },
    { "FLT_SBTR_ASSIGN",              flt_sbtr_assign,              },
    { "FLT_SCI",                      flt_sci,                      },
    { "FLT_SIN",                      flt_sin,                      },
    { "FLT_SINGLE2BITS",              flt_single2bits,              },
    { "FLT_SINH",                     flt_sinh,                     },
    { "FLT_SQRT",                     flt_sqrt,                     },
    { "FLT_STR",                      flt_str,                      },
    { "FLT_STR_SCIENTIFIC",           flt_str_scientific,           },
    { "FLT_TAN",                      flt_tan,                      },
    { "FLT_TANH",                     flt_tanh,                     },
    { "FLT_TRUNC",                    flt_trunc,                    },
    { "FLT_VALUE",                    flt_value,                    },
#endif

    { "GEN_DESTR",                    gen_destr,                    },

#if WITH_DRAW
    { "GKB_BUTTON_PRESSED",           gkb_button_pressed,           },
    { "GKB_CLICKED_XPOS",             gkb_clicked_xpos,             },
    { "GKB_CLICKED_YPOS",             gkb_clicked_ypos,             },
    { "GKB_GETC",                     gkb_getc,                     },
    { "GKB_GETS",                     gkb_gets,                     },
    { "GKB_INPUT_READY",              gkb_input_ready,              },
    { "GKB_LINE_READ",                gkb_line_read,                },
    { "GKB_RAW_GETC",                 gkb_raw_getc,                 },
    { "GKB_SELECT_INPUT",             gkb_select_input,             },
    { "GKB_WINDOW",                   gkb_window,                   },
    { "GKB_WORD_READ",                gkb_word_read,                },
#endif

    { "HSH_CONCAT_KEY_VALUE",         hsh_concat_key_value,         },
    { "HSH_CONTAINS",                 hsh_contains,                 },
    { "HSH_CPY",                      hsh_cpy,                      },
    { "HSH_CREATE",                   hsh_create,                   },
    { "HSH_DESTR",                    hsh_destr,                    },
    { "HSH_EMPTY",                    hsh_empty,                    },
    { "HSH_EXCL",                     hsh_excl,                     },
    { "HSH_FOR",                      hsh_for,                      },
    { "HSH_FOR_DATA_KEY",             hsh_for_data_key,             },
    { "HSH_FOR_KEY",                  hsh_for_key,                  },
    { "HSH_GEN_HASH",                 hsh_gen_hash,                 },
    { "HSH_GEN_KEY_VALUE",            hsh_gen_key_value,            },
    { "HSH_IDX",                      hsh_idx,                      },
    { "HSH_IDX2",                     hsh_idx2,                     },
    { "HSH_INCL",                     hsh_incl,                     },
    { "HSH_KEYS",                     hsh_keys,                     },
    { "HSH_LNG",                      hsh_lng,                      },
    { "HSH_RAND_KEY",                 hsh_rand_key,                 },
    { "HSH_REFIDX",                   hsh_refidx,                   },
    { "HSH_UPDATE",                   hsh_update,                   },
    { "HSH_VALUES",                   hsh_values,                   },

    { "INT_ABS",                      int_abs,                      },
    { "INT_ADD",                      int_add,                      },
    { "INT_ADD_ASSIGN",               int_add_assign,               },
    { "INT_BINOM",                    int_binom,                    },
    { "INT_BIT_LENGTH",               int_bit_length,               },
    { "INT_BYTES_BE_2_INT",           int_bytes_be_2_int,           },
    { "INT_BYTES_BE_2_UINT",          int_bytes_be_2_uint,          },
    { "INT_BYTES_BE_SIGNED",          int_bytes_be_signed,          },
    { "INT_BYTES_BE_UNSIGNED",        int_bytes_be_unsigned,        },
    { "INT_BYTES_LE_2_INT",           int_bytes_le_2_int,           },
    { "INT_BYTES_LE_2_UINT",          int_bytes_le_2_uint,          },
    { "INT_BYTES_LE_SIGNED",          int_bytes_le_signed,          },
    { "INT_BYTES_LE_UNSIGNED",        int_bytes_le_unsigned,        },
    { "INT_CMP",                      int_cmp,                      },
    { "INT_CPY",                      int_cpy,                      },
    { "INT_CREATE",                   int_create,                   },
    { "INT_DECR",                     int_decr,                     },
    { "INT_DIV",                      int_div,                      },
    { "INT_EQ",                       int_eq,                       },
    { "INT_FACT",                     int_fact,                     },
    { "INT_GE",                       int_ge,                       },
    { "INT_GT",                       int_gt,                       },
    { "INT_HASHCODE",                 int_hashcode,                 },
    { "INT_ICONV1",                   int_iconv1,                   },
    { "INT_ICONV3",                   int_iconv3,                   },
    { "INT_INCR",                     int_incr,                     },
    { "INT_LE",                       int_le,                       },
    { "INT_LOG10",                    int_log10,                    },
    { "INT_LOG2",                     int_log2,                     },
    { "INT_LOWEST_SET_BIT",           int_lowest_set_bit,           },
    { "INT_LPAD0",                    int_lpad0,                    },
    { "INT_LSHIFT",                   int_lshift,                   },
    { "INT_LSHIFT_ASSIGN",            int_lshift_assign,            },
    { "INT_LT",                       int_lt,                       },
    { "INT_MDIV",                     int_mdiv,                     },
    { "INT_MOD",                      int_mod,                      },
    { "INT_MULT",                     int_mult,                     },
    { "INT_MULT_ASSIGN",              int_mult_assign,              },
    { "INT_NE",                       int_ne,                       },
    { "INT_NEGATE",                   int_negate,                   },
    { "INT_N_BYTES_BE_SIGNED",        int_n_bytes_be_signed,        },
    { "INT_N_BYTES_BE_UNSIGNED",      int_n_bytes_be_unsigned,      },
    { "INT_N_BYTES_LE_SIGNED",        int_n_bytes_le_signed,        },
    { "INT_N_BYTES_LE_UNSIGNED",      int_n_bytes_le_unsigned,      },
    { "INT_ODD",                      int_odd,                      },
    { "INT_PARSE1",                   int_parse1,                   },
    { "INT_PLUS",                     int_plus,                     },
    { "INT_POW",                      int_pow,                      },
    { "INT_PRED",                     int_pred,                     },
    { "INT_RADIX",                    int_RADIX,                    },
    { "INT_RAND",                     int_rand,                     },
    { "INT_REM",                      int_rem,                      },
    { "INT_RSHIFT",                   int_rshift,                   },
    { "INT_RSHIFT_ASSIGN",            int_rshift_assign,            },
    { "INT_SBTR",                     int_sbtr,                     },
    { "INT_SBTR_ASSIGN",              int_sbtr_assign,              },
    { "INT_SQRT",                     int_sqrt,                     },
    { "INT_STR",                      int_str,                      },
    { "INT_SUCC",                     int_succ,                     },
    { "INT_VALUE",                    int_value,                    },
    { "INT_radix",                    int_radix,                    },

    { "ITF_CMP",                      itf_cmp,                      },
    { "ITF_CONV2",                    itf_conv2,                    },
    { "ITF_CPY",                      itf_cpy,                      },
    { "ITF_CPY2",                     itf_cpy2,                     },
    { "ITF_CREATE",                   itf_create,                   },
    { "ITF_CREATE2",                  itf_create2,                  },
    { "ITF_DESTR",                    itf_destr,                    },
    { "ITF_EQ",                       itf_eq,                       },
    { "ITF_HASHCODE",                 itf_hashcode,                 },
    { "ITF_NE",                       itf_ne,                       },
    { "ITF_SELECT",                   itf_select,                   },
    { "ITF_TO_INTERFACE",             itf_to_interface,             },

    { "KBD_GETC",                     kbd_getc,                     },
    { "KBD_GETS",                     kbd_gets,                     },
    { "KBD_INPUT_READY",              kbd_input_ready,              },
    { "KBD_LINE_READ",                kbd_line_read,                },
    { "KBD_RAW_GETC",                 kbd_raw_getc,                 },
    { "KBD_WORD_READ",                kbd_word_read,                },

    { "LST_CAT",                      lst_cat,                      },
    { "LST_CPY",                      lst_cpy,                      },
    { "LST_CREATE",                   lst_create,                   },
    { "LST_DESTR",                    lst_destr,                    },
    { "LST_EMPTY",                    lst_empty,                    },
    { "LST_EXCL",                     lst_excl,                     },
    { "LST_HEAD",                     lst_head,                     },
    { "LST_IDX",                      lst_idx,                      },
    { "LST_INCL",                     lst_incl,                     },
    { "LST_LNG",                      lst_lng,                      },
    { "LST_RANGE",                    lst_range,                    },
    { "LST_TAIL",                     lst_tail,                     },

    { "PCS_CHILD_STDERR",             pcs_child_stderr,             },
    { "PCS_CHILD_STDIN",              pcs_child_stdin,              },
    { "PCS_CHILD_STDOUT",             pcs_child_stdout,             },
    { "PCS_CMP",                      pcs_cmp,                      },
    { "PCS_CPY",                      pcs_cpy,                      },
    { "PCS_CREATE",                   pcs_create,                   },
    { "PCS_DESTR",                    pcs_destr,                    },
    { "PCS_EMPTY",                    pcs_empty,                    },
    { "PCS_EQ",                       pcs_eq,                       },
    { "PCS_EXIT_VALUE",               pcs_exit_value,               },
    { "PCS_HASHCODE",                 pcs_hashcode,                 },
    { "PCS_IS_ALIVE",                 pcs_is_alive,                 },
    { "PCS_KILL",                     pcs_kill,                     },
    { "PCS_NE",                       pcs_ne,                       },
    { "PCS_PIPE2",                    pcs_pipe2,                    },
    { "PCS_PTY",                      pcs_pty,                      },
    { "PCS_START",                    pcs_start,                    },
    { "PCS_START_PIPE",               pcs_start_pipe,               },
    { "PCS_STR",                      pcs_str,                      },
    { "PCS_VALUE",                    pcs_value,                    },
    { "PCS_WAIT_FOR",                 pcs_wait_for,                 },

#if WITH_DRAW
    { "PLT_BSTRING",                  plt_bstring,                  },
    { "PLT_CMP",                      plt_cmp,                      },
    { "PLT_CPY",                      plt_cpy,                      },
    { "PLT_CREATE",                   plt_create,                   },
    { "PLT_DESTR",                    plt_destr,                    },
    { "PLT_EMPTY",                    plt_empty,                    },
    { "PLT_EQ",                       plt_eq,                       },
    { "PLT_HASHCODE",                 plt_hashcode,                 },
    { "PLT_NE",                       plt_ne,                       },
    { "PLT_POINT_LIST",               plt_point_list,               },
    { "PLT_VALUE",                    plt_value,                    },
#endif

    { "POL_ADD_CHECK",                pol_add_check,                },
    { "POL_CLEAR",                    pol_clear,                    },
    { "POL_CPY",                      pol_cpy,                      },
    { "POL_CREATE",                   pol_create,                   },
    { "POL_DESTR",                    pol_destr,                    },
    { "POL_EMPTY",                    pol_empty,                    },
    { "POL_GET_CHECK",                pol_get_check,                },
    { "POL_GET_FINDING",              pol_get_finding,              },
    { "POL_HAS_NEXT",                 pol_has_next,                 },
    { "POL_ITER_CHECKS",              pol_iter_checks,              },
    { "POL_ITER_FINDINGS",            pol_iter_findings,            },
    { "POL_NEXT_FILE",                pol_next_file,                },
    { "POL_POLL",                     pol_poll,                     },
    { "POL_REMOVE_CHECK",             pol_remove_check,             },
    { "POL_VALUE",                    pol_value,                    },

    { "PRC_ARGS",                     prc_args,                     },
    { "PRC_BEGIN",                    prc_begin,                    },
    { "PRC_BEGIN_NOOP",               prc_begin_noop,               },
    { "PRC_BLOCK",                    prc_block,                    },
    { "PRC_BLOCK_CATCH_ALL",          prc_block_catch_all,          },
    { "PRC_BLOCK_OTHERWISE",          prc_block_otherwise,          },
    { "PRC_CASE",                     prc_case,                     },
    { "PRC_CASE_DEF",                 prc_case_def,                 },
    { "PRC_CASE_HASHSET",             prc_case_hashset,             },
    { "PRC_CASE_HASHSET_DEF",         prc_case_hashset_def,         },
    { "PRC_CPY",                      prc_cpy,                      },
    { "PRC_CREATE",                   prc_create,                   },
    { "PRC_DECLS",                    prc_decls,                    },
    { "PRC_DESTR",                    prc_destr,                    },
    { "PRC_DYNAMIC",                  prc_dynamic,                  },
    { "PRC_EXIT",                     prc_exit,                     },
    { "PRC_FOR_DOWNTO",               prc_for_downto,               },
    { "PRC_FOR_DOWNTO_STEP",          prc_for_downto_step,          },
    { "PRC_FOR_TO",                   prc_for_to,                   },
    { "PRC_FOR_TO_STEP",              prc_for_to_step,              },
    { "PRC_HEAPSTAT",                 prc_heapstat,                 },
    { "PRC_HSIZE",                    prc_hsize,                    },
    { "PRC_IF",                       prc_if,                       },
    { "PRC_IF_ELSIF",                 prc_if_elsif,                 },
    { "PRC_IF_NOOP",                  prc_if_noop,                  },
    { "PRC_INCLUDE",                  prc_include,                  },
    { "PRC_LINE",                     prc_line,                     },
    { "PRC_LOCAL",                    prc_local,                    },
    { "PRC_NOOP",                     prc_noop,                     },
    { "PRC_RAISE",                    prc_raise,                    },
    { "PRC_REPEAT",                   prc_repeat,                   },
    { "PRC_REPEAT_NOOP",              prc_repeat_noop,              },
    { "PRC_RES_BEGIN",                prc_res_begin,                },
    { "PRC_RES_LOCAL",                prc_res_local,                },
    { "PRC_RETURN",                   prc_return,                   },
    { "PRC_RETURN2",                  prc_return2,                  },
    { "PRC_RETURN_VAR",               prc_return_var,               },
    { "PRC_RETURN_VAR2",              prc_return_var2,              },
    { "PRC_SEMICOLON",                prc_semicolon,                },
    { "PRC_SETTRACE",                 prc_settrace,                 },
    { "PRC_TRACE",                    prc_trace,                    },
    { "PRC_WHILE",                    prc_while,                    },
    { "PRC_WHILE_NOOP",               prc_while_noop,               },

    { "PRG_BSTRI_PARSE",              prg_bstri_parse,              },
    { "PRG_CMP",                      prg_cmp,                      },
    { "PRG_CPY",                      prg_cpy,                      },
    { "PRG_CREATE",                   prg_create,                   },
    { "PRG_DESTR",                    prg_destr,                    },
    { "PRG_EMPTY",                    prg_empty,                    },
    { "PRG_EQ",                       prg_eq,                       },
    { "PRG_ERROR_COUNT",              prg_error_count,              },
    { "PRG_EVAL",                     prg_eval,                     },
    { "PRG_EVAL_WITH_ARGS",           prg_eval_with_args,           },
    { "PRG_EXEC",                     prg_exec,                     },
    { "PRG_FIL_PARSE",                prg_fil_parse,                },
    { "PRG_GET_ERROR",                prg_get_error,                },
    { "PRG_GLOBAL_OBJECTS",           prg_global_objects,           },
    { "PRG_HASHCODE",                 prg_hashcode,                 },
    { "PRG_MATCH",                    prg_match,                    },
    { "PRG_MATCH_EXPR",               prg_match_expr,               },
    { "PRG_NAME",                     prg_name,                     },
    { "PRG_NE",                       prg_ne,                       },
    { "PRG_OWN_NAME",                 prg_own_name,                 },
    { "PRG_OWN_PATH",                 prg_own_path,                 },
    { "PRG_PATH",                     prg_path,                     },
    { "PRG_STRUCT_SYMBOLS",           prg_struct_symbols,           },
    { "PRG_STR_PARSE",                prg_str_parse,                },
    { "PRG_SYOBJECT",                 prg_syobject,                 },
    { "PRG_SYSVAR",                   prg_sysvar,                   },
    { "PRG_VALUE",                    prg_value,                    },

#if WITH_REFERENCE
    { "REF_ADDR",                     ref_addr,                     },
    { "REF_ALLOC",                    ref_alloc,                    },
    { "REF_ALLOC_INT",                ref_alloc_int,                },
    { "REF_ALLOC_STRI",               ref_alloc_stri,               },
    { "REF_ALLOC_VAR",                ref_alloc_var,                },
    { "REF_APPEND_PARAMS",            ref_append_params,            },
    { "REF_ARRMAXIDX",                ref_arrmaxidx,                },
    { "REF_ARRMINIDX",                ref_arrminidx,                },
    { "REF_ARRTOLIST",                ref_arrtolist,                },
    { "REF_BODY",                     ref_body,                     },
    { "REF_CAST",                     ref_cast,                     },
    { "REF_CATEGORY",                 ref_category,                 },
    { "REF_CAT_PARSE",                ref_cat_parse,                },
    { "REF_CAT_STR",                  ref_cat_str,                  },
    { "REF_CMP",                      ref_cmp,                      },
    { "REF_CONTENT",                  ref_content,                  },
    { "REF_CPY",                      ref_cpy,                      },
    { "REF_CREATE",                   ref_create,                   },
    { "REF_DEREF",                    ref_deref,                    },
    { "REF_EQ",                       ref_eq,                       },
    { "REF_FILE",                     ref_file,                     },
    { "REF_GETREF",                   ref_getref,                   },
    { "REF_HASHCODE",                 ref_hashcode,                 },
    { "REF_HSHDATATOLIST",            ref_hshdatatolist,            },
    { "REF_HSHKEYSTOLIST",            ref_hshkeystolist,            },
    { "REF_HSHLENGTH",                ref_hshlength,                },
    { "REF_ISSYMB",                   ref_issymb,                   },
    { "REF_ISTEMP",                   ref_istemp,                   },
    { "REF_ISVAR",                    ref_isvar,                    },
    { "REF_ITFTOSCT",                 ref_itftosct,                 },
    { "REF_LINE",                     ref_line,                     },
    { "REF_LOCAL_CONSTS",             ref_local_consts,             },
    { "REF_LOCAL_VARS",               ref_local_vars,               },
    { "REF_MKREF",                    ref_mkref,                    },
    { "REF_NE",                       ref_ne,                       },
    { "REF_NIL",                      ref_nil,                      },
    { "REF_NUM",                      ref_num,                      },
    { "REF_PARAMS",                   ref_params,                   },
    { "REF_PATH",                     ref_path,                     },
    { "REF_PROG",                     ref_prog,                     },
    { "REF_RESINI",                   ref_resini,                   },
    { "REF_RESULT",                   ref_result,                   },
    { "REF_SCAN",                     ref_scan,                     },
    { "REF_SCTTOLIST",                ref_scttolist,                },
    { "REF_SELECT",                   ref_select,                   },
    { "REF_SETCATEGORY",              ref_setcategory,              },
    { "REF_SETPARAMS",                ref_setparams,                },
    { "REF_SETTYPE",                  ref_settype,                  },
    { "REF_SETVAR",                   ref_setvar,                   },
    { "REF_STR",                      ref_str,                      },
    { "REF_SYMB",                     ref_symb,                     },
    { "REF_TRACE",                    ref_trace,                    },
    { "REF_TYPE",                     ref_type,                     },
    { "REF_VALUE",                    ref_value,                    },

    { "RFL_APPEND",                   rfl_append,                   },
    { "RFL_CAT",                      rfl_cat,                      },
    { "RFL_CPY",                      rfl_cpy,                      },
    { "RFL_CREATE",                   rfl_create,                   },
    { "RFL_DESTR",                    rfl_destr,                    },
    { "RFL_ELEM",                     rfl_elem,                     },
    { "RFL_ELEMCPY",                  rfl_elemcpy,                  },
    { "RFL_EMPTY",                    rfl_empty,                    },
    { "RFL_EQ",                       rfl_eq,                       },
    { "RFL_EXCL",                     rfl_excl,                     },
    { "RFL_EXPR",                     rfl_expr,                     },
    { "RFL_FOR",                      rfl_for,                      },
    { "RFL_FOR_UNTIL",                rfl_for_until,                },
    { "RFL_HEAD",                     rfl_head,                     },
    { "RFL_IDX",                      rfl_idx,                      },
    { "RFL_INCL",                     rfl_incl,                     },
    { "RFL_IPOS",                     rfl_ipos,                     },
    { "RFL_LNG",                      rfl_lng,                      },
    { "RFL_MKLIST",                   rfl_mklist,                   },
    { "RFL_NE",                       rfl_ne,                       },
    { "RFL_NOT_ELEM",                 rfl_not_elem,                 },
    { "RFL_POS",                      rfl_pos,                      },
    { "RFL_RANGE",                    rfl_range,                    },
    { "RFL_SET_VALUE",                rfl_set_value,                },
    { "RFL_TAIL",                     rfl_tail,                     },
    { "RFL_TRACE",                    rfl_trace,                    },
    { "RFL_VALUE",                    rfl_value,                    },
#endif

    { "SCT_ALLOC",                    sct_alloc,                    },
    { "SCT_CAT",                      sct_cat,                      },
    { "SCT_CONV",                     sct_conv,                     },
    { "SCT_CPY",                      sct_cpy,                      },
    { "SCT_CREATE",                   sct_create,                   },
    { "SCT_DESTR",                    sct_destr,                    },
    { "SCT_EMPTY",                    sct_empty,                    },
    { "SCT_INCL",                     sct_incl,                     },
    { "SCT_LNG",                      sct_lng,                      },
    { "SCT_REFIDX",                   sct_refidx,                   },
    { "SCT_SELECT",                   sct_select,                   },

    { "SEL_CMP",                      sel_cmp,                      },
    { "SEL_CONV1",                    sel_conv1,                    },
    { "SEL_CPY",                      sel_cpy,                      },
    { "SEL_CREATE",                   sel_create,                   },
    { "SEL_EQ",                       sel_eq,                       },
    { "SEL_HASHCODE",                 sel_hashcode,                 },
    { "SEL_NAME",                     sel_name,                     },
    { "SEL_NE",                       sel_ne,                       },
    { "SEL_SYMB",                     sel_symb,                     },
    { "SEL_TYPE",                     sel_type,                     },

    { "SET_ARRLIT",                   set_arrlit,                   },
    { "SET_BASELIT",                  set_baselit,                  },
    { "SET_CARD",                     set_card,                     },
    { "SET_CMP",                      set_cmp,                      },
    { "SET_CONV1",                    set_conv1,                    },
    { "SET_CONV3",                    set_conv3,                    },
    { "SET_CPY",                      set_cpy,                      },
    { "SET_CREATE",                   set_create,                   },
    { "SET_DESTR",                    set_destr,                    },
    { "SET_DIFF",                     set_diff,                     },
    { "SET_DIFF_ASSIGN",              set_diff_assign,              },
    { "SET_ELEM",                     set_elem,                     },
    { "SET_EMPTY",                    set_empty,                    },
    { "SET_EQ",                       set_eq,                       },
    { "SET_EXCL",                     set_excl,                     },
    { "SET_GE",                       set_ge,                       },
    { "SET_GT",                       set_gt,                       },
    { "SET_HASHCODE",                 set_hashcode,                 },
    { "SET_ICONV1",                   set_iconv1,                   },
    { "SET_ICONV3",                   set_iconv3,                   },
    { "SET_INCL",                     set_incl,                     },
    { "SET_INTERSECT",                set_intersect,                },
    { "SET_INTERSECT_ASSIGN",         set_intersect_assign,         },
    { "SET_LE",                       set_le,                       },
    { "SET_LT",                       set_lt,                       },
    { "SET_MAX",                      set_max,                      },
    { "SET_MIN",                      set_min,                      },
    { "SET_NE",                       set_ne,                       },
    { "SET_NEXT",                     set_next,                     },
    { "SET_NOT_ELEM",                 set_not_elem,                 },
    { "SET_RAND",                     set_rand,                     },
    { "SET_RANGELIT",                 set_rangelit,                 },
    { "SET_SCONV1",                   set_sconv1,                   },
    { "SET_SCONV3",                   set_sconv3,                   },
    { "SET_SYMDIFF",                  set_symdiff,                  },
    { "SET_UNION",                    set_union,                    },
    { "SET_UNION_ASSIGN",             set_union_assign,             },
    { "SET_VALUE",                    set_value,                    },

    { "SOC_ACCEPT",                   soc_accept,                   },
    { "SOC_ADDR_FAMILY",              soc_addr_family,              },
    { "SOC_ADDR_NUMERIC",             soc_addr_numeric,             },
    { "SOC_ADDR_SERVICE",             soc_addr_service,             },
    { "SOC_BIND",                     soc_bind,                     },
    { "SOC_CLOSE",                    soc_close,                    },
    { "SOC_CONNECT",                  soc_connect,                  },
    { "SOC_CPY",                      soc_cpy,                      },
    { "SOC_CREATE",                   soc_create,                   },
    { "SOC_EMPTY",                    soc_empty,                    },
    { "SOC_EQ",                       soc_eq,                       },
    { "SOC_GETC",                     soc_getc,                     },
    { "SOC_GETS",                     soc_gets,                     },
    { "SOC_GET_HOSTNAME",             soc_get_hostname,             },
    { "SOC_GET_LOCAL_ADDR",           soc_get_local_addr,           },
    { "SOC_GET_PEER_ADDR",            soc_get_peer_addr,            },
    { "SOC_HAS_NEXT",                 soc_has_next,                 },
    { "SOC_INET_ADDR",                soc_inet_addr,                },
    { "SOC_INET_LOCAL_ADDR",          soc_inet_local_addr,          },
    { "SOC_INET_SERV_ADDR",           soc_inet_serv_addr,           },
    { "SOC_INPUT_READY",              soc_input_ready,              },
    { "SOC_LINE_READ",                soc_line_read,                },
    { "SOC_LISTEN",                   soc_listen,                   },
    { "SOC_NE",                       soc_ne,                       },
    { "SOC_ORD",                      soc_ord,                      },
    { "SOC_RECV",                     soc_recv,                     },
    { "SOC_RECVFROM",                 soc_recvfrom,                 },
    { "SOC_SEND",                     soc_send,                     },
    { "SOC_SENDTO",                   soc_sendto,                   },
    { "SOC_SET_OPT_BOOL",             soc_set_opt_bool,             },
    { "SOC_SOCKET",                   soc_socket,                   },
    { "SOC_WORD_READ",                soc_word_read,                },
    { "SOC_WRITE",                    soc_write,                    },

#if WITH_SQL
    { "SQL_BIND_BIGINT",              sql_bind_bigint,              },
    { "SQL_BIND_BIGRAT",              sql_bind_bigrat,              },
    { "SQL_BIND_BOOL",                sql_bind_bool,                },
    { "SQL_BIND_BSTRI",               sql_bind_bstri,               },
    { "SQL_BIND_DURATION",            sql_bind_duration,            },
    { "SQL_BIND_FLOAT",               sql_bind_float,               },
    { "SQL_BIND_INT",                 sql_bind_int,                 },
    { "SQL_BIND_NULL",                sql_bind_null,                },
    { "SQL_BIND_STRI",                sql_bind_stri,                },
    { "SQL_BIND_TIME",                sql_bind_time,                },
    { "SQL_CLOSE",                    sql_close,                    },
    { "SQL_CMP_DB",                   sql_cmp_db,                   },
    { "SQL_CMP_STMT",                 sql_cmp_stmt,                 },
    { "SQL_COLUMN_BIGINT",            sql_column_bigint,            },
    { "SQL_COLUMN_BIGRAT",            sql_column_bigrat,            },
    { "SQL_COLUMN_BOOL",              sql_column_bool,              },
    { "SQL_COLUMN_BSTRI",             sql_column_bstri,             },
    { "SQL_COLUMN_DURATION",          sql_column_duration,          },
    { "SQL_COLUMN_FLOAT",             sql_column_float,             },
    { "SQL_COLUMN_INT",               sql_column_int,               },
    { "SQL_COLUMN_STRI",              sql_column_stri,              },
    { "SQL_COLUMN_TIME",              sql_column_time,              },
    { "SQL_COMMIT",                   sql_commit,                   },
    { "SQL_CPY_DB",                   sql_cpy_db,                   },
    { "SQL_CPY_STMT",                 sql_cpy_stmt,                 },
    { "SQL_CREATE_DB",                sql_create_db,                },
    { "SQL_CREATE_STMT",              sql_create_stmt,              },
    { "SQL_DB_CATEGORY",              sql_db_category,              },
    { "SQL_DESTR_DB",                 sql_destr_db,                 },
    { "SQL_DESTR_STMT",               sql_destr_stmt,               },
    { "SQL_DRIVER",                   sql_driver,                   },
    { "SQL_EMPTY_DB",                 sql_empty_db,                 },
    { "SQL_EMPTY_STMT",               sql_empty_stmt,               },
    { "SQL_EQ_DB",                    sql_eq_db,                    },
    { "SQL_EQ_STMT",                  sql_eq_stmt,                  },
    { "SQL_ERR_CODE",                 sql_err_code,                 },
    { "SQL_ERR_DB_FUNC",              sql_err_db_func,              },
    { "SQL_ERR_LIB_FUNC",             sql_err_lib_func,             },
    { "SQL_ERR_MESSAGE",              sql_err_message,              },
    { "SQL_EXECUTE",                  sql_execute,                  },
    { "SQL_FETCH",                    sql_fetch,                    },
    { "SQL_GET_AUTO_COMMIT",          sql_get_auto_commit,          },
    { "SQL_IS_NULL",                  sql_is_null,                  },
    { "SQL_NE_DB",                    sql_ne_db,                    },
    { "SQL_NE_STMT",                  sql_ne_stmt,                  },
    { "SQL_OPEN_DB2",                 sql_open_db2,                 },
    { "SQL_OPEN_FIRE",                sql_open_fire,                },
    { "SQL_OPEN_INFORMIX",            sql_open_informix,            },
    { "SQL_OPEN_LITE",                sql_open_lite,                },
    { "SQL_OPEN_MY",                  sql_open_my,                  },
    { "SQL_OPEN_OCI",                 sql_open_oci,                 },
    { "SQL_OPEN_ODBC",                sql_open_odbc,                },
    { "SQL_OPEN_POST",                sql_open_post,                },
    { "SQL_OPEN_SQLSRV",              sql_open_sqlsrv,              },
    { "SQL_OPEN_TDS",                 sql_open_tds,                 },
    { "SQL_PREPARE",                  sql_prepare,                  },
    { "SQL_ROLLBACK",                 sql_rollback,                 },
    { "SQL_SET_AUTO_COMMIT",          sql_set_auto_commit,          },
    { "SQL_STMT_COLUMN_COUNT",        sql_stmt_column_count,        },
    { "SQL_STMT_COLUMN_NAME",         sql_stmt_column_name,         },
#endif

    { "STR_APPEND",                   str_append,                   },
    { "STR_CAT",                      str_cat,                      },
    { "STR_CHIPOS",                   str_chipos,                   },
    { "STR_CHPOS",                    str_chpos,                    },
    { "STR_CHSPLIT",                  str_chsplit,                  },
    { "STR_CLIT",                     str_clit,                     },
    { "STR_CMP",                      str_cmp,                      },
 /* { "STR_CNT",                      str_cnt,                      }, */
    { "STR_CPY",                      str_cpy,                      },
    { "STR_CREATE",                   str_create,                   },
    { "STR_DESTR",                    str_destr,                    },
    { "STR_ELEMCPY",                  str_elemcpy,                  },
    { "STR_EQ",                       str_eq,                       },
    { "STR_FOR",                      str_for,                      },
    { "STR_FOR_KEY",                  str_for_key,                  },
    { "STR_FOR_VAR_KEY",              str_for_var_key,              },
    { "STR_FROM_UTF8",                str_from_utf8,                },
    { "STR_GE",                       str_ge,                       },
    { "STR_GT",                       str_gt,                       },
    { "STR_HASHCODE",                 str_hashcode,                 },
    { "STR_HEAD",                     str_head,                     },
    { "STR_IDX",                      str_idx,                      },
    { "STR_IPOS",                     str_ipos,                     },
    { "STR_LE",                       str_le,                       },
    { "STR_LIT",                      str_lit,                      },
    { "STR_LNG",                      str_lng,                      },
    { "STR_LOW",                      str_low,                      },
    { "STR_LPAD",                     str_lpad,                     },
    { "STR_LPAD0",                    str_lpad0,                    },
    { "STR_LT",                       str_lt,                       },
    { "STR_LTRIM",                    str_ltrim,                    },
    { "STR_MULT",                     str_mult,                     },
    { "STR_NE",                       str_ne,                       },
    { "STR_POS",                      str_pos,                      },
    { "STR_POSCPY",                   str_poscpy,                   },
    { "STR_PUSH",                     str_push,                     },
    { "STR_RANGE",                    str_range,                    },
    { "STR_RCHIPOS",                  str_rchipos,                  },
    { "STR_RCHPOS",                   str_rchpos,                   },
    { "STR_REPL",                     str_repl,                     },
    { "STR_RIPOS",                    str_ripos,                    },
    { "STR_RPAD",                     str_rpad,                     },
    { "STR_RPOS",                     str_rpos,                     },
    { "STR_RTRIM",                    str_rtrim,                    },
    { "STR_SPLIT",                    str_split,                    },
    { "STR_STR",                      str_str,                      },
    { "STR_SUBSTR",                   str_substr,                   },
    { "STR_SUBSTR_FIXLEN",            str_substr_fixlen,            },
    { "STR_TAIL",                     str_tail,                     },
    { "STR_TO_UTF8",                  str_to_utf8,                  },
    { "STR_TRIM",                     str_trim,                     },
    { "STR_UP",                       str_up,                       },
    { "STR_VALUE",                    str_value,                    },

    { "TIM_AWAIT",                    tim_await,                    },
    { "TIM_FROM_TIMESTAMP",           tim_from_timestamp,           },
    { "TIM_NOW",                      tim_now,                      },
    { "TIM_SET_LOCAL_TZ",             tim_set_local_tz,             },

    { "TYP_ADDINTERFACE",             typ_addinterface,             },
    { "TYP_CMP",                      typ_cmp,                      },
    { "TYP_CPY",                      typ_cpy,                      },
    { "TYP_CREATE",                   typ_create,                   },
    { "TYP_DESTR",                    typ_destr,                    },
    { "TYP_EQ",                       typ_eq,                       },
    { "TYP_FUNC",                     typ_func,                     },
    { "TYP_GENSUB",                   typ_gensub,                   },
    { "TYP_GENTYPE",                  typ_gentype,                  },
    { "TYP_HASHCODE",                 typ_hashcode,                 },
    { "TYP_INTERFACES",               typ_interfaces,               },
    { "TYP_ISDECLARED",               typ_isdeclared,               },
    { "TYP_ISDERIVED",                typ_isderived,                },
    { "TYP_ISFORWARD",                typ_isforward,                },
    { "TYP_ISFUNC",                   typ_isfunc,                   },
    { "TYP_ISVARFUNC",                typ_isvarfunc,                },
    { "TYP_MATCHOBJ",                 typ_matchobj,                 },
    { "TYP_META",                     typ_meta,                     },
    { "TYP_NE",                       typ_ne,                       },
    { "TYP_NUM",                      typ_num,                      },
    { "TYP_RESULT",                   typ_result,                   },
    { "TYP_SET_IN_PARAM_REF",         typ_set_in_param_ref,         },
    { "TYP_SET_IN_PARAM_VALUE",       typ_set_in_param_value,       },
    { "TYP_STR",                      typ_str,                      },
    { "TYP_VALUE",                    typ_value,                    },
    { "TYP_VARCONV",                  typ_varconv,                  },
    { "TYP_VARFUNC",                  typ_varfunc,                  },

    { "UT8_GETC",                     ut8_getc,                     },
    { "UT8_GETS",                     ut8_gets,                     },
    { "UT8_LINE_READ",                ut8_line_read,                },
    { "UT8_SEEK",                     ut8_seek,                     },
    { "UT8_WORD_READ",                ut8_word_read,                },
    { "UT8_WRITE",                    ut8_write,                    },
  };



void init_primitiv (void)

  { /* init_primitiv */
    actTable.size = sizeof(actEntryTable) / sizeof(actEntryRecord);
    actTable.table = actEntryTable;
  } /* init_primitiv */
