/********************************************************************/
/*                                                                  */
/*  tim_drv.h     Prototypes of OS specific time functions.         */
/*  Copyright (C) 1989 - 2011  Thomas Mertes                        */
/*                                                                  */
/*  This file is part of the Seed7 Runtime Library.                 */
/*                                                                  */
/*  The Seed7 Runtime Library is free software; you can             */
/*  redistribute it and/or modify it under the terms of the GNU     */
/*  Lesser General Public License as published by the Free Software */
/*  Foundation; either version 2.1 of the License, or (at your      */
/*  option) any later version.                                      */
/*                                                                  */
/*  The Seed7 Runtime Library is distributed in the hope that it    */
/*  will be useful, but WITHOUT ANY WARRANTY; without even the      */
/*  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR */
/*  PURPOSE.  See the GNU Lesser General Public License for more    */
/*  details.                                                        */
/*                                                                  */
/*  You should have received a copy of the GNU Lesser General       */
/*  Public License along with this program; if not, write to the    */
/*  Free Software Foundation, Inc., 51 Franklin Street,             */
/*  Fifth Floor, Boston, MA  02110-1301, USA.                       */
/*                                                                  */
/*  Module: Seed7 Runtime Library                                   */
/*  File: seed7/src/tim_drv.h                                       */
/*  Changes: 1992, 1993, 1994, 2009  Thomas Mertes                  */
/*  Content: Prototypes of OS specific time functions.              */
/*                                                                  */
/********************************************************************/

#ifdef USE_ALTERNATE_UTIME
#ifdef INCLUDE_SYS_UTIME
#include "sys/utime.h"
#else
#include "utime.h"
#endif
#endif

/* Seconds between 1601-01-01 and 1970-01-01 */
#define SECONDS_FROM_1601_TO_1970 INT64_SUFFIX(11644473600)
#define WINDOWS_TICK UINT64_SUFFIX(10000000)

#ifdef USE_ALTERNATE_LOCALTIME_R
#define localtime_r alternate_localtime_r
#endif

void timAwait (intType year, intType month, intType day, intType hour,
    intType min, intType sec, intType micro_sec, intType time_zone);
intType timMicroSec (void);
void timNow (intType *year, intType *month, intType *day, intType *hour,
    intType *min, intType *sec, intType *micro_sec, intType *time_zone,
    boolType *is_dst);
#ifdef USE_ALTERNATE_LOCALTIME_R
struct tm *alternate_localtime_r (time_t *utc_seconds, struct tm *tm_result);
#endif
#ifdef USE_ALTERNATE_UTIME
int alternate_utime (const wchar_t *os_path, os_utimbuf_struct *utime_buf);
#endif
