// ##### ENDFILE "CloudNetworkEnvironmentInfoWrap.h"


// ##### BEGINFILE "CloudClientWrap.h"
/** @file
 * VirtualBox API class wrapper header for ICloudClient.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#ifndef CloudClientWrap_H_
#define CloudClientWrap_H_
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif

#include "VirtualBoxBase.h"
#include "Wrapper.h"

class ATL_NO_VTABLE CloudClientWrap
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(ICloudClient)
{
    Q_OBJECT

public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(CloudClientWrap, ICloudClient)
    DECLARE_NOT_AGGREGATABLE(CloudClientWrap)
    DECLARE_PROTECT_FINAL_CONSTRUCT()

    BEGIN_COM_MAP(CloudClientWrap)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(ICloudClient)
        COM_INTERFACE_ENTRY2(IDispatch, ICloudClient)
        VBOX_TWEAK_INTERFACE_ENTRY(ICloudClient)
    END_COM_MAP()

    DECLARE_EMPTY_CTOR_DTOR(CloudClientWrap)

    /** @name Public ICloudClient properties
     * @{ */
    STDMETHOD(COMGETTER(InternalAndReservedAttribute1ICloudClient))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute2ICloudClient))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute3ICloudClient))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute4ICloudClient))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute5ICloudClient))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute6ICloudClient))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute7ICloudClient))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute8ICloudClient))(ULONG *aReserved);
    /** @} */

    /** @name Public ICloudClient methods
     * @{ */
    STDMETHOD(GetExportDescriptionForm)(IVirtualSystemDescription *aDescription,
                                        IVirtualSystemDescriptionForm **aForm,
                                        IProgress **aProgress);
    STDMETHOD(ExportVM)(IVirtualSystemDescription *aDescription,
                        IProgress *aProgress);
    STDMETHOD(GetLaunchDescriptionForm)(IVirtualSystemDescription *aDescription,
                                        IVirtualSystemDescriptionForm **aForm,
                                        IProgress **aProgress);
    STDMETHOD(LaunchVM)(IVirtualSystemDescription *aDescription,
                        IProgress **aProgress);
    STDMETHOD(GetImportDescriptionForm)(IVirtualSystemDescription *aDescription,
                                        IVirtualSystemDescriptionForm **aForm,
                                        IProgress **aProgress);
    STDMETHOD(ImportInstance)(IVirtualSystemDescription *aDescription,
                              IProgress *aProgress);
    STDMETHOD(ListInstances)(ComSafeArrayIn(CloudMachineState_T, aMachineState),
                             IStringArray **aReturnNames,
                             IStringArray **aReturnIds,
                             IProgress **aProgress);
    STDMETHOD(ListImages)(ComSafeArrayIn(CloudImageState_T, aImageState),
                          IStringArray **aReturnNames,
                          IStringArray **aReturnIds,
                          IProgress **aProgress);
    STDMETHOD(GetInstanceInfo)(IN_BSTR aUid,
                               IVirtualSystemDescription *aDescription,
                               IProgress **aProgress);
    STDMETHOD(StartInstance)(IN_BSTR aUid,
                             IProgress **aProgress);
    STDMETHOD(PauseInstance)(IN_BSTR aUid,
                             IProgress **aProgress);
    STDMETHOD(TerminateInstance)(IN_BSTR aUid,
                                 IProgress **aProgress);
    STDMETHOD(CreateImage)(ComSafeArrayIn(IN_BSTR, aParameters),
                           IProgress **aProgress);
    STDMETHOD(ExportImage)(IMedium *aImage,
                           ComSafeArrayIn(IN_BSTR, aParameters),
                           IProgress **aProgress);
    STDMETHOD(ImportImage)(IN_BSTR aUid,
                           ComSafeArrayIn(IN_BSTR, aParameters),
                           IProgress **aProgress);
    STDMETHOD(DeleteImage)(IN_BSTR aUid,
                           IProgress **aProgress);
    STDMETHOD(GetImageInfo)(IN_BSTR aUid,
                            IStringArray **aInfoArray,
                            IProgress **aProgress);
    STDMETHOD(StartCloudNetworkGateway)(ICloudNetwork *aNetwork,
                                        IN_BSTR aSshPublicKey,
                                        ICloudNetworkGatewayInfo **aGatewayInfo,
                                        IProgress **aProgress);
    STDMETHOD(SetupCloudNetworkEnvironment)(IN_BSTR aTunnelNetworkName,
                                            IN_BSTR aTunnelNetworkRange,
                                            IN_BSTR aGatewayOsName,
                                            IN_BSTR aGatewayOsVersion,
                                            IN_BSTR aGatewayShape,
                                            ICloudNetworkEnvironmentInfo **aNetworkEnvironmentInfo,
                                            IProgress **aProgress);
    STDMETHOD(InternalAndReservedMethod1ICloudClient)();
    STDMETHOD(InternalAndReservedMethod2ICloudClient)();
    STDMETHOD(InternalAndReservedMethod3ICloudClient)();
    STDMETHOD(InternalAndReservedMethod4ICloudClient)();
    STDMETHOD(InternalAndReservedMethod5ICloudClient)();
    STDMETHOD(InternalAndReservedMethod6ICloudClient)();
    STDMETHOD(InternalAndReservedMethod7ICloudClient)();
    STDMETHOD(InternalAndReservedMethod8ICloudClient)();
    STDMETHOD(InternalAndReservedMethod9ICloudClient)();
    STDMETHOD(InternalAndReservedMethod10ICloudClient)();
    STDMETHOD(InternalAndReservedMethod11ICloudClient)();
    STDMETHOD(InternalAndReservedMethod12ICloudClient)();
    STDMETHOD(InternalAndReservedMethod13ICloudClient)();
    STDMETHOD(InternalAndReservedMethod14ICloudClient)();
    STDMETHOD(InternalAndReservedMethod15ICloudClient)();
    /** @} */

private:
    /** @name Wrapped ICloudClient properties
     * @{ */
    /** @} */

    /** @name Wrapped ICloudClient methods
     * @{ */
    virtual HRESULT getExportDescriptionForm(const ComPtr<IVirtualSystemDescription> &aDescription,
                                             ComPtr<IVirtualSystemDescriptionForm> &aForm,
                                             ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT exportVM(const ComPtr<IVirtualSystemDescription> &aDescription,
                             const ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT getLaunchDescriptionForm(const ComPtr<IVirtualSystemDescription> &aDescription,
                                             ComPtr<IVirtualSystemDescriptionForm> &aForm,
                                             ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT launchVM(const ComPtr<IVirtualSystemDescription> &aDescription,
                             ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT getImportDescriptionForm(const ComPtr<IVirtualSystemDescription> &aDescription,
                                             ComPtr<IVirtualSystemDescriptionForm> &aForm,
                                             ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT importInstance(const ComPtr<IVirtualSystemDescription> &aDescription,
                                   const ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT listInstances(const std::vector<CloudMachineState_T> &aMachineState,
                                  ComPtr<IStringArray> &aReturnNames,
                                  ComPtr<IStringArray> &aReturnIds,
                                  ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT listImages(const std::vector<CloudImageState_T> &aImageState,
                               ComPtr<IStringArray> &aReturnNames,
                               ComPtr<IStringArray> &aReturnIds,
                               ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT getInstanceInfo(const com::Utf8Str &aUid,
                                    const ComPtr<IVirtualSystemDescription> &aDescription,
                                    ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT startInstance(const com::Utf8Str &aUid,
                                  ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT pauseInstance(const com::Utf8Str &aUid,
                                  ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT terminateInstance(const com::Utf8Str &aUid,
                                      ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT createImage(const std::vector<com::Utf8Str> &aParameters,
                                ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT exportImage(const ComPtr<IMedium> &aImage,
                                const std::vector<com::Utf8Str> &aParameters,
                                ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT importImage(const com::Utf8Str &aUid,
                                const std::vector<com::Utf8Str> &aParameters,
                                ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT deleteImage(const com::Utf8Str &aUid,
                                ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT getImageInfo(const com::Utf8Str &aUid,
                                 ComPtr<IStringArray> &aInfoArray,
                                 ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT startCloudNetworkGateway(const ComPtr<ICloudNetwork> &aNetwork,
                                             const com::Utf8Str &aSshPublicKey,
                                             ComPtr<ICloudNetworkGatewayInfo> &aGatewayInfo,
                                             ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT setupCloudNetworkEnvironment(const com::Utf8Str &aTunnelNetworkName,
                                                 const com::Utf8Str &aTunnelNetworkRange,
                                                 const com::Utf8Str &aGatewayOsName,
                                                 const com::Utf8Str &aGatewayOsVersion,
                                                 const com::Utf8Str &aGatewayShape,
                                                 ComPtr<ICloudNetworkEnvironmentInfo> &aNetworkEnvironmentInfo,
                                                 ComPtr<IProgress> &aProgress) = 0;
    /** @} */

private:
    DECLARE_CLS_COPY_CTOR_ASSIGN_NOOP(CloudClientWrap); /* Shuts up MSC warning C4625. */

};

#endif // !CloudClientWrap_H_

