// ##### ENDFILE "DHCPConfigWrap.h"


// ##### BEGINFILE "DHCPGlobalConfigWrap.h"
/** @file
 * VirtualBox API class wrapper header for IDHCPGlobalConfig.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#ifndef DHCPGlobalConfigWrap_H_
#define DHCPGlobalConfigWrap_H_
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif

#include "VirtualBoxBase.h"
#include "Wrapper.h"

class ATL_NO_VTABLE DHCPGlobalConfigWrap
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IDHCPGlobalConfig)
{
    Q_OBJECT

public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(DHCPGlobalConfigWrap, IDHCPGlobalConfig)
    DECLARE_NOT_AGGREGATABLE(DHCPGlobalConfigWrap)
    DECLARE_PROTECT_FINAL_CONSTRUCT()

    BEGIN_COM_MAP(DHCPGlobalConfigWrap)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IDHCPGlobalConfig)
        COM_INTERFACE_ENTRY(IDHCPConfig)
        COM_INTERFACE_ENTRY2(IDispatch, IDHCPGlobalConfig)
        VBOX_TWEAK_INTERFACE_ENTRY(IDHCPGlobalConfig)
    END_COM_MAP()

    DECLARE_EMPTY_CTOR_DTOR(DHCPGlobalConfigWrap)

    /** @name Public IDHCPConfig properties
     * @{ */
    STDMETHOD(COMGETTER(Scope))(DHCPConfigScope_T *aScope);
    STDMETHOD(COMGETTER(MinLeaseTime))(ULONG *aMinLeaseTime);
    STDMETHOD(COMSETTER(MinLeaseTime))(ULONG aMinLeaseTime);
    STDMETHOD(COMGETTER(DefaultLeaseTime))(ULONG *aDefaultLeaseTime);
    STDMETHOD(COMSETTER(DefaultLeaseTime))(ULONG aDefaultLeaseTime);
    STDMETHOD(COMGETTER(MaxLeaseTime))(ULONG *aMaxLeaseTime);
    STDMETHOD(COMSETTER(MaxLeaseTime))(ULONG aMaxLeaseTime);
    STDMETHOD(COMGETTER(ForcedOptions))(ComSafeArrayOut(DHCPOption_T, aForcedOptions));
    STDMETHOD(COMSETTER(ForcedOptions))(ComSafeArrayIn(DHCPOption_T, aForcedOptions));
    STDMETHOD(COMGETTER(SuppressedOptions))(ComSafeArrayOut(DHCPOption_T, aSuppressedOptions));
    STDMETHOD(COMSETTER(SuppressedOptions))(ComSafeArrayIn(DHCPOption_T, aSuppressedOptions));
    STDMETHOD(COMGETTER(InternalAndReservedAttribute1IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute2IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute3IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute4IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute5IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute6IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute7IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute8IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute9IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute10IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute11IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute12IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute13IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute14IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute15IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute16IDHCPConfig))(ULONG *aReserved);
    /** @} */

    /** @name Public IDHCPGlobalConfig properties
     * @{ */
    STDMETHOD(COMGETTER(InternalAndReservedAttribute1IDHCPGlobalConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute2IDHCPGlobalConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute3IDHCPGlobalConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute4IDHCPGlobalConfig))(ULONG *aReserved);
    /** @} */

    /** @name Public IDHCPConfig methods
     * @{ */
    STDMETHOD(SetOption)(DHCPOption_T aOption,
                         DHCPOptionEncoding_T aEncoding,
                         IN_BSTR aValue);
    STDMETHOD(RemoveOption)(DHCPOption_T aOption);
    STDMETHOD(RemoveAllOptions)();
    STDMETHOD(GetOption)(DHCPOption_T aOption,
                         DHCPOptionEncoding_T *aEncoding,
                         BSTR *aValue);
    STDMETHOD(GetAllOptions)(ComSafeArrayOut(DHCPOption_T, aOptions),
                             ComSafeArrayOut(DHCPOptionEncoding_T, aEncodings),
                             ComSafeArrayOut(BSTR, aValues));
    STDMETHOD(Remove)();
    STDMETHOD(InternalAndReservedMethod1IDHCPConfig)();
    STDMETHOD(InternalAndReservedMethod2IDHCPConfig)();
    STDMETHOD(InternalAndReservedMethod3IDHCPConfig)();
    STDMETHOD(InternalAndReservedMethod4IDHCPConfig)();
    STDMETHOD(InternalAndReservedMethod5IDHCPConfig)();
    STDMETHOD(InternalAndReservedMethod6IDHCPConfig)();
    STDMETHOD(InternalAndReservedMethod7IDHCPConfig)();
    STDMETHOD(InternalAndReservedMethod8IDHCPConfig)();
    /** @} */

    /** @name Public IDHCPGlobalConfig methods
     * @{ */
    STDMETHOD(InternalAndReservedMethod1IDHCPGlobalConfig)();
    STDMETHOD(InternalAndReservedMethod2IDHCPGlobalConfig)();
    STDMETHOD(InternalAndReservedMethod3IDHCPGlobalConfig)();
    STDMETHOD(InternalAndReservedMethod4IDHCPGlobalConfig)();
    /** @} */

private:
    /** @name Wrapped IDHCPConfig properties
     * @{ */
    virtual HRESULT getScope(DHCPConfigScope_T *aScope) = 0;
    virtual HRESULT getMinLeaseTime(ULONG *aMinLeaseTime) = 0;
    virtual HRESULT setMinLeaseTime(ULONG aMinLeaseTime) = 0;
    virtual HRESULT getDefaultLeaseTime(ULONG *aDefaultLeaseTime) = 0;
    virtual HRESULT setDefaultLeaseTime(ULONG aDefaultLeaseTime) = 0;
    virtual HRESULT getMaxLeaseTime(ULONG *aMaxLeaseTime) = 0;
    virtual HRESULT setMaxLeaseTime(ULONG aMaxLeaseTime) = 0;
    virtual HRESULT getForcedOptions(std::vector<DHCPOption_T> &aForcedOptions) = 0;
    virtual HRESULT setForcedOptions(const std::vector<DHCPOption_T> &aForcedOptions) = 0;
    virtual HRESULT getSuppressedOptions(std::vector<DHCPOption_T> &aSuppressedOptions) = 0;
    virtual HRESULT setSuppressedOptions(const std::vector<DHCPOption_T> &aSuppressedOptions) = 0;
    /** @} */

    /** @name Wrapped IDHCPGlobalConfig properties
     * @{ */
    /** @} */

    /** @name Wrapped IDHCPConfig methods
     * @{ */
    virtual HRESULT setOption(DHCPOption_T aOption,
                              DHCPOptionEncoding_T aEncoding,
                              const com::Utf8Str &aValue) = 0;
    virtual HRESULT removeOption(DHCPOption_T aOption) = 0;
    virtual HRESULT removeAllOptions() = 0;
    virtual HRESULT getOption(DHCPOption_T aOption,
                              DHCPOptionEncoding_T *aEncoding,
                              com::Utf8Str &aValue) = 0;
    virtual HRESULT getAllOptions(std::vector<DHCPOption_T> &aOptions,
                                  std::vector<DHCPOptionEncoding_T> &aEncodings,
                                  std::vector<com::Utf8Str> &aValues) = 0;
    virtual HRESULT remove() = 0;
    /** @} */

    /** @name Wrapped IDHCPGlobalConfig methods
     * @{ */
    /** @} */

private:
    DECLARE_CLS_COPY_CTOR_ASSIGN_NOOP(DHCPGlobalConfigWrap); /* Shuts up MSC warning C4625. */

};

#endif // !DHCPGlobalConfigWrap_H_

