// ##### ENDFILE "DHCPGroupConditionWrap.h"


// ##### BEGINFILE "DHCPGroupConfigWrap.h"
/** @file
 * VirtualBox API class wrapper header for IDHCPGroupConfig.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#ifndef DHCPGroupConfigWrap_H_
#define DHCPGroupConfigWrap_H_
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif

#include "VirtualBoxBase.h"
#include "Wrapper.h"

class ATL_NO_VTABLE DHCPGroupConfigWrap
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IDHCPGroupConfig)
{
    Q_OBJECT

public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(DHCPGroupConfigWrap, IDHCPGroupConfig)
    DECLARE_NOT_AGGREGATABLE(DHCPGroupConfigWrap)
    DECLARE_PROTECT_FINAL_CONSTRUCT()

    BEGIN_COM_MAP(DHCPGroupConfigWrap)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IDHCPGroupConfig)
        COM_INTERFACE_ENTRY(IDHCPConfig)
        COM_INTERFACE_ENTRY2(IDispatch, IDHCPGroupConfig)
        VBOX_TWEAK_INTERFACE_ENTRY(IDHCPGroupConfig)
    END_COM_MAP()

    DECLARE_EMPTY_CTOR_DTOR(DHCPGroupConfigWrap)

    /** @name Public IDHCPConfig properties
     * @{ */
    STDMETHOD(COMGETTER(Scope))(DHCPConfigScope_T *aScope);
    STDMETHOD(COMGETTER(MinLeaseTime))(ULONG *aMinLeaseTime);
    STDMETHOD(COMSETTER(MinLeaseTime))(ULONG aMinLeaseTime);
    STDMETHOD(COMGETTER(DefaultLeaseTime))(ULONG *aDefaultLeaseTime);
    STDMETHOD(COMSETTER(DefaultLeaseTime))(ULONG aDefaultLeaseTime);
    STDMETHOD(COMGETTER(MaxLeaseTime))(ULONG *aMaxLeaseTime);
    STDMETHOD(COMSETTER(MaxLeaseTime))(ULONG aMaxLeaseTime);
    STDMETHOD(COMGETTER(ForcedOptions))(ComSafeArrayOut(DHCPOption_T, aForcedOptions));
    STDMETHOD(COMSETTER(ForcedOptions))(ComSafeArrayIn(DHCPOption_T, aForcedOptions));
    STDMETHOD(COMGETTER(SuppressedOptions))(ComSafeArrayOut(DHCPOption_T, aSuppressedOptions));
    STDMETHOD(COMSETTER(SuppressedOptions))(ComSafeArrayIn(DHCPOption_T, aSuppressedOptions));
    STDMETHOD(COMGETTER(InternalAndReservedAttribute1IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute2IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute3IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute4IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute5IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute6IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute7IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute8IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute9IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute10IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute11IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute12IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute13IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute14IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute15IDHCPConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute16IDHCPConfig))(ULONG *aReserved);
    /** @} */

    /** @name Public IDHCPGroupConfig properties
     * @{ */
    STDMETHOD(COMGETTER(Name))(BSTR *aName);
    STDMETHOD(COMSETTER(Name))(IN_BSTR aName);
    STDMETHOD(COMGETTER(Conditions))(ComSafeArrayOut(IDHCPGroupCondition *, aConditions));
    STDMETHOD(COMGETTER(InternalAndReservedAttribute1IDHCPGroupConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute2IDHCPGroupConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute3IDHCPGroupConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute4IDHCPGroupConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute5IDHCPGroupConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute6IDHCPGroupConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute7IDHCPGroupConfig))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute8IDHCPGroupConfig))(ULONG *aReserved);
    /** @} */

    /** @name Public IDHCPConfig methods
     * @{ */
    STDMETHOD(SetOption)(DHCPOption_T aOption,
                         DHCPOptionEncoding_T aEncoding,
                         IN_BSTR aValue);
    STDMETHOD(RemoveOption)(DHCPOption_T aOption);
    STDMETHOD(RemoveAllOptions)();
    STDMETHOD(GetOption)(DHCPOption_T aOption,
                         DHCPOptionEncoding_T *aEncoding,
                         BSTR *aValue);
    STDMETHOD(GetAllOptions)(ComSafeArrayOut(DHCPOption_T, aOptions),
                             ComSafeArrayOut(DHCPOptionEncoding_T, aEncodings),
                             ComSafeArrayOut(BSTR, aValues));
    STDMETHOD(Remove)();
    STDMETHOD(InternalAndReservedMethod1IDHCPConfig)();
    STDMETHOD(InternalAndReservedMethod2IDHCPConfig)();
    STDMETHOD(InternalAndReservedMethod3IDHCPConfig)();
    STDMETHOD(InternalAndReservedMethod4IDHCPConfig)();
    STDMETHOD(InternalAndReservedMethod5IDHCPConfig)();
    STDMETHOD(InternalAndReservedMethod6IDHCPConfig)();
    STDMETHOD(InternalAndReservedMethod7IDHCPConfig)();
    STDMETHOD(InternalAndReservedMethod8IDHCPConfig)();
    /** @} */

    /** @name Public IDHCPGroupConfig methods
     * @{ */
    STDMETHOD(AddCondition)(BOOL aInclusive,
                            DHCPGroupConditionType_T aType,
                            IN_BSTR aValue,
                            IDHCPGroupCondition **aCondition);
    STDMETHOD(RemoveAllConditions)();
    STDMETHOD(InternalAndReservedMethod1IDHCPGroupConfig)();
    STDMETHOD(InternalAndReservedMethod2IDHCPGroupConfig)();
    STDMETHOD(InternalAndReservedMethod3IDHCPGroupConfig)();
    STDMETHOD(InternalAndReservedMethod4IDHCPGroupConfig)();
    STDMETHOD(InternalAndReservedMethod5IDHCPGroupConfig)();
    STDMETHOD(InternalAndReservedMethod6IDHCPGroupConfig)();
    STDMETHOD(InternalAndReservedMethod7IDHCPGroupConfig)();
    STDMETHOD(InternalAndReservedMethod8IDHCPGroupConfig)();
    /** @} */

private:
    /** @name Wrapped IDHCPConfig properties
     * @{ */
    virtual HRESULT getScope(DHCPConfigScope_T *aScope) = 0;
    virtual HRESULT getMinLeaseTime(ULONG *aMinLeaseTime) = 0;
    virtual HRESULT setMinLeaseTime(ULONG aMinLeaseTime) = 0;
    virtual HRESULT getDefaultLeaseTime(ULONG *aDefaultLeaseTime) = 0;
    virtual HRESULT setDefaultLeaseTime(ULONG aDefaultLeaseTime) = 0;
    virtual HRESULT getMaxLeaseTime(ULONG *aMaxLeaseTime) = 0;
    virtual HRESULT setMaxLeaseTime(ULONG aMaxLeaseTime) = 0;
    virtual HRESULT getForcedOptions(std::vector<DHCPOption_T> &aForcedOptions) = 0;
    virtual HRESULT setForcedOptions(const std::vector<DHCPOption_T> &aForcedOptions) = 0;
    virtual HRESULT getSuppressedOptions(std::vector<DHCPOption_T> &aSuppressedOptions) = 0;
    virtual HRESULT setSuppressedOptions(const std::vector<DHCPOption_T> &aSuppressedOptions) = 0;
    /** @} */

    /** @name Wrapped IDHCPGroupConfig properties
     * @{ */
    virtual HRESULT getName(com::Utf8Str &aName) = 0;
    virtual HRESULT setName(const com::Utf8Str &aName) = 0;
    virtual HRESULT getConditions(std::vector<ComPtr<IDHCPGroupCondition> > &aConditions) = 0;
    /** @} */

    /** @name Wrapped IDHCPConfig methods
     * @{ */
    virtual HRESULT setOption(DHCPOption_T aOption,
                              DHCPOptionEncoding_T aEncoding,
                              const com::Utf8Str &aValue) = 0;
    virtual HRESULT removeOption(DHCPOption_T aOption) = 0;
    virtual HRESULT removeAllOptions() = 0;
    virtual HRESULT getOption(DHCPOption_T aOption,
                              DHCPOptionEncoding_T *aEncoding,
                              com::Utf8Str &aValue) = 0;
    virtual HRESULT getAllOptions(std::vector<DHCPOption_T> &aOptions,
                                  std::vector<DHCPOptionEncoding_T> &aEncodings,
                                  std::vector<com::Utf8Str> &aValues) = 0;
    virtual HRESULT remove() = 0;
    /** @} */

    /** @name Wrapped IDHCPGroupConfig methods
     * @{ */
    virtual HRESULT addCondition(BOOL aInclusive,
                                 DHCPGroupConditionType_T aType,
                                 const com::Utf8Str &aValue,
                                 ComPtr<IDHCPGroupCondition> &aCondition) = 0;
    virtual HRESULT removeAllConditions() = 0;
    /** @} */

private:
    DECLARE_CLS_COPY_CTOR_ASSIGN_NOOP(DHCPGroupConfigWrap); /* Shuts up MSC warning C4625. */

};

#endif // !DHCPGroupConfigWrap_H_

