// ##### ENDFILE "FramebufferOverlayWrap.cpp"


// ##### BEGINFILE "DisplayWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IDisplay.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_DISPLAY

#include "DisplayWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(DisplayWrap)

//
// IDisplay properties
//

STDMETHODIMP DisplayWrap::COMGETTER(GuestScreenLayout)(ComSafeArrayOut(IGuestScreenInfo *, aGuestScreenLayout))
{
    LogRelFlow(("{%p} %s: enter aGuestScreenLayout=%p\n", this, "Display::getGuestScreenLayout", aGuestScreenLayout));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGuestScreenLayout);
        ArrayComTypeOutConverter<IGuestScreenInfo> TmpGuestScreenLayout(ComSafeArrayOutArg(aGuestScreenLayout));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_GET_GUESTSCREENLAYOUT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGuestScreenLayout(TmpGuestScreenLayout.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_GET_GUESTSCREENLAYOUT_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpGuestScreenLayout.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_GET_GUESTSCREENLAYOUT_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_GET_GUESTSCREENLAYOUT_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aGuestScreenLayout=%zu hrc=%Rhrc\n", this, "Display::getGuestScreenLayout", ComSafeArraySize(*aGuestScreenLayout), hrc));
    return hrc;
}

STDMETHODIMP DisplayWrap::COMGETTER(InternalAndReservedAttribute1IDisplay)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DisplayWrap::COMGETTER(InternalAndReservedAttribute2IDisplay)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DisplayWrap::COMGETTER(InternalAndReservedAttribute3IDisplay)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DisplayWrap::COMGETTER(InternalAndReservedAttribute4IDisplay)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DisplayWrap::COMGETTER(InternalAndReservedAttribute5IDisplay)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DisplayWrap::COMGETTER(InternalAndReservedAttribute6IDisplay)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DisplayWrap::COMGETTER(InternalAndReservedAttribute7IDisplay)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DisplayWrap::COMGETTER(InternalAndReservedAttribute8IDisplay)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DisplayWrap::COMGETTER(InternalAndReservedAttribute9IDisplay)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DisplayWrap::COMGETTER(InternalAndReservedAttribute10IDisplay)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DisplayWrap::COMGETTER(InternalAndReservedAttribute11IDisplay)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DisplayWrap::COMGETTER(InternalAndReservedAttribute12IDisplay)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DisplayWrap::COMGETTER(InternalAndReservedAttribute13IDisplay)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DisplayWrap::COMGETTER(InternalAndReservedAttribute14IDisplay)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DisplayWrap::COMGETTER(InternalAndReservedAttribute15IDisplay)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DisplayWrap::COMGETTER(InternalAndReservedAttribute16IDisplay)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

//
// IEventListener properties
//


//
// IDisplay methods
//

STDMETHODIMP DisplayWrap::GetScreenResolution(ULONG aScreenId,
                                              ULONG *aWidth,
                                              ULONG *aHeight,
                                              ULONG *aBitsPerPixel,
                                              LONG *aXOrigin,
                                              LONG *aYOrigin,
                                              GuestMonitorStatus_T *aGuestMonitorStatus)
{
    LogRelFlow(("{%p} %s:enter aScreenId=%RU32 aWidth=%p aHeight=%p aBitsPerPixel=%p aXOrigin=%p aYOrigin=%p aGuestMonitorStatus=%p\n", this, "Display::getScreenResolution", aScreenId, aWidth, aHeight, aBitsPerPixel, aXOrigin, aYOrigin, aGuestMonitorStatus));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWidth);
        CheckComArgOutPointerValidThrow(aHeight);
        CheckComArgOutPointerValidThrow(aBitsPerPixel);
        CheckComArgOutPointerValidThrow(aXOrigin);
        CheckComArgOutPointerValidThrow(aYOrigin);
        CheckComArgOutPointerValidThrow(aGuestMonitorStatus);


        
        
        
        
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_GETSCREENRESOLUTION_ENTER(this, aScreenId);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getScreenResolution(aScreenId,
                                      aWidth,
                                      aHeight,
                                      aBitsPerPixel,
                                      aXOrigin,
                                      aYOrigin,
                                      aGuestMonitorStatus);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_GETSCREENRESOLUTION_RETURN(this, hrc, 0 /*normal*/, aScreenId, *aWidth, *aHeight, *aBitsPerPixel, *aXOrigin, *aYOrigin, *aGuestMonitorStatus);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_GETSCREENRESOLUTION_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, *aWidth, *aHeight, *aBitsPerPixel, *aXOrigin, *aYOrigin, *aGuestMonitorStatus);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_GETSCREENRESOLUTION_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, *aWidth, *aHeight, *aBitsPerPixel, *aXOrigin, *aYOrigin, *aGuestMonitorStatus);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aWidth=%RU32 *aHeight=%RU32 *aBitsPerPixel=%RU32 *aXOrigin=%RI32 *aYOrigin=%RI32 *aGuestMonitorStatus=%RU32 hrc=%Rhrc\n", this, "Display::getScreenResolution", *aWidth, *aHeight, *aBitsPerPixel, *aXOrigin, *aYOrigin, *aGuestMonitorStatus, hrc));
    return hrc;
}

STDMETHODIMP DisplayWrap::AttachFramebuffer(ULONG aScreenId,
                                            IFramebuffer *aFramebuffer,
                                            BSTR *aId)
{
    LogRelFlow(("{%p} %s:enter aScreenId=%RU32 aFramebuffer=%p aId=%p\n", this, "Display::attachFramebuffer", aScreenId, aFramebuffer, aId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aId);


        
        ComTypeInConverter<IFramebuffer> TmpFramebuffer(aFramebuffer);
        UuidOutConverter TmpId(aId);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_ATTACHFRAMEBUFFER_ENTER(this, aScreenId, (void *)TmpFramebuffer.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = attachFramebuffer(aScreenId,
                                    TmpFramebuffer.ptr(),
                                    TmpId.uuid());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_ATTACHFRAMEBUFFER_RETURN(this, hrc, 0 /*normal*/, aScreenId, (void *)TmpFramebuffer.ptr(), TmpId.uuid().toStringCurly().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_ATTACHFRAMEBUFFER_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_ATTACHFRAMEBUFFER_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aId=%ls hrc=%Rhrc\n", this, "Display::attachFramebuffer", *aId, hrc));
    return hrc;
}

STDMETHODIMP DisplayWrap::DetachFramebuffer(ULONG aScreenId,
                                            IN_BSTR aId)
{
    LogRelFlow(("{%p} %s:enter aScreenId=%RU32 aId=%ls\n", this, "Display::detachFramebuffer", aScreenId, aId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        UuidInConverter TmpId(aId);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_DETACHFRAMEBUFFER_ENTER(this, aScreenId, TmpId.uuid().toStringCurly().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = detachFramebuffer(aScreenId,
                                    TmpId.uuid());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_DETACHFRAMEBUFFER_RETURN(this, hrc, 0 /*normal*/, aScreenId, TmpId.uuid().toStringCurly().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_DETACHFRAMEBUFFER_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_DETACHFRAMEBUFFER_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Display::detachFramebuffer", hrc));
    return hrc;
}

STDMETHODIMP DisplayWrap::QueryFramebuffer(ULONG aScreenId,
                                           IFramebuffer **aFramebuffer)
{
    LogRelFlow(("{%p} %s:enter aScreenId=%RU32 aFramebuffer=%p\n", this, "Display::queryFramebuffer", aScreenId, aFramebuffer));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFramebuffer);


        
        ComTypeOutConverter<IFramebuffer> TmpFramebuffer(aFramebuffer);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_QUERYFRAMEBUFFER_ENTER(this, aScreenId);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = queryFramebuffer(aScreenId,
                                   TmpFramebuffer.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_QUERYFRAMEBUFFER_RETURN(this, hrc, 0 /*normal*/, aScreenId, (void *)TmpFramebuffer.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_QUERYFRAMEBUFFER_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_QUERYFRAMEBUFFER_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aFramebuffer=%p hrc=%Rhrc\n", this, "Display::queryFramebuffer", *aFramebuffer, hrc));
    return hrc;
}

STDMETHODIMP DisplayWrap::SetVideoModeHint(ULONG aDisplay,
                                           BOOL aEnabled,
                                           BOOL aChangeOrigin,
                                           LONG aOriginX,
                                           LONG aOriginY,
                                           ULONG aWidth,
                                           ULONG aHeight,
                                           ULONG aBitsPerPixel,
                                           BOOL aNotify)
{
    LogRelFlow(("{%p} %s:enter aDisplay=%RU32 aEnabled=%RTbool aChangeOrigin=%RTbool aOriginX=%RI32 aOriginY=%RI32 aWidth=%RU32 aHeight=%RU32 aBitsPerPixel=%RU32 aNotify=%RTbool\n", this, "Display::setVideoModeHint", aDisplay, aEnabled, aChangeOrigin, aOriginX, aOriginY, aWidth, aHeight, aBitsPerPixel, aNotify));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        
        
        
        
        
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_SETVIDEOMODEHINT_ENTER(this, aDisplay, aEnabled != FALSE, aChangeOrigin != FALSE, aOriginX, aOriginY, aWidth, aHeight, aBitsPerPixel, aNotify != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setVideoModeHint(aDisplay,
                                   aEnabled != FALSE,
                                   aChangeOrigin != FALSE,
                                   aOriginX,
                                   aOriginY,
                                   aWidth,
                                   aHeight,
                                   aBitsPerPixel,
                                   aNotify != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_SETVIDEOMODEHINT_RETURN(this, hrc, 0 /*normal*/, aDisplay, aEnabled != FALSE, aChangeOrigin != FALSE, aOriginX, aOriginY, aWidth, aHeight, aBitsPerPixel, aNotify != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_SETVIDEOMODEHINT_RETURN(this, hrc, 1 /*hrc exception*/, aDisplay, aEnabled != FALSE, aChangeOrigin != FALSE, aOriginX, aOriginY, aWidth, aHeight, aBitsPerPixel, aNotify != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_SETVIDEOMODEHINT_RETURN(this, hrc, 9 /*unhandled exception*/, aDisplay, aEnabled != FALSE, aChangeOrigin != FALSE, aOriginX, aOriginY, aWidth, aHeight, aBitsPerPixel, aNotify != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Display::setVideoModeHint", hrc));
    return hrc;
}

STDMETHODIMP DisplayWrap::GetVideoModeHint(ULONG aDisplay,
                                           BOOL *aEnabled,
                                           BOOL *aChangeOrigin,
                                           LONG *aOriginX,
                                           LONG *aOriginY,
                                           ULONG *aWidth,
                                           ULONG *aHeight,
                                           ULONG *aBitsPerPixel)
{
    LogRelFlow(("{%p} %s:enter aDisplay=%RU32 aEnabled=%p aChangeOrigin=%p aOriginX=%p aOriginY=%p aWidth=%p aHeight=%p aBitsPerPixel=%p\n", this, "Display::getVideoModeHint", aDisplay, aEnabled, aChangeOrigin, aOriginX, aOriginY, aWidth, aHeight, aBitsPerPixel));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnabled);
        CheckComArgOutPointerValidThrow(aChangeOrigin);
        CheckComArgOutPointerValidThrow(aOriginX);
        CheckComArgOutPointerValidThrow(aOriginY);
        CheckComArgOutPointerValidThrow(aWidth);
        CheckComArgOutPointerValidThrow(aHeight);
        CheckComArgOutPointerValidThrow(aBitsPerPixel);


        
        
        
        
        
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_GETVIDEOMODEHINT_ENTER(this, aDisplay);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVideoModeHint(aDisplay,
                                   aEnabled,
                                   aChangeOrigin,
                                   aOriginX,
                                   aOriginY,
                                   aWidth,
                                   aHeight,
                                   aBitsPerPixel);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_GETVIDEOMODEHINT_RETURN(this, hrc, 0 /*normal*/, aDisplay, *aEnabled != FALSE, *aChangeOrigin != FALSE, *aOriginX, *aOriginY, *aWidth, *aHeight, *aBitsPerPixel);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_GETVIDEOMODEHINT_RETURN(this, hrc, 1 /*hrc exception*/, aDisplay, *aEnabled != FALSE, *aChangeOrigin != FALSE, *aOriginX, *aOriginY, *aWidth, *aHeight, *aBitsPerPixel);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_GETVIDEOMODEHINT_RETURN(this, hrc, 9 /*unhandled exception*/, aDisplay, *aEnabled != FALSE, *aChangeOrigin != FALSE, *aOriginX, *aOriginY, *aWidth, *aHeight, *aBitsPerPixel);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEnabled=%RTbool *aChangeOrigin=%RTbool *aOriginX=%RI32 *aOriginY=%RI32 *aWidth=%RU32 *aHeight=%RU32 *aBitsPerPixel=%RU32 hrc=%Rhrc\n", this, "Display::getVideoModeHint", *aEnabled, *aChangeOrigin, *aOriginX, *aOriginY, *aWidth, *aHeight, *aBitsPerPixel, hrc));
    return hrc;
}

STDMETHODIMP DisplayWrap::SetSeamlessMode(BOOL aEnabled)
{
    LogRelFlow(("{%p} %s:enter aEnabled=%RTbool\n", this, "Display::setSeamlessMode", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_SETSEAMLESSMODE_ENTER(this, aEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setSeamlessMode(aEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_SETSEAMLESSMODE_RETURN(this, hrc, 0 /*normal*/, aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_SETSEAMLESSMODE_RETURN(this, hrc, 1 /*hrc exception*/, aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_SETSEAMLESSMODE_RETURN(this, hrc, 9 /*unhandled exception*/, aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Display::setSeamlessMode", hrc));
    return hrc;
}

STDMETHODIMP DisplayWrap::TakeScreenShot(ULONG aScreenId,
                                         BYTE *aAddress,
                                         ULONG aWidth,
                                         ULONG aHeight,
                                         BitmapFormat_T aBitmapFormat)
{
    LogRelFlow(("{%p} %s:enter aScreenId=%RU32 aAddress=%p aWidth=%RU32 aHeight=%RU32 aBitmapFormat=%RU32\n", this, "Display::takeScreenShot", aScreenId, aAddress, aWidth, aHeight, aBitmapFormat));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_TAKESCREENSHOT_ENTER(this, aScreenId, aAddress, aWidth, aHeight, aBitmapFormat);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = takeScreenShot(aScreenId,
                                 aAddress,
                                 aWidth,
                                 aHeight,
                                 aBitmapFormat);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_TAKESCREENSHOT_RETURN(this, hrc, 0 /*normal*/, aScreenId, aAddress, aWidth, aHeight, aBitmapFormat);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_TAKESCREENSHOT_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, aAddress, aWidth, aHeight, aBitmapFormat);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_TAKESCREENSHOT_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, aAddress, aWidth, aHeight, aBitmapFormat);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Display::takeScreenShot", hrc));
    return hrc;
}

STDMETHODIMP DisplayWrap::TakeScreenShotToArray(ULONG aScreenId,
                                                ULONG aWidth,
                                                ULONG aHeight,
                                                BitmapFormat_T aBitmapFormat,
                                                ComSafeArrayOut(BYTE, aScreenData))
{
    LogRelFlow(("{%p} %s:enter aScreenId=%RU32 aWidth=%RU32 aHeight=%RU32 aBitmapFormat=%RU32 aScreenData=%p\n", this, "Display::takeScreenShotToArray", aScreenId, aWidth, aHeight, aBitmapFormat, aScreenData));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aScreenData);


        
        
        
        
        ArrayOutConverter<BYTE> TmpScreenData(ComSafeArrayOutArg(aScreenData));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_TAKESCREENSHOTTOARRAY_ENTER(this, aScreenId, aWidth, aHeight, aBitmapFormat);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = takeScreenShotToArray(aScreenId,
                                        aWidth,
                                        aHeight,
                                        aBitmapFormat,
                                        TmpScreenData.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_TAKESCREENSHOTTOARRAY_RETURN(this, hrc, 0 /*normal*/, aScreenId, aWidth, aHeight, aBitmapFormat, (uint32_t)TmpScreenData.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_TAKESCREENSHOTTOARRAY_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, aWidth, aHeight, aBitmapFormat, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_TAKESCREENSHOTTOARRAY_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, aWidth, aHeight, aBitmapFormat, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aScreenData=%zu hrc=%Rhrc\n", this, "Display::takeScreenShotToArray", ComSafeArraySize(*aScreenData), hrc));
    return hrc;
}

STDMETHODIMP DisplayWrap::DrawToScreen(ULONG aScreenId,
                                       BYTE *aAddress,
                                       ULONG aX,
                                       ULONG aY,
                                       ULONG aWidth,
                                       ULONG aHeight)
{
    LogRelFlow(("{%p} %s:enter aScreenId=%RU32 aAddress=%p aX=%RU32 aY=%RU32 aWidth=%RU32 aHeight=%RU32\n", this, "Display::drawToScreen", aScreenId, aAddress, aX, aY, aWidth, aHeight));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        
        
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_DRAWTOSCREEN_ENTER(this, aScreenId, aAddress, aX, aY, aWidth, aHeight);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = drawToScreen(aScreenId,
                               aAddress,
                               aX,
                               aY,
                               aWidth,
                               aHeight);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_DRAWTOSCREEN_RETURN(this, hrc, 0 /*normal*/, aScreenId, aAddress, aX, aY, aWidth, aHeight);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_DRAWTOSCREEN_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, aAddress, aX, aY, aWidth, aHeight);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_DRAWTOSCREEN_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, aAddress, aX, aY, aWidth, aHeight);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Display::drawToScreen", hrc));
    return hrc;
}

STDMETHODIMP DisplayWrap::InvalidateAndUpdate()
{
    LogRelFlow(("{%p} %s:enter\n", this, "Display::invalidateAndUpdate"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_INVALIDATEANDUPDATE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = invalidateAndUpdate();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_INVALIDATEANDUPDATE_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_INVALIDATEANDUPDATE_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_INVALIDATEANDUPDATE_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Display::invalidateAndUpdate", hrc));
    return hrc;
}

STDMETHODIMP DisplayWrap::InvalidateAndUpdateScreen(ULONG aScreenId)
{
    LogRelFlow(("{%p} %s:enter aScreenId=%RU32\n", this, "Display::invalidateAndUpdateScreen", aScreenId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_INVALIDATEANDUPDATESCREEN_ENTER(this, aScreenId);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = invalidateAndUpdateScreen(aScreenId);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_INVALIDATEANDUPDATESCREEN_RETURN(this, hrc, 0 /*normal*/, aScreenId);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_INVALIDATEANDUPDATESCREEN_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_INVALIDATEANDUPDATESCREEN_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Display::invalidateAndUpdateScreen", hrc));
    return hrc;
}

STDMETHODIMP DisplayWrap::CompleteVHWACommand(BYTE *aCommand)
{
    LogRelFlow(("{%p} %s:enter aCommand=%p\n", this, "Display::completeVHWACommand", aCommand));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_COMPLETEVHWACOMMAND_ENTER(this, aCommand);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = completeVHWACommand(aCommand);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_COMPLETEVHWACOMMAND_RETURN(this, hrc, 0 /*normal*/, aCommand);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_COMPLETEVHWACOMMAND_RETURN(this, hrc, 1 /*hrc exception*/, aCommand);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_COMPLETEVHWACOMMAND_RETURN(this, hrc, 9 /*unhandled exception*/, aCommand);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Display::completeVHWACommand", hrc));
    return hrc;
}

STDMETHODIMP DisplayWrap::ViewportChanged(ULONG aScreenId,
                                          ULONG aX,
                                          ULONG aY,
                                          ULONG aWidth,
                                          ULONG aHeight)
{
    LogRelFlow(("{%p} %s:enter aScreenId=%RU32 aX=%RU32 aY=%RU32 aWidth=%RU32 aHeight=%RU32\n", this, "Display::viewportChanged", aScreenId, aX, aY, aWidth, aHeight));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_VIEWPORTCHANGED_ENTER(this, aScreenId, aX, aY, aWidth, aHeight);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = viewportChanged(aScreenId,
                                  aX,
                                  aY,
                                  aWidth,
                                  aHeight);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_VIEWPORTCHANGED_RETURN(this, hrc, 0 /*normal*/, aScreenId, aX, aY, aWidth, aHeight);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_VIEWPORTCHANGED_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, aX, aY, aWidth, aHeight);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_VIEWPORTCHANGED_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, aX, aY, aWidth, aHeight);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Display::viewportChanged", hrc));
    return hrc;
}

STDMETHODIMP DisplayWrap::QuerySourceBitmap(ULONG aScreenId,
                                            IDisplaySourceBitmap **aDisplaySourceBitmap)
{
    LogRelFlow(("{%p} %s:enter aScreenId=%RU32 aDisplaySourceBitmap=%p\n", this, "Display::querySourceBitmap", aScreenId, aDisplaySourceBitmap));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDisplaySourceBitmap);


        
        ComTypeOutConverter<IDisplaySourceBitmap> TmpDisplaySourceBitmap(aDisplaySourceBitmap);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_QUERYSOURCEBITMAP_ENTER(this, aScreenId);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = querySourceBitmap(aScreenId,
                                    TmpDisplaySourceBitmap.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_QUERYSOURCEBITMAP_RETURN(this, hrc, 0 /*normal*/, aScreenId, (void *)TmpDisplaySourceBitmap.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_QUERYSOURCEBITMAP_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_QUERYSOURCEBITMAP_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDisplaySourceBitmap=%p hrc=%Rhrc\n", this, "Display::querySourceBitmap", *aDisplaySourceBitmap, hrc));
    return hrc;
}

STDMETHODIMP DisplayWrap::NotifyScaleFactorChange(ULONG aScreenId,
                                                  ULONG aU32ScaleFactorWMultiplied,
                                                  ULONG aU32ScaleFactorHMultiplied)
{
    LogRelFlow(("{%p} %s:enter aScreenId=%RU32 aU32ScaleFactorWMultiplied=%RU32 aU32ScaleFactorHMultiplied=%RU32\n", this, "Display::notifyScaleFactorChange", aScreenId, aU32ScaleFactorWMultiplied, aU32ScaleFactorHMultiplied));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_NOTIFYSCALEFACTORCHANGE_ENTER(this, aScreenId, aU32ScaleFactorWMultiplied, aU32ScaleFactorHMultiplied);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = notifyScaleFactorChange(aScreenId,
                                          aU32ScaleFactorWMultiplied,
                                          aU32ScaleFactorHMultiplied);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_NOTIFYSCALEFACTORCHANGE_RETURN(this, hrc, 0 /*normal*/, aScreenId, aU32ScaleFactorWMultiplied, aU32ScaleFactorHMultiplied);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_NOTIFYSCALEFACTORCHANGE_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, aU32ScaleFactorWMultiplied, aU32ScaleFactorHMultiplied);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_NOTIFYSCALEFACTORCHANGE_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, aU32ScaleFactorWMultiplied, aU32ScaleFactorHMultiplied);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Display::notifyScaleFactorChange", hrc));
    return hrc;
}

STDMETHODIMP DisplayWrap::NotifyHiDPIOutputPolicyChange(BOOL aFUnscaledHiDPI)
{
    LogRelFlow(("{%p} %s:enter aFUnscaledHiDPI=%RTbool\n", this, "Display::notifyHiDPIOutputPolicyChange", aFUnscaledHiDPI));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_NOTIFYHIDPIOUTPUTPOLICYCHANGE_ENTER(this, aFUnscaledHiDPI != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = notifyHiDPIOutputPolicyChange(aFUnscaledHiDPI != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_NOTIFYHIDPIOUTPUTPOLICYCHANGE_RETURN(this, hrc, 0 /*normal*/, aFUnscaledHiDPI != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_NOTIFYHIDPIOUTPUTPOLICYCHANGE_RETURN(this, hrc, 1 /*hrc exception*/, aFUnscaledHiDPI != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_NOTIFYHIDPIOUTPUTPOLICYCHANGE_RETURN(this, hrc, 9 /*unhandled exception*/, aFUnscaledHiDPI != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Display::notifyHiDPIOutputPolicyChange", hrc));
    return hrc;
}

STDMETHODIMP DisplayWrap::SetScreenLayout(ScreenLayoutMode_T aScreenLayoutMode,
                                          ComSafeArrayIn(IGuestScreenInfo *, aGuestScreenInfo))
{
    LogRelFlow(("{%p} %s:enter aScreenLayoutMode=%RU32 aGuestScreenInfo=%zu\n", this, "Display::setScreenLayout", aScreenLayoutMode, aGuestScreenInfo));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        ArrayComTypeInConverter<IGuestScreenInfo> TmpGuestScreenInfo(ComSafeArrayInArg(aGuestScreenInfo));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_SETSCREENLAYOUT_ENTER(this, aScreenLayoutMode, (uint32_t)TmpGuestScreenInfo.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setScreenLayout(aScreenLayoutMode,
                                  TmpGuestScreenInfo.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_SETSCREENLAYOUT_RETURN(this, hrc, 0 /*normal*/, aScreenLayoutMode, (uint32_t)TmpGuestScreenInfo.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_SETSCREENLAYOUT_RETURN(this, hrc, 1 /*hrc exception*/, aScreenLayoutMode, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_SETSCREENLAYOUT_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenLayoutMode, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Display::setScreenLayout", hrc));
    return hrc;
}

STDMETHODIMP DisplayWrap::DetachScreens(ComSafeArrayIn(LONG, aScreenIds))
{
    LogRelFlow(("{%p} %s:enter aScreenIds=%zu\n", this, "Display::detachScreens", aScreenIds));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ArrayInConverter<LONG> TmpScreenIds(ComSafeArrayInArg(aScreenIds));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_DETACHSCREENS_ENTER(this, (uint32_t)TmpScreenIds.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = detachScreens(TmpScreenIds.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_DETACHSCREENS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpScreenIds.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_DETACHSCREENS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_DETACHSCREENS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Display::detachScreens", hrc));
    return hrc;
}

STDMETHODIMP DisplayWrap::CreateGuestScreenInfo(ULONG aDisplay,
                                                GuestMonitorStatus_T aStatus,
                                                BOOL aPrimary,
                                                BOOL aChangeOrigin,
                                                LONG aOriginX,
                                                LONG aOriginY,
                                                ULONG aWidth,
                                                ULONG aHeight,
                                                ULONG aBitsPerPixel,
                                                IGuestScreenInfo **aGuestScreenInfo)
{
    LogRelFlow(("{%p} %s:enter aDisplay=%RU32 aStatus=%RU32 aPrimary=%RTbool aChangeOrigin=%RTbool aOriginX=%RI32 aOriginY=%RI32 aWidth=%RU32 aHeight=%RU32 aBitsPerPixel=%RU32 aGuestScreenInfo=%p\n", this, "Display::createGuestScreenInfo", aDisplay, aStatus, aPrimary, aChangeOrigin, aOriginX, aOriginY, aWidth, aHeight, aBitsPerPixel, aGuestScreenInfo));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGuestScreenInfo);


        
        
        
        
        
        
        
        
        
        ComTypeOutConverter<IGuestScreenInfo> TmpGuestScreenInfo(aGuestScreenInfo);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_CREATEGUESTSCREENINFO_ENTER(this, aDisplay, aStatus, aPrimary != FALSE, aChangeOrigin != FALSE, aOriginX, aOriginY, aWidth, aHeight, aBitsPerPixel);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = createGuestScreenInfo(aDisplay,
                                        aStatus,
                                        aPrimary != FALSE,
                                        aChangeOrigin != FALSE,
                                        aOriginX,
                                        aOriginY,
                                        aWidth,
                                        aHeight,
                                        aBitsPerPixel,
                                        TmpGuestScreenInfo.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_CREATEGUESTSCREENINFO_RETURN(this, hrc, 0 /*normal*/, aDisplay, aStatus, aPrimary != FALSE, aChangeOrigin != FALSE, aOriginX, aOriginY, aWidth, aHeight, aBitsPerPixel, (void *)TmpGuestScreenInfo.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_CREATEGUESTSCREENINFO_RETURN(this, hrc, 1 /*hrc exception*/, aDisplay, aStatus, aPrimary != FALSE, aChangeOrigin != FALSE, aOriginX, aOriginY, aWidth, aHeight, aBitsPerPixel, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_CREATEGUESTSCREENINFO_RETURN(this, hrc, 9 /*unhandled exception*/, aDisplay, aStatus, aPrimary != FALSE, aChangeOrigin != FALSE, aOriginX, aOriginY, aWidth, aHeight, aBitsPerPixel, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aGuestScreenInfo=%p hrc=%Rhrc\n", this, "Display::createGuestScreenInfo", *aGuestScreenInfo, hrc));
    return hrc;
}

STDMETHODIMP DisplayWrap::InternalAndReservedMethod1IDisplay()
{
    return E_NOTIMPL;
}

STDMETHODIMP DisplayWrap::InternalAndReservedMethod2IDisplay()
{
    return E_NOTIMPL;
}

STDMETHODIMP DisplayWrap::InternalAndReservedMethod3IDisplay()
{
    return E_NOTIMPL;
}

STDMETHODIMP DisplayWrap::InternalAndReservedMethod4IDisplay()
{
    return E_NOTIMPL;
}

STDMETHODIMP DisplayWrap::InternalAndReservedMethod5IDisplay()
{
    return E_NOTIMPL;
}

STDMETHODIMP DisplayWrap::InternalAndReservedMethod6IDisplay()
{
    return E_NOTIMPL;
}

STDMETHODIMP DisplayWrap::InternalAndReservedMethod7IDisplay()
{
    return E_NOTIMPL;
}

STDMETHODIMP DisplayWrap::InternalAndReservedMethod8IDisplay()
{
    return E_NOTIMPL;
}

//
// IEventListener methods
//

STDMETHODIMP DisplayWrap::HandleEvent(IEvent *aEvent)
{
    LogRelFlow(("{%p} %s:enter aEvent=%p\n", this, "Display::handleEvent", aEvent));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<IEvent> TmpEvent(aEvent);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_HANDLEEVENT_ENTER(this, (void *)TmpEvent.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = handleEvent(TmpEvent.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_HANDLEEVENT_RETURN(this, hrc, 0 /*normal*/, (void *)TmpEvent.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_HANDLEEVENT_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DISPLAY_HANDLEEVENT_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Display::handleEvent", hrc));
    return hrc;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(DisplayWrap)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(DisplayWrap, IDisplay, IEventListener)
#endif // VBOX_WITH_XPCOM

