// ##### ENDFILE "GuestSessionEventWrap.cpp"


// ##### BEGINFILE "GuestProcessIOEventWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IGuestProcessIOEvent.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_GUESTPROCESSIOEVENT

#include "GuestProcessIOEventWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(GuestProcessIOEventWrap)

//
// IEvent properties
//

STDMETHODIMP GuestProcessIOEventWrap::COMGETTER(Type)(VBoxEventType_T *aType)
{
    LogRelFlow(("{%p} %s: enter aType=%p\n", this, "GuestProcessIOEvent::getType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_TYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getType(aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_TYPE_RETURN(this, hrc, 0 /*normal*/,*aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aType=%RU32 hrc=%Rhrc\n", this, "GuestProcessIOEvent::getType", *aType, hrc));
    return hrc;
}

STDMETHODIMP GuestProcessIOEventWrap::COMGETTER(Source)(IEventSource **aSource)
{
    LogRelFlow(("{%p} %s: enter aSource=%p\n", this, "GuestProcessIOEvent::getSource", aSource));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSource);
        ComTypeOutConverter<IEventSource> TmpSource(aSource);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_SOURCE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSource(TmpSource.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_SOURCE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpSource.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_SOURCE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_SOURCE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSource=%p hrc=%Rhrc\n", this, "GuestProcessIOEvent::getSource", *aSource, hrc));
    return hrc;
}

STDMETHODIMP GuestProcessIOEventWrap::COMGETTER(Waitable)(BOOL *aWaitable)
{
    LogRelFlow(("{%p} %s: enter aWaitable=%p\n", this, "GuestProcessIOEvent::getWaitable", aWaitable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWaitable);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_WAITABLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getWaitable(aWaitable);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_WAITABLE_RETURN(this, hrc, 0 /*normal*/,*aWaitable != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_WAITABLE_RETURN(this, hrc, 1 /*hrc exception*/,*aWaitable != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_WAITABLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aWaitable != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aWaitable=%RTbool hrc=%Rhrc\n", this, "GuestProcessIOEvent::getWaitable", *aWaitable, hrc));
    return hrc;
}

//
// IGuestSessionEvent properties
//

STDMETHODIMP GuestProcessIOEventWrap::COMGETTER(Session)(IGuestSession **aSession)
{
    LogRelFlow(("{%p} %s: enter aSession=%p\n", this, "GuestProcessIOEvent::getSession", aSession));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSession);
        ComTypeOutConverter<IGuestSession> TmpSession(aSession);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_SESSION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSession(TmpSession.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_SESSION_RETURN(this, hrc, 0 /*normal*/,(void *)TmpSession.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_SESSION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_SESSION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSession=%p hrc=%Rhrc\n", this, "GuestProcessIOEvent::getSession", *aSession, hrc));
    return hrc;
}

//
// IGuestProcessEvent properties
//

STDMETHODIMP GuestProcessIOEventWrap::COMGETTER(Process)(IGuestProcess **aProcess)
{
    LogRelFlow(("{%p} %s: enter aProcess=%p\n", this, "GuestProcessIOEvent::getProcess", aProcess));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProcess);
        ComTypeOutConverter<IGuestProcess> TmpProcess(aProcess);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_PROCESS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProcess(TmpProcess.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_PROCESS_RETURN(this, hrc, 0 /*normal*/,(void *)TmpProcess.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_PROCESS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_PROCESS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProcess=%p hrc=%Rhrc\n", this, "GuestProcessIOEvent::getProcess", *aProcess, hrc));
    return hrc;
}

STDMETHODIMP GuestProcessIOEventWrap::COMGETTER(Pid)(ULONG *aPid)
{
    LogRelFlow(("{%p} %s: enter aPid=%p\n", this, "GuestProcessIOEvent::getPid", aPid));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPid);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_PID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPid(aPid);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_PID_RETURN(this, hrc, 0 /*normal*/,*aPid);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_PID_RETURN(this, hrc, 1 /*hrc exception*/,*aPid);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_PID_RETURN(this, hrc, 9 /*unhandled exception*/,*aPid);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPid=%RU32 hrc=%Rhrc\n", this, "GuestProcessIOEvent::getPid", *aPid, hrc));
    return hrc;
}

//
// IGuestProcessIOEvent properties
//

STDMETHODIMP GuestProcessIOEventWrap::COMGETTER(Handle)(ULONG *aHandle)
{
    LogRelFlow(("{%p} %s: enter aHandle=%p\n", this, "GuestProcessIOEvent::getHandle", aHandle));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHandle);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_HANDLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHandle(aHandle);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_HANDLE_RETURN(this, hrc, 0 /*normal*/,*aHandle);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_HANDLE_RETURN(this, hrc, 1 /*hrc exception*/,*aHandle);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_HANDLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aHandle);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHandle=%RU32 hrc=%Rhrc\n", this, "GuestProcessIOEvent::getHandle", *aHandle, hrc));
    return hrc;
}

STDMETHODIMP GuestProcessIOEventWrap::COMGETTER(Processed)(ULONG *aProcessed)
{
    LogRelFlow(("{%p} %s: enter aProcessed=%p\n", this, "GuestProcessIOEvent::getProcessed", aProcessed));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProcessed);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_PROCESSED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProcessed(aProcessed);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_PROCESSED_RETURN(this, hrc, 0 /*normal*/,*aProcessed);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_PROCESSED_RETURN(this, hrc, 1 /*hrc exception*/,*aProcessed);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_GET_PROCESSED_RETURN(this, hrc, 9 /*unhandled exception*/,*aProcessed);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProcessed=%RU32 hrc=%Rhrc\n", this, "GuestProcessIOEvent::getProcessed", *aProcessed, hrc));
    return hrc;
}


//
// IEvent methods
//

STDMETHODIMP GuestProcessIOEventWrap::SetProcessed()
{
    LogRelFlow(("{%p} %s:enter\n", this, "GuestProcessIOEvent::setProcessed"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_SETPROCESSED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setProcessed();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_SETPROCESSED_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_SETPROCESSED_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_SETPROCESSED_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestProcessIOEvent::setProcessed", hrc));
    return hrc;
}

STDMETHODIMP GuestProcessIOEventWrap::WaitProcessed(LONG aTimeout,
                                                    BOOL *aResult)
{
    LogRelFlow(("{%p} %s:enter aTimeout=%RI32 aResult=%p\n", this, "GuestProcessIOEvent::waitProcessed", aTimeout, aResult));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aResult);


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_WAITPROCESSED_ENTER(this, aTimeout);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = waitProcessed(aTimeout,
                                aResult);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_WAITPROCESSED_RETURN(this, hrc, 0 /*normal*/, aTimeout, *aResult != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_WAITPROCESSED_RETURN(this, hrc, 1 /*hrc exception*/, aTimeout, *aResult != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESSIOEVENT_WAITPROCESSED_RETURN(this, hrc, 9 /*unhandled exception*/, aTimeout, *aResult != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aResult=%RTbool hrc=%Rhrc\n", this, "GuestProcessIOEvent::waitProcessed", *aResult, hrc));
    return hrc;
}

//
// IGuestSessionEvent methods
//

//
// IGuestProcessEvent methods
//

//
// IGuestProcessIOEvent methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestProcessIOEventWrap)
NS_IMPL_THREADSAFE_ISUPPORTS4_CI(GuestProcessIOEventWrap, IGuestProcessIOEvent, IGuestProcessEvent, IGuestSessionEvent, IEvent)
#endif // VBOX_WITH_XPCOM

