// ##### ENDFILE "RecordingScreenSettingsWrap.cpp"


// ##### BEGINFILE "PCIAddressWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IPCIAddress.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_PCIADDRESS

#include "PCIAddressWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(PCIAddressWrap)

//
// IPCIAddress properties
//

STDMETHODIMP PCIAddressWrap::COMGETTER(Bus)(SHORT *aBus)
{
    LogRelFlow(("{%p} %s: enter aBus=%p\n", this, "PCIAddress::getBus", aBus));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBus);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_GET_BUS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getBus(aBus);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_GET_BUS_RETURN(this, hrc, 0 /*normal*/,*aBus);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_GET_BUS_RETURN(this, hrc, 1 /*hrc exception*/,*aBus);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_GET_BUS_RETURN(this, hrc, 9 /*unhandled exception*/,*aBus);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aBus=%RI16 hrc=%Rhrc\n", this, "PCIAddress::getBus", *aBus, hrc));
    return hrc;
}

STDMETHODIMP PCIAddressWrap::COMSETTER(Bus)(SHORT aBus)
{
    LogRelFlow(("{%p} %s: enter aBus=%RI16\n", this, "PCIAddress::setBus", aBus));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_SET_BUS_ENTER(this, aBus);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setBus(aBus);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_SET_BUS_RETURN(this, hrc, 0 /*normal*/,aBus);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_SET_BUS_RETURN(this, hrc, 1 /*hrc exception*/,aBus);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_SET_BUS_RETURN(this, hrc, 9 /*unhandled exception*/,aBus);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "PCIAddress::setBus", hrc));
    return hrc;
}

STDMETHODIMP PCIAddressWrap::COMGETTER(Device)(SHORT *aDevice)
{
    LogRelFlow(("{%p} %s: enter aDevice=%p\n", this, "PCIAddress::getDevice", aDevice));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDevice);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_GET_DEVICE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDevice(aDevice);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_GET_DEVICE_RETURN(this, hrc, 0 /*normal*/,*aDevice);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_GET_DEVICE_RETURN(this, hrc, 1 /*hrc exception*/,*aDevice);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_GET_DEVICE_RETURN(this, hrc, 9 /*unhandled exception*/,*aDevice);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDevice=%RI16 hrc=%Rhrc\n", this, "PCIAddress::getDevice", *aDevice, hrc));
    return hrc;
}

STDMETHODIMP PCIAddressWrap::COMSETTER(Device)(SHORT aDevice)
{
    LogRelFlow(("{%p} %s: enter aDevice=%RI16\n", this, "PCIAddress::setDevice", aDevice));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_SET_DEVICE_ENTER(this, aDevice);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setDevice(aDevice);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_SET_DEVICE_RETURN(this, hrc, 0 /*normal*/,aDevice);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_SET_DEVICE_RETURN(this, hrc, 1 /*hrc exception*/,aDevice);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_SET_DEVICE_RETURN(this, hrc, 9 /*unhandled exception*/,aDevice);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "PCIAddress::setDevice", hrc));
    return hrc;
}

STDMETHODIMP PCIAddressWrap::COMGETTER(DevFunction)(SHORT *aDevFunction)
{
    LogRelFlow(("{%p} %s: enter aDevFunction=%p\n", this, "PCIAddress::getDevFunction", aDevFunction));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDevFunction);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_GET_DEVFUNCTION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDevFunction(aDevFunction);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_GET_DEVFUNCTION_RETURN(this, hrc, 0 /*normal*/,*aDevFunction);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_GET_DEVFUNCTION_RETURN(this, hrc, 1 /*hrc exception*/,*aDevFunction);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_GET_DEVFUNCTION_RETURN(this, hrc, 9 /*unhandled exception*/,*aDevFunction);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDevFunction=%RI16 hrc=%Rhrc\n", this, "PCIAddress::getDevFunction", *aDevFunction, hrc));
    return hrc;
}

STDMETHODIMP PCIAddressWrap::COMSETTER(DevFunction)(SHORT aDevFunction)
{
    LogRelFlow(("{%p} %s: enter aDevFunction=%RI16\n", this, "PCIAddress::setDevFunction", aDevFunction));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_SET_DEVFUNCTION_ENTER(this, aDevFunction);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setDevFunction(aDevFunction);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_SET_DEVFUNCTION_RETURN(this, hrc, 0 /*normal*/,aDevFunction);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_SET_DEVFUNCTION_RETURN(this, hrc, 1 /*hrc exception*/,aDevFunction);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_SET_DEVFUNCTION_RETURN(this, hrc, 9 /*unhandled exception*/,aDevFunction);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "PCIAddress::setDevFunction", hrc));
    return hrc;
}


//
// IPCIAddress methods
//

STDMETHODIMP PCIAddressWrap::AsLong(LONG *aResult)
{
    LogRelFlow(("{%p} %s:enter aResult=%p\n", this, "PCIAddress::asLong", aResult));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aResult);


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_ASLONG_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = asLong(aResult);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_ASLONG_RETURN(this, hrc, 0 /*normal*/, *aResult);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_ASLONG_RETURN(this, hrc, 1 /*hrc exception*/, *aResult);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_ASLONG_RETURN(this, hrc, 9 /*unhandled exception*/, *aResult);
#endif
    }

    LogRelFlow(("{%p} %s: leave aResult=%RI32 hrc=%Rhrc\n", this, "PCIAddress::asLong", *aResult, hrc));
    return hrc;
}

STDMETHODIMP PCIAddressWrap::FromLong(LONG aNumber)
{
    LogRelFlow(("{%p} %s:enter aNumber=%RI32\n", this, "PCIAddress::fromLong", aNumber));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_FROMLONG_ENTER(this, aNumber);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = fromLong(aNumber);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_FROMLONG_RETURN(this, hrc, 0 /*normal*/, aNumber);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_FROMLONG_RETURN(this, hrc, 1 /*hrc exception*/, aNumber);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIADDRESS_FROMLONG_RETURN(this, hrc, 9 /*unhandled exception*/, aNumber);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "PCIAddress::fromLong", hrc));
    return hrc;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(PCIAddressWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(PCIAddressWrap, IPCIAddress)
#endif // VBOX_WITH_XPCOM

