// ##### ENDFILE "GuestFsObjInfoWrap.cpp"


// ##### BEGINFILE "ProgressWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IProgress.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_PROGRESS

#include "ProgressWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(ProgressWrap)

//
// IProgress properties
//

STDMETHODIMP ProgressWrap::COMGETTER(Id)(BSTR *aId)
{
    LogRelFlow(("{%p} %s: enter aId=%p\n", this, "Progress::getId", aId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aId);
        UuidOutConverter TmpId(aId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_ID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getId(TmpId.uuid());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_ID_RETURN(this, hrc, 0 /*normal*/,TmpId.uuid().toStringCurly().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_ID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_ID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aId=%ls hrc=%Rhrc\n", this, "Progress::getId", *aId, hrc));
    return hrc;
}

STDMETHODIMP ProgressWrap::COMGETTER(Description)(BSTR *aDescription)
{
    LogRelFlow(("{%p} %s: enter aDescription=%p\n", this, "Progress::getDescription", aDescription));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDescription);
        BSTROutConverter TmpDescription(aDescription);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_DESCRIPTION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDescription(TmpDescription.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_DESCRIPTION_RETURN(this, hrc, 0 /*normal*/,TmpDescription.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_DESCRIPTION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_DESCRIPTION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDescription=%ls hrc=%Rhrc\n", this, "Progress::getDescription", *aDescription, hrc));
    return hrc;
}

STDMETHODIMP ProgressWrap::COMGETTER(Initiator)(IUnknown **aInitiator)
{
    LogRelFlow(("{%p} %s: enter aInitiator=%p\n", this, "Progress::getInitiator", aInitiator));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aInitiator);
        ComTypeOutConverter<IUnknown> TmpInitiator(aInitiator);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_INITIATOR_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getInitiator(TmpInitiator.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_INITIATOR_RETURN(this, hrc, 0 /*normal*/,(void *)TmpInitiator.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_INITIATOR_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_INITIATOR_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aInitiator=%p hrc=%Rhrc\n", this, "Progress::getInitiator", *aInitiator, hrc));
    return hrc;
}

STDMETHODIMP ProgressWrap::COMGETTER(Cancelable)(BOOL *aCancelable)
{
    LogRelFlow(("{%p} %s: enter aCancelable=%p\n", this, "Progress::getCancelable", aCancelable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCancelable);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_CANCELABLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCancelable(aCancelable);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_CANCELABLE_RETURN(this, hrc, 0 /*normal*/,*aCancelable != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_CANCELABLE_RETURN(this, hrc, 1 /*hrc exception*/,*aCancelable != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_CANCELABLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aCancelable != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCancelable=%RTbool hrc=%Rhrc\n", this, "Progress::getCancelable", *aCancelable, hrc));
    return hrc;
}

STDMETHODIMP ProgressWrap::COMGETTER(Percent)(ULONG *aPercent)
{
    LogRelFlow(("{%p} %s: enter aPercent=%p\n", this, "Progress::getPercent", aPercent));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPercent);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_PERCENT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPercent(aPercent);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_PERCENT_RETURN(this, hrc, 0 /*normal*/,*aPercent);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_PERCENT_RETURN(this, hrc, 1 /*hrc exception*/,*aPercent);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_PERCENT_RETURN(this, hrc, 9 /*unhandled exception*/,*aPercent);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPercent=%RU32 hrc=%Rhrc\n", this, "Progress::getPercent", *aPercent, hrc));
    return hrc;
}

STDMETHODIMP ProgressWrap::COMGETTER(TimeRemaining)(LONG *aTimeRemaining)
{
    LogRelFlow(("{%p} %s: enter aTimeRemaining=%p\n", this, "Progress::getTimeRemaining", aTimeRemaining));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTimeRemaining);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_TIMEREMAINING_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTimeRemaining(aTimeRemaining);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_TIMEREMAINING_RETURN(this, hrc, 0 /*normal*/,*aTimeRemaining);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_TIMEREMAINING_RETURN(this, hrc, 1 /*hrc exception*/,*aTimeRemaining);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_TIMEREMAINING_RETURN(this, hrc, 9 /*unhandled exception*/,*aTimeRemaining);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTimeRemaining=%RI32 hrc=%Rhrc\n", this, "Progress::getTimeRemaining", *aTimeRemaining, hrc));
    return hrc;
}

STDMETHODIMP ProgressWrap::COMGETTER(Completed)(BOOL *aCompleted)
{
    LogRelFlow(("{%p} %s: enter aCompleted=%p\n", this, "Progress::getCompleted", aCompleted));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCompleted);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_COMPLETED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCompleted(aCompleted);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_COMPLETED_RETURN(this, hrc, 0 /*normal*/,*aCompleted != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_COMPLETED_RETURN(this, hrc, 1 /*hrc exception*/,*aCompleted != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_COMPLETED_RETURN(this, hrc, 9 /*unhandled exception*/,*aCompleted != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCompleted=%RTbool hrc=%Rhrc\n", this, "Progress::getCompleted", *aCompleted, hrc));
    return hrc;
}

STDMETHODIMP ProgressWrap::COMGETTER(Canceled)(BOOL *aCanceled)
{
    LogRelFlow(("{%p} %s: enter aCanceled=%p\n", this, "Progress::getCanceled", aCanceled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCanceled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_CANCELED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCanceled(aCanceled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_CANCELED_RETURN(this, hrc, 0 /*normal*/,*aCanceled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_CANCELED_RETURN(this, hrc, 1 /*hrc exception*/,*aCanceled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_CANCELED_RETURN(this, hrc, 9 /*unhandled exception*/,*aCanceled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCanceled=%RTbool hrc=%Rhrc\n", this, "Progress::getCanceled", *aCanceled, hrc));
    return hrc;
}

STDMETHODIMP ProgressWrap::COMGETTER(ResultCode)(LONG *aResultCode)
{
    LogRelFlow(("{%p} %s: enter aResultCode=%p\n", this, "Progress::getResultCode", aResultCode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aResultCode);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_RESULTCODE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getResultCode(aResultCode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_RESULTCODE_RETURN(this, hrc, 0 /*normal*/,*aResultCode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_RESULTCODE_RETURN(this, hrc, 1 /*hrc exception*/,*aResultCode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_RESULTCODE_RETURN(this, hrc, 9 /*unhandled exception*/,*aResultCode);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aResultCode=%RI32 hrc=%Rhrc\n", this, "Progress::getResultCode", *aResultCode, hrc));
    return hrc;
}

STDMETHODIMP ProgressWrap::COMGETTER(ErrorInfo)(IVirtualBoxErrorInfo **aErrorInfo)
{
    LogRelFlow(("{%p} %s: enter aErrorInfo=%p\n", this, "Progress::getErrorInfo", aErrorInfo));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aErrorInfo);
        ComTypeOutConverter<IVirtualBoxErrorInfo> TmpErrorInfo(aErrorInfo);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_ERRORINFO_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getErrorInfo(TmpErrorInfo.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_ERRORINFO_RETURN(this, hrc, 0 /*normal*/,(void *)TmpErrorInfo.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_ERRORINFO_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_ERRORINFO_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aErrorInfo=%p hrc=%Rhrc\n", this, "Progress::getErrorInfo", *aErrorInfo, hrc));
    return hrc;
}

STDMETHODIMP ProgressWrap::COMGETTER(OperationCount)(ULONG *aOperationCount)
{
    LogRelFlow(("{%p} %s: enter aOperationCount=%p\n", this, "Progress::getOperationCount", aOperationCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOperationCount);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_OPERATIONCOUNT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getOperationCount(aOperationCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_OPERATIONCOUNT_RETURN(this, hrc, 0 /*normal*/,*aOperationCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_OPERATIONCOUNT_RETURN(this, hrc, 1 /*hrc exception*/,*aOperationCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_OPERATIONCOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,*aOperationCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aOperationCount=%RU32 hrc=%Rhrc\n", this, "Progress::getOperationCount", *aOperationCount, hrc));
    return hrc;
}

STDMETHODIMP ProgressWrap::COMGETTER(Operation)(ULONG *aOperation)
{
    LogRelFlow(("{%p} %s: enter aOperation=%p\n", this, "Progress::getOperation", aOperation));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOperation);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_OPERATION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getOperation(aOperation);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_OPERATION_RETURN(this, hrc, 0 /*normal*/,*aOperation);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_OPERATION_RETURN(this, hrc, 1 /*hrc exception*/,*aOperation);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_OPERATION_RETURN(this, hrc, 9 /*unhandled exception*/,*aOperation);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aOperation=%RU32 hrc=%Rhrc\n", this, "Progress::getOperation", *aOperation, hrc));
    return hrc;
}

STDMETHODIMP ProgressWrap::COMGETTER(OperationDescription)(BSTR *aOperationDescription)
{
    LogRelFlow(("{%p} %s: enter aOperationDescription=%p\n", this, "Progress::getOperationDescription", aOperationDescription));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOperationDescription);
        BSTROutConverter TmpOperationDescription(aOperationDescription);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_OPERATIONDESCRIPTION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getOperationDescription(TmpOperationDescription.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_OPERATIONDESCRIPTION_RETURN(this, hrc, 0 /*normal*/,TmpOperationDescription.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_OPERATIONDESCRIPTION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_OPERATIONDESCRIPTION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aOperationDescription=%ls hrc=%Rhrc\n", this, "Progress::getOperationDescription", *aOperationDescription, hrc));
    return hrc;
}

STDMETHODIMP ProgressWrap::COMGETTER(OperationPercent)(ULONG *aOperationPercent)
{
    LogRelFlow(("{%p} %s: enter aOperationPercent=%p\n", this, "Progress::getOperationPercent", aOperationPercent));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOperationPercent);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_OPERATIONPERCENT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getOperationPercent(aOperationPercent);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_OPERATIONPERCENT_RETURN(this, hrc, 0 /*normal*/,*aOperationPercent);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_OPERATIONPERCENT_RETURN(this, hrc, 1 /*hrc exception*/,*aOperationPercent);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_OPERATIONPERCENT_RETURN(this, hrc, 9 /*unhandled exception*/,*aOperationPercent);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aOperationPercent=%RU32 hrc=%Rhrc\n", this, "Progress::getOperationPercent", *aOperationPercent, hrc));
    return hrc;
}

STDMETHODIMP ProgressWrap::COMGETTER(OperationWeight)(ULONG *aOperationWeight)
{
    LogRelFlow(("{%p} %s: enter aOperationWeight=%p\n", this, "Progress::getOperationWeight", aOperationWeight));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOperationWeight);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_OPERATIONWEIGHT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getOperationWeight(aOperationWeight);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_OPERATIONWEIGHT_RETURN(this, hrc, 0 /*normal*/,*aOperationWeight);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_OPERATIONWEIGHT_RETURN(this, hrc, 1 /*hrc exception*/,*aOperationWeight);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_OPERATIONWEIGHT_RETURN(this, hrc, 9 /*unhandled exception*/,*aOperationWeight);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aOperationWeight=%RU32 hrc=%Rhrc\n", this, "Progress::getOperationWeight", *aOperationWeight, hrc));
    return hrc;
}

STDMETHODIMP ProgressWrap::COMGETTER(Timeout)(ULONG *aTimeout)
{
    LogRelFlow(("{%p} %s: enter aTimeout=%p\n", this, "Progress::getTimeout", aTimeout));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTimeout);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_TIMEOUT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTimeout(aTimeout);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_TIMEOUT_RETURN(this, hrc, 0 /*normal*/,*aTimeout);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_TIMEOUT_RETURN(this, hrc, 1 /*hrc exception*/,*aTimeout);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_TIMEOUT_RETURN(this, hrc, 9 /*unhandled exception*/,*aTimeout);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTimeout=%RU32 hrc=%Rhrc\n", this, "Progress::getTimeout", *aTimeout, hrc));
    return hrc;
}

STDMETHODIMP ProgressWrap::COMSETTER(Timeout)(ULONG aTimeout)
{
    LogRelFlow(("{%p} %s: enter aTimeout=%RU32\n", this, "Progress::setTimeout", aTimeout));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_SET_TIMEOUT_ENTER(this, aTimeout);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setTimeout(aTimeout);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_SET_TIMEOUT_RETURN(this, hrc, 0 /*normal*/,aTimeout);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_SET_TIMEOUT_RETURN(this, hrc, 1 /*hrc exception*/,aTimeout);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_SET_TIMEOUT_RETURN(this, hrc, 9 /*unhandled exception*/,aTimeout);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Progress::setTimeout", hrc));
    return hrc;
}

STDMETHODIMP ProgressWrap::COMGETTER(EventSource)(IEventSource **aEventSource)
{
    LogRelFlow(("{%p} %s: enter aEventSource=%p\n", this, "Progress::getEventSource", aEventSource));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEventSource);
        ComTypeOutConverter<IEventSource> TmpEventSource(aEventSource);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_EVENTSOURCE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEventSource(TmpEventSource.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_EVENTSOURCE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpEventSource.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_EVENTSOURCE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_GET_EVENTSOURCE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEventSource=%p hrc=%Rhrc\n", this, "Progress::getEventSource", *aEventSource, hrc));
    return hrc;
}

STDMETHODIMP ProgressWrap::COMGETTER(InternalAndReservedAttribute1IProgress)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::COMGETTER(InternalAndReservedAttribute2IProgress)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::COMGETTER(InternalAndReservedAttribute3IProgress)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::COMGETTER(InternalAndReservedAttribute4IProgress)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::COMGETTER(InternalAndReservedAttribute5IProgress)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::COMGETTER(InternalAndReservedAttribute6IProgress)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::COMGETTER(InternalAndReservedAttribute7IProgress)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::COMGETTER(InternalAndReservedAttribute8IProgress)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::COMGETTER(InternalAndReservedAttribute9IProgress)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::COMGETTER(InternalAndReservedAttribute10IProgress)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::COMGETTER(InternalAndReservedAttribute11IProgress)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::COMGETTER(InternalAndReservedAttribute12IProgress)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

//
// IInternalProgressControl properties
//

STDMETHODIMP ProgressWrap::COMGETTER(InternalAndReservedAttribute1IInternalProgressControl)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::COMGETTER(InternalAndReservedAttribute2IInternalProgressControl)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::COMGETTER(InternalAndReservedAttribute3IInternalProgressControl)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::COMGETTER(InternalAndReservedAttribute4IInternalProgressControl)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::COMGETTER(InternalAndReservedAttribute5IInternalProgressControl)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::COMGETTER(InternalAndReservedAttribute6IInternalProgressControl)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::COMGETTER(InternalAndReservedAttribute7IInternalProgressControl)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::COMGETTER(InternalAndReservedAttribute8IInternalProgressControl)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IProgress methods
//

STDMETHODIMP ProgressWrap::WaitForCompletion(LONG aTimeout)
{
    LogRelFlow(("{%p} %s:enter aTimeout=%RI32\n", this, "Progress::waitForCompletion", aTimeout));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_WAITFORCOMPLETION_ENTER(this, aTimeout);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = waitForCompletion(aTimeout);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_WAITFORCOMPLETION_RETURN(this, hrc, 0 /*normal*/, aTimeout);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_WAITFORCOMPLETION_RETURN(this, hrc, 1 /*hrc exception*/, aTimeout);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_WAITFORCOMPLETION_RETURN(this, hrc, 9 /*unhandled exception*/, aTimeout);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Progress::waitForCompletion", hrc));
    return hrc;
}

STDMETHODIMP ProgressWrap::WaitForOperationCompletion(ULONG aOperation,
                                                      LONG aTimeout)
{
    LogRelFlow(("{%p} %s:enter aOperation=%RU32 aTimeout=%RI32\n", this, "Progress::waitForOperationCompletion", aOperation, aTimeout));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_WAITFOROPERATIONCOMPLETION_ENTER(this, aOperation, aTimeout);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = waitForOperationCompletion(aOperation,
                                             aTimeout);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_WAITFOROPERATIONCOMPLETION_RETURN(this, hrc, 0 /*normal*/, aOperation, aTimeout);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_WAITFOROPERATIONCOMPLETION_RETURN(this, hrc, 1 /*hrc exception*/, aOperation, aTimeout);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_WAITFOROPERATIONCOMPLETION_RETURN(this, hrc, 9 /*unhandled exception*/, aOperation, aTimeout);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Progress::waitForOperationCompletion", hrc));
    return hrc;
}

STDMETHODIMP ProgressWrap::Cancel()
{
    LogRelFlow(("{%p} %s:enter\n", this, "Progress::cancel"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_CANCEL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = cancel();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_CANCEL_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_CANCEL_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_CANCEL_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Progress::cancel", hrc));
    return hrc;
}

STDMETHODIMP ProgressWrap::InternalAndReservedMethod1IProgress()
{
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::InternalAndReservedMethod2IProgress()
{
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::InternalAndReservedMethod3IProgress()
{
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::InternalAndReservedMethod4IProgress()
{
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::InternalAndReservedMethod5IProgress()
{
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::InternalAndReservedMethod6IProgress()
{
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::InternalAndReservedMethod7IProgress()
{
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::InternalAndReservedMethod8IProgress()
{
    return E_NOTIMPL;
}

//
// IInternalProgressControl methods
//

STDMETHODIMP ProgressWrap::SetCurrentOperationProgress(ULONG aPercent)
{
    LogRelFlow(("{%p} %s:enter aPercent=%RU32\n", this, "Progress::setCurrentOperationProgress", aPercent));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_SETCURRENTOPERATIONPROGRESS_ENTER(this, aPercent);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setCurrentOperationProgress(aPercent);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_SETCURRENTOPERATIONPROGRESS_RETURN(this, hrc, 0 /*normal*/, aPercent);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_SETCURRENTOPERATIONPROGRESS_RETURN(this, hrc, 1 /*hrc exception*/, aPercent);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_SETCURRENTOPERATIONPROGRESS_RETURN(this, hrc, 9 /*unhandled exception*/, aPercent);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Progress::setCurrentOperationProgress", hrc));
    return hrc;
}

STDMETHODIMP ProgressWrap::WaitForOtherProgressCompletion(IProgress *aProgressOther,
                                                          ULONG aTimeoutMS)
{
    LogRelFlow(("{%p} %s:enter aProgressOther=%p aTimeoutMS=%RU32\n", this, "Progress::waitForOtherProgressCompletion", aProgressOther, aTimeoutMS));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<IProgress> TmpProgressOther(aProgressOther);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_WAITFOROTHERPROGRESSCOMPLETION_ENTER(this, (void *)TmpProgressOther.ptr(), aTimeoutMS);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = waitForOtherProgressCompletion(TmpProgressOther.ptr(),
                                                 aTimeoutMS);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_WAITFOROTHERPROGRESSCOMPLETION_RETURN(this, hrc, 0 /*normal*/, (void *)TmpProgressOther.ptr(), aTimeoutMS);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_WAITFOROTHERPROGRESSCOMPLETION_RETURN(this, hrc, 1 /*hrc exception*/, 0, aTimeoutMS);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_WAITFOROTHERPROGRESSCOMPLETION_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aTimeoutMS);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Progress::waitForOtherProgressCompletion", hrc));
    return hrc;
}

STDMETHODIMP ProgressWrap::SetNextOperation(IN_BSTR aNextOperationDescription,
                                            ULONG aNextOperationsWeight)
{
    LogRelFlow(("{%p} %s:enter aNextOperationDescription=%ls aNextOperationsWeight=%RU32\n", this, "Progress::setNextOperation", aNextOperationDescription, aNextOperationsWeight));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpNextOperationDescription(aNextOperationDescription);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_SETNEXTOPERATION_ENTER(this, TmpNextOperationDescription.str().c_str(), aNextOperationsWeight);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setNextOperation(TmpNextOperationDescription.str(),
                                   aNextOperationsWeight);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_SETNEXTOPERATION_RETURN(this, hrc, 0 /*normal*/, TmpNextOperationDescription.str().c_str(), aNextOperationsWeight);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_SETNEXTOPERATION_RETURN(this, hrc, 1 /*hrc exception*/, 0, aNextOperationsWeight);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_SETNEXTOPERATION_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aNextOperationsWeight);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Progress::setNextOperation", hrc));
    return hrc;
}

STDMETHODIMP ProgressWrap::NotifyPointOfNoReturn()
{
    LogRelFlow(("{%p} %s:enter\n", this, "Progress::notifyPointOfNoReturn"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_NOTIFYPOINTOFNORETURN_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = notifyPointOfNoReturn();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_NOTIFYPOINTOFNORETURN_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_NOTIFYPOINTOFNORETURN_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_NOTIFYPOINTOFNORETURN_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Progress::notifyPointOfNoReturn", hrc));
    return hrc;
}

STDMETHODIMP ProgressWrap::NotifyComplete(LONG aResultCode,
                                          IVirtualBoxErrorInfo *aErrorInfo)
{
    LogRelFlow(("{%p} %s:enter aResultCode=%RI32 aErrorInfo=%p\n", this, "Progress::notifyComplete", aResultCode, aErrorInfo));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        ComTypeInConverter<IVirtualBoxErrorInfo> TmpErrorInfo(aErrorInfo);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_NOTIFYCOMPLETE_ENTER(this, aResultCode, (void *)TmpErrorInfo.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = notifyComplete(aResultCode,
                                 TmpErrorInfo.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_NOTIFYCOMPLETE_RETURN(this, hrc, 0 /*normal*/, aResultCode, (void *)TmpErrorInfo.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_NOTIFYCOMPLETE_RETURN(this, hrc, 1 /*hrc exception*/, aResultCode, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROGRESS_NOTIFYCOMPLETE_RETURN(this, hrc, 9 /*unhandled exception*/, aResultCode, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Progress::notifyComplete", hrc));
    return hrc;
}

STDMETHODIMP ProgressWrap::InternalAndReservedMethod1IInternalProgressControl()
{
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::InternalAndReservedMethod2IInternalProgressControl()
{
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::InternalAndReservedMethod3IInternalProgressControl()
{
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::InternalAndReservedMethod4IInternalProgressControl()
{
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::InternalAndReservedMethod5IInternalProgressControl()
{
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::InternalAndReservedMethod6IInternalProgressControl()
{
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::InternalAndReservedMethod7IInternalProgressControl()
{
    return E_NOTIMPL;
}

STDMETHODIMP ProgressWrap::InternalAndReservedMethod8IInternalProgressControl()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(ProgressWrap)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(ProgressWrap, IProgress, IInternalProgressControl)
#endif // VBOX_WITH_XPCOM

