// ##### ENDFILE "RangedIntegerFormValueWrap.h"


// ##### BEGINFILE "StringFormValueWrap.h"
/** @file
 * VirtualBox API class wrapper header for IStringFormValue.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#ifndef StringFormValueWrap_H_
#define StringFormValueWrap_H_
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif

#include "VirtualBoxBase.h"
#include "Wrapper.h"

class ATL_NO_VTABLE StringFormValueWrap
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IStringFormValue)
{
    Q_OBJECT

public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(StringFormValueWrap, IStringFormValue)
    DECLARE_NOT_AGGREGATABLE(StringFormValueWrap)
    DECLARE_PROTECT_FINAL_CONSTRUCT()

    BEGIN_COM_MAP(StringFormValueWrap)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IStringFormValue)
        COM_INTERFACE_ENTRY(IFormValue)
        COM_INTERFACE_ENTRY2(IDispatch, IStringFormValue)
        VBOX_TWEAK_INTERFACE_ENTRY(IStringFormValue)
    END_COM_MAP()

    DECLARE_EMPTY_CTOR_DTOR(StringFormValueWrap)

    /** @name Public IFormValue properties
     * @{ */
    STDMETHOD(COMGETTER(Type))(FormValueType_T *aType);
    STDMETHOD(COMGETTER(Generation))(LONG *aGeneration);
    STDMETHOD(COMGETTER(Enabled))(BOOL *aEnabled);
    STDMETHOD(COMGETTER(Visible))(BOOL *aVisible);
    STDMETHOD(COMGETTER(Label))(BSTR *aLabel);
    STDMETHOD(COMGETTER(Description))(BSTR *aDescription);
    STDMETHOD(COMGETTER(Help))(BSTR *aHelp);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute1IFormValue))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute2IFormValue))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute3IFormValue))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute4IFormValue))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute5IFormValue))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute6IFormValue))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute7IFormValue))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute8IFormValue))(ULONG *aReserved);
    /** @} */

    /** @name Public IStringFormValue properties
     * @{ */
    STDMETHOD(COMGETTER(Multiline))(BOOL *aMultiline);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute1IStringFormValue))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute2IStringFormValue))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute3IStringFormValue))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute4IStringFormValue))(ULONG *aReserved);
    /** @} */

    /** @name Public IFormValue methods
     * @{ */
    STDMETHOD(InternalAndReservedMethod1IFormValue)();
    STDMETHOD(InternalAndReservedMethod2IFormValue)();
    STDMETHOD(InternalAndReservedMethod3IFormValue)();
    STDMETHOD(InternalAndReservedMethod4IFormValue)();
    /** @} */

    /** @name Public IStringFormValue methods
     * @{ */
    STDMETHOD(GetString)(BSTR *aText);
    STDMETHOD(SetString)(IN_BSTR aText,
                         IProgress **aProgress);
    STDMETHOD(InternalAndReservedMethod1IStringFormValue)();
    STDMETHOD(InternalAndReservedMethod2IStringFormValue)();
    STDMETHOD(InternalAndReservedMethod3IStringFormValue)();
    STDMETHOD(InternalAndReservedMethod4IStringFormValue)();
    /** @} */

private:
    /** @name Wrapped IFormValue properties
     * @{ */
    virtual HRESULT getType(FormValueType_T *aType) = 0;
    virtual HRESULT getGeneration(LONG *aGeneration) = 0;
    virtual HRESULT getEnabled(BOOL *aEnabled) = 0;
    virtual HRESULT getVisible(BOOL *aVisible) = 0;
    virtual HRESULT getLabel(com::Utf8Str &aLabel) = 0;
    virtual HRESULT getDescription(com::Utf8Str &aDescription) = 0;
    virtual HRESULT getHelp(com::Utf8Str &aHelp) = 0;
    /** @} */

    /** @name Wrapped IStringFormValue properties
     * @{ */
    virtual HRESULT getMultiline(BOOL *aMultiline) = 0;
    /** @} */

    /** @name Wrapped IFormValue methods
     * @{ */
    /** @} */

    /** @name Wrapped IStringFormValue methods
     * @{ */
    virtual HRESULT getString(com::Utf8Str &aText) = 0;
    virtual HRESULT setString(const com::Utf8Str &aText,
                              ComPtr<IProgress> &aProgress) = 0;
    /** @} */

private:
    DECLARE_CLS_COPY_CTOR_ASSIGN_NOOP(StringFormValueWrap); /* Shuts up MSC warning C4625. */

};

#endif // !StringFormValueWrap_H_

