// ##### ENDFILE "ChoiceFormValueWrap.cpp"


// ##### BEGINFILE "VirtualSystemDescriptionFormWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IVirtualSystemDescriptionForm.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_VIRTUALSYSTEMDESCRIPTIONFORM

#include "VirtualSystemDescriptionFormWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(VirtualSystemDescriptionFormWrap)

//
// IForm properties
//

STDMETHODIMP VirtualSystemDescriptionFormWrap::COMGETTER(Values)(ComSafeArrayOut(IFormValue *, aValues))
{
    LogRelFlow(("{%p} %s: enter aValues=%p\n", this, "VirtualSystemDescriptionForm::getValues", aValues));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValues);
        ArrayComTypeOutConverter<IFormValue> TmpValues(ComSafeArrayOutArg(aValues));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTIONFORM_GET_VALUES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getValues(TmpValues.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTIONFORM_GET_VALUES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpValues.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTIONFORM_GET_VALUES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTIONFORM_GET_VALUES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aValues=%zu hrc=%Rhrc\n", this, "VirtualSystemDescriptionForm::getValues", ComSafeArraySize(*aValues), hrc));
    return hrc;
}

STDMETHODIMP VirtualSystemDescriptionFormWrap::COMGETTER(InternalAndReservedAttribute1IForm)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VirtualSystemDescriptionFormWrap::COMGETTER(InternalAndReservedAttribute2IForm)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VirtualSystemDescriptionFormWrap::COMGETTER(InternalAndReservedAttribute3IForm)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VirtualSystemDescriptionFormWrap::COMGETTER(InternalAndReservedAttribute4IForm)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

//
// IVirtualSystemDescriptionForm properties
//

STDMETHODIMP VirtualSystemDescriptionFormWrap::COMGETTER(InternalAndReservedAttribute1IVirtualSystemDescriptionForm)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VirtualSystemDescriptionFormWrap::COMGETTER(InternalAndReservedAttribute2IVirtualSystemDescriptionForm)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VirtualSystemDescriptionFormWrap::COMGETTER(InternalAndReservedAttribute3IVirtualSystemDescriptionForm)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VirtualSystemDescriptionFormWrap::COMGETTER(InternalAndReservedAttribute4IVirtualSystemDescriptionForm)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IForm methods
//

STDMETHODIMP VirtualSystemDescriptionFormWrap::InternalAndReservedMethod1IForm()
{
    return E_NOTIMPL;
}

STDMETHODIMP VirtualSystemDescriptionFormWrap::InternalAndReservedMethod2IForm()
{
    return E_NOTIMPL;
}

STDMETHODIMP VirtualSystemDescriptionFormWrap::InternalAndReservedMethod3IForm()
{
    return E_NOTIMPL;
}

STDMETHODIMP VirtualSystemDescriptionFormWrap::InternalAndReservedMethod4IForm()
{
    return E_NOTIMPL;
}

//
// IVirtualSystemDescriptionForm methods
//

STDMETHODIMP VirtualSystemDescriptionFormWrap::GetVirtualSystemDescription(IVirtualSystemDescription **aDescription)
{
    LogRelFlow(("{%p} %s:enter aDescription=%p\n", this, "VirtualSystemDescriptionForm::getVirtualSystemDescription", aDescription));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDescription);


        ComTypeOutConverter<IVirtualSystemDescription> TmpDescription(aDescription);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTIONFORM_GETVIRTUALSYSTEMDESCRIPTION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVirtualSystemDescription(TmpDescription.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTIONFORM_GETVIRTUALSYSTEMDESCRIPTION_RETURN(this, hrc, 0 /*normal*/, (void *)TmpDescription.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTIONFORM_GETVIRTUALSYSTEMDESCRIPTION_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTIONFORM_GETVIRTUALSYSTEMDESCRIPTION_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aDescription=%p hrc=%Rhrc\n", this, "VirtualSystemDescriptionForm::getVirtualSystemDescription", *aDescription, hrc));
    return hrc;
}

STDMETHODIMP VirtualSystemDescriptionFormWrap::InternalAndReservedMethod1IVirtualSystemDescriptionForm()
{
    return E_NOTIMPL;
}

STDMETHODIMP VirtualSystemDescriptionFormWrap::InternalAndReservedMethod2IVirtualSystemDescriptionForm()
{
    return E_NOTIMPL;
}

STDMETHODIMP VirtualSystemDescriptionFormWrap::InternalAndReservedMethod3IVirtualSystemDescriptionForm()
{
    return E_NOTIMPL;
}

STDMETHODIMP VirtualSystemDescriptionFormWrap::InternalAndReservedMethod4IVirtualSystemDescriptionForm()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(VirtualSystemDescriptionFormWrap)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(VirtualSystemDescriptionFormWrap, IVirtualSystemDescriptionForm, IForm)
#endif // VBOX_WITH_XPCOM

