// ##### ENDFILE "VFSExplorerWrap.h"


// ##### BEGINFILE "CertificateWrap.h"
/** @file
 * VirtualBox API class wrapper header for ICertificate.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#ifndef CertificateWrap_H_
#define CertificateWrap_H_
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif

#include "VirtualBoxBase.h"
#include "Wrapper.h"

class ATL_NO_VTABLE CertificateWrap
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(ICertificate)
{
    Q_OBJECT

public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(CertificateWrap, ICertificate)
    DECLARE_NOT_AGGREGATABLE(CertificateWrap)
    DECLARE_PROTECT_FINAL_CONSTRUCT()

    BEGIN_COM_MAP(CertificateWrap)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(ICertificate)
        COM_INTERFACE_ENTRY2(IDispatch, ICertificate)
        VBOX_TWEAK_INTERFACE_ENTRY(ICertificate)
    END_COM_MAP()

    DECLARE_EMPTY_CTOR_DTOR(CertificateWrap)

    /** @name Public ICertificate properties
     * @{ */
    STDMETHOD(COMGETTER(VersionNumber))(CertificateVersion_T *aVersionNumber);
    STDMETHOD(COMGETTER(SerialNumber))(BSTR *aSerialNumber);
    STDMETHOD(COMGETTER(SignatureAlgorithmOID))(BSTR *aSignatureAlgorithmOID);
    STDMETHOD(COMGETTER(SignatureAlgorithmName))(BSTR *aSignatureAlgorithmName);
    STDMETHOD(COMGETTER(IssuerName))(ComSafeArrayOut(BSTR, aIssuerName));
    STDMETHOD(COMGETTER(SubjectName))(ComSafeArrayOut(BSTR, aSubjectName));
    STDMETHOD(COMGETTER(FriendlyName))(BSTR *aFriendlyName);
    STDMETHOD(COMGETTER(ValidityPeriodNotBefore))(BSTR *aValidityPeriodNotBefore);
    STDMETHOD(COMGETTER(ValidityPeriodNotAfter))(BSTR *aValidityPeriodNotAfter);
    STDMETHOD(COMGETTER(PublicKeyAlgorithmOID))(BSTR *aPublicKeyAlgorithmOID);
    STDMETHOD(COMGETTER(PublicKeyAlgorithm))(BSTR *aPublicKeyAlgorithm);
    STDMETHOD(COMGETTER(SubjectPublicKey))(ComSafeArrayOut(BYTE, aSubjectPublicKey));
    STDMETHOD(COMGETTER(IssuerUniqueIdentifier))(BSTR *aIssuerUniqueIdentifier);
    STDMETHOD(COMGETTER(SubjectUniqueIdentifier))(BSTR *aSubjectUniqueIdentifier);
    STDMETHOD(COMGETTER(CertificateAuthority))(BOOL *aCertificateAuthority);
    STDMETHOD(COMGETTER(KeyUsage))(ULONG *aKeyUsage);
    STDMETHOD(COMGETTER(ExtendedKeyUsage))(ComSafeArrayOut(BSTR, aExtendedKeyUsage));
    STDMETHOD(COMGETTER(RawCertData))(ComSafeArrayOut(BYTE, aRawCertData));
    STDMETHOD(COMGETTER(SelfSigned))(BOOL *aSelfSigned);
    STDMETHOD(COMGETTER(Trusted))(BOOL *aTrusted);
    STDMETHOD(COMGETTER(Expired))(BOOL *aExpired);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute1ICertificate))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute2ICertificate))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute3ICertificate))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute4ICertificate))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute5ICertificate))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute6ICertificate))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute7ICertificate))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute8ICertificate))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute9ICertificate))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute10ICertificate))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute11ICertificate))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute12ICertificate))(ULONG *aReserved);
    /** @} */

    /** @name Public ICertificate methods
     * @{ */
    STDMETHOD(IsCurrentlyExpired)(BOOL *aResult);
    STDMETHOD(QueryInfo)(LONG aWhat,
                         BSTR *aResult);
    STDMETHOD(InternalAndReservedMethod1ICertificate)();
    STDMETHOD(InternalAndReservedMethod2ICertificate)();
    /** @} */

private:
    /** @name Wrapped ICertificate properties
     * @{ */
    virtual HRESULT getVersionNumber(CertificateVersion_T *aVersionNumber) = 0;
    virtual HRESULT getSerialNumber(com::Utf8Str &aSerialNumber) = 0;
    virtual HRESULT getSignatureAlgorithmOID(com::Utf8Str &aSignatureAlgorithmOID) = 0;
    virtual HRESULT getSignatureAlgorithmName(com::Utf8Str &aSignatureAlgorithmName) = 0;
    virtual HRESULT getIssuerName(std::vector<com::Utf8Str> &aIssuerName) = 0;
    virtual HRESULT getSubjectName(std::vector<com::Utf8Str> &aSubjectName) = 0;
    virtual HRESULT getFriendlyName(com::Utf8Str &aFriendlyName) = 0;
    virtual HRESULT getValidityPeriodNotBefore(com::Utf8Str &aValidityPeriodNotBefore) = 0;
    virtual HRESULT getValidityPeriodNotAfter(com::Utf8Str &aValidityPeriodNotAfter) = 0;
    virtual HRESULT getPublicKeyAlgorithmOID(com::Utf8Str &aPublicKeyAlgorithmOID) = 0;
    virtual HRESULT getPublicKeyAlgorithm(com::Utf8Str &aPublicKeyAlgorithm) = 0;
    virtual HRESULT getSubjectPublicKey(std::vector<BYTE> &aSubjectPublicKey) = 0;
    virtual HRESULT getIssuerUniqueIdentifier(com::Utf8Str &aIssuerUniqueIdentifier) = 0;
    virtual HRESULT getSubjectUniqueIdentifier(com::Utf8Str &aSubjectUniqueIdentifier) = 0;
    virtual HRESULT getCertificateAuthority(BOOL *aCertificateAuthority) = 0;
    virtual HRESULT getKeyUsage(ULONG *aKeyUsage) = 0;
    virtual HRESULT getExtendedKeyUsage(std::vector<com::Utf8Str> &aExtendedKeyUsage) = 0;
    virtual HRESULT getRawCertData(std::vector<BYTE> &aRawCertData) = 0;
    virtual HRESULT getSelfSigned(BOOL *aSelfSigned) = 0;
    virtual HRESULT getTrusted(BOOL *aTrusted) = 0;
    virtual HRESULT getExpired(BOOL *aExpired) = 0;
    /** @} */

    /** @name Wrapped ICertificate methods
     * @{ */
    virtual HRESULT isCurrentlyExpired(BOOL *aResult) = 0;
    virtual HRESULT queryInfo(LONG aWhat,
                              com::Utf8Str &aResult) = 0;
    /** @} */

private:
    DECLARE_CLS_COPY_CTOR_ASSIGN_NOOP(CertificateWrap); /* Shuts up MSC warning C4625. */

};

#endif // !CertificateWrap_H_

