// ##### ENDFILE "CloudNetworkGatewayInfoWrap.cpp"


// ##### BEGINFILE "CloudClientWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for ICloudClient.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_CLOUDCLIENT

#include "CloudClientWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(CloudClientWrap)

//
// ICloudClient properties
//

STDMETHODIMP CloudClientWrap::COMGETTER(InternalAndReservedAttribute1ICloudClient)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudClientWrap::COMGETTER(InternalAndReservedAttribute2ICloudClient)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudClientWrap::COMGETTER(InternalAndReservedAttribute3ICloudClient)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudClientWrap::COMGETTER(InternalAndReservedAttribute4ICloudClient)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudClientWrap::COMGETTER(InternalAndReservedAttribute5ICloudClient)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudClientWrap::COMGETTER(InternalAndReservedAttribute6ICloudClient)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudClientWrap::COMGETTER(InternalAndReservedAttribute7ICloudClient)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudClientWrap::COMGETTER(InternalAndReservedAttribute8ICloudClient)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// ICloudClient methods
//

STDMETHODIMP CloudClientWrap::GetExportDescriptionForm(IVirtualSystemDescription *aDescription,
                                                       IVirtualSystemDescriptionForm **aForm,
                                                       IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aDescription=%p aForm=%p aProgress=%p\n", this, "CloudClient::getExportDescriptionForm", aDescription, aForm, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aForm);
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeInConverter<IVirtualSystemDescription> TmpDescription(aDescription);
        ComTypeOutConverter<IVirtualSystemDescriptionForm> TmpForm(aForm);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_GETEXPORTDESCRIPTIONFORM_ENTER(this, (void *)TmpDescription.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getExportDescriptionForm(TmpDescription.ptr(),
                                           TmpForm.ptr(),
                                           TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_GETEXPORTDESCRIPTIONFORM_RETURN(this, hrc, 0 /*normal*/, (void *)TmpDescription.ptr(), (void *)TmpForm.ptr(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_GETEXPORTDESCRIPTIONFORM_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_GETEXPORTDESCRIPTIONFORM_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aForm=%p aProgress=%p hrc=%Rhrc\n", this, "CloudClient::getExportDescriptionForm", *aForm, *aProgress, hrc));
    return hrc;
}

STDMETHODIMP CloudClientWrap::ExportVM(IVirtualSystemDescription *aDescription,
                                       IProgress *aProgress)
{
    LogRelFlow(("{%p} %s:enter aDescription=%p aProgress=%p\n", this, "CloudClient::exportVM", aDescription, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<IVirtualSystemDescription> TmpDescription(aDescription);
        ComTypeInConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_EXPORTVM_ENTER(this, (void *)TmpDescription.ptr(), (void *)TmpProgress.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = exportVM(TmpDescription.ptr(),
                           TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_EXPORTVM_RETURN(this, hrc, 0 /*normal*/, (void *)TmpDescription.ptr(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_EXPORTVM_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_EXPORTVM_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "CloudClient::exportVM", hrc));
    return hrc;
}

STDMETHODIMP CloudClientWrap::GetLaunchDescriptionForm(IVirtualSystemDescription *aDescription,
                                                       IVirtualSystemDescriptionForm **aForm,
                                                       IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aDescription=%p aForm=%p aProgress=%p\n", this, "CloudClient::getLaunchDescriptionForm", aDescription, aForm, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aForm);
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeInConverter<IVirtualSystemDescription> TmpDescription(aDescription);
        ComTypeOutConverter<IVirtualSystemDescriptionForm> TmpForm(aForm);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_GETLAUNCHDESCRIPTIONFORM_ENTER(this, (void *)TmpDescription.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLaunchDescriptionForm(TmpDescription.ptr(),
                                           TmpForm.ptr(),
                                           TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_GETLAUNCHDESCRIPTIONFORM_RETURN(this, hrc, 0 /*normal*/, (void *)TmpDescription.ptr(), (void *)TmpForm.ptr(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_GETLAUNCHDESCRIPTIONFORM_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_GETLAUNCHDESCRIPTIONFORM_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aForm=%p aProgress=%p hrc=%Rhrc\n", this, "CloudClient::getLaunchDescriptionForm", *aForm, *aProgress, hrc));
    return hrc;
}

STDMETHODIMP CloudClientWrap::LaunchVM(IVirtualSystemDescription *aDescription,
                                       IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aDescription=%p aProgress=%p\n", this, "CloudClient::launchVM", aDescription, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeInConverter<IVirtualSystemDescription> TmpDescription(aDescription);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_LAUNCHVM_ENTER(this, (void *)TmpDescription.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = launchVM(TmpDescription.ptr(),
                           TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_LAUNCHVM_RETURN(this, hrc, 0 /*normal*/, (void *)TmpDescription.ptr(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_LAUNCHVM_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_LAUNCHVM_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "CloudClient::launchVM", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP CloudClientWrap::GetImportDescriptionForm(IVirtualSystemDescription *aDescription,
                                                       IVirtualSystemDescriptionForm **aForm,
                                                       IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aDescription=%p aForm=%p aProgress=%p\n", this, "CloudClient::getImportDescriptionForm", aDescription, aForm, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aForm);
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeInConverter<IVirtualSystemDescription> TmpDescription(aDescription);
        ComTypeOutConverter<IVirtualSystemDescriptionForm> TmpForm(aForm);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_GETIMPORTDESCRIPTIONFORM_ENTER(this, (void *)TmpDescription.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getImportDescriptionForm(TmpDescription.ptr(),
                                           TmpForm.ptr(),
                                           TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_GETIMPORTDESCRIPTIONFORM_RETURN(this, hrc, 0 /*normal*/, (void *)TmpDescription.ptr(), (void *)TmpForm.ptr(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_GETIMPORTDESCRIPTIONFORM_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_GETIMPORTDESCRIPTIONFORM_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aForm=%p aProgress=%p hrc=%Rhrc\n", this, "CloudClient::getImportDescriptionForm", *aForm, *aProgress, hrc));
    return hrc;
}

STDMETHODIMP CloudClientWrap::ImportInstance(IVirtualSystemDescription *aDescription,
                                             IProgress *aProgress)
{
    LogRelFlow(("{%p} %s:enter aDescription=%p aProgress=%p\n", this, "CloudClient::importInstance", aDescription, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<IVirtualSystemDescription> TmpDescription(aDescription);
        ComTypeInConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_IMPORTINSTANCE_ENTER(this, (void *)TmpDescription.ptr(), (void *)TmpProgress.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = importInstance(TmpDescription.ptr(),
                                 TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_IMPORTINSTANCE_RETURN(this, hrc, 0 /*normal*/, (void *)TmpDescription.ptr(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_IMPORTINSTANCE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_IMPORTINSTANCE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "CloudClient::importInstance", hrc));
    return hrc;
}

STDMETHODIMP CloudClientWrap::ListInstances(ComSafeArrayIn(CloudMachineState_T, aMachineState),
                                            IStringArray **aReturnNames,
                                            IStringArray **aReturnIds,
                                            IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aMachineState=%zu aReturnNames=%p aReturnIds=%p aProgress=%p\n", this, "CloudClient::listInstances", aMachineState, aReturnNames, aReturnIds, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aReturnNames);
        CheckComArgOutPointerValidThrow(aReturnIds);
        CheckComArgOutPointerValidThrow(aProgress);


        ArrayInConverter<CloudMachineState_T> TmpMachineState(ComSafeArrayInArg(aMachineState));
        ComTypeOutConverter<IStringArray> TmpReturnNames(aReturnNames);
        ComTypeOutConverter<IStringArray> TmpReturnIds(aReturnIds);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_LISTINSTANCES_ENTER(this, (uint32_t)TmpMachineState.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = listInstances(TmpMachineState.array(),
                                TmpReturnNames.ptr(),
                                TmpReturnIds.ptr(),
                                TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_LISTINSTANCES_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpMachineState.array().size(), NULL /*for now*/, (void *)TmpReturnNames.ptr(), (void *)TmpReturnIds.ptr(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_LISTINSTANCES_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_LISTINSTANCES_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aReturnNames=%p *aReturnIds=%p aProgress=%p hrc=%Rhrc\n", this, "CloudClient::listInstances", *aReturnNames, *aReturnIds, *aProgress, hrc));
    return hrc;
}

STDMETHODIMP CloudClientWrap::ListImages(ComSafeArrayIn(CloudImageState_T, aImageState),
                                         IStringArray **aReturnNames,
                                         IStringArray **aReturnIds,
                                         IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aImageState=%zu aReturnNames=%p aReturnIds=%p aProgress=%p\n", this, "CloudClient::listImages", aImageState, aReturnNames, aReturnIds, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aReturnNames);
        CheckComArgOutPointerValidThrow(aReturnIds);
        CheckComArgOutPointerValidThrow(aProgress);


        ArrayInConverter<CloudImageState_T> TmpImageState(ComSafeArrayInArg(aImageState));
        ComTypeOutConverter<IStringArray> TmpReturnNames(aReturnNames);
        ComTypeOutConverter<IStringArray> TmpReturnIds(aReturnIds);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_LISTIMAGES_ENTER(this, (uint32_t)TmpImageState.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = listImages(TmpImageState.array(),
                             TmpReturnNames.ptr(),
                             TmpReturnIds.ptr(),
                             TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_LISTIMAGES_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpImageState.array().size(), NULL /*for now*/, (void *)TmpReturnNames.ptr(), (void *)TmpReturnIds.ptr(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_LISTIMAGES_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_LISTIMAGES_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aReturnNames=%p *aReturnIds=%p aProgress=%p hrc=%Rhrc\n", this, "CloudClient::listImages", *aReturnNames, *aReturnIds, *aProgress, hrc));
    return hrc;
}

STDMETHODIMP CloudClientWrap::GetInstanceInfo(IN_BSTR aUid,
                                              IVirtualSystemDescription *aDescription,
                                              IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aUid=%ls aDescription=%p aProgress=%p\n", this, "CloudClient::getInstanceInfo", aUid, aDescription, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpUid(aUid);
        ComTypeInConverter<IVirtualSystemDescription> TmpDescription(aDescription);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_GETINSTANCEINFO_ENTER(this, TmpUid.str().c_str(), (void *)TmpDescription.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getInstanceInfo(TmpUid.str(),
                                  TmpDescription.ptr(),
                                  TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_GETINSTANCEINFO_RETURN(this, hrc, 0 /*normal*/, TmpUid.str().c_str(), (void *)TmpDescription.ptr(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_GETINSTANCEINFO_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_GETINSTANCEINFO_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "CloudClient::getInstanceInfo", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP CloudClientWrap::StartInstance(IN_BSTR aUid,
                                            IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aUid=%ls aProgress=%p\n", this, "CloudClient::startInstance", aUid, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpUid(aUid);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_STARTINSTANCE_ENTER(this, TmpUid.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = startInstance(TmpUid.str(),
                                TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_STARTINSTANCE_RETURN(this, hrc, 0 /*normal*/, TmpUid.str().c_str(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_STARTINSTANCE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_STARTINSTANCE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "CloudClient::startInstance", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP CloudClientWrap::PauseInstance(IN_BSTR aUid,
                                            IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aUid=%ls aProgress=%p\n", this, "CloudClient::pauseInstance", aUid, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpUid(aUid);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_PAUSEINSTANCE_ENTER(this, TmpUid.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = pauseInstance(TmpUid.str(),
                                TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_PAUSEINSTANCE_RETURN(this, hrc, 0 /*normal*/, TmpUid.str().c_str(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_PAUSEINSTANCE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_PAUSEINSTANCE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "CloudClient::pauseInstance", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP CloudClientWrap::TerminateInstance(IN_BSTR aUid,
                                                IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aUid=%ls aProgress=%p\n", this, "CloudClient::terminateInstance", aUid, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpUid(aUid);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_TERMINATEINSTANCE_ENTER(this, TmpUid.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = terminateInstance(TmpUid.str(),
                                    TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_TERMINATEINSTANCE_RETURN(this, hrc, 0 /*normal*/, TmpUid.str().c_str(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_TERMINATEINSTANCE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_TERMINATEINSTANCE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "CloudClient::terminateInstance", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP CloudClientWrap::CreateImage(ComSafeArrayIn(IN_BSTR, aParameters),
                                          IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aParameters=%zu aProgress=%p\n", this, "CloudClient::createImage", aParameters, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ArrayBSTRInConverter TmpParameters(ComSafeArrayInArg(aParameters));
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_CREATEIMAGE_ENTER(this, (uint32_t)TmpParameters.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = createImage(TmpParameters.array(),
                              TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_CREATEIMAGE_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpParameters.array().size(), NULL /*for now*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_CREATEIMAGE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_CREATEIMAGE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "CloudClient::createImage", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP CloudClientWrap::ExportImage(IMedium *aImage,
                                          ComSafeArrayIn(IN_BSTR, aParameters),
                                          IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aImage=%p aParameters=%zu aProgress=%p\n", this, "CloudClient::exportImage", aImage, aParameters, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeInConverter<IMedium> TmpImage(aImage);
        ArrayBSTRInConverter TmpParameters(ComSafeArrayInArg(aParameters));
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_EXPORTIMAGE_ENTER(this, (void *)TmpImage.ptr(), (uint32_t)TmpParameters.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = exportImage(TmpImage.ptr(),
                              TmpParameters.array(),
                              TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_EXPORTIMAGE_RETURN(this, hrc, 0 /*normal*/, (void *)TmpImage.ptr(), (uint32_t)TmpParameters.array().size(), NULL /*for now*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_EXPORTIMAGE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_EXPORTIMAGE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "CloudClient::exportImage", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP CloudClientWrap::ImportImage(IN_BSTR aUid,
                                          ComSafeArrayIn(IN_BSTR, aParameters),
                                          IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aUid=%ls aParameters=%zu aProgress=%p\n", this, "CloudClient::importImage", aUid, aParameters, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpUid(aUid);
        ArrayBSTRInConverter TmpParameters(ComSafeArrayInArg(aParameters));
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_IMPORTIMAGE_ENTER(this, TmpUid.str().c_str(), (uint32_t)TmpParameters.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = importImage(TmpUid.str(),
                              TmpParameters.array(),
                              TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_IMPORTIMAGE_RETURN(this, hrc, 0 /*normal*/, TmpUid.str().c_str(), (uint32_t)TmpParameters.array().size(), NULL /*for now*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_IMPORTIMAGE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_IMPORTIMAGE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "CloudClient::importImage", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP CloudClientWrap::DeleteImage(IN_BSTR aUid,
                                          IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aUid=%ls aProgress=%p\n", this, "CloudClient::deleteImage", aUid, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpUid(aUid);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_DELETEIMAGE_ENTER(this, TmpUid.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = deleteImage(TmpUid.str(),
                              TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_DELETEIMAGE_RETURN(this, hrc, 0 /*normal*/, TmpUid.str().c_str(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_DELETEIMAGE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_DELETEIMAGE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "CloudClient::deleteImage", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP CloudClientWrap::GetImageInfo(IN_BSTR aUid,
                                           IStringArray **aInfoArray,
                                           IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aUid=%ls aInfoArray=%p aProgress=%p\n", this, "CloudClient::getImageInfo", aUid, aInfoArray, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aInfoArray);
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpUid(aUid);
        ComTypeOutConverter<IStringArray> TmpInfoArray(aInfoArray);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_GETIMAGEINFO_ENTER(this, TmpUid.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getImageInfo(TmpUid.str(),
                               TmpInfoArray.ptr(),
                               TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_GETIMAGEINFO_RETURN(this, hrc, 0 /*normal*/, TmpUid.str().c_str(), (void *)TmpInfoArray.ptr(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_GETIMAGEINFO_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_GETIMAGEINFO_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aInfoArray=%p aProgress=%p hrc=%Rhrc\n", this, "CloudClient::getImageInfo", *aInfoArray, *aProgress, hrc));
    return hrc;
}

STDMETHODIMP CloudClientWrap::StartCloudNetworkGateway(ICloudNetwork *aNetwork,
                                                       IN_BSTR aSshPublicKey,
                                                       ICloudNetworkGatewayInfo **aGatewayInfo,
                                                       IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aNetwork=%p aSshPublicKey=%ls aGatewayInfo=%p aProgress=%p\n", this, "CloudClient::startCloudNetworkGateway", aNetwork, aSshPublicKey, aGatewayInfo, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGatewayInfo);
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeInConverter<ICloudNetwork> TmpNetwork(aNetwork);
        BSTRInConverter TmpSshPublicKey(aSshPublicKey);
        ComTypeOutConverter<ICloudNetworkGatewayInfo> TmpGatewayInfo(aGatewayInfo);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_STARTCLOUDNETWORKGATEWAY_ENTER(this, (void *)TmpNetwork.ptr(), TmpSshPublicKey.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = startCloudNetworkGateway(TmpNetwork.ptr(),
                                           TmpSshPublicKey.str(),
                                           TmpGatewayInfo.ptr(),
                                           TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_STARTCLOUDNETWORKGATEWAY_RETURN(this, hrc, 0 /*normal*/, (void *)TmpNetwork.ptr(), TmpSshPublicKey.str().c_str(), (void *)TmpGatewayInfo.ptr(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_STARTCLOUDNETWORKGATEWAY_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_STARTCLOUDNETWORKGATEWAY_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aGatewayInfo=%p aProgress=%p hrc=%Rhrc\n", this, "CloudClient::startCloudNetworkGateway", *aGatewayInfo, *aProgress, hrc));
    return hrc;
}

STDMETHODIMP CloudClientWrap::SetupCloudNetworkEnvironment(IN_BSTR aTunnelNetworkName,
                                                           IN_BSTR aTunnelNetworkRange,
                                                           IN_BSTR aGatewayOsName,
                                                           IN_BSTR aGatewayOsVersion,
                                                           IN_BSTR aGatewayShape,
                                                           ICloudNetworkEnvironmentInfo **aNetworkEnvironmentInfo,
                                                           IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aTunnelNetworkName=%ls aTunnelNetworkRange=%ls aGatewayOsName=%ls aGatewayOsVersion=%ls aGatewayShape=%ls aNetworkEnvironmentInfo=%p aProgress=%p\n", this, "CloudClient::setupCloudNetworkEnvironment", aTunnelNetworkName, aTunnelNetworkRange, aGatewayOsName, aGatewayOsVersion, aGatewayShape, aNetworkEnvironmentInfo, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNetworkEnvironmentInfo);
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpTunnelNetworkName(aTunnelNetworkName);
        BSTRInConverter TmpTunnelNetworkRange(aTunnelNetworkRange);
        BSTRInConverter TmpGatewayOsName(aGatewayOsName);
        BSTRInConverter TmpGatewayOsVersion(aGatewayOsVersion);
        BSTRInConverter TmpGatewayShape(aGatewayShape);
        ComTypeOutConverter<ICloudNetworkEnvironmentInfo> TmpNetworkEnvironmentInfo(aNetworkEnvironmentInfo);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_SETUPCLOUDNETWORKENVIRONMENT_ENTER(this, TmpTunnelNetworkName.str().c_str(), TmpTunnelNetworkRange.str().c_str(), TmpGatewayOsName.str().c_str(), TmpGatewayOsVersion.str().c_str(), TmpGatewayShape.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setupCloudNetworkEnvironment(TmpTunnelNetworkName.str(),
                                               TmpTunnelNetworkRange.str(),
                                               TmpGatewayOsName.str(),
                                               TmpGatewayOsVersion.str(),
                                               TmpGatewayShape.str(),
                                               TmpNetworkEnvironmentInfo.ptr(),
                                               TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_SETUPCLOUDNETWORKENVIRONMENT_RETURN(this, hrc, 0 /*normal*/, TmpTunnelNetworkName.str().c_str(), TmpTunnelNetworkRange.str().c_str(), TmpGatewayOsName.str().c_str(), TmpGatewayOsVersion.str().c_str(), TmpGatewayShape.str().c_str(), (void *)TmpNetworkEnvironmentInfo.ptr(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_SETUPCLOUDNETWORKENVIRONMENT_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDCLIENT_SETUPCLOUDNETWORKENVIRONMENT_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNetworkEnvironmentInfo=%p aProgress=%p hrc=%Rhrc\n", this, "CloudClient::setupCloudNetworkEnvironment", *aNetworkEnvironmentInfo, *aProgress, hrc));
    return hrc;
}

STDMETHODIMP CloudClientWrap::InternalAndReservedMethod1ICloudClient()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudClientWrap::InternalAndReservedMethod2ICloudClient()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudClientWrap::InternalAndReservedMethod3ICloudClient()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudClientWrap::InternalAndReservedMethod4ICloudClient()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudClientWrap::InternalAndReservedMethod5ICloudClient()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudClientWrap::InternalAndReservedMethod6ICloudClient()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudClientWrap::InternalAndReservedMethod7ICloudClient()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudClientWrap::InternalAndReservedMethod8ICloudClient()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudClientWrap::InternalAndReservedMethod9ICloudClient()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudClientWrap::InternalAndReservedMethod10ICloudClient()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudClientWrap::InternalAndReservedMethod11ICloudClient()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudClientWrap::InternalAndReservedMethod12ICloudClient()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudClientWrap::InternalAndReservedMethod13ICloudClient()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudClientWrap::InternalAndReservedMethod14ICloudClient()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudClientWrap::InternalAndReservedMethod15ICloudClient()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(CloudClientWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(CloudClientWrap, ICloudClient)
#endif // VBOX_WITH_XPCOM

