// ##### ENDFILE "GuestScreenInfoWrap.h"


// ##### BEGINFILE "DisplayWrap.h"
/** @file
 * VirtualBox API class wrapper header for IDisplay.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#ifndef DisplayWrap_H_
#define DisplayWrap_H_
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif

#include "VirtualBoxBase.h"
#include "Wrapper.h"

class ATL_NO_VTABLE DisplayWrap
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IDisplay)
    , VBOX_SCRIPTABLE_IMPL(IEventListener)
{
    Q_OBJECT

public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(DisplayWrap, IDisplay)
    DECLARE_NOT_AGGREGATABLE(DisplayWrap)
    DECLARE_PROTECT_FINAL_CONSTRUCT()

    BEGIN_COM_MAP(DisplayWrap)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IDisplay)
        COM_INTERFACE_ENTRY2(IDispatch, IDisplay)
        COM_INTERFACE_ENTRY(IEventListener)
        VBOX_TWEAK_INTERFACE_ENTRY(IDisplay)
    END_COM_MAP()

    DECLARE_EMPTY_CTOR_DTOR(DisplayWrap)

    /** @name Public IDisplay properties
     * @{ */
    STDMETHOD(COMGETTER(GuestScreenLayout))(ComSafeArrayOut(IGuestScreenInfo *, aGuestScreenLayout));
    STDMETHOD(COMGETTER(InternalAndReservedAttribute1IDisplay))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute2IDisplay))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute3IDisplay))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute4IDisplay))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute5IDisplay))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute6IDisplay))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute7IDisplay))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute8IDisplay))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute9IDisplay))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute10IDisplay))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute11IDisplay))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute12IDisplay))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute13IDisplay))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute14IDisplay))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute15IDisplay))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute16IDisplay))(ULONG *aReserved);
    /** @} */

    /** @name Public IDisplay methods
     * @{ */
    STDMETHOD(GetScreenResolution)(ULONG aScreenId,
                                   ULONG *aWidth,
                                   ULONG *aHeight,
                                   ULONG *aBitsPerPixel,
                                   LONG *aXOrigin,
                                   LONG *aYOrigin,
                                   GuestMonitorStatus_T *aGuestMonitorStatus);
    STDMETHOD(AttachFramebuffer)(ULONG aScreenId,
                                 IFramebuffer *aFramebuffer,
                                 BSTR *aId);
    STDMETHOD(DetachFramebuffer)(ULONG aScreenId,
                                 IN_BSTR aId);
    STDMETHOD(QueryFramebuffer)(ULONG aScreenId,
                                IFramebuffer **aFramebuffer);
    STDMETHOD(SetVideoModeHint)(ULONG aDisplay,
                                BOOL aEnabled,
                                BOOL aChangeOrigin,
                                LONG aOriginX,
                                LONG aOriginY,
                                ULONG aWidth,
                                ULONG aHeight,
                                ULONG aBitsPerPixel,
                                BOOL aNotify);
    STDMETHOD(GetVideoModeHint)(ULONG aDisplay,
                                BOOL *aEnabled,
                                BOOL *aChangeOrigin,
                                LONG *aOriginX,
                                LONG *aOriginY,
                                ULONG *aWidth,
                                ULONG *aHeight,
                                ULONG *aBitsPerPixel);
    STDMETHOD(SetSeamlessMode)(BOOL aEnabled);
    STDMETHOD(TakeScreenShot)(ULONG aScreenId,
                              BYTE *aAddress,
                              ULONG aWidth,
                              ULONG aHeight,
                              BitmapFormat_T aBitmapFormat);
    STDMETHOD(TakeScreenShotToArray)(ULONG aScreenId,
                                     ULONG aWidth,
                                     ULONG aHeight,
                                     BitmapFormat_T aBitmapFormat,
                                     ComSafeArrayOut(BYTE, aScreenData));
    STDMETHOD(DrawToScreen)(ULONG aScreenId,
                            BYTE *aAddress,
                            ULONG aX,
                            ULONG aY,
                            ULONG aWidth,
                            ULONG aHeight);
    STDMETHOD(InvalidateAndUpdate)();
    STDMETHOD(InvalidateAndUpdateScreen)(ULONG aScreenId);
    STDMETHOD(CompleteVHWACommand)(BYTE *aCommand);
    STDMETHOD(ViewportChanged)(ULONG aScreenId,
                               ULONG aX,
                               ULONG aY,
                               ULONG aWidth,
                               ULONG aHeight);
    STDMETHOD(QuerySourceBitmap)(ULONG aScreenId,
                                 IDisplaySourceBitmap **aDisplaySourceBitmap);
    STDMETHOD(NotifyScaleFactorChange)(ULONG aScreenId,
                                       ULONG aU32ScaleFactorWMultiplied,
                                       ULONG aU32ScaleFactorHMultiplied);
    STDMETHOD(NotifyHiDPIOutputPolicyChange)(BOOL aFUnscaledHiDPI);
    STDMETHOD(SetScreenLayout)(ScreenLayoutMode_T aScreenLayoutMode,
                               ComSafeArrayIn(IGuestScreenInfo *, aGuestScreenInfo));
    STDMETHOD(DetachScreens)(ComSafeArrayIn(LONG, aScreenIds));
    STDMETHOD(CreateGuestScreenInfo)(ULONG aDisplay,
                                     GuestMonitorStatus_T aStatus,
                                     BOOL aPrimary,
                                     BOOL aChangeOrigin,
                                     LONG aOriginX,
                                     LONG aOriginY,
                                     ULONG aWidth,
                                     ULONG aHeight,
                                     ULONG aBitsPerPixel,
                                     IGuestScreenInfo **aGuestScreenInfo);
    STDMETHOD(InternalAndReservedMethod1IDisplay)();
    STDMETHOD(InternalAndReservedMethod2IDisplay)();
    STDMETHOD(InternalAndReservedMethod3IDisplay)();
    STDMETHOD(InternalAndReservedMethod4IDisplay)();
    STDMETHOD(InternalAndReservedMethod5IDisplay)();
    STDMETHOD(InternalAndReservedMethod6IDisplay)();
    STDMETHOD(InternalAndReservedMethod7IDisplay)();
    STDMETHOD(InternalAndReservedMethod8IDisplay)();
    /** @} */

    /** @name Public IEventListener properties
     * @{ */
    /** @} */

    /** @name Public IEventListener methods
     * @{ */
    STDMETHOD(HandleEvent)(IEvent *aEvent);
    /** @} */

private:
    /** @name Wrapped IDisplay properties
     * @{ */
    virtual HRESULT getGuestScreenLayout(std::vector<ComPtr<IGuestScreenInfo> > &aGuestScreenLayout) = 0;
    /** @} */

    /** @name Wrapped IDisplay methods
     * @{ */
    virtual HRESULT getScreenResolution(ULONG aScreenId,
                                        ULONG *aWidth,
                                        ULONG *aHeight,
                                        ULONG *aBitsPerPixel,
                                        LONG *aXOrigin,
                                        LONG *aYOrigin,
                                        GuestMonitorStatus_T *aGuestMonitorStatus) = 0;
    virtual HRESULT attachFramebuffer(ULONG aScreenId,
                                      const ComPtr<IFramebuffer> &aFramebuffer,
                                      com::Guid &aId) = 0;
    virtual HRESULT detachFramebuffer(ULONG aScreenId,
                                      const com::Guid &aId) = 0;
    virtual HRESULT queryFramebuffer(ULONG aScreenId,
                                     ComPtr<IFramebuffer> &aFramebuffer) = 0;
    virtual HRESULT setVideoModeHint(ULONG aDisplay,
                                     BOOL aEnabled,
                                     BOOL aChangeOrigin,
                                     LONG aOriginX,
                                     LONG aOriginY,
                                     ULONG aWidth,
                                     ULONG aHeight,
                                     ULONG aBitsPerPixel,
                                     BOOL aNotify) = 0;
    virtual HRESULT getVideoModeHint(ULONG aDisplay,
                                     BOOL *aEnabled,
                                     BOOL *aChangeOrigin,
                                     LONG *aOriginX,
                                     LONG *aOriginY,
                                     ULONG *aWidth,
                                     ULONG *aHeight,
                                     ULONG *aBitsPerPixel) = 0;
    virtual HRESULT setSeamlessMode(BOOL aEnabled) = 0;
    virtual HRESULT takeScreenShot(ULONG aScreenId,
                                   BYTE *aAddress,
                                   ULONG aWidth,
                                   ULONG aHeight,
                                   BitmapFormat_T aBitmapFormat) = 0;
    virtual HRESULT takeScreenShotToArray(ULONG aScreenId,
                                          ULONG aWidth,
                                          ULONG aHeight,
                                          BitmapFormat_T aBitmapFormat,
                                          std::vector<BYTE> &aScreenData) = 0;
    virtual HRESULT drawToScreen(ULONG aScreenId,
                                 BYTE *aAddress,
                                 ULONG aX,
                                 ULONG aY,
                                 ULONG aWidth,
                                 ULONG aHeight) = 0;
    virtual HRESULT invalidateAndUpdate() = 0;
    virtual HRESULT invalidateAndUpdateScreen(ULONG aScreenId) = 0;
    virtual HRESULT completeVHWACommand(BYTE *aCommand) = 0;
    virtual HRESULT viewportChanged(ULONG aScreenId,
                                    ULONG aX,
                                    ULONG aY,
                                    ULONG aWidth,
                                    ULONG aHeight) = 0;
    virtual HRESULT querySourceBitmap(ULONG aScreenId,
                                      ComPtr<IDisplaySourceBitmap> &aDisplaySourceBitmap) = 0;
    virtual HRESULT notifyScaleFactorChange(ULONG aScreenId,
                                            ULONG aU32ScaleFactorWMultiplied,
                                            ULONG aU32ScaleFactorHMultiplied) = 0;
    virtual HRESULT notifyHiDPIOutputPolicyChange(BOOL aFUnscaledHiDPI) = 0;
    virtual HRESULT setScreenLayout(ScreenLayoutMode_T aScreenLayoutMode,
                                    const std::vector<ComPtr<IGuestScreenInfo> > &aGuestScreenInfo) = 0;
    virtual HRESULT detachScreens(const std::vector<LONG> &aScreenIds) = 0;
    virtual HRESULT createGuestScreenInfo(ULONG aDisplay,
                                          GuestMonitorStatus_T aStatus,
                                          BOOL aPrimary,
                                          BOOL aChangeOrigin,
                                          LONG aOriginX,
                                          LONG aOriginY,
                                          ULONG aWidth,
                                          ULONG aHeight,
                                          ULONG aBitsPerPixel,
                                          ComPtr<IGuestScreenInfo> &aGuestScreenInfo) = 0;
    /** @} */

    /** @name Wrapped IEventListener properties
     * @{ */
    /** @} */

    /** @name Wrapped IEventListener methods
     * @{ */
    virtual HRESULT handleEvent(const ComPtr<IEvent> &aEvent) = 0;
    /** @} */

private:
    DECLARE_CLS_COPY_CTOR_ASSIGN_NOOP(DisplayWrap); /* Shuts up MSC warning C4625. */

};

#endif // !DisplayWrap_H_

