// ##### ENDFILE "SystemPropertiesWrap.cpp"


// ##### BEGINFILE "DnDBaseWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IDnDBase.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_DNDBASE

#include "DnDBaseWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(DnDBaseWrap)

//
// IDnDBase properties
//

STDMETHODIMP DnDBaseWrap::COMGETTER(Formats)(ComSafeArrayOut(BSTR, aFormats))
{
    LogRelFlow(("{%p} %s: enter aFormats=%p\n", this, "DnDBase::getFormats", aFormats));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFormats);
        ArrayBSTROutConverter TmpFormats(ComSafeArrayOutArg(aFormats));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDBASE_GET_FORMATS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFormats(TmpFormats.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDBASE_GET_FORMATS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpFormats.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDBASE_GET_FORMATS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDBASE_GET_FORMATS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFormats=%zu hrc=%Rhrc\n", this, "DnDBase::getFormats", ComSafeArraySize(*aFormats), hrc));
    return hrc;
}

STDMETHODIMP DnDBaseWrap::COMGETTER(ProtocolVersion)(ULONG *aProtocolVersion)
{
    LogRelFlow(("{%p} %s: enter aProtocolVersion=%p\n", this, "DnDBase::getProtocolVersion", aProtocolVersion));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProtocolVersion);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDBASE_GET_PROTOCOLVERSION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProtocolVersion(aProtocolVersion);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDBASE_GET_PROTOCOLVERSION_RETURN(this, hrc, 0 /*normal*/,*aProtocolVersion);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDBASE_GET_PROTOCOLVERSION_RETURN(this, hrc, 1 /*hrc exception*/,*aProtocolVersion);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDBASE_GET_PROTOCOLVERSION_RETURN(this, hrc, 9 /*unhandled exception*/,*aProtocolVersion);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProtocolVersion=%RU32 hrc=%Rhrc\n", this, "DnDBase::getProtocolVersion", *aProtocolVersion, hrc));
    return hrc;
}

STDMETHODIMP DnDBaseWrap::COMGETTER(InternalAndReservedAttribute1IDnDBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DnDBaseWrap::COMGETTER(InternalAndReservedAttribute2IDnDBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IDnDBase methods
//

STDMETHODIMP DnDBaseWrap::IsFormatSupported(IN_BSTR aFormat,
                                            BOOL *aSupported)
{
    LogRelFlow(("{%p} %s:enter aFormat=%ls aSupported=%p\n", this, "DnDBase::isFormatSupported", aFormat, aSupported));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupported);


        BSTRInConverter TmpFormat(aFormat);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDBASE_ISFORMATSUPPORTED_ENTER(this, TmpFormat.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = isFormatSupported(TmpFormat.str(),
                                    aSupported);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDBASE_ISFORMATSUPPORTED_RETURN(this, hrc, 0 /*normal*/, TmpFormat.str().c_str(), *aSupported != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDBASE_ISFORMATSUPPORTED_RETURN(this, hrc, 1 /*hrc exception*/, 0, *aSupported != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDBASE_ISFORMATSUPPORTED_RETURN(this, hrc, 9 /*unhandled exception*/, 0, *aSupported != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aSupported=%RTbool hrc=%Rhrc\n", this, "DnDBase::isFormatSupported", *aSupported, hrc));
    return hrc;
}

STDMETHODIMP DnDBaseWrap::AddFormats(ComSafeArrayIn(IN_BSTR, aFormats))
{
    LogRelFlow(("{%p} %s:enter aFormats=%zu\n", this, "DnDBase::addFormats", aFormats));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ArrayBSTRInConverter TmpFormats(ComSafeArrayInArg(aFormats));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDBASE_ADDFORMATS_ENTER(this, (uint32_t)TmpFormats.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = addFormats(TmpFormats.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDBASE_ADDFORMATS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpFormats.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDBASE_ADDFORMATS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDBASE_ADDFORMATS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DnDBase::addFormats", hrc));
    return hrc;
}

STDMETHODIMP DnDBaseWrap::RemoveFormats(ComSafeArrayIn(IN_BSTR, aFormats))
{
    LogRelFlow(("{%p} %s:enter aFormats=%zu\n", this, "DnDBase::removeFormats", aFormats));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ArrayBSTRInConverter TmpFormats(ComSafeArrayInArg(aFormats));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDBASE_REMOVEFORMATS_ENTER(this, (uint32_t)TmpFormats.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeFormats(TmpFormats.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDBASE_REMOVEFORMATS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpFormats.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDBASE_REMOVEFORMATS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDBASE_REMOVEFORMATS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DnDBase::removeFormats", hrc));
    return hrc;
}

STDMETHODIMP DnDBaseWrap::InternalAndReservedMethod1IDnDBase()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(DnDBaseWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(DnDBaseWrap, IDnDBase)
#endif // VBOX_WITH_XPCOM

