// ##### ENDFILE "DisplaySourceBitmapWrap.cpp"


// ##### BEGINFILE "FramebufferWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IFramebuffer.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_FRAMEBUFFER

#include "FramebufferWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(FramebufferWrap)

//
// IFramebuffer properties
//

STDMETHODIMP FramebufferWrap::COMGETTER(Width)(ULONG *aWidth)
{
    LogRelFlow(("{%p} %s: enter aWidth=%p\n", this, "Framebuffer::getWidth", aWidth));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWidth);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_WIDTH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getWidth(aWidth);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_WIDTH_RETURN(this, hrc, 0 /*normal*/,*aWidth);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_WIDTH_RETURN(this, hrc, 1 /*hrc exception*/,*aWidth);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_WIDTH_RETURN(this, hrc, 9 /*unhandled exception*/,*aWidth);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aWidth=%RU32 hrc=%Rhrc\n", this, "Framebuffer::getWidth", *aWidth, hrc));
    return hrc;
}

STDMETHODIMP FramebufferWrap::COMGETTER(Height)(ULONG *aHeight)
{
    LogRelFlow(("{%p} %s: enter aHeight=%p\n", this, "Framebuffer::getHeight", aHeight));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHeight);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_HEIGHT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHeight(aHeight);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_HEIGHT_RETURN(this, hrc, 0 /*normal*/,*aHeight);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_HEIGHT_RETURN(this, hrc, 1 /*hrc exception*/,*aHeight);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_HEIGHT_RETURN(this, hrc, 9 /*unhandled exception*/,*aHeight);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHeight=%RU32 hrc=%Rhrc\n", this, "Framebuffer::getHeight", *aHeight, hrc));
    return hrc;
}

STDMETHODIMP FramebufferWrap::COMGETTER(BitsPerPixel)(ULONG *aBitsPerPixel)
{
    LogRelFlow(("{%p} %s: enter aBitsPerPixel=%p\n", this, "Framebuffer::getBitsPerPixel", aBitsPerPixel));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBitsPerPixel);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_BITSPERPIXEL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getBitsPerPixel(aBitsPerPixel);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_BITSPERPIXEL_RETURN(this, hrc, 0 /*normal*/,*aBitsPerPixel);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_BITSPERPIXEL_RETURN(this, hrc, 1 /*hrc exception*/,*aBitsPerPixel);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_BITSPERPIXEL_RETURN(this, hrc, 9 /*unhandled exception*/,*aBitsPerPixel);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aBitsPerPixel=%RU32 hrc=%Rhrc\n", this, "Framebuffer::getBitsPerPixel", *aBitsPerPixel, hrc));
    return hrc;
}

STDMETHODIMP FramebufferWrap::COMGETTER(BytesPerLine)(ULONG *aBytesPerLine)
{
    LogRelFlow(("{%p} %s: enter aBytesPerLine=%p\n", this, "Framebuffer::getBytesPerLine", aBytesPerLine));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBytesPerLine);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_BYTESPERLINE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getBytesPerLine(aBytesPerLine);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_BYTESPERLINE_RETURN(this, hrc, 0 /*normal*/,*aBytesPerLine);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_BYTESPERLINE_RETURN(this, hrc, 1 /*hrc exception*/,*aBytesPerLine);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_BYTESPERLINE_RETURN(this, hrc, 9 /*unhandled exception*/,*aBytesPerLine);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aBytesPerLine=%RU32 hrc=%Rhrc\n", this, "Framebuffer::getBytesPerLine", *aBytesPerLine, hrc));
    return hrc;
}

STDMETHODIMP FramebufferWrap::COMGETTER(PixelFormat)(BitmapFormat_T *aPixelFormat)
{
    LogRelFlow(("{%p} %s: enter aPixelFormat=%p\n", this, "Framebuffer::getPixelFormat", aPixelFormat));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPixelFormat);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_PIXELFORMAT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPixelFormat(aPixelFormat);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_PIXELFORMAT_RETURN(this, hrc, 0 /*normal*/,*aPixelFormat);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_PIXELFORMAT_RETURN(this, hrc, 1 /*hrc exception*/,*aPixelFormat);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_PIXELFORMAT_RETURN(this, hrc, 9 /*unhandled exception*/,*aPixelFormat);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPixelFormat=%RU32 hrc=%Rhrc\n", this, "Framebuffer::getPixelFormat", *aPixelFormat, hrc));
    return hrc;
}

STDMETHODIMP FramebufferWrap::COMGETTER(HeightReduction)(ULONG *aHeightReduction)
{
    LogRelFlow(("{%p} %s: enter aHeightReduction=%p\n", this, "Framebuffer::getHeightReduction", aHeightReduction));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHeightReduction);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_HEIGHTREDUCTION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHeightReduction(aHeightReduction);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_HEIGHTREDUCTION_RETURN(this, hrc, 0 /*normal*/,*aHeightReduction);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_HEIGHTREDUCTION_RETURN(this, hrc, 1 /*hrc exception*/,*aHeightReduction);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_HEIGHTREDUCTION_RETURN(this, hrc, 9 /*unhandled exception*/,*aHeightReduction);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHeightReduction=%RU32 hrc=%Rhrc\n", this, "Framebuffer::getHeightReduction", *aHeightReduction, hrc));
    return hrc;
}

STDMETHODIMP FramebufferWrap::COMGETTER(Overlay)(IFramebufferOverlay **aOverlay)
{
    LogRelFlow(("{%p} %s: enter aOverlay=%p\n", this, "Framebuffer::getOverlay", aOverlay));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOverlay);
        ComTypeOutConverter<IFramebufferOverlay> TmpOverlay(aOverlay);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_OVERLAY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getOverlay(TmpOverlay.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_OVERLAY_RETURN(this, hrc, 0 /*normal*/,(void *)TmpOverlay.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_OVERLAY_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_OVERLAY_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aOverlay=%p hrc=%Rhrc\n", this, "Framebuffer::getOverlay", *aOverlay, hrc));
    return hrc;
}

STDMETHODIMP FramebufferWrap::COMGETTER(WinId)(LONG64 *aWinId)
{
    LogRelFlow(("{%p} %s: enter aWinId=%p\n", this, "Framebuffer::getWinId", aWinId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWinId);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_WINID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getWinId(aWinId);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_WINID_RETURN(this, hrc, 0 /*normal*/,*aWinId);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_WINID_RETURN(this, hrc, 1 /*hrc exception*/,*aWinId);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_WINID_RETURN(this, hrc, 9 /*unhandled exception*/,*aWinId);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aWinId=%RI64 hrc=%Rhrc\n", this, "Framebuffer::getWinId", *aWinId, hrc));
    return hrc;
}

STDMETHODIMP FramebufferWrap::COMGETTER(Capabilities)(ComSafeArrayOut(FramebufferCapabilities_T, aCapabilities))
{
    LogRelFlow(("{%p} %s: enter aCapabilities=%p\n", this, "Framebuffer::getCapabilities", aCapabilities));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCapabilities);
        ArrayOutConverter<FramebufferCapabilities_T> TmpCapabilities(ComSafeArrayOutArg(aCapabilities));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_CAPABILITIES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCapabilities(TmpCapabilities.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_CAPABILITIES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpCapabilities.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_CAPABILITIES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GET_CAPABILITIES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCapabilities=%zu hrc=%Rhrc\n", this, "Framebuffer::getCapabilities", ComSafeArraySize(*aCapabilities), hrc));
    return hrc;
}


//
// IFramebuffer methods
//

STDMETHODIMP FramebufferWrap::NotifyUpdate(ULONG aX,
                                           ULONG aY,
                                           ULONG aWidth,
                                           ULONG aHeight)
{
    LogRelFlow(("{%p} %s:enter aX=%RU32 aY=%RU32 aWidth=%RU32 aHeight=%RU32\n", this, "Framebuffer::notifyUpdate", aX, aY, aWidth, aHeight));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_NOTIFYUPDATE_ENTER(this, aX, aY, aWidth, aHeight);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = notifyUpdate(aX,
                               aY,
                               aWidth,
                               aHeight);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_NOTIFYUPDATE_RETURN(this, hrc, 0 /*normal*/, aX, aY, aWidth, aHeight);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_NOTIFYUPDATE_RETURN(this, hrc, 1 /*hrc exception*/, aX, aY, aWidth, aHeight);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_NOTIFYUPDATE_RETURN(this, hrc, 9 /*unhandled exception*/, aX, aY, aWidth, aHeight);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Framebuffer::notifyUpdate", hrc));
    return hrc;
}

STDMETHODIMP FramebufferWrap::NotifyUpdateImage(ULONG aX,
                                                ULONG aY,
                                                ULONG aWidth,
                                                ULONG aHeight,
                                                ComSafeArrayIn(BYTE, aImage))
{
    LogRelFlow(("{%p} %s:enter aX=%RU32 aY=%RU32 aWidth=%RU32 aHeight=%RU32 aImage=%zu\n", this, "Framebuffer::notifyUpdateImage", aX, aY, aWidth, aHeight, aImage));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        
        
        
        ArrayInConverter<BYTE> TmpImage(ComSafeArrayInArg(aImage));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_NOTIFYUPDATEIMAGE_ENTER(this, aX, aY, aWidth, aHeight, (uint32_t)TmpImage.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = notifyUpdateImage(aX,
                                    aY,
                                    aWidth,
                                    aHeight,
                                    TmpImage.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_NOTIFYUPDATEIMAGE_RETURN(this, hrc, 0 /*normal*/, aX, aY, aWidth, aHeight, (uint32_t)TmpImage.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_NOTIFYUPDATEIMAGE_RETURN(this, hrc, 1 /*hrc exception*/, aX, aY, aWidth, aHeight, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_NOTIFYUPDATEIMAGE_RETURN(this, hrc, 9 /*unhandled exception*/, aX, aY, aWidth, aHeight, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Framebuffer::notifyUpdateImage", hrc));
    return hrc;
}

STDMETHODIMP FramebufferWrap::NotifyChange(ULONG aScreenId,
                                           ULONG aXOrigin,
                                           ULONG aYOrigin,
                                           ULONG aWidth,
                                           ULONG aHeight)
{
    LogRelFlow(("{%p} %s:enter aScreenId=%RU32 aXOrigin=%RU32 aYOrigin=%RU32 aWidth=%RU32 aHeight=%RU32\n", this, "Framebuffer::notifyChange", aScreenId, aXOrigin, aYOrigin, aWidth, aHeight));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_NOTIFYCHANGE_ENTER(this, aScreenId, aXOrigin, aYOrigin, aWidth, aHeight);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = notifyChange(aScreenId,
                               aXOrigin,
                               aYOrigin,
                               aWidth,
                               aHeight);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_NOTIFYCHANGE_RETURN(this, hrc, 0 /*normal*/, aScreenId, aXOrigin, aYOrigin, aWidth, aHeight);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_NOTIFYCHANGE_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, aXOrigin, aYOrigin, aWidth, aHeight);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_NOTIFYCHANGE_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, aXOrigin, aYOrigin, aWidth, aHeight);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Framebuffer::notifyChange", hrc));
    return hrc;
}

STDMETHODIMP FramebufferWrap::VideoModeSupported(ULONG aWidth,
                                                 ULONG aHeight,
                                                 ULONG aBpp,
                                                 BOOL *aSupported)
{
    LogRelFlow(("{%p} %s:enter aWidth=%RU32 aHeight=%RU32 aBpp=%RU32 aSupported=%p\n", this, "Framebuffer::videoModeSupported", aWidth, aHeight, aBpp, aSupported));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupported);


        
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_VIDEOMODESUPPORTED_ENTER(this, aWidth, aHeight, aBpp);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = videoModeSupported(aWidth,
                                     aHeight,
                                     aBpp,
                                     aSupported);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_VIDEOMODESUPPORTED_RETURN(this, hrc, 0 /*normal*/, aWidth, aHeight, aBpp, *aSupported != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_VIDEOMODESUPPORTED_RETURN(this, hrc, 1 /*hrc exception*/, aWidth, aHeight, aBpp, *aSupported != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_VIDEOMODESUPPORTED_RETURN(this, hrc, 9 /*unhandled exception*/, aWidth, aHeight, aBpp, *aSupported != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aSupported=%RTbool hrc=%Rhrc\n", this, "Framebuffer::videoModeSupported", *aSupported, hrc));
    return hrc;
}

STDMETHODIMP FramebufferWrap::GetVisibleRegion(BYTE *aRectangles,
                                               ULONG aCount,
                                               ULONG *aCountCopied)
{
    LogRelFlow(("{%p} %s:enter aRectangles=%p aCount=%RU32 aCountCopied=%p\n", this, "Framebuffer::getVisibleRegion", aRectangles, aCount, aCountCopied));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCountCopied);


        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GETVISIBLEREGION_ENTER(this, aRectangles, aCount);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVisibleRegion(aRectangles,
                                   aCount,
                                   aCountCopied);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GETVISIBLEREGION_RETURN(this, hrc, 0 /*normal*/, aRectangles, aCount, *aCountCopied);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GETVISIBLEREGION_RETURN(this, hrc, 1 /*hrc exception*/, aRectangles, aCount, *aCountCopied);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_GETVISIBLEREGION_RETURN(this, hrc, 9 /*unhandled exception*/, aRectangles, aCount, *aCountCopied);
#endif
    }

    LogRelFlow(("{%p} %s: leave aCountCopied=%RU32 hrc=%Rhrc\n", this, "Framebuffer::getVisibleRegion", *aCountCopied, hrc));
    return hrc;
}

STDMETHODIMP FramebufferWrap::SetVisibleRegion(BYTE *aRectangles,
                                               ULONG aCount)
{
    LogRelFlow(("{%p} %s:enter aRectangles=%p aCount=%RU32\n", this, "Framebuffer::setVisibleRegion", aRectangles, aCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_SETVISIBLEREGION_ENTER(this, aRectangles, aCount);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setVisibleRegion(aRectangles,
                                   aCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_SETVISIBLEREGION_RETURN(this, hrc, 0 /*normal*/, aRectangles, aCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_SETVISIBLEREGION_RETURN(this, hrc, 1 /*hrc exception*/, aRectangles, aCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_SETVISIBLEREGION_RETURN(this, hrc, 9 /*unhandled exception*/, aRectangles, aCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Framebuffer::setVisibleRegion", hrc));
    return hrc;
}

STDMETHODIMP FramebufferWrap::ProcessVHWACommand(BYTE *aCommand,
                                                 LONG aEnmCmd,
                                                 BOOL aFromGuest)
{
    LogRelFlow(("{%p} %s:enter aCommand=%p aEnmCmd=%RI32 aFromGuest=%RTbool\n", this, "Framebuffer::processVHWACommand", aCommand, aEnmCmd, aFromGuest));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_PROCESSVHWACOMMAND_ENTER(this, aCommand, aEnmCmd, aFromGuest != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = processVHWACommand(aCommand,
                                     aEnmCmd,
                                     aFromGuest != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_PROCESSVHWACOMMAND_RETURN(this, hrc, 0 /*normal*/, aCommand, aEnmCmd, aFromGuest != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_PROCESSVHWACOMMAND_RETURN(this, hrc, 1 /*hrc exception*/, aCommand, aEnmCmd, aFromGuest != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_PROCESSVHWACOMMAND_RETURN(this, hrc, 9 /*unhandled exception*/, aCommand, aEnmCmd, aFromGuest != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Framebuffer::processVHWACommand", hrc));
    return hrc;
}

STDMETHODIMP FramebufferWrap::Notify3DEvent(ULONG aType,
                                            ComSafeArrayIn(BYTE, aData))
{
    LogRelFlow(("{%p} %s:enter aType=%RU32 aData=%zu\n", this, "Framebuffer::notify3DEvent", aType, aData));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        ArrayInConverter<BYTE> TmpData(ComSafeArrayInArg(aData));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_NOTIFY3DEVENT_ENTER(this, aType, (uint32_t)TmpData.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = notify3DEvent(aType,
                                TmpData.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_NOTIFY3DEVENT_RETURN(this, hrc, 0 /*normal*/, aType, (uint32_t)TmpData.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_NOTIFY3DEVENT_RETURN(this, hrc, 1 /*hrc exception*/, aType, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFER_NOTIFY3DEVENT_RETURN(this, hrc, 9 /*unhandled exception*/, aType, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Framebuffer::notify3DEvent", hrc));
    return hrc;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(FramebufferWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(FramebufferWrap, IFramebuffer)
#endif // VBOX_WITH_XPCOM

