// ##### ENDFILE "DnDBaseWrap.cpp"


// ##### BEGINFILE "GuestDnDSourceWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IGuestDnDSource.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_GUESTDNDSOURCE

#include "GuestDnDSourceWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(GuestDnDSourceWrap)

//
// IDnDBase properties
//

STDMETHODIMP GuestDnDSourceWrap::COMGETTER(Formats)(ComSafeArrayOut(BSTR, aFormats))
{
    LogRelFlow(("{%p} %s: enter aFormats=%p\n", this, "GuestDnDSource::getFormats", aFormats));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFormats);
        ArrayBSTROutConverter TmpFormats(ComSafeArrayOutArg(aFormats));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_GET_FORMATS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFormats(TmpFormats.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_GET_FORMATS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpFormats.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_GET_FORMATS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_GET_FORMATS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFormats=%zu hrc=%Rhrc\n", this, "GuestDnDSource::getFormats", ComSafeArraySize(*aFormats), hrc));
    return hrc;
}

STDMETHODIMP GuestDnDSourceWrap::COMGETTER(ProtocolVersion)(ULONG *aProtocolVersion)
{
    LogRelFlow(("{%p} %s: enter aProtocolVersion=%p\n", this, "GuestDnDSource::getProtocolVersion", aProtocolVersion));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProtocolVersion);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_GET_PROTOCOLVERSION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProtocolVersion(aProtocolVersion);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_GET_PROTOCOLVERSION_RETURN(this, hrc, 0 /*normal*/,*aProtocolVersion);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_GET_PROTOCOLVERSION_RETURN(this, hrc, 1 /*hrc exception*/,*aProtocolVersion);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_GET_PROTOCOLVERSION_RETURN(this, hrc, 9 /*unhandled exception*/,*aProtocolVersion);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProtocolVersion=%RU32 hrc=%Rhrc\n", this, "GuestDnDSource::getProtocolVersion", *aProtocolVersion, hrc));
    return hrc;
}

STDMETHODIMP GuestDnDSourceWrap::COMGETTER(InternalAndReservedAttribute1IDnDBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestDnDSourceWrap::COMGETTER(InternalAndReservedAttribute2IDnDBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

//
// IDnDSource properties
//

STDMETHODIMP GuestDnDSourceWrap::COMGETTER(InternalAndReservedAttribute1IDnDSource)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestDnDSourceWrap::COMGETTER(InternalAndReservedAttribute2IDnDSource)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

//
// IGuestDnDSource properties
//

STDMETHODIMP GuestDnDSourceWrap::COMGETTER(MidlDoesNotLikeEmptyInterfaces)(BOOL *aMidlDoesNotLikeEmptyInterfaces)
{
#if 0 /* This is a dummy attribute */
    LogRelFlow(("{%p} %s: enter aMidlDoesNotLikeEmptyInterfaces=%p\n", this, "GuestDnDSource::getMidlDoesNotLikeEmptyInterfaces", aMidlDoesNotLikeEmptyInterfaces));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMidlDoesNotLikeEmptyInterfaces);
        
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMidlDoesNotLikeEmptyInterfaces(aMidlDoesNotLikeEmptyInterfaces);
        }
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
    }

    LogRelFlow(("{%p} %s: leave *aMidlDoesNotLikeEmptyInterfaces=%RTbool hrc=%Rhrc\n", this, "GuestDnDSource::getMidlDoesNotLikeEmptyInterfaces", *aMidlDoesNotLikeEmptyInterfaces, hrc));
    return hrc;
#else  /* dummy attribute */
    NOREF(aMidlDoesNotLikeEmptyInterfaces);
    return E_FAIL;
#endif /* dummy attribute */
}


//
// IDnDBase methods
//

STDMETHODIMP GuestDnDSourceWrap::IsFormatSupported(IN_BSTR aFormat,
                                                   BOOL *aSupported)
{
    LogRelFlow(("{%p} %s:enter aFormat=%ls aSupported=%p\n", this, "GuestDnDSource::isFormatSupported", aFormat, aSupported));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupported);


        BSTRInConverter TmpFormat(aFormat);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_ISFORMATSUPPORTED_ENTER(this, TmpFormat.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = isFormatSupported(TmpFormat.str(),
                                    aSupported);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_ISFORMATSUPPORTED_RETURN(this, hrc, 0 /*normal*/, TmpFormat.str().c_str(), *aSupported != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_ISFORMATSUPPORTED_RETURN(this, hrc, 1 /*hrc exception*/, 0, *aSupported != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_ISFORMATSUPPORTED_RETURN(this, hrc, 9 /*unhandled exception*/, 0, *aSupported != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aSupported=%RTbool hrc=%Rhrc\n", this, "GuestDnDSource::isFormatSupported", *aSupported, hrc));
    return hrc;
}

STDMETHODIMP GuestDnDSourceWrap::AddFormats(ComSafeArrayIn(IN_BSTR, aFormats))
{
    LogRelFlow(("{%p} %s:enter aFormats=%zu\n", this, "GuestDnDSource::addFormats", aFormats));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ArrayBSTRInConverter TmpFormats(ComSafeArrayInArg(aFormats));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_ADDFORMATS_ENTER(this, (uint32_t)TmpFormats.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = addFormats(TmpFormats.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_ADDFORMATS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpFormats.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_ADDFORMATS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_ADDFORMATS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestDnDSource::addFormats", hrc));
    return hrc;
}

STDMETHODIMP GuestDnDSourceWrap::RemoveFormats(ComSafeArrayIn(IN_BSTR, aFormats))
{
    LogRelFlow(("{%p} %s:enter aFormats=%zu\n", this, "GuestDnDSource::removeFormats", aFormats));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ArrayBSTRInConverter TmpFormats(ComSafeArrayInArg(aFormats));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_REMOVEFORMATS_ENTER(this, (uint32_t)TmpFormats.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeFormats(TmpFormats.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_REMOVEFORMATS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpFormats.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_REMOVEFORMATS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_REMOVEFORMATS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestDnDSource::removeFormats", hrc));
    return hrc;
}

STDMETHODIMP GuestDnDSourceWrap::InternalAndReservedMethod1IDnDBase()
{
    return E_NOTIMPL;
}

//
// IDnDSource methods
//

STDMETHODIMP GuestDnDSourceWrap::DragIsPending(ULONG aScreenId,
                                               ComSafeArrayOut(BSTR, aFormats),
                                               ComSafeArrayOut(DnDAction_T, aAllowedActions),
                                               DnDAction_T *aDefaultAction)
{
    LogRelFlow(("{%p} %s:enter aScreenId=%RU32 aFormats=%p aAllowedActions=%p aDefaultAction=%p\n", this, "GuestDnDSource::dragIsPending", aScreenId, aFormats, aAllowedActions, aDefaultAction));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFormats);
        CheckComArgOutPointerValidThrow(aAllowedActions);
        CheckComArgOutPointerValidThrow(aDefaultAction);


        
        ArrayBSTROutConverter TmpFormats(ComSafeArrayOutArg(aFormats));
        ArrayOutConverter<DnDAction_T> TmpAllowedActions(ComSafeArrayOutArg(aAllowedActions));
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_DRAGISPENDING_ENTER(this, aScreenId);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = dragIsPending(aScreenId,
                                TmpFormats.array(),
                                TmpAllowedActions.array(),
                                aDefaultAction);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_DRAGISPENDING_RETURN(this, hrc, 0 /*normal*/, aScreenId, (uint32_t)TmpFormats.array().size(), NULL /*for now*/, (uint32_t)TmpAllowedActions.array().size(), NULL /*for now*/, *aDefaultAction);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_DRAGISPENDING_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, 0, 0, 0, 0, *aDefaultAction);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_DRAGISPENDING_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, 0, 0, 0, 0, *aDefaultAction);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFormats=%zu *aAllowedActions=%zu aDefaultAction=%RU32 hrc=%Rhrc\n", this, "GuestDnDSource::dragIsPending", ComSafeArraySize(*aFormats), ComSafeArraySize(*aAllowedActions), *aDefaultAction, hrc));
    return hrc;
}

STDMETHODIMP GuestDnDSourceWrap::Drop(IN_BSTR aFormat,
                                      DnDAction_T aAction,
                                      IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aFormat=%ls aAction=%RU32 aProgress=%p\n", this, "GuestDnDSource::drop", aFormat, aAction, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpFormat(aFormat);
        
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_DROP_ENTER(this, TmpFormat.str().c_str(), aAction);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = drop(TmpFormat.str(),
                       aAction,
                       TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_DROP_RETURN(this, hrc, 0 /*normal*/, TmpFormat.str().c_str(), aAction, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_DROP_RETURN(this, hrc, 1 /*hrc exception*/, 0, aAction, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_DROP_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aAction, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "GuestDnDSource::drop", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP GuestDnDSourceWrap::ReceiveData(ComSafeArrayOut(BYTE, aData))
{
    LogRelFlow(("{%p} %s:enter aData=%p\n", this, "GuestDnDSource::receiveData", aData));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aData);


        ArrayOutConverter<BYTE> TmpData(ComSafeArrayOutArg(aData));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_RECEIVEDATA_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = receiveData(TmpData.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_RECEIVEDATA_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpData.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_RECEIVEDATA_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDSOURCE_RECEIVEDATA_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aData=%zu hrc=%Rhrc\n", this, "GuestDnDSource::receiveData", ComSafeArraySize(*aData), hrc));
    return hrc;
}

STDMETHODIMP GuestDnDSourceWrap::InternalAndReservedMethod1IDnDSource()
{
    return E_NOTIMPL;
}

//
// IGuestDnDSource methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestDnDSourceWrap)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(GuestDnDSourceWrap, IGuestDnDSource, IDnDSource, IDnDBase)
#endif // VBOX_WITH_XPCOM

