

// ##### BEGINFILE "CloudNetworkWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for ICloudNetwork.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_CLOUDNETWORK

#include "CloudNetworkWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(CloudNetworkWrap)

//
// ICloudNetwork properties
//

STDMETHODIMP CloudNetworkWrap::COMGETTER(NetworkName)(BSTR *aNetworkName)
{
    LogRelFlow(("{%p} %s: enter aNetworkName=%p\n", this, "CloudNetwork::getNetworkName", aNetworkName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNetworkName);
        BSTROutConverter TmpNetworkName(aNetworkName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_GET_NETWORKNAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNetworkName(TmpNetworkName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_GET_NETWORKNAME_RETURN(this, hrc, 0 /*normal*/,TmpNetworkName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_GET_NETWORKNAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_GET_NETWORKNAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNetworkName=%ls hrc=%Rhrc\n", this, "CloudNetwork::getNetworkName", *aNetworkName, hrc));
    return hrc;
}

STDMETHODIMP CloudNetworkWrap::COMSETTER(NetworkName)(IN_BSTR aNetworkName)
{
    LogRelFlow(("{%p} %s: enter aNetworkName=%ls\n", this, "CloudNetwork::setNetworkName", aNetworkName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpNetworkName(aNetworkName);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_SET_NETWORKNAME_ENTER(this, TmpNetworkName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setNetworkName(TmpNetworkName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_SET_NETWORKNAME_RETURN(this, hrc, 0 /*normal*/,TmpNetworkName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_SET_NETWORKNAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_SET_NETWORKNAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "CloudNetwork::setNetworkName", hrc));
    return hrc;
}

STDMETHODIMP CloudNetworkWrap::COMGETTER(Enabled)(BOOL *aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%p\n", this, "CloudNetwork::getEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_GET_ENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEnabled(aEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_GET_ENABLED_RETURN(this, hrc, 0 /*normal*/,*aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_GET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_GET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEnabled=%RTbool hrc=%Rhrc\n", this, "CloudNetwork::getEnabled", *aEnabled, hrc));
    return hrc;
}

STDMETHODIMP CloudNetworkWrap::COMSETTER(Enabled)(BOOL aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%RTbool\n", this, "CloudNetwork::setEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_SET_ENABLED_ENTER(this, aEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setEnabled(aEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_SET_ENABLED_RETURN(this, hrc, 0 /*normal*/,aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_SET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_SET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "CloudNetwork::setEnabled", hrc));
    return hrc;
}

STDMETHODIMP CloudNetworkWrap::COMGETTER(Provider)(BSTR *aProvider)
{
    LogRelFlow(("{%p} %s: enter aProvider=%p\n", this, "CloudNetwork::getProvider", aProvider));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProvider);
        BSTROutConverter TmpProvider(aProvider);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_GET_PROVIDER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProvider(TmpProvider.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_GET_PROVIDER_RETURN(this, hrc, 0 /*normal*/,TmpProvider.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_GET_PROVIDER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_GET_PROVIDER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProvider=%ls hrc=%Rhrc\n", this, "CloudNetwork::getProvider", *aProvider, hrc));
    return hrc;
}

STDMETHODIMP CloudNetworkWrap::COMSETTER(Provider)(IN_BSTR aProvider)
{
    LogRelFlow(("{%p} %s: enter aProvider=%ls\n", this, "CloudNetwork::setProvider", aProvider));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpProvider(aProvider);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_SET_PROVIDER_ENTER(this, TmpProvider.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setProvider(TmpProvider.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_SET_PROVIDER_RETURN(this, hrc, 0 /*normal*/,TmpProvider.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_SET_PROVIDER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_SET_PROVIDER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "CloudNetwork::setProvider", hrc));
    return hrc;
}

STDMETHODIMP CloudNetworkWrap::COMGETTER(Profile)(BSTR *aProfile)
{
    LogRelFlow(("{%p} %s: enter aProfile=%p\n", this, "CloudNetwork::getProfile", aProfile));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProfile);
        BSTROutConverter TmpProfile(aProfile);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_GET_PROFILE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProfile(TmpProfile.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_GET_PROFILE_RETURN(this, hrc, 0 /*normal*/,TmpProfile.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_GET_PROFILE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_GET_PROFILE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProfile=%ls hrc=%Rhrc\n", this, "CloudNetwork::getProfile", *aProfile, hrc));
    return hrc;
}

STDMETHODIMP CloudNetworkWrap::COMSETTER(Profile)(IN_BSTR aProfile)
{
    LogRelFlow(("{%p} %s: enter aProfile=%ls\n", this, "CloudNetwork::setProfile", aProfile));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpProfile(aProfile);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_SET_PROFILE_ENTER(this, TmpProfile.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setProfile(TmpProfile.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_SET_PROFILE_RETURN(this, hrc, 0 /*normal*/,TmpProfile.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_SET_PROFILE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_SET_PROFILE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "CloudNetwork::setProfile", hrc));
    return hrc;
}

STDMETHODIMP CloudNetworkWrap::COMGETTER(NetworkId)(BSTR *aNetworkId)
{
    LogRelFlow(("{%p} %s: enter aNetworkId=%p\n", this, "CloudNetwork::getNetworkId", aNetworkId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNetworkId);
        BSTROutConverter TmpNetworkId(aNetworkId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_GET_NETWORKID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNetworkId(TmpNetworkId.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_GET_NETWORKID_RETURN(this, hrc, 0 /*normal*/,TmpNetworkId.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_GET_NETWORKID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_GET_NETWORKID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNetworkId=%ls hrc=%Rhrc\n", this, "CloudNetwork::getNetworkId", *aNetworkId, hrc));
    return hrc;
}

STDMETHODIMP CloudNetworkWrap::COMSETTER(NetworkId)(IN_BSTR aNetworkId)
{
    LogRelFlow(("{%p} %s: enter aNetworkId=%ls\n", this, "CloudNetwork::setNetworkId", aNetworkId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpNetworkId(aNetworkId);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_SET_NETWORKID_ENTER(this, TmpNetworkId.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setNetworkId(TmpNetworkId.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_SET_NETWORKID_RETURN(this, hrc, 0 /*normal*/,TmpNetworkId.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_SET_NETWORKID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORK_SET_NETWORKID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "CloudNetwork::setNetworkId", hrc));
    return hrc;
}

STDMETHODIMP CloudNetworkWrap::COMGETTER(InternalAndReservedAttribute1ICloudNetwork)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudNetworkWrap::COMGETTER(InternalAndReservedAttribute2ICloudNetwork)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudNetworkWrap::COMGETTER(InternalAndReservedAttribute3ICloudNetwork)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudNetworkWrap::COMGETTER(InternalAndReservedAttribute4ICloudNetwork)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudNetworkWrap::COMGETTER(InternalAndReservedAttribute5ICloudNetwork)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudNetworkWrap::COMGETTER(InternalAndReservedAttribute6ICloudNetwork)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudNetworkWrap::COMGETTER(InternalAndReservedAttribute7ICloudNetwork)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudNetworkWrap::COMGETTER(InternalAndReservedAttribute8ICloudNetwork)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudNetworkWrap::COMGETTER(InternalAndReservedAttribute9ICloudNetwork)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudNetworkWrap::COMGETTER(InternalAndReservedAttribute10ICloudNetwork)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudNetworkWrap::COMGETTER(InternalAndReservedAttribute11ICloudNetwork)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudNetworkWrap::COMGETTER(InternalAndReservedAttribute12ICloudNetwork)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// ICloudNetwork methods
//

STDMETHODIMP CloudNetworkWrap::InternalAndReservedMethod1ICloudNetwork()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudNetworkWrap::InternalAndReservedMethod2ICloudNetwork()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudNetworkWrap::InternalAndReservedMethod3ICloudNetwork()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudNetworkWrap::InternalAndReservedMethod4ICloudNetwork()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(CloudNetworkWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(CloudNetworkWrap, ICloudNetwork)
#endif // VBOX_WITH_XPCOM

