// ##### ENDFILE "CloudNetworkWrap.h"


// ##### BEGINFILE "DHCPServerWrap.h"
/** @file
 * VirtualBox API class wrapper header for IDHCPServer.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#ifndef DHCPServerWrap_H_
#define DHCPServerWrap_H_
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif

#include "VirtualBoxBase.h"
#include "Wrapper.h"

class ATL_NO_VTABLE DHCPServerWrap
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IDHCPServer)
{
    Q_OBJECT

public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(DHCPServerWrap, IDHCPServer)
    DECLARE_NOT_AGGREGATABLE(DHCPServerWrap)
    DECLARE_PROTECT_FINAL_CONSTRUCT()

    BEGIN_COM_MAP(DHCPServerWrap)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IDHCPServer)
        COM_INTERFACE_ENTRY2(IDispatch, IDHCPServer)
        VBOX_TWEAK_INTERFACE_ENTRY(IDHCPServer)
    END_COM_MAP()

    DECLARE_EMPTY_CTOR_DTOR(DHCPServerWrap)

    /** @name Public IDHCPServer properties
     * @{ */
    STDMETHOD(COMGETTER(EventSource))(IEventSource **aEventSource);
    STDMETHOD(COMGETTER(Enabled))(BOOL *aEnabled);
    STDMETHOD(COMSETTER(Enabled))(BOOL aEnabled);
    STDMETHOD(COMGETTER(IPAddress))(BSTR *aIPAddress);
    STDMETHOD(COMGETTER(NetworkMask))(BSTR *aNetworkMask);
    STDMETHOD(COMGETTER(NetworkName))(BSTR *aNetworkName);
    STDMETHOD(COMGETTER(LowerIP))(BSTR *aLowerIP);
    STDMETHOD(COMGETTER(UpperIP))(BSTR *aUpperIP);
    STDMETHOD(COMGETTER(GlobalConfig))(IDHCPGlobalConfig **aGlobalConfig);
    STDMETHOD(COMGETTER(GroupConfigs))(ComSafeArrayOut(IDHCPGroupConfig *, aGroupConfigs));
    STDMETHOD(COMGETTER(IndividualConfigs))(ComSafeArrayOut(IDHCPIndividualConfig *, aIndividualConfigs));
    STDMETHOD(COMGETTER(InternalAndReservedAttribute1IDHCPServer))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute2IDHCPServer))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute3IDHCPServer))(ULONG *aReserved);
    /** @} */

    /** @name Public IDHCPServer methods
     * @{ */
    STDMETHOD(SetConfiguration)(IN_BSTR aIPAddress,
                                IN_BSTR aNetworkMask,
                                IN_BSTR aFromIPAddress,
                                IN_BSTR aToIPAddress);
    STDMETHOD(Start)(IN_BSTR aTrunkName,
                     IN_BSTR aTrunkType);
    STDMETHOD(Stop)();
    STDMETHOD(Restart)();
    STDMETHOD(FindLeaseByMAC)(IN_BSTR aMac,
                              LONG aType,
                              BSTR *aAddress,
                              BSTR *aState,
                              LONG64 *aIssued,
                              LONG64 *aExpire);
    STDMETHOD(GetConfig)(DHCPConfigScope_T aScope,
                         IN_BSTR aName,
                         ULONG aSlot,
                         BOOL aMayAdd,
                         IDHCPConfig **aConfig);
    /** @} */

private:
    /** @name Wrapped IDHCPServer properties
     * @{ */
    virtual HRESULT getEventSource(ComPtr<IEventSource> &aEventSource) = 0;
    virtual HRESULT getEnabled(BOOL *aEnabled) = 0;
    virtual HRESULT setEnabled(BOOL aEnabled) = 0;
    virtual HRESULT getIPAddress(com::Utf8Str &aIPAddress) = 0;
    virtual HRESULT getNetworkMask(com::Utf8Str &aNetworkMask) = 0;
    virtual HRESULT getNetworkName(com::Utf8Str &aNetworkName) = 0;
    virtual HRESULT getLowerIP(com::Utf8Str &aLowerIP) = 0;
    virtual HRESULT getUpperIP(com::Utf8Str &aUpperIP) = 0;
    virtual HRESULT getGlobalConfig(ComPtr<IDHCPGlobalConfig> &aGlobalConfig) = 0;
    virtual HRESULT getGroupConfigs(std::vector<ComPtr<IDHCPGroupConfig> > &aGroupConfigs) = 0;
    virtual HRESULT getIndividualConfigs(std::vector<ComPtr<IDHCPIndividualConfig> > &aIndividualConfigs) = 0;
    /** @} */

    /** @name Wrapped IDHCPServer methods
     * @{ */
    virtual HRESULT setConfiguration(const com::Utf8Str &aIPAddress,
                                     const com::Utf8Str &aNetworkMask,
                                     const com::Utf8Str &aFromIPAddress,
                                     const com::Utf8Str &aToIPAddress) = 0;
    virtual HRESULT start(const com::Utf8Str &aTrunkName,
                          const com::Utf8Str &aTrunkType) = 0;
    virtual HRESULT stop() = 0;
    virtual HRESULT restart() = 0;
    virtual HRESULT findLeaseByMAC(const com::Utf8Str &aMac,
                                   LONG aType,
                                   com::Utf8Str &aAddress,
                                   com::Utf8Str &aState,
                                   LONG64 *aIssued,
                                   LONG64 *aExpire) = 0;
    virtual HRESULT getConfig(DHCPConfigScope_T aScope,
                              const com::Utf8Str &aName,
                              ULONG aSlot,
                              BOOL aMayAdd,
                              ComPtr<IDHCPConfig> &aConfig) = 0;
    /** @} */

private:
    DECLARE_CLS_COPY_CTOR_ASSIGN_NOOP(DHCPServerWrap); /* Shuts up MSC warning C4625. */

};

#endif // !DHCPServerWrap_H_

