// ##### ENDFILE "FramebufferWrap.h"


// ##### BEGINFILE "FramebufferOverlayWrap.h"
/** @file
 * VirtualBox API class wrapper header for IFramebufferOverlay.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#ifndef FramebufferOverlayWrap_H_
#define FramebufferOverlayWrap_H_
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif

#include "VirtualBoxBase.h"
#include "Wrapper.h"

class ATL_NO_VTABLE FramebufferOverlayWrap
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IFramebufferOverlay)
{
    Q_OBJECT

public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(FramebufferOverlayWrap, IFramebufferOverlay)
    DECLARE_NOT_AGGREGATABLE(FramebufferOverlayWrap)
    DECLARE_PROTECT_FINAL_CONSTRUCT()

    BEGIN_COM_MAP(FramebufferOverlayWrap)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IFramebufferOverlay)
        COM_INTERFACE_ENTRY(IFramebuffer)
        COM_INTERFACE_ENTRY2(IDispatch, IFramebufferOverlay)
        VBOX_TWEAK_INTERFACE_ENTRY(IFramebufferOverlay)
    END_COM_MAP()

    DECLARE_EMPTY_CTOR_DTOR(FramebufferOverlayWrap)

    /** @name Public IFramebuffer properties
     * @{ */
    STDMETHOD(COMGETTER(Width))(ULONG *aWidth);
    STDMETHOD(COMGETTER(Height))(ULONG *aHeight);
    STDMETHOD(COMGETTER(BitsPerPixel))(ULONG *aBitsPerPixel);
    STDMETHOD(COMGETTER(BytesPerLine))(ULONG *aBytesPerLine);
    STDMETHOD(COMGETTER(PixelFormat))(BitmapFormat_T *aPixelFormat);
    STDMETHOD(COMGETTER(HeightReduction))(ULONG *aHeightReduction);
    STDMETHOD(COMGETTER(Overlay))(IFramebufferOverlay **aOverlay);
    STDMETHOD(COMGETTER(WinId))(LONG64 *aWinId);
    STDMETHOD(COMGETTER(Capabilities))(ComSafeArrayOut(FramebufferCapabilities_T, aCapabilities));
    /** @} */

    /** @name Public IFramebufferOverlay properties
     * @{ */
    STDMETHOD(COMGETTER(X))(ULONG *aX);
    STDMETHOD(COMGETTER(Y))(ULONG *aY);
    STDMETHOD(COMGETTER(Visible))(BOOL *aVisible);
    STDMETHOD(COMSETTER(Visible))(BOOL aVisible);
    STDMETHOD(COMGETTER(Alpha))(ULONG *aAlpha);
    STDMETHOD(COMSETTER(Alpha))(ULONG aAlpha);
    /** @} */

    /** @name Public IFramebuffer methods
     * @{ */
    STDMETHOD(NotifyUpdate)(ULONG aX,
                            ULONG aY,
                            ULONG aWidth,
                            ULONG aHeight);
    STDMETHOD(NotifyUpdateImage)(ULONG aX,
                                 ULONG aY,
                                 ULONG aWidth,
                                 ULONG aHeight,
                                 ComSafeArrayIn(BYTE, aImage));
    STDMETHOD(NotifyChange)(ULONG aScreenId,
                            ULONG aXOrigin,
                            ULONG aYOrigin,
                            ULONG aWidth,
                            ULONG aHeight);
    STDMETHOD(VideoModeSupported)(ULONG aWidth,
                                  ULONG aHeight,
                                  ULONG aBpp,
                                  BOOL *aSupported);
    STDMETHOD(GetVisibleRegion)(BYTE *aRectangles,
                                ULONG aCount,
                                ULONG *aCountCopied);
    STDMETHOD(SetVisibleRegion)(BYTE *aRectangles,
                                ULONG aCount);
    STDMETHOD(ProcessVHWACommand)(BYTE *aCommand,
                                  LONG aEnmCmd,
                                  BOOL aFromGuest);
    STDMETHOD(Notify3DEvent)(ULONG aType,
                             ComSafeArrayIn(BYTE, aData));
    /** @} */

    /** @name Public IFramebufferOverlay methods
     * @{ */
    STDMETHOD(Move)(ULONG aX,
                    ULONG aY);
    /** @} */

private:
    /** @name Wrapped IFramebuffer properties
     * @{ */
    virtual HRESULT getWidth(ULONG *aWidth) = 0;
    virtual HRESULT getHeight(ULONG *aHeight) = 0;
    virtual HRESULT getBitsPerPixel(ULONG *aBitsPerPixel) = 0;
    virtual HRESULT getBytesPerLine(ULONG *aBytesPerLine) = 0;
    virtual HRESULT getPixelFormat(BitmapFormat_T *aPixelFormat) = 0;
    virtual HRESULT getHeightReduction(ULONG *aHeightReduction) = 0;
    virtual HRESULT getOverlay(ComPtr<IFramebufferOverlay> &aOverlay) = 0;
    virtual HRESULT getWinId(LONG64 *aWinId) = 0;
    virtual HRESULT getCapabilities(std::vector<FramebufferCapabilities_T> &aCapabilities) = 0;
    /** @} */

    /** @name Wrapped IFramebufferOverlay properties
     * @{ */
    virtual HRESULT getX(ULONG *aX) = 0;
    virtual HRESULT getY(ULONG *aY) = 0;
    virtual HRESULT getVisible(BOOL *aVisible) = 0;
    virtual HRESULT setVisible(BOOL aVisible) = 0;
    virtual HRESULT getAlpha(ULONG *aAlpha) = 0;
    virtual HRESULT setAlpha(ULONG aAlpha) = 0;
    /** @} */

    /** @name Wrapped IFramebuffer methods
     * @{ */
    virtual HRESULT notifyUpdate(ULONG aX,
                                 ULONG aY,
                                 ULONG aWidth,
                                 ULONG aHeight) = 0;
    virtual HRESULT notifyUpdateImage(ULONG aX,
                                      ULONG aY,
                                      ULONG aWidth,
                                      ULONG aHeight,
                                      const std::vector<BYTE> &aImage) = 0;
    virtual HRESULT notifyChange(ULONG aScreenId,
                                 ULONG aXOrigin,
                                 ULONG aYOrigin,
                                 ULONG aWidth,
                                 ULONG aHeight) = 0;
    virtual HRESULT videoModeSupported(ULONG aWidth,
                                       ULONG aHeight,
                                       ULONG aBpp,
                                       BOOL *aSupported) = 0;
    virtual HRESULT getVisibleRegion(BYTE *aRectangles,
                                     ULONG aCount,
                                     ULONG *aCountCopied) = 0;
    virtual HRESULT setVisibleRegion(BYTE *aRectangles,
                                     ULONG aCount) = 0;
    virtual HRESULT processVHWACommand(BYTE *aCommand,
                                       LONG aEnmCmd,
                                       BOOL aFromGuest) = 0;
    virtual HRESULT notify3DEvent(ULONG aType,
                                  const std::vector<BYTE> &aData) = 0;
    /** @} */

    /** @name Wrapped IFramebufferOverlay methods
     * @{ */
    virtual HRESULT move(ULONG aX,
                         ULONG aY) = 0;
    /** @} */

private:
    DECLARE_CLS_COPY_CTOR_ASSIGN_NOOP(FramebufferOverlayWrap); /* Shuts up MSC warning C4625. */

};

#endif // !FramebufferOverlayWrap_H_

