// ##### ENDFILE "ReusableEventWrap.cpp"


// ##### BEGINFILE "GuestSessionEventWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IGuestSessionEvent.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_GUESTSESSIONEVENT

#include "GuestSessionEventWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(GuestSessionEventWrap)

//
// IEvent properties
//

STDMETHODIMP GuestSessionEventWrap::COMGETTER(Type)(VBoxEventType_T *aType)
{
    LogRelFlow(("{%p} %s: enter aType=%p\n", this, "GuestSessionEvent::getType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSIONEVENT_GET_TYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getType(aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSIONEVENT_GET_TYPE_RETURN(this, hrc, 0 /*normal*/,*aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSIONEVENT_GET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSIONEVENT_GET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aType=%RU32 hrc=%Rhrc\n", this, "GuestSessionEvent::getType", *aType, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionEventWrap::COMGETTER(Source)(IEventSource **aSource)
{
    LogRelFlow(("{%p} %s: enter aSource=%p\n", this, "GuestSessionEvent::getSource", aSource));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSource);
        ComTypeOutConverter<IEventSource> TmpSource(aSource);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSIONEVENT_GET_SOURCE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSource(TmpSource.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSIONEVENT_GET_SOURCE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpSource.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSIONEVENT_GET_SOURCE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSIONEVENT_GET_SOURCE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSource=%p hrc=%Rhrc\n", this, "GuestSessionEvent::getSource", *aSource, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionEventWrap::COMGETTER(Waitable)(BOOL *aWaitable)
{
    LogRelFlow(("{%p} %s: enter aWaitable=%p\n", this, "GuestSessionEvent::getWaitable", aWaitable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWaitable);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSIONEVENT_GET_WAITABLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getWaitable(aWaitable);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSIONEVENT_GET_WAITABLE_RETURN(this, hrc, 0 /*normal*/,*aWaitable != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSIONEVENT_GET_WAITABLE_RETURN(this, hrc, 1 /*hrc exception*/,*aWaitable != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSIONEVENT_GET_WAITABLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aWaitable != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aWaitable=%RTbool hrc=%Rhrc\n", this, "GuestSessionEvent::getWaitable", *aWaitable, hrc));
    return hrc;
}

//
// IGuestSessionEvent properties
//

STDMETHODIMP GuestSessionEventWrap::COMGETTER(Session)(IGuestSession **aSession)
{
    LogRelFlow(("{%p} %s: enter aSession=%p\n", this, "GuestSessionEvent::getSession", aSession));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSession);
        ComTypeOutConverter<IGuestSession> TmpSession(aSession);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSIONEVENT_GET_SESSION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSession(TmpSession.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSIONEVENT_GET_SESSION_RETURN(this, hrc, 0 /*normal*/,(void *)TmpSession.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSIONEVENT_GET_SESSION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSIONEVENT_GET_SESSION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSession=%p hrc=%Rhrc\n", this, "GuestSessionEvent::getSession", *aSession, hrc));
    return hrc;
}


//
// IEvent methods
//

STDMETHODIMP GuestSessionEventWrap::SetProcessed()
{
    LogRelFlow(("{%p} %s:enter\n", this, "GuestSessionEvent::setProcessed"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSIONEVENT_SETPROCESSED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setProcessed();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSIONEVENT_SETPROCESSED_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSIONEVENT_SETPROCESSED_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSIONEVENT_SETPROCESSED_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestSessionEvent::setProcessed", hrc));
    return hrc;
}

STDMETHODIMP GuestSessionEventWrap::WaitProcessed(LONG aTimeout,
                                                  BOOL *aResult)
{
    LogRelFlow(("{%p} %s:enter aTimeout=%RI32 aResult=%p\n", this, "GuestSessionEvent::waitProcessed", aTimeout, aResult));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aResult);


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSIONEVENT_WAITPROCESSED_ENTER(this, aTimeout);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = waitProcessed(aTimeout,
                                aResult);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSIONEVENT_WAITPROCESSED_RETURN(this, hrc, 0 /*normal*/, aTimeout, *aResult != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSIONEVENT_WAITPROCESSED_RETURN(this, hrc, 1 /*hrc exception*/, aTimeout, *aResult != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSIONEVENT_WAITPROCESSED_RETURN(this, hrc, 9 /*unhandled exception*/, aTimeout, *aResult != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aResult=%RTbool hrc=%Rhrc\n", this, "GuestSessionEvent::waitProcessed", *aResult, hrc));
    return hrc;
}

//
// IGuestSessionEvent methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestSessionEventWrap)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(GuestSessionEventWrap, IGuestSessionEvent, IEvent)
#endif // VBOX_WITH_XPCOM

