// ##### ENDFILE "MediumIOWrap.cpp"


// ##### BEGINFILE "MousePointerShapeWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IMousePointerShape.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_MOUSEPOINTERSHAPE

#include "MousePointerShapeWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(MousePointerShapeWrap)

//
// IMousePointerShape properties
//

STDMETHODIMP MousePointerShapeWrap::COMGETTER(Visible)(BOOL *aVisible)
{
    LogRelFlow(("{%p} %s: enter aVisible=%p\n", this, "MousePointerShape::getVisible", aVisible));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVisible);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_VISIBLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVisible(aVisible);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_VISIBLE_RETURN(this, hrc, 0 /*normal*/,*aVisible != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_VISIBLE_RETURN(this, hrc, 1 /*hrc exception*/,*aVisible != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_VISIBLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aVisible != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVisible=%RTbool hrc=%Rhrc\n", this, "MousePointerShape::getVisible", *aVisible, hrc));
    return hrc;
}

STDMETHODIMP MousePointerShapeWrap::COMGETTER(Alpha)(BOOL *aAlpha)
{
    LogRelFlow(("{%p} %s: enter aAlpha=%p\n", this, "MousePointerShape::getAlpha", aAlpha));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAlpha);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_ALPHA_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAlpha(aAlpha);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_ALPHA_RETURN(this, hrc, 0 /*normal*/,*aAlpha != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_ALPHA_RETURN(this, hrc, 1 /*hrc exception*/,*aAlpha != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_ALPHA_RETURN(this, hrc, 9 /*unhandled exception*/,*aAlpha != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAlpha=%RTbool hrc=%Rhrc\n", this, "MousePointerShape::getAlpha", *aAlpha, hrc));
    return hrc;
}

STDMETHODIMP MousePointerShapeWrap::COMGETTER(HotX)(ULONG *aHotX)
{
    LogRelFlow(("{%p} %s: enter aHotX=%p\n", this, "MousePointerShape::getHotX", aHotX));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHotX);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_HOTX_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHotX(aHotX);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_HOTX_RETURN(this, hrc, 0 /*normal*/,*aHotX);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_HOTX_RETURN(this, hrc, 1 /*hrc exception*/,*aHotX);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_HOTX_RETURN(this, hrc, 9 /*unhandled exception*/,*aHotX);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHotX=%RU32 hrc=%Rhrc\n", this, "MousePointerShape::getHotX", *aHotX, hrc));
    return hrc;
}

STDMETHODIMP MousePointerShapeWrap::COMGETTER(HotY)(ULONG *aHotY)
{
    LogRelFlow(("{%p} %s: enter aHotY=%p\n", this, "MousePointerShape::getHotY", aHotY));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHotY);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_HOTY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHotY(aHotY);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_HOTY_RETURN(this, hrc, 0 /*normal*/,*aHotY);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_HOTY_RETURN(this, hrc, 1 /*hrc exception*/,*aHotY);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_HOTY_RETURN(this, hrc, 9 /*unhandled exception*/,*aHotY);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHotY=%RU32 hrc=%Rhrc\n", this, "MousePointerShape::getHotY", *aHotY, hrc));
    return hrc;
}

STDMETHODIMP MousePointerShapeWrap::COMGETTER(Width)(ULONG *aWidth)
{
    LogRelFlow(("{%p} %s: enter aWidth=%p\n", this, "MousePointerShape::getWidth", aWidth));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWidth);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_WIDTH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getWidth(aWidth);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_WIDTH_RETURN(this, hrc, 0 /*normal*/,*aWidth);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_WIDTH_RETURN(this, hrc, 1 /*hrc exception*/,*aWidth);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_WIDTH_RETURN(this, hrc, 9 /*unhandled exception*/,*aWidth);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aWidth=%RU32 hrc=%Rhrc\n", this, "MousePointerShape::getWidth", *aWidth, hrc));
    return hrc;
}

STDMETHODIMP MousePointerShapeWrap::COMGETTER(Height)(ULONG *aHeight)
{
    LogRelFlow(("{%p} %s: enter aHeight=%p\n", this, "MousePointerShape::getHeight", aHeight));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHeight);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_HEIGHT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHeight(aHeight);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_HEIGHT_RETURN(this, hrc, 0 /*normal*/,*aHeight);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_HEIGHT_RETURN(this, hrc, 1 /*hrc exception*/,*aHeight);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_HEIGHT_RETURN(this, hrc, 9 /*unhandled exception*/,*aHeight);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHeight=%RU32 hrc=%Rhrc\n", this, "MousePointerShape::getHeight", *aHeight, hrc));
    return hrc;
}

STDMETHODIMP MousePointerShapeWrap::COMGETTER(Shape)(ComSafeArrayOut(BYTE, aShape))
{
    LogRelFlow(("{%p} %s: enter aShape=%p\n", this, "MousePointerShape::getShape", aShape));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aShape);
        ArrayOutConverter<BYTE> TmpShape(ComSafeArrayOutArg(aShape));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_SHAPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getShape(TmpShape.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_SHAPE_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpShape.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_SHAPE_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSEPOINTERSHAPE_GET_SHAPE_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aShape=%zu hrc=%Rhrc\n", this, "MousePointerShape::getShape", ComSafeArraySize(*aShape), hrc));
    return hrc;
}

STDMETHODIMP MousePointerShapeWrap::COMGETTER(InternalAndReservedAttribute1IMousePointerShape)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MousePointerShapeWrap::COMGETTER(InternalAndReservedAttribute2IMousePointerShape)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MousePointerShapeWrap::COMGETTER(InternalAndReservedAttribute3IMousePointerShape)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MousePointerShapeWrap::COMGETTER(InternalAndReservedAttribute4IMousePointerShape)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IMousePointerShape methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(MousePointerShapeWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(MousePointerShapeWrap, IMousePointerShape)
#endif // VBOX_WITH_XPCOM

