// ##### ENDFILE "USBDeviceWrap.cpp"


// ##### BEGINFILE "USBProxyBackendWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IUSBProxyBackend.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_USBPROXYBACKEND

#include "USBProxyBackendWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(USBProxyBackendWrap)

//
// IUSBProxyBackend properties
//

STDMETHODIMP USBProxyBackendWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "USBProxyBackend::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBPROXYBACKEND_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBPROXYBACKEND_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBPROXYBACKEND_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBPROXYBACKEND_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "USBProxyBackend::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP USBProxyBackendWrap::COMGETTER(Type)(BSTR *aType)
{
    LogRelFlow(("{%p} %s: enter aType=%p\n", this, "USBProxyBackend::getType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aType);
        BSTROutConverter TmpType(aType);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBPROXYBACKEND_GET_TYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getType(TmpType.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBPROXYBACKEND_GET_TYPE_RETURN(this, hrc, 0 /*normal*/,TmpType.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBPROXYBACKEND_GET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBPROXYBACKEND_GET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aType=%ls hrc=%Rhrc\n", this, "USBProxyBackend::getType", *aType, hrc));
    return hrc;
}

STDMETHODIMP USBProxyBackendWrap::COMGETTER(InternalAndReservedAttribute1IUSBProxyBackend)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP USBProxyBackendWrap::COMGETTER(InternalAndReservedAttribute2IUSBProxyBackend)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP USBProxyBackendWrap::COMGETTER(InternalAndReservedAttribute3IUSBProxyBackend)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP USBProxyBackendWrap::COMGETTER(InternalAndReservedAttribute4IUSBProxyBackend)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP USBProxyBackendWrap::COMGETTER(InternalAndReservedAttribute5IUSBProxyBackend)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP USBProxyBackendWrap::COMGETTER(InternalAndReservedAttribute6IUSBProxyBackend)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP USBProxyBackendWrap::COMGETTER(InternalAndReservedAttribute7IUSBProxyBackend)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP USBProxyBackendWrap::COMGETTER(InternalAndReservedAttribute8IUSBProxyBackend)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IUSBProxyBackend methods
//

STDMETHODIMP USBProxyBackendWrap::InternalAndReservedMethod1IUSBProxyBackend()
{
    return E_NOTIMPL;
}

STDMETHODIMP USBProxyBackendWrap::InternalAndReservedMethod2IUSBProxyBackend()
{
    return E_NOTIMPL;
}

STDMETHODIMP USBProxyBackendWrap::InternalAndReservedMethod3IUSBProxyBackend()
{
    return E_NOTIMPL;
}

STDMETHODIMP USBProxyBackendWrap::InternalAndReservedMethod4IUSBProxyBackend()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(USBProxyBackendWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(USBProxyBackendWrap, IUSBProxyBackend)
#endif // VBOX_WITH_XPCOM

