// ##### ENDFILE "VetoEventWrap.cpp"


// ##### BEGINFILE "BooleanFormValueWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IBooleanFormValue.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_BOOLEANFORMVALUE

#include "BooleanFormValueWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(BooleanFormValueWrap)

//
// IFormValue properties
//

STDMETHODIMP BooleanFormValueWrap::COMGETTER(Type)(FormValueType_T *aType)
{
    LogRelFlow(("{%p} %s: enter aType=%p\n", this, "BooleanFormValue::getType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_TYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getType(aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_TYPE_RETURN(this, hrc, 0 /*normal*/,*aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aType=%RU32 hrc=%Rhrc\n", this, "BooleanFormValue::getType", *aType, hrc));
    return hrc;
}

STDMETHODIMP BooleanFormValueWrap::COMGETTER(Generation)(LONG *aGeneration)
{
    LogRelFlow(("{%p} %s: enter aGeneration=%p\n", this, "BooleanFormValue::getGeneration", aGeneration));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGeneration);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_GENERATION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGeneration(aGeneration);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_GENERATION_RETURN(this, hrc, 0 /*normal*/,*aGeneration);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_GENERATION_RETURN(this, hrc, 1 /*hrc exception*/,*aGeneration);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_GENERATION_RETURN(this, hrc, 9 /*unhandled exception*/,*aGeneration);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aGeneration=%RI32 hrc=%Rhrc\n", this, "BooleanFormValue::getGeneration", *aGeneration, hrc));
    return hrc;
}

STDMETHODIMP BooleanFormValueWrap::COMGETTER(Enabled)(BOOL *aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%p\n", this, "BooleanFormValue::getEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_ENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEnabled(aEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_ENABLED_RETURN(this, hrc, 0 /*normal*/,*aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEnabled=%RTbool hrc=%Rhrc\n", this, "BooleanFormValue::getEnabled", *aEnabled, hrc));
    return hrc;
}

STDMETHODIMP BooleanFormValueWrap::COMGETTER(Visible)(BOOL *aVisible)
{
    LogRelFlow(("{%p} %s: enter aVisible=%p\n", this, "BooleanFormValue::getVisible", aVisible));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVisible);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_VISIBLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVisible(aVisible);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_VISIBLE_RETURN(this, hrc, 0 /*normal*/,*aVisible != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_VISIBLE_RETURN(this, hrc, 1 /*hrc exception*/,*aVisible != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_VISIBLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aVisible != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVisible=%RTbool hrc=%Rhrc\n", this, "BooleanFormValue::getVisible", *aVisible, hrc));
    return hrc;
}

STDMETHODIMP BooleanFormValueWrap::COMGETTER(Label)(BSTR *aLabel)
{
    LogRelFlow(("{%p} %s: enter aLabel=%p\n", this, "BooleanFormValue::getLabel", aLabel));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLabel);
        BSTROutConverter TmpLabel(aLabel);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_LABEL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLabel(TmpLabel.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_LABEL_RETURN(this, hrc, 0 /*normal*/,TmpLabel.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_LABEL_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_LABEL_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLabel=%ls hrc=%Rhrc\n", this, "BooleanFormValue::getLabel", *aLabel, hrc));
    return hrc;
}

STDMETHODIMP BooleanFormValueWrap::COMGETTER(Description)(BSTR *aDescription)
{
    LogRelFlow(("{%p} %s: enter aDescription=%p\n", this, "BooleanFormValue::getDescription", aDescription));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDescription);
        BSTROutConverter TmpDescription(aDescription);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_DESCRIPTION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDescription(TmpDescription.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_DESCRIPTION_RETURN(this, hrc, 0 /*normal*/,TmpDescription.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_DESCRIPTION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_DESCRIPTION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDescription=%ls hrc=%Rhrc\n", this, "BooleanFormValue::getDescription", *aDescription, hrc));
    return hrc;
}

STDMETHODIMP BooleanFormValueWrap::COMGETTER(Help)(BSTR *aHelp)
{
    LogRelFlow(("{%p} %s: enter aHelp=%p\n", this, "BooleanFormValue::getHelp", aHelp));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHelp);
        BSTROutConverter TmpHelp(aHelp);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_HELP_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHelp(TmpHelp.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_HELP_RETURN(this, hrc, 0 /*normal*/,TmpHelp.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_HELP_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GET_HELP_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHelp=%ls hrc=%Rhrc\n", this, "BooleanFormValue::getHelp", *aHelp, hrc));
    return hrc;
}

STDMETHODIMP BooleanFormValueWrap::COMGETTER(InternalAndReservedAttribute1IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP BooleanFormValueWrap::COMGETTER(InternalAndReservedAttribute2IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP BooleanFormValueWrap::COMGETTER(InternalAndReservedAttribute3IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP BooleanFormValueWrap::COMGETTER(InternalAndReservedAttribute4IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP BooleanFormValueWrap::COMGETTER(InternalAndReservedAttribute5IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP BooleanFormValueWrap::COMGETTER(InternalAndReservedAttribute6IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP BooleanFormValueWrap::COMGETTER(InternalAndReservedAttribute7IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP BooleanFormValueWrap::COMGETTER(InternalAndReservedAttribute8IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

//
// IBooleanFormValue properties
//

STDMETHODIMP BooleanFormValueWrap::COMGETTER(InternalAndReservedAttribute1IBooleanFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP BooleanFormValueWrap::COMGETTER(InternalAndReservedAttribute2IBooleanFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP BooleanFormValueWrap::COMGETTER(InternalAndReservedAttribute3IBooleanFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP BooleanFormValueWrap::COMGETTER(InternalAndReservedAttribute4IBooleanFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IFormValue methods
//

STDMETHODIMP BooleanFormValueWrap::InternalAndReservedMethod1IFormValue()
{
    return E_NOTIMPL;
}

STDMETHODIMP BooleanFormValueWrap::InternalAndReservedMethod2IFormValue()
{
    return E_NOTIMPL;
}

STDMETHODIMP BooleanFormValueWrap::InternalAndReservedMethod3IFormValue()
{
    return E_NOTIMPL;
}

STDMETHODIMP BooleanFormValueWrap::InternalAndReservedMethod4IFormValue()
{
    return E_NOTIMPL;
}

//
// IBooleanFormValue methods
//

STDMETHODIMP BooleanFormValueWrap::GetSelected(BOOL *aSelected)
{
    LogRelFlow(("{%p} %s:enter aSelected=%p\n", this, "BooleanFormValue::getSelected", aSelected));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSelected);


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GETSELECTED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSelected(aSelected);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GETSELECTED_RETURN(this, hrc, 0 /*normal*/, *aSelected != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GETSELECTED_RETURN(this, hrc, 1 /*hrc exception*/, *aSelected != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_GETSELECTED_RETURN(this, hrc, 9 /*unhandled exception*/, *aSelected != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aSelected=%RTbool hrc=%Rhrc\n", this, "BooleanFormValue::getSelected", *aSelected, hrc));
    return hrc;
}

STDMETHODIMP BooleanFormValueWrap::SetSelected(BOOL aSelected,
                                               IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aSelected=%RTbool aProgress=%p\n", this, "BooleanFormValue::setSelected", aSelected, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_SETSELECTED_ENTER(this, aSelected != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setSelected(aSelected != FALSE,
                              TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_SETSELECTED_RETURN(this, hrc, 0 /*normal*/, aSelected != FALSE, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_SETSELECTED_RETURN(this, hrc, 1 /*hrc exception*/, aSelected != FALSE, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BOOLEANFORMVALUE_SETSELECTED_RETURN(this, hrc, 9 /*unhandled exception*/, aSelected != FALSE, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "BooleanFormValue::setSelected", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP BooleanFormValueWrap::InternalAndReservedMethod1IBooleanFormValue()
{
    return E_NOTIMPL;
}

STDMETHODIMP BooleanFormValueWrap::InternalAndReservedMethod2IBooleanFormValue()
{
    return E_NOTIMPL;
}

STDMETHODIMP BooleanFormValueWrap::InternalAndReservedMethod3IBooleanFormValue()
{
    return E_NOTIMPL;
}

STDMETHODIMP BooleanFormValueWrap::InternalAndReservedMethod4IBooleanFormValue()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(BooleanFormValueWrap)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(BooleanFormValueWrap, IBooleanFormValue, IFormValue)
#endif // VBOX_WITH_XPCOM

