// ##### ENDFILE "MouseWrap.cpp"


// ##### BEGINFILE "FramebufferOverlayWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IFramebufferOverlay.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_FRAMEBUFFEROVERLAY

#include "FramebufferOverlayWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(FramebufferOverlayWrap)

//
// IFramebuffer properties
//

STDMETHODIMP FramebufferOverlayWrap::COMGETTER(Width)(ULONG *aWidth)
{
    LogRelFlow(("{%p} %s: enter aWidth=%p\n", this, "FramebufferOverlay::getWidth", aWidth));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWidth);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_WIDTH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getWidth(aWidth);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_WIDTH_RETURN(this, hrc, 0 /*normal*/,*aWidth);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_WIDTH_RETURN(this, hrc, 1 /*hrc exception*/,*aWidth);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_WIDTH_RETURN(this, hrc, 9 /*unhandled exception*/,*aWidth);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aWidth=%RU32 hrc=%Rhrc\n", this, "FramebufferOverlay::getWidth", *aWidth, hrc));
    return hrc;
}

STDMETHODIMP FramebufferOverlayWrap::COMGETTER(Height)(ULONG *aHeight)
{
    LogRelFlow(("{%p} %s: enter aHeight=%p\n", this, "FramebufferOverlay::getHeight", aHeight));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHeight);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_HEIGHT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHeight(aHeight);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_HEIGHT_RETURN(this, hrc, 0 /*normal*/,*aHeight);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_HEIGHT_RETURN(this, hrc, 1 /*hrc exception*/,*aHeight);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_HEIGHT_RETURN(this, hrc, 9 /*unhandled exception*/,*aHeight);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHeight=%RU32 hrc=%Rhrc\n", this, "FramebufferOverlay::getHeight", *aHeight, hrc));
    return hrc;
}

STDMETHODIMP FramebufferOverlayWrap::COMGETTER(BitsPerPixel)(ULONG *aBitsPerPixel)
{
    LogRelFlow(("{%p} %s: enter aBitsPerPixel=%p\n", this, "FramebufferOverlay::getBitsPerPixel", aBitsPerPixel));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBitsPerPixel);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_BITSPERPIXEL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getBitsPerPixel(aBitsPerPixel);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_BITSPERPIXEL_RETURN(this, hrc, 0 /*normal*/,*aBitsPerPixel);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_BITSPERPIXEL_RETURN(this, hrc, 1 /*hrc exception*/,*aBitsPerPixel);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_BITSPERPIXEL_RETURN(this, hrc, 9 /*unhandled exception*/,*aBitsPerPixel);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aBitsPerPixel=%RU32 hrc=%Rhrc\n", this, "FramebufferOverlay::getBitsPerPixel", *aBitsPerPixel, hrc));
    return hrc;
}

STDMETHODIMP FramebufferOverlayWrap::COMGETTER(BytesPerLine)(ULONG *aBytesPerLine)
{
    LogRelFlow(("{%p} %s: enter aBytesPerLine=%p\n", this, "FramebufferOverlay::getBytesPerLine", aBytesPerLine));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBytesPerLine);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_BYTESPERLINE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getBytesPerLine(aBytesPerLine);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_BYTESPERLINE_RETURN(this, hrc, 0 /*normal*/,*aBytesPerLine);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_BYTESPERLINE_RETURN(this, hrc, 1 /*hrc exception*/,*aBytesPerLine);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_BYTESPERLINE_RETURN(this, hrc, 9 /*unhandled exception*/,*aBytesPerLine);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aBytesPerLine=%RU32 hrc=%Rhrc\n", this, "FramebufferOverlay::getBytesPerLine", *aBytesPerLine, hrc));
    return hrc;
}

STDMETHODIMP FramebufferOverlayWrap::COMGETTER(PixelFormat)(BitmapFormat_T *aPixelFormat)
{
    LogRelFlow(("{%p} %s: enter aPixelFormat=%p\n", this, "FramebufferOverlay::getPixelFormat", aPixelFormat));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPixelFormat);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_PIXELFORMAT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPixelFormat(aPixelFormat);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_PIXELFORMAT_RETURN(this, hrc, 0 /*normal*/,*aPixelFormat);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_PIXELFORMAT_RETURN(this, hrc, 1 /*hrc exception*/,*aPixelFormat);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_PIXELFORMAT_RETURN(this, hrc, 9 /*unhandled exception*/,*aPixelFormat);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPixelFormat=%RU32 hrc=%Rhrc\n", this, "FramebufferOverlay::getPixelFormat", *aPixelFormat, hrc));
    return hrc;
}

STDMETHODIMP FramebufferOverlayWrap::COMGETTER(HeightReduction)(ULONG *aHeightReduction)
{
    LogRelFlow(("{%p} %s: enter aHeightReduction=%p\n", this, "FramebufferOverlay::getHeightReduction", aHeightReduction));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHeightReduction);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_HEIGHTREDUCTION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHeightReduction(aHeightReduction);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_HEIGHTREDUCTION_RETURN(this, hrc, 0 /*normal*/,*aHeightReduction);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_HEIGHTREDUCTION_RETURN(this, hrc, 1 /*hrc exception*/,*aHeightReduction);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_HEIGHTREDUCTION_RETURN(this, hrc, 9 /*unhandled exception*/,*aHeightReduction);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHeightReduction=%RU32 hrc=%Rhrc\n", this, "FramebufferOverlay::getHeightReduction", *aHeightReduction, hrc));
    return hrc;
}

STDMETHODIMP FramebufferOverlayWrap::COMGETTER(Overlay)(IFramebufferOverlay **aOverlay)
{
    LogRelFlow(("{%p} %s: enter aOverlay=%p\n", this, "FramebufferOverlay::getOverlay", aOverlay));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOverlay);
        ComTypeOutConverter<IFramebufferOverlay> TmpOverlay(aOverlay);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_OVERLAY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getOverlay(TmpOverlay.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_OVERLAY_RETURN(this, hrc, 0 /*normal*/,(void *)TmpOverlay.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_OVERLAY_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_OVERLAY_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aOverlay=%p hrc=%Rhrc\n", this, "FramebufferOverlay::getOverlay", *aOverlay, hrc));
    return hrc;
}

STDMETHODIMP FramebufferOverlayWrap::COMGETTER(WinId)(LONG64 *aWinId)
{
    LogRelFlow(("{%p} %s: enter aWinId=%p\n", this, "FramebufferOverlay::getWinId", aWinId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWinId);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_WINID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getWinId(aWinId);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_WINID_RETURN(this, hrc, 0 /*normal*/,*aWinId);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_WINID_RETURN(this, hrc, 1 /*hrc exception*/,*aWinId);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_WINID_RETURN(this, hrc, 9 /*unhandled exception*/,*aWinId);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aWinId=%RI64 hrc=%Rhrc\n", this, "FramebufferOverlay::getWinId", *aWinId, hrc));
    return hrc;
}

STDMETHODIMP FramebufferOverlayWrap::COMGETTER(Capabilities)(ComSafeArrayOut(FramebufferCapabilities_T, aCapabilities))
{
    LogRelFlow(("{%p} %s: enter aCapabilities=%p\n", this, "FramebufferOverlay::getCapabilities", aCapabilities));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCapabilities);
        ArrayOutConverter<FramebufferCapabilities_T> TmpCapabilities(ComSafeArrayOutArg(aCapabilities));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_CAPABILITIES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCapabilities(TmpCapabilities.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_CAPABILITIES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpCapabilities.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_CAPABILITIES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_CAPABILITIES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCapabilities=%zu hrc=%Rhrc\n", this, "FramebufferOverlay::getCapabilities", ComSafeArraySize(*aCapabilities), hrc));
    return hrc;
}

//
// IFramebufferOverlay properties
//

STDMETHODIMP FramebufferOverlayWrap::COMGETTER(X)(ULONG *aX)
{
    LogRelFlow(("{%p} %s: enter aX=%p\n", this, "FramebufferOverlay::getX", aX));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aX);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_X_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getX(aX);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_X_RETURN(this, hrc, 0 /*normal*/,*aX);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_X_RETURN(this, hrc, 1 /*hrc exception*/,*aX);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_X_RETURN(this, hrc, 9 /*unhandled exception*/,*aX);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aX=%RU32 hrc=%Rhrc\n", this, "FramebufferOverlay::getX", *aX, hrc));
    return hrc;
}

STDMETHODIMP FramebufferOverlayWrap::COMGETTER(Y)(ULONG *aY)
{
    LogRelFlow(("{%p} %s: enter aY=%p\n", this, "FramebufferOverlay::getY", aY));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aY);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_Y_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getY(aY);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_Y_RETURN(this, hrc, 0 /*normal*/,*aY);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_Y_RETURN(this, hrc, 1 /*hrc exception*/,*aY);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_Y_RETURN(this, hrc, 9 /*unhandled exception*/,*aY);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aY=%RU32 hrc=%Rhrc\n", this, "FramebufferOverlay::getY", *aY, hrc));
    return hrc;
}

STDMETHODIMP FramebufferOverlayWrap::COMGETTER(Visible)(BOOL *aVisible)
{
    LogRelFlow(("{%p} %s: enter aVisible=%p\n", this, "FramebufferOverlay::getVisible", aVisible));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVisible);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_VISIBLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVisible(aVisible);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_VISIBLE_RETURN(this, hrc, 0 /*normal*/,*aVisible != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_VISIBLE_RETURN(this, hrc, 1 /*hrc exception*/,*aVisible != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_VISIBLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aVisible != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVisible=%RTbool hrc=%Rhrc\n", this, "FramebufferOverlay::getVisible", *aVisible, hrc));
    return hrc;
}

STDMETHODIMP FramebufferOverlayWrap::COMSETTER(Visible)(BOOL aVisible)
{
    LogRelFlow(("{%p} %s: enter aVisible=%RTbool\n", this, "FramebufferOverlay::setVisible", aVisible));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_SET_VISIBLE_ENTER(this, aVisible != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setVisible(aVisible != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_SET_VISIBLE_RETURN(this, hrc, 0 /*normal*/,aVisible != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_SET_VISIBLE_RETURN(this, hrc, 1 /*hrc exception*/,aVisible != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_SET_VISIBLE_RETURN(this, hrc, 9 /*unhandled exception*/,aVisible != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "FramebufferOverlay::setVisible", hrc));
    return hrc;
}

STDMETHODIMP FramebufferOverlayWrap::COMGETTER(Alpha)(ULONG *aAlpha)
{
    LogRelFlow(("{%p} %s: enter aAlpha=%p\n", this, "FramebufferOverlay::getAlpha", aAlpha));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAlpha);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_ALPHA_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAlpha(aAlpha);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_ALPHA_RETURN(this, hrc, 0 /*normal*/,*aAlpha);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_ALPHA_RETURN(this, hrc, 1 /*hrc exception*/,*aAlpha);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GET_ALPHA_RETURN(this, hrc, 9 /*unhandled exception*/,*aAlpha);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAlpha=%RU32 hrc=%Rhrc\n", this, "FramebufferOverlay::getAlpha", *aAlpha, hrc));
    return hrc;
}

STDMETHODIMP FramebufferOverlayWrap::COMSETTER(Alpha)(ULONG aAlpha)
{
    LogRelFlow(("{%p} %s: enter aAlpha=%RU32\n", this, "FramebufferOverlay::setAlpha", aAlpha));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_SET_ALPHA_ENTER(this, aAlpha);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAlpha(aAlpha);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_SET_ALPHA_RETURN(this, hrc, 0 /*normal*/,aAlpha);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_SET_ALPHA_RETURN(this, hrc, 1 /*hrc exception*/,aAlpha);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_SET_ALPHA_RETURN(this, hrc, 9 /*unhandled exception*/,aAlpha);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "FramebufferOverlay::setAlpha", hrc));
    return hrc;
}


//
// IFramebuffer methods
//

STDMETHODIMP FramebufferOverlayWrap::NotifyUpdate(ULONG aX,
                                                  ULONG aY,
                                                  ULONG aWidth,
                                                  ULONG aHeight)
{
    LogRelFlow(("{%p} %s:enter aX=%RU32 aY=%RU32 aWidth=%RU32 aHeight=%RU32\n", this, "FramebufferOverlay::notifyUpdate", aX, aY, aWidth, aHeight));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_NOTIFYUPDATE_ENTER(this, aX, aY, aWidth, aHeight);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = notifyUpdate(aX,
                               aY,
                               aWidth,
                               aHeight);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_NOTIFYUPDATE_RETURN(this, hrc, 0 /*normal*/, aX, aY, aWidth, aHeight);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_NOTIFYUPDATE_RETURN(this, hrc, 1 /*hrc exception*/, aX, aY, aWidth, aHeight);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_NOTIFYUPDATE_RETURN(this, hrc, 9 /*unhandled exception*/, aX, aY, aWidth, aHeight);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "FramebufferOverlay::notifyUpdate", hrc));
    return hrc;
}

STDMETHODIMP FramebufferOverlayWrap::NotifyUpdateImage(ULONG aX,
                                                       ULONG aY,
                                                       ULONG aWidth,
                                                       ULONG aHeight,
                                                       ComSafeArrayIn(BYTE, aImage))
{
    LogRelFlow(("{%p} %s:enter aX=%RU32 aY=%RU32 aWidth=%RU32 aHeight=%RU32 aImage=%zu\n", this, "FramebufferOverlay::notifyUpdateImage", aX, aY, aWidth, aHeight, aImage));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        
        
        
        ArrayInConverter<BYTE> TmpImage(ComSafeArrayInArg(aImage));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_NOTIFYUPDATEIMAGE_ENTER(this, aX, aY, aWidth, aHeight, (uint32_t)TmpImage.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = notifyUpdateImage(aX,
                                    aY,
                                    aWidth,
                                    aHeight,
                                    TmpImage.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_NOTIFYUPDATEIMAGE_RETURN(this, hrc, 0 /*normal*/, aX, aY, aWidth, aHeight, (uint32_t)TmpImage.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_NOTIFYUPDATEIMAGE_RETURN(this, hrc, 1 /*hrc exception*/, aX, aY, aWidth, aHeight, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_NOTIFYUPDATEIMAGE_RETURN(this, hrc, 9 /*unhandled exception*/, aX, aY, aWidth, aHeight, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "FramebufferOverlay::notifyUpdateImage", hrc));
    return hrc;
}

STDMETHODIMP FramebufferOverlayWrap::NotifyChange(ULONG aScreenId,
                                                  ULONG aXOrigin,
                                                  ULONG aYOrigin,
                                                  ULONG aWidth,
                                                  ULONG aHeight)
{
    LogRelFlow(("{%p} %s:enter aScreenId=%RU32 aXOrigin=%RU32 aYOrigin=%RU32 aWidth=%RU32 aHeight=%RU32\n", this, "FramebufferOverlay::notifyChange", aScreenId, aXOrigin, aYOrigin, aWidth, aHeight));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_NOTIFYCHANGE_ENTER(this, aScreenId, aXOrigin, aYOrigin, aWidth, aHeight);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = notifyChange(aScreenId,
                               aXOrigin,
                               aYOrigin,
                               aWidth,
                               aHeight);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_NOTIFYCHANGE_RETURN(this, hrc, 0 /*normal*/, aScreenId, aXOrigin, aYOrigin, aWidth, aHeight);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_NOTIFYCHANGE_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, aXOrigin, aYOrigin, aWidth, aHeight);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_NOTIFYCHANGE_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, aXOrigin, aYOrigin, aWidth, aHeight);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "FramebufferOverlay::notifyChange", hrc));
    return hrc;
}

STDMETHODIMP FramebufferOverlayWrap::VideoModeSupported(ULONG aWidth,
                                                        ULONG aHeight,
                                                        ULONG aBpp,
                                                        BOOL *aSupported)
{
    LogRelFlow(("{%p} %s:enter aWidth=%RU32 aHeight=%RU32 aBpp=%RU32 aSupported=%p\n", this, "FramebufferOverlay::videoModeSupported", aWidth, aHeight, aBpp, aSupported));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupported);


        
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_VIDEOMODESUPPORTED_ENTER(this, aWidth, aHeight, aBpp);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = videoModeSupported(aWidth,
                                     aHeight,
                                     aBpp,
                                     aSupported);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_VIDEOMODESUPPORTED_RETURN(this, hrc, 0 /*normal*/, aWidth, aHeight, aBpp, *aSupported != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_VIDEOMODESUPPORTED_RETURN(this, hrc, 1 /*hrc exception*/, aWidth, aHeight, aBpp, *aSupported != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_VIDEOMODESUPPORTED_RETURN(this, hrc, 9 /*unhandled exception*/, aWidth, aHeight, aBpp, *aSupported != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aSupported=%RTbool hrc=%Rhrc\n", this, "FramebufferOverlay::videoModeSupported", *aSupported, hrc));
    return hrc;
}

STDMETHODIMP FramebufferOverlayWrap::GetVisibleRegion(BYTE *aRectangles,
                                                      ULONG aCount,
                                                      ULONG *aCountCopied)
{
    LogRelFlow(("{%p} %s:enter aRectangles=%p aCount=%RU32 aCountCopied=%p\n", this, "FramebufferOverlay::getVisibleRegion", aRectangles, aCount, aCountCopied));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCountCopied);


        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GETVISIBLEREGION_ENTER(this, aRectangles, aCount);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVisibleRegion(aRectangles,
                                   aCount,
                                   aCountCopied);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GETVISIBLEREGION_RETURN(this, hrc, 0 /*normal*/, aRectangles, aCount, *aCountCopied);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GETVISIBLEREGION_RETURN(this, hrc, 1 /*hrc exception*/, aRectangles, aCount, *aCountCopied);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_GETVISIBLEREGION_RETURN(this, hrc, 9 /*unhandled exception*/, aRectangles, aCount, *aCountCopied);
#endif
    }

    LogRelFlow(("{%p} %s: leave aCountCopied=%RU32 hrc=%Rhrc\n", this, "FramebufferOverlay::getVisibleRegion", *aCountCopied, hrc));
    return hrc;
}

STDMETHODIMP FramebufferOverlayWrap::SetVisibleRegion(BYTE *aRectangles,
                                                      ULONG aCount)
{
    LogRelFlow(("{%p} %s:enter aRectangles=%p aCount=%RU32\n", this, "FramebufferOverlay::setVisibleRegion", aRectangles, aCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_SETVISIBLEREGION_ENTER(this, aRectangles, aCount);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setVisibleRegion(aRectangles,
                                   aCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_SETVISIBLEREGION_RETURN(this, hrc, 0 /*normal*/, aRectangles, aCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_SETVISIBLEREGION_RETURN(this, hrc, 1 /*hrc exception*/, aRectangles, aCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_SETVISIBLEREGION_RETURN(this, hrc, 9 /*unhandled exception*/, aRectangles, aCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "FramebufferOverlay::setVisibleRegion", hrc));
    return hrc;
}

STDMETHODIMP FramebufferOverlayWrap::ProcessVHWACommand(BYTE *aCommand,
                                                        LONG aEnmCmd,
                                                        BOOL aFromGuest)
{
    LogRelFlow(("{%p} %s:enter aCommand=%p aEnmCmd=%RI32 aFromGuest=%RTbool\n", this, "FramebufferOverlay::processVHWACommand", aCommand, aEnmCmd, aFromGuest));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_PROCESSVHWACOMMAND_ENTER(this, aCommand, aEnmCmd, aFromGuest != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = processVHWACommand(aCommand,
                                     aEnmCmd,
                                     aFromGuest != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_PROCESSVHWACOMMAND_RETURN(this, hrc, 0 /*normal*/, aCommand, aEnmCmd, aFromGuest != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_PROCESSVHWACOMMAND_RETURN(this, hrc, 1 /*hrc exception*/, aCommand, aEnmCmd, aFromGuest != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_PROCESSVHWACOMMAND_RETURN(this, hrc, 9 /*unhandled exception*/, aCommand, aEnmCmd, aFromGuest != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "FramebufferOverlay::processVHWACommand", hrc));
    return hrc;
}

STDMETHODIMP FramebufferOverlayWrap::Notify3DEvent(ULONG aType,
                                                   ComSafeArrayIn(BYTE, aData))
{
    LogRelFlow(("{%p} %s:enter aType=%RU32 aData=%zu\n", this, "FramebufferOverlay::notify3DEvent", aType, aData));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        ArrayInConverter<BYTE> TmpData(ComSafeArrayInArg(aData));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_NOTIFY3DEVENT_ENTER(this, aType, (uint32_t)TmpData.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = notify3DEvent(aType,
                                TmpData.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_NOTIFY3DEVENT_RETURN(this, hrc, 0 /*normal*/, aType, (uint32_t)TmpData.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_NOTIFY3DEVENT_RETURN(this, hrc, 1 /*hrc exception*/, aType, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_NOTIFY3DEVENT_RETURN(this, hrc, 9 /*unhandled exception*/, aType, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "FramebufferOverlay::notify3DEvent", hrc));
    return hrc;
}

//
// IFramebufferOverlay methods
//

STDMETHODIMP FramebufferOverlayWrap::Move(ULONG aX,
                                          ULONG aY)
{
    LogRelFlow(("{%p} %s:enter aX=%RU32 aY=%RU32\n", this, "FramebufferOverlay::move", aX, aY));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_MOVE_ENTER(this, aX, aY);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = move(aX,
                       aY);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_MOVE_RETURN(this, hrc, 0 /*normal*/, aX, aY);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_MOVE_RETURN(this, hrc, 1 /*hrc exception*/, aX, aY);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FRAMEBUFFEROVERLAY_MOVE_RETURN(this, hrc, 9 /*unhandled exception*/, aX, aY);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "FramebufferOverlay::move", hrc));
    return hrc;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(FramebufferOverlayWrap)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(FramebufferOverlayWrap, IFramebufferOverlay, IFramebuffer)
#endif // VBOX_WITH_XPCOM

