// ##### ENDFILE "ParallelPortWrap.cpp"


// ##### BEGINFILE "MachineDebuggerWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IMachineDebugger.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_MACHINEDEBUGGER

#include "MachineDebuggerWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(MachineDebuggerWrap)

//
// IMachineDebugger properties
//

STDMETHODIMP MachineDebuggerWrap::COMGETTER(SingleStep)(BOOL *aSingleStep)
{
    LogRelFlow(("{%p} %s: enter aSingleStep=%p\n", this, "MachineDebugger::getSingleStep", aSingleStep));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSingleStep);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_SINGLESTEP_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSingleStep(aSingleStep);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_SINGLESTEP_RETURN(this, hrc, 0 /*normal*/,*aSingleStep != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_SINGLESTEP_RETURN(this, hrc, 1 /*hrc exception*/,*aSingleStep != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_SINGLESTEP_RETURN(this, hrc, 9 /*unhandled exception*/,*aSingleStep != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSingleStep=%RTbool hrc=%Rhrc\n", this, "MachineDebugger::getSingleStep", *aSingleStep, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMSETTER(SingleStep)(BOOL aSingleStep)
{
    LogRelFlow(("{%p} %s: enter aSingleStep=%RTbool\n", this, "MachineDebugger::setSingleStep", aSingleStep));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_SINGLESTEP_ENTER(this, aSingleStep != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setSingleStep(aSingleStep != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_SINGLESTEP_RETURN(this, hrc, 0 /*normal*/,aSingleStep != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_SINGLESTEP_RETURN(this, hrc, 1 /*hrc exception*/,aSingleStep != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_SINGLESTEP_RETURN(this, hrc, 9 /*unhandled exception*/,aSingleStep != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "MachineDebugger::setSingleStep", hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(RecompileUser)(BOOL *aRecompileUser)
{
    LogRelFlow(("{%p} %s: enter aRecompileUser=%p\n", this, "MachineDebugger::getRecompileUser", aRecompileUser));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecompileUser);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_RECOMPILEUSER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecompileUser(aRecompileUser);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_RECOMPILEUSER_RETURN(this, hrc, 0 /*normal*/,*aRecompileUser != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_RECOMPILEUSER_RETURN(this, hrc, 1 /*hrc exception*/,*aRecompileUser != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_RECOMPILEUSER_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecompileUser != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecompileUser=%RTbool hrc=%Rhrc\n", this, "MachineDebugger::getRecompileUser", *aRecompileUser, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMSETTER(RecompileUser)(BOOL aRecompileUser)
{
    LogRelFlow(("{%p} %s: enter aRecompileUser=%RTbool\n", this, "MachineDebugger::setRecompileUser", aRecompileUser));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_RECOMPILEUSER_ENTER(this, aRecompileUser != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setRecompileUser(aRecompileUser != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_RECOMPILEUSER_RETURN(this, hrc, 0 /*normal*/,aRecompileUser != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_RECOMPILEUSER_RETURN(this, hrc, 1 /*hrc exception*/,aRecompileUser != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_RECOMPILEUSER_RETURN(this, hrc, 9 /*unhandled exception*/,aRecompileUser != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "MachineDebugger::setRecompileUser", hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(RecompileSupervisor)(BOOL *aRecompileSupervisor)
{
    LogRelFlow(("{%p} %s: enter aRecompileSupervisor=%p\n", this, "MachineDebugger::getRecompileSupervisor", aRecompileSupervisor));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRecompileSupervisor);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_RECOMPILESUPERVISOR_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRecompileSupervisor(aRecompileSupervisor);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_RECOMPILESUPERVISOR_RETURN(this, hrc, 0 /*normal*/,*aRecompileSupervisor != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_RECOMPILESUPERVISOR_RETURN(this, hrc, 1 /*hrc exception*/,*aRecompileSupervisor != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_RECOMPILESUPERVISOR_RETURN(this, hrc, 9 /*unhandled exception*/,*aRecompileSupervisor != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRecompileSupervisor=%RTbool hrc=%Rhrc\n", this, "MachineDebugger::getRecompileSupervisor", *aRecompileSupervisor, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMSETTER(RecompileSupervisor)(BOOL aRecompileSupervisor)
{
    LogRelFlow(("{%p} %s: enter aRecompileSupervisor=%RTbool\n", this, "MachineDebugger::setRecompileSupervisor", aRecompileSupervisor));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_RECOMPILESUPERVISOR_ENTER(this, aRecompileSupervisor != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setRecompileSupervisor(aRecompileSupervisor != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_RECOMPILESUPERVISOR_RETURN(this, hrc, 0 /*normal*/,aRecompileSupervisor != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_RECOMPILESUPERVISOR_RETURN(this, hrc, 1 /*hrc exception*/,aRecompileSupervisor != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_RECOMPILESUPERVISOR_RETURN(this, hrc, 9 /*unhandled exception*/,aRecompileSupervisor != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "MachineDebugger::setRecompileSupervisor", hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(ExecuteAllInIEM)(BOOL *aExecuteAllInIEM)
{
    LogRelFlow(("{%p} %s: enter aExecuteAllInIEM=%p\n", this, "MachineDebugger::getExecuteAllInIEM", aExecuteAllInIEM));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aExecuteAllInIEM);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_EXECUTEALLINIEM_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getExecuteAllInIEM(aExecuteAllInIEM);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_EXECUTEALLINIEM_RETURN(this, hrc, 0 /*normal*/,*aExecuteAllInIEM != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_EXECUTEALLINIEM_RETURN(this, hrc, 1 /*hrc exception*/,*aExecuteAllInIEM != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_EXECUTEALLINIEM_RETURN(this, hrc, 9 /*unhandled exception*/,*aExecuteAllInIEM != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aExecuteAllInIEM=%RTbool hrc=%Rhrc\n", this, "MachineDebugger::getExecuteAllInIEM", *aExecuteAllInIEM, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMSETTER(ExecuteAllInIEM)(BOOL aExecuteAllInIEM)
{
    LogRelFlow(("{%p} %s: enter aExecuteAllInIEM=%RTbool\n", this, "MachineDebugger::setExecuteAllInIEM", aExecuteAllInIEM));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_EXECUTEALLINIEM_ENTER(this, aExecuteAllInIEM != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setExecuteAllInIEM(aExecuteAllInIEM != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_EXECUTEALLINIEM_RETURN(this, hrc, 0 /*normal*/,aExecuteAllInIEM != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_EXECUTEALLINIEM_RETURN(this, hrc, 1 /*hrc exception*/,aExecuteAllInIEM != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_EXECUTEALLINIEM_RETURN(this, hrc, 9 /*unhandled exception*/,aExecuteAllInIEM != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "MachineDebugger::setExecuteAllInIEM", hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(PATMEnabled)(BOOL *aPATMEnabled)
{
    LogRelFlow(("{%p} %s: enter aPATMEnabled=%p\n", this, "MachineDebugger::getPATMEnabled", aPATMEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPATMEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_PATMENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPATMEnabled(aPATMEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_PATMENABLED_RETURN(this, hrc, 0 /*normal*/,*aPATMEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_PATMENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aPATMEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_PATMENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aPATMEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPATMEnabled=%RTbool hrc=%Rhrc\n", this, "MachineDebugger::getPATMEnabled", *aPATMEnabled, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMSETTER(PATMEnabled)(BOOL aPATMEnabled)
{
    LogRelFlow(("{%p} %s: enter aPATMEnabled=%RTbool\n", this, "MachineDebugger::setPATMEnabled", aPATMEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_PATMENABLED_ENTER(this, aPATMEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setPATMEnabled(aPATMEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_PATMENABLED_RETURN(this, hrc, 0 /*normal*/,aPATMEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_PATMENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aPATMEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_PATMENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aPATMEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "MachineDebugger::setPATMEnabled", hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(CSAMEnabled)(BOOL *aCSAMEnabled)
{
    LogRelFlow(("{%p} %s: enter aCSAMEnabled=%p\n", this, "MachineDebugger::getCSAMEnabled", aCSAMEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCSAMEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_CSAMENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCSAMEnabled(aCSAMEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_CSAMENABLED_RETURN(this, hrc, 0 /*normal*/,*aCSAMEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_CSAMENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aCSAMEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_CSAMENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aCSAMEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCSAMEnabled=%RTbool hrc=%Rhrc\n", this, "MachineDebugger::getCSAMEnabled", *aCSAMEnabled, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMSETTER(CSAMEnabled)(BOOL aCSAMEnabled)
{
    LogRelFlow(("{%p} %s: enter aCSAMEnabled=%RTbool\n", this, "MachineDebugger::setCSAMEnabled", aCSAMEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_CSAMENABLED_ENTER(this, aCSAMEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setCSAMEnabled(aCSAMEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_CSAMENABLED_RETURN(this, hrc, 0 /*normal*/,aCSAMEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_CSAMENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aCSAMEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_CSAMENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aCSAMEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "MachineDebugger::setCSAMEnabled", hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(LogEnabled)(BOOL *aLogEnabled)
{
    LogRelFlow(("{%p} %s: enter aLogEnabled=%p\n", this, "MachineDebugger::getLogEnabled", aLogEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLogEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLogEnabled(aLogEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGENABLED_RETURN(this, hrc, 0 /*normal*/,*aLogEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aLogEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aLogEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLogEnabled=%RTbool hrc=%Rhrc\n", this, "MachineDebugger::getLogEnabled", *aLogEnabled, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMSETTER(LogEnabled)(BOOL aLogEnabled)
{
    LogRelFlow(("{%p} %s: enter aLogEnabled=%RTbool\n", this, "MachineDebugger::setLogEnabled", aLogEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_LOGENABLED_ENTER(this, aLogEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setLogEnabled(aLogEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_LOGENABLED_RETURN(this, hrc, 0 /*normal*/,aLogEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_LOGENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aLogEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_LOGENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aLogEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "MachineDebugger::setLogEnabled", hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(LogDbgFlags)(BSTR *aLogDbgFlags)
{
    LogRelFlow(("{%p} %s: enter aLogDbgFlags=%p\n", this, "MachineDebugger::getLogDbgFlags", aLogDbgFlags));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLogDbgFlags);
        BSTROutConverter TmpLogDbgFlags(aLogDbgFlags);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGDBGFLAGS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLogDbgFlags(TmpLogDbgFlags.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGDBGFLAGS_RETURN(this, hrc, 0 /*normal*/,TmpLogDbgFlags.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGDBGFLAGS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGDBGFLAGS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLogDbgFlags=%ls hrc=%Rhrc\n", this, "MachineDebugger::getLogDbgFlags", *aLogDbgFlags, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(LogDbgGroups)(BSTR *aLogDbgGroups)
{
    LogRelFlow(("{%p} %s: enter aLogDbgGroups=%p\n", this, "MachineDebugger::getLogDbgGroups", aLogDbgGroups));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLogDbgGroups);
        BSTROutConverter TmpLogDbgGroups(aLogDbgGroups);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGDBGGROUPS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLogDbgGroups(TmpLogDbgGroups.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGDBGGROUPS_RETURN(this, hrc, 0 /*normal*/,TmpLogDbgGroups.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGDBGGROUPS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGDBGGROUPS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLogDbgGroups=%ls hrc=%Rhrc\n", this, "MachineDebugger::getLogDbgGroups", *aLogDbgGroups, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(LogDbgDestinations)(BSTR *aLogDbgDestinations)
{
    LogRelFlow(("{%p} %s: enter aLogDbgDestinations=%p\n", this, "MachineDebugger::getLogDbgDestinations", aLogDbgDestinations));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLogDbgDestinations);
        BSTROutConverter TmpLogDbgDestinations(aLogDbgDestinations);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGDBGDESTINATIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLogDbgDestinations(TmpLogDbgDestinations.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGDBGDESTINATIONS_RETURN(this, hrc, 0 /*normal*/,TmpLogDbgDestinations.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGDBGDESTINATIONS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGDBGDESTINATIONS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLogDbgDestinations=%ls hrc=%Rhrc\n", this, "MachineDebugger::getLogDbgDestinations", *aLogDbgDestinations, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(LogRelFlags)(BSTR *aLogRelFlags)
{
    LogRelFlow(("{%p} %s: enter aLogRelFlags=%p\n", this, "MachineDebugger::getLogRelFlags", aLogRelFlags));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLogRelFlags);
        BSTROutConverter TmpLogRelFlags(aLogRelFlags);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGRELFLAGS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLogRelFlags(TmpLogRelFlags.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGRELFLAGS_RETURN(this, hrc, 0 /*normal*/,TmpLogRelFlags.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGRELFLAGS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGRELFLAGS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLogRelFlags=%ls hrc=%Rhrc\n", this, "MachineDebugger::getLogRelFlags", *aLogRelFlags, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(LogRelGroups)(BSTR *aLogRelGroups)
{
    LogRelFlow(("{%p} %s: enter aLogRelGroups=%p\n", this, "MachineDebugger::getLogRelGroups", aLogRelGroups));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLogRelGroups);
        BSTROutConverter TmpLogRelGroups(aLogRelGroups);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGRELGROUPS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLogRelGroups(TmpLogRelGroups.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGRELGROUPS_RETURN(this, hrc, 0 /*normal*/,TmpLogRelGroups.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGRELGROUPS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGRELGROUPS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLogRelGroups=%ls hrc=%Rhrc\n", this, "MachineDebugger::getLogRelGroups", *aLogRelGroups, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(LogRelDestinations)(BSTR *aLogRelDestinations)
{
    LogRelFlow(("{%p} %s: enter aLogRelDestinations=%p\n", this, "MachineDebugger::getLogRelDestinations", aLogRelDestinations));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLogRelDestinations);
        BSTROutConverter TmpLogRelDestinations(aLogRelDestinations);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGRELDESTINATIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLogRelDestinations(TmpLogRelDestinations.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGRELDESTINATIONS_RETURN(this, hrc, 0 /*normal*/,TmpLogRelDestinations.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGRELDESTINATIONS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_LOGRELDESTINATIONS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLogRelDestinations=%ls hrc=%Rhrc\n", this, "MachineDebugger::getLogRelDestinations", *aLogRelDestinations, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(ExecutionEngine)(VMExecutionEngine_T *aExecutionEngine)
{
    LogRelFlow(("{%p} %s: enter aExecutionEngine=%p\n", this, "MachineDebugger::getExecutionEngine", aExecutionEngine));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aExecutionEngine);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_EXECUTIONENGINE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getExecutionEngine(aExecutionEngine);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_EXECUTIONENGINE_RETURN(this, hrc, 0 /*normal*/,*aExecutionEngine);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_EXECUTIONENGINE_RETURN(this, hrc, 1 /*hrc exception*/,*aExecutionEngine);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_EXECUTIONENGINE_RETURN(this, hrc, 9 /*unhandled exception*/,*aExecutionEngine);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aExecutionEngine=%RU32 hrc=%Rhrc\n", this, "MachineDebugger::getExecutionEngine", *aExecutionEngine, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(HWVirtExEnabled)(BOOL *aHWVirtExEnabled)
{
    LogRelFlow(("{%p} %s: enter aHWVirtExEnabled=%p\n", this, "MachineDebugger::getHWVirtExEnabled", aHWVirtExEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHWVirtExEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_HWVIRTEXENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHWVirtExEnabled(aHWVirtExEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_HWVIRTEXENABLED_RETURN(this, hrc, 0 /*normal*/,*aHWVirtExEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_HWVIRTEXENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aHWVirtExEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_HWVIRTEXENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aHWVirtExEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHWVirtExEnabled=%RTbool hrc=%Rhrc\n", this, "MachineDebugger::getHWVirtExEnabled", *aHWVirtExEnabled, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(HWVirtExNestedPagingEnabled)(BOOL *aHWVirtExNestedPagingEnabled)
{
    LogRelFlow(("{%p} %s: enter aHWVirtExNestedPagingEnabled=%p\n", this, "MachineDebugger::getHWVirtExNestedPagingEnabled", aHWVirtExNestedPagingEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHWVirtExNestedPagingEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_HWVIRTEXNESTEDPAGINGENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHWVirtExNestedPagingEnabled(aHWVirtExNestedPagingEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_HWVIRTEXNESTEDPAGINGENABLED_RETURN(this, hrc, 0 /*normal*/,*aHWVirtExNestedPagingEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_HWVIRTEXNESTEDPAGINGENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aHWVirtExNestedPagingEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_HWVIRTEXNESTEDPAGINGENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aHWVirtExNestedPagingEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHWVirtExNestedPagingEnabled=%RTbool hrc=%Rhrc\n", this, "MachineDebugger::getHWVirtExNestedPagingEnabled", *aHWVirtExNestedPagingEnabled, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(HWVirtExVPIDEnabled)(BOOL *aHWVirtExVPIDEnabled)
{
    LogRelFlow(("{%p} %s: enter aHWVirtExVPIDEnabled=%p\n", this, "MachineDebugger::getHWVirtExVPIDEnabled", aHWVirtExVPIDEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHWVirtExVPIDEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_HWVIRTEXVPIDENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHWVirtExVPIDEnabled(aHWVirtExVPIDEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_HWVIRTEXVPIDENABLED_RETURN(this, hrc, 0 /*normal*/,*aHWVirtExVPIDEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_HWVIRTEXVPIDENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aHWVirtExVPIDEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_HWVIRTEXVPIDENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aHWVirtExVPIDEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHWVirtExVPIDEnabled=%RTbool hrc=%Rhrc\n", this, "MachineDebugger::getHWVirtExVPIDEnabled", *aHWVirtExVPIDEnabled, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(HWVirtExUXEnabled)(BOOL *aHWVirtExUXEnabled)
{
    LogRelFlow(("{%p} %s: enter aHWVirtExUXEnabled=%p\n", this, "MachineDebugger::getHWVirtExUXEnabled", aHWVirtExUXEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHWVirtExUXEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_HWVIRTEXUXENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHWVirtExUXEnabled(aHWVirtExUXEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_HWVIRTEXUXENABLED_RETURN(this, hrc, 0 /*normal*/,*aHWVirtExUXEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_HWVIRTEXUXENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aHWVirtExUXEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_HWVIRTEXUXENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aHWVirtExUXEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHWVirtExUXEnabled=%RTbool hrc=%Rhrc\n", this, "MachineDebugger::getHWVirtExUXEnabled", *aHWVirtExUXEnabled, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(OSName)(BSTR *aOSName)
{
    LogRelFlow(("{%p} %s: enter aOSName=%p\n", this, "MachineDebugger::getOSName", aOSName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOSName);
        BSTROutConverter TmpOSName(aOSName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_OSNAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getOSName(TmpOSName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_OSNAME_RETURN(this, hrc, 0 /*normal*/,TmpOSName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_OSNAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_OSNAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aOSName=%ls hrc=%Rhrc\n", this, "MachineDebugger::getOSName", *aOSName, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(OSVersion)(BSTR *aOSVersion)
{
    LogRelFlow(("{%p} %s: enter aOSVersion=%p\n", this, "MachineDebugger::getOSVersion", aOSVersion));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOSVersion);
        BSTROutConverter TmpOSVersion(aOSVersion);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_OSVERSION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getOSVersion(TmpOSVersion.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_OSVERSION_RETURN(this, hrc, 0 /*normal*/,TmpOSVersion.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_OSVERSION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_OSVERSION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aOSVersion=%ls hrc=%Rhrc\n", this, "MachineDebugger::getOSVersion", *aOSVersion, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(PAEEnabled)(BOOL *aPAEEnabled)
{
    LogRelFlow(("{%p} %s: enter aPAEEnabled=%p\n", this, "MachineDebugger::getPAEEnabled", aPAEEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPAEEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_PAEENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPAEEnabled(aPAEEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_PAEENABLED_RETURN(this, hrc, 0 /*normal*/,*aPAEEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_PAEENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aPAEEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_PAEENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aPAEEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPAEEnabled=%RTbool hrc=%Rhrc\n", this, "MachineDebugger::getPAEEnabled", *aPAEEnabled, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(VirtualTimeRate)(ULONG *aVirtualTimeRate)
{
    LogRelFlow(("{%p} %s: enter aVirtualTimeRate=%p\n", this, "MachineDebugger::getVirtualTimeRate", aVirtualTimeRate));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVirtualTimeRate);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_VIRTUALTIMERATE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVirtualTimeRate(aVirtualTimeRate);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_VIRTUALTIMERATE_RETURN(this, hrc, 0 /*normal*/,*aVirtualTimeRate);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_VIRTUALTIMERATE_RETURN(this, hrc, 1 /*hrc exception*/,*aVirtualTimeRate);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_VIRTUALTIMERATE_RETURN(this, hrc, 9 /*unhandled exception*/,*aVirtualTimeRate);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVirtualTimeRate=%RU32 hrc=%Rhrc\n", this, "MachineDebugger::getVirtualTimeRate", *aVirtualTimeRate, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMSETTER(VirtualTimeRate)(ULONG aVirtualTimeRate)
{
    LogRelFlow(("{%p} %s: enter aVirtualTimeRate=%RU32\n", this, "MachineDebugger::setVirtualTimeRate", aVirtualTimeRate));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_VIRTUALTIMERATE_ENTER(this, aVirtualTimeRate);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setVirtualTimeRate(aVirtualTimeRate);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_VIRTUALTIMERATE_RETURN(this, hrc, 0 /*normal*/,aVirtualTimeRate);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_VIRTUALTIMERATE_RETURN(this, hrc, 1 /*hrc exception*/,aVirtualTimeRate);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SET_VIRTUALTIMERATE_RETURN(this, hrc, 9 /*unhandled exception*/,aVirtualTimeRate);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "MachineDebugger::setVirtualTimeRate", hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(VM)(LONG64 *aVM)
{
    LogRelFlow(("{%p} %s: enter aVM=%p\n", this, "MachineDebugger::getVM", aVM));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVM);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_VM_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVM(aVM);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_VM_RETURN(this, hrc, 0 /*normal*/,*aVM);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_VM_RETURN(this, hrc, 1 /*hrc exception*/,*aVM);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_VM_RETURN(this, hrc, 9 /*unhandled exception*/,*aVM);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVM=%RI64 hrc=%Rhrc\n", this, "MachineDebugger::getVM", *aVM, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(Uptime)(LONG64 *aUptime)
{
    LogRelFlow(("{%p} %s: enter aUptime=%p\n", this, "MachineDebugger::getUptime", aUptime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUptime);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_UPTIME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUptime(aUptime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_UPTIME_RETURN(this, hrc, 0 /*normal*/,*aUptime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_UPTIME_RETURN(this, hrc, 1 /*hrc exception*/,*aUptime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GET_UPTIME_RETURN(this, hrc, 9 /*unhandled exception*/,*aUptime);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUptime=%RI64 hrc=%Rhrc\n", this, "MachineDebugger::getUptime", *aUptime, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(InternalAndReservedAttribute1IMachineDebugger)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(InternalAndReservedAttribute2IMachineDebugger)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(InternalAndReservedAttribute3IMachineDebugger)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(InternalAndReservedAttribute4IMachineDebugger)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(InternalAndReservedAttribute5IMachineDebugger)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(InternalAndReservedAttribute6IMachineDebugger)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(InternalAndReservedAttribute7IMachineDebugger)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(InternalAndReservedAttribute8IMachineDebugger)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(InternalAndReservedAttribute9IMachineDebugger)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(InternalAndReservedAttribute10IMachineDebugger)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(InternalAndReservedAttribute11IMachineDebugger)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(InternalAndReservedAttribute12IMachineDebugger)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(InternalAndReservedAttribute13IMachineDebugger)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(InternalAndReservedAttribute14IMachineDebugger)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(InternalAndReservedAttribute15IMachineDebugger)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::COMGETTER(InternalAndReservedAttribute16IMachineDebugger)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IMachineDebugger methods
//

STDMETHODIMP MachineDebuggerWrap::DumpGuestCore(IN_BSTR aFilename,
                                                IN_BSTR aCompression)
{
    LogRelFlow(("{%p} %s:enter aFilename=%ls aCompression=%ls\n", this, "MachineDebugger::dumpGuestCore", aFilename, aCompression));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpFilename(aFilename);
        BSTRInConverter TmpCompression(aCompression);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_DUMPGUESTCORE_ENTER(this, TmpFilename.str().c_str(), TmpCompression.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = dumpGuestCore(TmpFilename.str(),
                                TmpCompression.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_DUMPGUESTCORE_RETURN(this, hrc, 0 /*normal*/, TmpFilename.str().c_str(), TmpCompression.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_DUMPGUESTCORE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_DUMPGUESTCORE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "MachineDebugger::dumpGuestCore", hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::DumpHostProcessCore(IN_BSTR aFilename,
                                                      IN_BSTR aCompression)
{
    LogRelFlow(("{%p} %s:enter aFilename=%ls aCompression=%ls\n", this, "MachineDebugger::dumpHostProcessCore", aFilename, aCompression));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpFilename(aFilename);
        BSTRInConverter TmpCompression(aCompression);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_DUMPHOSTPROCESSCORE_ENTER(this, TmpFilename.str().c_str(), TmpCompression.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = dumpHostProcessCore(TmpFilename.str(),
                                      TmpCompression.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_DUMPHOSTPROCESSCORE_RETURN(this, hrc, 0 /*normal*/, TmpFilename.str().c_str(), TmpCompression.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_DUMPHOSTPROCESSCORE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_DUMPHOSTPROCESSCORE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "MachineDebugger::dumpHostProcessCore", hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::Info(IN_BSTR aName,
                                       IN_BSTR aArgs,
                                       BSTR *aInfo)
{
    LogRelFlow(("{%p} %s:enter aName=%ls aArgs=%ls aInfo=%p\n", this, "MachineDebugger::info", aName, aArgs, aInfo));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aInfo);


        BSTRInConverter TmpName(aName);
        BSTRInConverter TmpArgs(aArgs);
        BSTROutConverter TmpInfo(aInfo);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_INFO_ENTER(this, TmpName.str().c_str(), TmpArgs.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = info(TmpName.str(),
                       TmpArgs.str(),
                       TmpInfo.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_INFO_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), TmpArgs.str().c_str(), TmpInfo.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_INFO_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_INFO_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aInfo=%ls hrc=%Rhrc\n", this, "MachineDebugger::info", *aInfo, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::InjectNMI()
{
    LogRelFlow(("{%p} %s:enter\n", this, "MachineDebugger::injectNMI"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_INJECTNMI_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = injectNMI();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_INJECTNMI_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_INJECTNMI_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_INJECTNMI_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "MachineDebugger::injectNMI", hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::ModifyLogGroups(IN_BSTR aSettings)
{
    LogRelFlow(("{%p} %s:enter aSettings=%ls\n", this, "MachineDebugger::modifyLogGroups", aSettings));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpSettings(aSettings);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_MODIFYLOGGROUPS_ENTER(this, TmpSettings.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = modifyLogGroups(TmpSettings.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_MODIFYLOGGROUPS_RETURN(this, hrc, 0 /*normal*/, TmpSettings.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_MODIFYLOGGROUPS_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_MODIFYLOGGROUPS_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "MachineDebugger::modifyLogGroups", hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::ModifyLogFlags(IN_BSTR aSettings)
{
    LogRelFlow(("{%p} %s:enter aSettings=%ls\n", this, "MachineDebugger::modifyLogFlags", aSettings));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpSettings(aSettings);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_MODIFYLOGFLAGS_ENTER(this, TmpSettings.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = modifyLogFlags(TmpSettings.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_MODIFYLOGFLAGS_RETURN(this, hrc, 0 /*normal*/, TmpSettings.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_MODIFYLOGFLAGS_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_MODIFYLOGFLAGS_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "MachineDebugger::modifyLogFlags", hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::ModifyLogDestinations(IN_BSTR aSettings)
{
    LogRelFlow(("{%p} %s:enter aSettings=%ls\n", this, "MachineDebugger::modifyLogDestinations", aSettings));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpSettings(aSettings);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_MODIFYLOGDESTINATIONS_ENTER(this, TmpSettings.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = modifyLogDestinations(TmpSettings.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_MODIFYLOGDESTINATIONS_RETURN(this, hrc, 0 /*normal*/, TmpSettings.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_MODIFYLOGDESTINATIONS_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_MODIFYLOGDESTINATIONS_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "MachineDebugger::modifyLogDestinations", hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::ReadPhysicalMemory(LONG64 aAddress,
                                                     ULONG aSize,
                                                     ComSafeArrayOut(BYTE, aBytes))
{
    LogRelFlow(("{%p} %s:enter aAddress=%RI64 aSize=%RU32 aBytes=%p\n", this, "MachineDebugger::readPhysicalMemory", aAddress, aSize, aBytes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBytes);


        
        
        ArrayOutConverter<BYTE> TmpBytes(ComSafeArrayOutArg(aBytes));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_READPHYSICALMEMORY_ENTER(this, aAddress, aSize);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = readPhysicalMemory(aAddress,
                                     aSize,
                                     TmpBytes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_READPHYSICALMEMORY_RETURN(this, hrc, 0 /*normal*/, aAddress, aSize, (uint32_t)TmpBytes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_READPHYSICALMEMORY_RETURN(this, hrc, 1 /*hrc exception*/, aAddress, aSize, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_READPHYSICALMEMORY_RETURN(this, hrc, 9 /*unhandled exception*/, aAddress, aSize, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aBytes=%zu hrc=%Rhrc\n", this, "MachineDebugger::readPhysicalMemory", ComSafeArraySize(*aBytes), hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::WritePhysicalMemory(LONG64 aAddress,
                                                      ULONG aSize,
                                                      ComSafeArrayIn(BYTE, aBytes))
{
    LogRelFlow(("{%p} %s:enter aAddress=%RI64 aSize=%RU32 aBytes=%zu\n", this, "MachineDebugger::writePhysicalMemory", aAddress, aSize, aBytes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        
        ArrayInConverter<BYTE> TmpBytes(ComSafeArrayInArg(aBytes));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_WRITEPHYSICALMEMORY_ENTER(this, aAddress, aSize, (uint32_t)TmpBytes.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = writePhysicalMemory(aAddress,
                                      aSize,
                                      TmpBytes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_WRITEPHYSICALMEMORY_RETURN(this, hrc, 0 /*normal*/, aAddress, aSize, (uint32_t)TmpBytes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_WRITEPHYSICALMEMORY_RETURN(this, hrc, 1 /*hrc exception*/, aAddress, aSize, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_WRITEPHYSICALMEMORY_RETURN(this, hrc, 9 /*unhandled exception*/, aAddress, aSize, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "MachineDebugger::writePhysicalMemory", hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::ReadVirtualMemory(ULONG aCpuId,
                                                    LONG64 aAddress,
                                                    ULONG aSize,
                                                    ComSafeArrayOut(BYTE, aBytes))
{
    LogRelFlow(("{%p} %s:enter aCpuId=%RU32 aAddress=%RI64 aSize=%RU32 aBytes=%p\n", this, "MachineDebugger::readVirtualMemory", aCpuId, aAddress, aSize, aBytes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBytes);


        
        
        
        ArrayOutConverter<BYTE> TmpBytes(ComSafeArrayOutArg(aBytes));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_READVIRTUALMEMORY_ENTER(this, aCpuId, aAddress, aSize);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = readVirtualMemory(aCpuId,
                                    aAddress,
                                    aSize,
                                    TmpBytes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_READVIRTUALMEMORY_RETURN(this, hrc, 0 /*normal*/, aCpuId, aAddress, aSize, (uint32_t)TmpBytes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_READVIRTUALMEMORY_RETURN(this, hrc, 1 /*hrc exception*/, aCpuId, aAddress, aSize, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_READVIRTUALMEMORY_RETURN(this, hrc, 9 /*unhandled exception*/, aCpuId, aAddress, aSize, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aBytes=%zu hrc=%Rhrc\n", this, "MachineDebugger::readVirtualMemory", ComSafeArraySize(*aBytes), hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::WriteVirtualMemory(ULONG aCpuId,
                                                     LONG64 aAddress,
                                                     ULONG aSize,
                                                     ComSafeArrayIn(BYTE, aBytes))
{
    LogRelFlow(("{%p} %s:enter aCpuId=%RU32 aAddress=%RI64 aSize=%RU32 aBytes=%zu\n", this, "MachineDebugger::writeVirtualMemory", aCpuId, aAddress, aSize, aBytes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        
        
        ArrayInConverter<BYTE> TmpBytes(ComSafeArrayInArg(aBytes));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_WRITEVIRTUALMEMORY_ENTER(this, aCpuId, aAddress, aSize, (uint32_t)TmpBytes.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = writeVirtualMemory(aCpuId,
                                     aAddress,
                                     aSize,
                                     TmpBytes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_WRITEVIRTUALMEMORY_RETURN(this, hrc, 0 /*normal*/, aCpuId, aAddress, aSize, (uint32_t)TmpBytes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_WRITEVIRTUALMEMORY_RETURN(this, hrc, 1 /*hrc exception*/, aCpuId, aAddress, aSize, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_WRITEVIRTUALMEMORY_RETURN(this, hrc, 9 /*unhandled exception*/, aCpuId, aAddress, aSize, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "MachineDebugger::writeVirtualMemory", hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::LoadPlugIn(IN_BSTR aName,
                                             BSTR *aPlugInName)
{
    LogRelFlow(("{%p} %s:enter aName=%ls aPlugInName=%p\n", this, "MachineDebugger::loadPlugIn", aName, aPlugInName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPlugInName);


        BSTRInConverter TmpName(aName);
        BSTROutConverter TmpPlugInName(aPlugInName);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_LOADPLUGIN_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = loadPlugIn(TmpName.str(),
                             TmpPlugInName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_LOADPLUGIN_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), TmpPlugInName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_LOADPLUGIN_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_LOADPLUGIN_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aPlugInName=%ls hrc=%Rhrc\n", this, "MachineDebugger::loadPlugIn", *aPlugInName, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::UnloadPlugIn(IN_BSTR aName)
{
    LogRelFlow(("{%p} %s:enter aName=%ls\n", this, "MachineDebugger::unloadPlugIn", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_UNLOADPLUGIN_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = unloadPlugIn(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_UNLOADPLUGIN_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_UNLOADPLUGIN_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_UNLOADPLUGIN_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "MachineDebugger::unloadPlugIn", hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::DetectOS(BSTR *aOs)
{
    LogRelFlow(("{%p} %s:enter aOs=%p\n", this, "MachineDebugger::detectOS", aOs));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOs);


        BSTROutConverter TmpOs(aOs);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_DETECTOS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = detectOS(TmpOs.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_DETECTOS_RETURN(this, hrc, 0 /*normal*/, TmpOs.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_DETECTOS_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_DETECTOS_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aOs=%ls hrc=%Rhrc\n", this, "MachineDebugger::detectOS", *aOs, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::QueryOSKernelLog(ULONG aMaxMessages,
                                                   BSTR *aDmesg)
{
    LogRelFlow(("{%p} %s:enter aMaxMessages=%RU32 aDmesg=%p\n", this, "MachineDebugger::queryOSKernelLog", aMaxMessages, aDmesg));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDmesg);


        
        BSTROutConverter TmpDmesg(aDmesg);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_QUERYOSKERNELLOG_ENTER(this, aMaxMessages);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = queryOSKernelLog(aMaxMessages,
                                   TmpDmesg.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_QUERYOSKERNELLOG_RETURN(this, hrc, 0 /*normal*/, aMaxMessages, TmpDmesg.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_QUERYOSKERNELLOG_RETURN(this, hrc, 1 /*hrc exception*/, aMaxMessages, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_QUERYOSKERNELLOG_RETURN(this, hrc, 9 /*unhandled exception*/, aMaxMessages, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aDmesg=%ls hrc=%Rhrc\n", this, "MachineDebugger::queryOSKernelLog", *aDmesg, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::GetRegister(ULONG aCpuId,
                                              IN_BSTR aName,
                                              BSTR *aValue)
{
    LogRelFlow(("{%p} %s:enter aCpuId=%RU32 aName=%ls aValue=%p\n", this, "MachineDebugger::getRegister", aCpuId, aName, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValue);


        
        BSTRInConverter TmpName(aName);
        BSTROutConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GETREGISTER_ENTER(this, aCpuId, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRegister(aCpuId,
                              TmpName.str(),
                              TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GETREGISTER_RETURN(this, hrc, 0 /*normal*/, aCpuId, TmpName.str().c_str(), TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GETREGISTER_RETURN(this, hrc, 1 /*hrc exception*/, aCpuId, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GETREGISTER_RETURN(this, hrc, 9 /*unhandled exception*/, aCpuId, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aValue=%ls hrc=%Rhrc\n", this, "MachineDebugger::getRegister", *aValue, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::GetRegisters(ULONG aCpuId,
                                               ComSafeArrayOut(BSTR, aNames),
                                               ComSafeArrayOut(BSTR, aValues))
{
    LogRelFlow(("{%p} %s:enter aCpuId=%RU32 aNames=%p aValues=%p\n", this, "MachineDebugger::getRegisters", aCpuId, aNames, aValues));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNames);
        CheckComArgOutPointerValidThrow(aValues);


        
        ArrayBSTROutConverter TmpNames(ComSafeArrayOutArg(aNames));
        ArrayBSTROutConverter TmpValues(ComSafeArrayOutArg(aValues));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GETREGISTERS_ENTER(this, aCpuId);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRegisters(aCpuId,
                               TmpNames.array(),
                               TmpValues.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GETREGISTERS_RETURN(this, hrc, 0 /*normal*/, aCpuId, (uint32_t)TmpNames.array().size(), NULL /*for now*/, (uint32_t)TmpValues.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GETREGISTERS_RETURN(this, hrc, 1 /*hrc exception*/, aCpuId, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GETREGISTERS_RETURN(this, hrc, 9 /*unhandled exception*/, aCpuId, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNames=%zu *aValues=%zu hrc=%Rhrc\n", this, "MachineDebugger::getRegisters", ComSafeArraySize(*aNames), ComSafeArraySize(*aValues), hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::SetRegister(ULONG aCpuId,
                                              IN_BSTR aName,
                                              IN_BSTR aValue)
{
    LogRelFlow(("{%p} %s:enter aCpuId=%RU32 aName=%ls aValue=%ls\n", this, "MachineDebugger::setRegister", aCpuId, aName, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        BSTRInConverter TmpName(aName);
        BSTRInConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SETREGISTER_ENTER(this, aCpuId, TmpName.str().c_str(), TmpValue.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setRegister(aCpuId,
                              TmpName.str(),
                              TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SETREGISTER_RETURN(this, hrc, 0 /*normal*/, aCpuId, TmpName.str().c_str(), TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SETREGISTER_RETURN(this, hrc, 1 /*hrc exception*/, aCpuId, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SETREGISTER_RETURN(this, hrc, 9 /*unhandled exception*/, aCpuId, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "MachineDebugger::setRegister", hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::SetRegisters(ULONG aCpuId,
                                               ComSafeArrayIn(IN_BSTR, aNames),
                                               ComSafeArrayIn(IN_BSTR, aValues))
{
    LogRelFlow(("{%p} %s:enter aCpuId=%RU32 aNames=%zu aValues=%zu\n", this, "MachineDebugger::setRegisters", aCpuId, aNames, aValues));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        ArrayBSTRInConverter TmpNames(ComSafeArrayInArg(aNames));
        ArrayBSTRInConverter TmpValues(ComSafeArrayInArg(aValues));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SETREGISTERS_ENTER(this, aCpuId, (uint32_t)TmpNames.array().size(), NULL /*for now*/, (uint32_t)TmpValues.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setRegisters(aCpuId,
                               TmpNames.array(),
                               TmpValues.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SETREGISTERS_RETURN(this, hrc, 0 /*normal*/, aCpuId, (uint32_t)TmpNames.array().size(), NULL /*for now*/, (uint32_t)TmpValues.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SETREGISTERS_RETURN(this, hrc, 1 /*hrc exception*/, aCpuId, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_SETREGISTERS_RETURN(this, hrc, 9 /*unhandled exception*/, aCpuId, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "MachineDebugger::setRegisters", hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::DumpGuestStack(ULONG aCpuId,
                                                 BSTR *aStack)
{
    LogRelFlow(("{%p} %s:enter aCpuId=%RU32 aStack=%p\n", this, "MachineDebugger::dumpGuestStack", aCpuId, aStack));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aStack);


        
        BSTROutConverter TmpStack(aStack);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_DUMPGUESTSTACK_ENTER(this, aCpuId);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = dumpGuestStack(aCpuId,
                                 TmpStack.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_DUMPGUESTSTACK_RETURN(this, hrc, 0 /*normal*/, aCpuId, TmpStack.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_DUMPGUESTSTACK_RETURN(this, hrc, 1 /*hrc exception*/, aCpuId, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_DUMPGUESTSTACK_RETURN(this, hrc, 9 /*unhandled exception*/, aCpuId, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aStack=%ls hrc=%Rhrc\n", this, "MachineDebugger::dumpGuestStack", *aStack, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::ResetStats(IN_BSTR aPattern)
{
    LogRelFlow(("{%p} %s:enter aPattern=%ls\n", this, "MachineDebugger::resetStats", aPattern));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpPattern(aPattern);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_RESETSTATS_ENTER(this, TmpPattern.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = resetStats(TmpPattern.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_RESETSTATS_RETURN(this, hrc, 0 /*normal*/, TmpPattern.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_RESETSTATS_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_RESETSTATS_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "MachineDebugger::resetStats", hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::DumpStats(IN_BSTR aPattern)
{
    LogRelFlow(("{%p} %s:enter aPattern=%ls\n", this, "MachineDebugger::dumpStats", aPattern));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpPattern(aPattern);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_DUMPSTATS_ENTER(this, TmpPattern.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = dumpStats(TmpPattern.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_DUMPSTATS_RETURN(this, hrc, 0 /*normal*/, TmpPattern.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_DUMPSTATS_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_DUMPSTATS_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "MachineDebugger::dumpStats", hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::GetStats(IN_BSTR aPattern,
                                           BOOL aWithDescriptions,
                                           BSTR *aStats)
{
    LogRelFlow(("{%p} %s:enter aPattern=%ls aWithDescriptions=%RTbool aStats=%p\n", this, "MachineDebugger::getStats", aPattern, aWithDescriptions, aStats));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aStats);


        BSTRInConverter TmpPattern(aPattern);
        
        BSTROutConverter TmpStats(aStats);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GETSTATS_ENTER(this, TmpPattern.str().c_str(), aWithDescriptions != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getStats(TmpPattern.str(),
                           aWithDescriptions != FALSE,
                           TmpStats.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GETSTATS_RETURN(this, hrc, 0 /*normal*/, TmpPattern.str().c_str(), aWithDescriptions != FALSE, TmpStats.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GETSTATS_RETURN(this, hrc, 1 /*hrc exception*/, 0, aWithDescriptions != FALSE, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GETSTATS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aWithDescriptions != FALSE, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aStats=%ls hrc=%Rhrc\n", this, "MachineDebugger::getStats", *aStats, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::GetCPULoad(ULONG aCpuId,
                                             ULONG *aPctExecuting,
                                             ULONG *aPctHalted,
                                             ULONG *aPctOther,
                                             LONG64 *aMsInterval)
{
    LogRelFlow(("{%p} %s:enter aCpuId=%RU32 aPctExecuting=%p aPctHalted=%p aPctOther=%p aMsInterval=%p\n", this, "MachineDebugger::getCPULoad", aCpuId, aPctExecuting, aPctHalted, aPctOther, aMsInterval));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPctExecuting);
        CheckComArgOutPointerValidThrow(aPctHalted);
        CheckComArgOutPointerValidThrow(aPctOther);
        CheckComArgOutPointerValidThrow(aMsInterval);


        
        
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GETCPULOAD_ENTER(this, aCpuId);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCPULoad(aCpuId,
                             aPctExecuting,
                             aPctHalted,
                             aPctOther,
                             aMsInterval);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GETCPULOAD_RETURN(this, hrc, 0 /*normal*/, aCpuId, *aPctExecuting, *aPctHalted, *aPctOther, *aMsInterval);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GETCPULOAD_RETURN(this, hrc, 1 /*hrc exception*/, aCpuId, *aPctExecuting, *aPctHalted, *aPctOther, *aMsInterval);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MACHINEDEBUGGER_GETCPULOAD_RETURN(this, hrc, 9 /*unhandled exception*/, aCpuId, *aPctExecuting, *aPctHalted, *aPctOther, *aMsInterval);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPctExecuting=%RU32 *aPctHalted=%RU32 *aPctOther=%RU32 aMsInterval=%RI64 hrc=%Rhrc\n", this, "MachineDebugger::getCPULoad", *aPctExecuting, *aPctHalted, *aPctOther, *aMsInterval, hrc));
    return hrc;
}

STDMETHODIMP MachineDebuggerWrap::InternalAndReservedMethod1IMachineDebugger()
{
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::InternalAndReservedMethod2IMachineDebugger()
{
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::InternalAndReservedMethod3IMachineDebugger()
{
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::InternalAndReservedMethod4IMachineDebugger()
{
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::InternalAndReservedMethod5IMachineDebugger()
{
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::InternalAndReservedMethod6IMachineDebugger()
{
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::InternalAndReservedMethod7IMachineDebugger()
{
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::InternalAndReservedMethod8IMachineDebugger()
{
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::InternalAndReservedMethod9IMachineDebugger()
{
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::InternalAndReservedMethod10IMachineDebugger()
{
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::InternalAndReservedMethod11IMachineDebugger()
{
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::InternalAndReservedMethod12IMachineDebugger()
{
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::InternalAndReservedMethod13IMachineDebugger()
{
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::InternalAndReservedMethod14IMachineDebugger()
{
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::InternalAndReservedMethod15IMachineDebugger()
{
    return E_NOTIMPL;
}

STDMETHODIMP MachineDebuggerWrap::InternalAndReservedMethod16IMachineDebugger()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(MachineDebuggerWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(MachineDebuggerWrap, IMachineDebugger)
#endif // VBOX_WITH_XPCOM

