#
# Linux generic kernel configuration
#

#
# Set NR_CPUS option, (values > 256 (512 is the default on arm_v8 now) will
# select CONFIG_CPUMASK_OFFSTACK)
#
LX_NR_CPUS = 64

# kernel fundamentals
LX_ENABLE += TTY MMU SERIAL_EARLYCON SERIAL_OF_PLATFORM PRINTK HAS_IOMEM SMP

# support disabling ticking during idle
LX_ENABLE  += NO_HZ_IDLE

# initrd support
LX_ENABLE += BINFMT_ELF BLK_DEV_INITRD

# kmem_cache allocator
LX_DISABLE += SLOB SLUB_DEBUG
LX_ENABLE  += SLUB

# network infrastructure
LX_ENABLE += NET NETDEVICES

# PCI support
LX_ENABLE += PCI

# Virtio devices
LX_ENABLE += VIRTIO_MENU VIRTIO_PCI VIRTIO_NET VIRTIO_CONSOLE

# network protocols
LX_ENABLE += INET IP_PNP IP_PNP_DHCP

# remove IPv6 for now
LX_DISABLE += IPV6

# random number generator
LX_ENABLE += HW_RANDOM ARCH_RANDOM RANDOM_TRUST_CPU RANDOM_TRUST_BOOTLOADER
LX_ENABLE += CRYPTO_JITTERENTROPY CRYPTO_ANSI_CPRNG HW_RANDOM_TIMERIOMEM

# wireguard driver
LX_ENABLE += WIREGUARD WIREGUARD_DEBUG

# input
LX_ENABLE += INPUT INPUT_EVDEV

# HID
LX_ENABLE += HID HID_GENERIC

# USB
LX_ENABLE  += USB USB_SUPPORT USB USB_ARCH_HAS_HCD
LX_DISABLE += USB_PCI

# USB HID
LX_ENABLE += USB_HID NEW_LEDS INPUT_LEDS LEDS_CLASS
LX_ENABLE += HID_APPLE HID_CHERRY HID_HOLTEK HID_MICROSOFT HID_MAGICMOUSE
LX_ENABLE += HID_MULTITOUCH HID_WACOM

# USB NET
LX_ENABLE  += USB_NET_DRIVERS USB_USBNET
LX_ENABLE  += USB_NET_AX8817X USB_NET_AX88179_178A USB_NET_CDCETHER
LX_ENABLE  += USB_NET_SMSC95XX

# USB MBIM MODEM
LX_ENABLE  += USB_NET_CDC_NCM USB_NET_CDC_MBIM USB_WDM

# USB serial
LX_ENABLE  += USB_SERIAL USB_SERIAL_PL2303 USB_SERIAL_FTDI_SIO USB_SERIAL_CP210X USB_SERIAL_CH341

# disable unwanted
LX_DISABLE += USB_NET_NET1080 USB_NET_CDC_SUBSET_ENABLE USB_BELKIN
LX_DISABLE += USB_ARMLINUX USB_NET_ZAURUS USB_NET_CDC_SUBSET
LX_DISABLE += USB_NET_RNDIS_HOST

# disable cpu frequency scaling
LX_DISABLE += SCHED_MC CPU_FREQ

# disable optimization not possible in PIC code under Genode
LX_DISABLE += CC_HAS_ASM_GOTO

# slim down kernel by removing superfluous drivers
LX_DISABLE += VGA_CONSOLE DUMMY_CONSOLE NLS VGA_ARB DEBUG_LIST
LX_DISABLE += INPUT_KEYBOARD INPUT_MOUSE WLAN WIRELESS ETHERNET
