// ##### ENDFILE "CloudProviderWrap.h"


// ##### BEGINFILE "CloudProviderManagerWrap.h"
/** @file
 * VirtualBox API class wrapper header for ICloudProviderManager.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#ifndef CloudProviderManagerWrap_H_
#define CloudProviderManagerWrap_H_
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif

#include "VirtualBoxBase.h"
#include "Wrapper.h"

class ATL_NO_VTABLE CloudProviderManagerWrap
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(ICloudProviderManager)
{
    Q_OBJECT

public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(CloudProviderManagerWrap, ICloudProviderManager)
    DECLARE_NOT_AGGREGATABLE(CloudProviderManagerWrap)
    DECLARE_PROTECT_FINAL_CONSTRUCT()

    BEGIN_COM_MAP(CloudProviderManagerWrap)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(ICloudProviderManager)
        COM_INTERFACE_ENTRY2(IDispatch, ICloudProviderManager)
        VBOX_TWEAK_INTERFACE_ENTRY(ICloudProviderManager)
    END_COM_MAP()

    DECLARE_EMPTY_CTOR_DTOR(CloudProviderManagerWrap)

    /** @name Public ICloudProviderManager properties
     * @{ */
    STDMETHOD(COMGETTER(Providers))(ComSafeArrayOut(ICloudProvider *, aProviders));
    STDMETHOD(COMGETTER(InternalAndReservedAttribute1ICloudProviderManager))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute2ICloudProviderManager))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute3ICloudProviderManager))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute4ICloudProviderManager))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute5ICloudProviderManager))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute6ICloudProviderManager))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute7ICloudProviderManager))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute8ICloudProviderManager))(ULONG *aReserved);
    /** @} */

    /** @name Public ICloudProviderManager methods
     * @{ */
    STDMETHOD(GetProviderById)(IN_BSTR aProviderId,
                               ICloudProvider **aProvider);
    STDMETHOD(GetProviderByShortName)(IN_BSTR aProviderName,
                                      ICloudProvider **aProvider);
    STDMETHOD(GetProviderByName)(IN_BSTR aProviderName,
                                 ICloudProvider **aProvider);
    STDMETHOD(InternalAndReservedMethod1ICloudProviderManager)();
    STDMETHOD(InternalAndReservedMethod2ICloudProviderManager)();
    STDMETHOD(InternalAndReservedMethod3ICloudProviderManager)();
    STDMETHOD(InternalAndReservedMethod4ICloudProviderManager)();
    /** @} */

private:
    /** @name Wrapped ICloudProviderManager properties
     * @{ */
    virtual HRESULT getProviders(std::vector<ComPtr<ICloudProvider> > &aProviders) = 0;
    /** @} */

    /** @name Wrapped ICloudProviderManager methods
     * @{ */
    virtual HRESULT getProviderById(const com::Guid &aProviderId,
                                    ComPtr<ICloudProvider> &aProvider) = 0;
    virtual HRESULT getProviderByShortName(const com::Utf8Str &aProviderName,
                                           ComPtr<ICloudProvider> &aProvider) = 0;
    virtual HRESULT getProviderByName(const com::Utf8Str &aProviderName,
                                      ComPtr<ICloudProvider> &aProvider) = 0;
    /** @} */

private:
    DECLARE_CLS_COPY_CTOR_ASSIGN_NOOP(CloudProviderManagerWrap); /* Shuts up MSC warning C4625. */

};

#endif // !CloudProviderManagerWrap_H_

