// ##### ENDFILE "CloudProfileWrap.h"


// ##### BEGINFILE "CloudProviderWrap.h"
/** @file
 * VirtualBox API class wrapper header for ICloudProvider.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#ifndef CloudProviderWrap_H_
#define CloudProviderWrap_H_
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif

#include "VirtualBoxBase.h"
#include "Wrapper.h"

class ATL_NO_VTABLE CloudProviderWrap
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(ICloudProvider)
{
    Q_OBJECT

public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(CloudProviderWrap, ICloudProvider)
    DECLARE_NOT_AGGREGATABLE(CloudProviderWrap)
    DECLARE_PROTECT_FINAL_CONSTRUCT()

    BEGIN_COM_MAP(CloudProviderWrap)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(ICloudProvider)
        COM_INTERFACE_ENTRY2(IDispatch, ICloudProvider)
        VBOX_TWEAK_INTERFACE_ENTRY(ICloudProvider)
    END_COM_MAP()

    DECLARE_EMPTY_CTOR_DTOR(CloudProviderWrap)

    /** @name Public ICloudProvider properties
     * @{ */
    STDMETHOD(COMGETTER(Name))(BSTR *aName);
    STDMETHOD(COMGETTER(ShortName))(BSTR *aShortName);
    STDMETHOD(COMGETTER(Id))(BSTR *aId);
    STDMETHOD(COMGETTER(Profiles))(ComSafeArrayOut(ICloudProfile *, aProfiles));
    STDMETHOD(COMGETTER(ProfileNames))(ComSafeArrayOut(BSTR, aProfileNames));
    STDMETHOD(COMGETTER(SupportedPropertyNames))(ComSafeArrayOut(BSTR, aSupportedPropertyNames));
    STDMETHOD(COMGETTER(InternalAndReservedAttribute1ICloudProvider))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute2ICloudProvider))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute3ICloudProvider))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute4ICloudProvider))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute5ICloudProvider))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute6ICloudProvider))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute7ICloudProvider))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute8ICloudProvider))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute9ICloudProvider))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute10ICloudProvider))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute11ICloudProvider))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute12ICloudProvider))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute13ICloudProvider))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute14ICloudProvider))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute15ICloudProvider))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute16ICloudProvider))(ULONG *aReserved);
    /** @} */

    /** @name Public ICloudProvider methods
     * @{ */
    STDMETHOD(GetPropertyDescription)(IN_BSTR aName,
                                      BSTR *aDescription);
    STDMETHOD(CreateProfile)(IN_BSTR aProfileName,
                             ComSafeArrayIn(IN_BSTR, aNames),
                             ComSafeArrayIn(IN_BSTR, aValues));
    STDMETHOD(ImportProfiles)();
    STDMETHOD(RestoreProfiles)();
    STDMETHOD(SaveProfiles)();
    STDMETHOD(GetProfileByName)(IN_BSTR aProfileName,
                                ICloudProfile **aProfile);
    STDMETHOD(PrepareUninstall)();
    STDMETHOD(InternalAndReservedMethod1ICloudProvider)();
    STDMETHOD(InternalAndReservedMethod2ICloudProvider)();
    STDMETHOD(InternalAndReservedMethod3ICloudProvider)();
    STDMETHOD(InternalAndReservedMethod4ICloudProvider)();
    STDMETHOD(InternalAndReservedMethod5ICloudProvider)();
    STDMETHOD(InternalAndReservedMethod6ICloudProvider)();
    STDMETHOD(InternalAndReservedMethod7ICloudProvider)();
    STDMETHOD(InternalAndReservedMethod8ICloudProvider)();
    /** @} */

private:
    /** @name Wrapped ICloudProvider properties
     * @{ */
    virtual HRESULT getName(com::Utf8Str &aName) = 0;
    virtual HRESULT getShortName(com::Utf8Str &aShortName) = 0;
    virtual HRESULT getId(com::Guid &aId) = 0;
    virtual HRESULT getProfiles(std::vector<ComPtr<ICloudProfile> > &aProfiles) = 0;
    virtual HRESULT getProfileNames(std::vector<com::Utf8Str> &aProfileNames) = 0;
    virtual HRESULT getSupportedPropertyNames(std::vector<com::Utf8Str> &aSupportedPropertyNames) = 0;
    /** @} */

    /** @name Wrapped ICloudProvider methods
     * @{ */
    virtual HRESULT getPropertyDescription(const com::Utf8Str &aName,
                                           com::Utf8Str &aDescription) = 0;
    virtual HRESULT createProfile(const com::Utf8Str &aProfileName,
                                  const std::vector<com::Utf8Str> &aNames,
                                  const std::vector<com::Utf8Str> &aValues) = 0;
    virtual HRESULT importProfiles() = 0;
    virtual HRESULT restoreProfiles() = 0;
    virtual HRESULT saveProfiles() = 0;
    virtual HRESULT getProfileByName(const com::Utf8Str &aProfileName,
                                     ComPtr<ICloudProfile> &aProfile) = 0;
    virtual HRESULT prepareUninstall(AutoCaller &aAutoCaller) = 0;
    /** @} */

private:
    DECLARE_CLS_COPY_CTOR_ASSIGN_NOOP(CloudProviderWrap); /* Shuts up MSC warning C4625. */

};

#endif // !CloudProviderWrap_H_

