// ##### ENDFILE "DnDSourceWrap.cpp"


// ##### BEGINFILE "DnDTargetWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IDnDTarget.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_DNDTARGET

#include "DnDTargetWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(DnDTargetWrap)

//
// IDnDBase properties
//

STDMETHODIMP DnDTargetWrap::COMGETTER(Formats)(ComSafeArrayOut(BSTR, aFormats))
{
    LogRelFlow(("{%p} %s: enter aFormats=%p\n", this, "DnDTarget::getFormats", aFormats));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFormats);
        ArrayBSTROutConverter TmpFormats(ComSafeArrayOutArg(aFormats));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_GET_FORMATS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFormats(TmpFormats.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_GET_FORMATS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpFormats.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_GET_FORMATS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_GET_FORMATS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFormats=%zu hrc=%Rhrc\n", this, "DnDTarget::getFormats", ComSafeArraySize(*aFormats), hrc));
    return hrc;
}

STDMETHODIMP DnDTargetWrap::COMGETTER(ProtocolVersion)(ULONG *aProtocolVersion)
{
    LogRelFlow(("{%p} %s: enter aProtocolVersion=%p\n", this, "DnDTarget::getProtocolVersion", aProtocolVersion));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProtocolVersion);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_GET_PROTOCOLVERSION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProtocolVersion(aProtocolVersion);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_GET_PROTOCOLVERSION_RETURN(this, hrc, 0 /*normal*/,*aProtocolVersion);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_GET_PROTOCOLVERSION_RETURN(this, hrc, 1 /*hrc exception*/,*aProtocolVersion);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_GET_PROTOCOLVERSION_RETURN(this, hrc, 9 /*unhandled exception*/,*aProtocolVersion);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProtocolVersion=%RU32 hrc=%Rhrc\n", this, "DnDTarget::getProtocolVersion", *aProtocolVersion, hrc));
    return hrc;
}

STDMETHODIMP DnDTargetWrap::COMGETTER(InternalAndReservedAttribute1IDnDBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DnDTargetWrap::COMGETTER(InternalAndReservedAttribute2IDnDBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

//
// IDnDTarget properties
//

STDMETHODIMP DnDTargetWrap::COMGETTER(InternalAndReservedAttribute1IDnDTarget)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DnDTargetWrap::COMGETTER(InternalAndReservedAttribute2IDnDTarget)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IDnDBase methods
//

STDMETHODIMP DnDTargetWrap::IsFormatSupported(IN_BSTR aFormat,
                                              BOOL *aSupported)
{
    LogRelFlow(("{%p} %s:enter aFormat=%ls aSupported=%p\n", this, "DnDTarget::isFormatSupported", aFormat, aSupported));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupported);


        BSTRInConverter TmpFormat(aFormat);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_ISFORMATSUPPORTED_ENTER(this, TmpFormat.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = isFormatSupported(TmpFormat.str(),
                                    aSupported);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_ISFORMATSUPPORTED_RETURN(this, hrc, 0 /*normal*/, TmpFormat.str().c_str(), *aSupported != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_ISFORMATSUPPORTED_RETURN(this, hrc, 1 /*hrc exception*/, 0, *aSupported != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_ISFORMATSUPPORTED_RETURN(this, hrc, 9 /*unhandled exception*/, 0, *aSupported != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aSupported=%RTbool hrc=%Rhrc\n", this, "DnDTarget::isFormatSupported", *aSupported, hrc));
    return hrc;
}

STDMETHODIMP DnDTargetWrap::AddFormats(ComSafeArrayIn(IN_BSTR, aFormats))
{
    LogRelFlow(("{%p} %s:enter aFormats=%zu\n", this, "DnDTarget::addFormats", aFormats));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ArrayBSTRInConverter TmpFormats(ComSafeArrayInArg(aFormats));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_ADDFORMATS_ENTER(this, (uint32_t)TmpFormats.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = addFormats(TmpFormats.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_ADDFORMATS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpFormats.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_ADDFORMATS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_ADDFORMATS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DnDTarget::addFormats", hrc));
    return hrc;
}

STDMETHODIMP DnDTargetWrap::RemoveFormats(ComSafeArrayIn(IN_BSTR, aFormats))
{
    LogRelFlow(("{%p} %s:enter aFormats=%zu\n", this, "DnDTarget::removeFormats", aFormats));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ArrayBSTRInConverter TmpFormats(ComSafeArrayInArg(aFormats));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_REMOVEFORMATS_ENTER(this, (uint32_t)TmpFormats.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeFormats(TmpFormats.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_REMOVEFORMATS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpFormats.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_REMOVEFORMATS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_REMOVEFORMATS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DnDTarget::removeFormats", hrc));
    return hrc;
}

STDMETHODIMP DnDTargetWrap::InternalAndReservedMethod1IDnDBase()
{
    return E_NOTIMPL;
}

//
// IDnDTarget methods
//

STDMETHODIMP DnDTargetWrap::Enter(ULONG aScreenId,
                                  ULONG aY,
                                  ULONG aX,
                                  DnDAction_T aDefaultAction,
                                  ComSafeArrayIn(DnDAction_T, aAllowedActions),
                                  ComSafeArrayIn(IN_BSTR, aFormats),
                                  DnDAction_T *aResultAction)
{
    LogRelFlow(("{%p} %s:enter aScreenId=%RU32 aY=%RU32 aX=%RU32 aDefaultAction=%RU32 aAllowedActions=%zu aFormats=%zu aResultAction=%p\n", this, "DnDTarget::enter", aScreenId, aY, aX, aDefaultAction, aAllowedActions, aFormats, aResultAction));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aResultAction);


        
        
        
        
        ArrayInConverter<DnDAction_T> TmpAllowedActions(ComSafeArrayInArg(aAllowedActions));
        ArrayBSTRInConverter TmpFormats(ComSafeArrayInArg(aFormats));
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_ENTER_ENTER(this, aScreenId, aY, aX, aDefaultAction, (uint32_t)TmpAllowedActions.array().size(), NULL /*for now*/, (uint32_t)TmpFormats.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = enter(aScreenId,
                        aY,
                        aX,
                        aDefaultAction,
                        TmpAllowedActions.array(),
                        TmpFormats.array(),
                        aResultAction);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_ENTER_RETURN(this, hrc, 0 /*normal*/, aScreenId, aY, aX, aDefaultAction, (uint32_t)TmpAllowedActions.array().size(), NULL /*for now*/, (uint32_t)TmpFormats.array().size(), NULL /*for now*/, *aResultAction);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_ENTER_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, aY, aX, aDefaultAction, 0, 0, 0, 0, *aResultAction);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_ENTER_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, aY, aX, aDefaultAction, 0, 0, 0, 0, *aResultAction);
#endif
    }

    LogRelFlow(("{%p} %s: leave aResultAction=%RU32 hrc=%Rhrc\n", this, "DnDTarget::enter", *aResultAction, hrc));
    return hrc;
}

STDMETHODIMP DnDTargetWrap::Move(ULONG aScreenId,
                                 ULONG aX,
                                 ULONG aY,
                                 DnDAction_T aDefaultAction,
                                 ComSafeArrayIn(DnDAction_T, aAllowedActions),
                                 ComSafeArrayIn(IN_BSTR, aFormats),
                                 DnDAction_T *aResultAction)
{
    LogRelFlow(("{%p} %s:enter aScreenId=%RU32 aX=%RU32 aY=%RU32 aDefaultAction=%RU32 aAllowedActions=%zu aFormats=%zu aResultAction=%p\n", this, "DnDTarget::move", aScreenId, aX, aY, aDefaultAction, aAllowedActions, aFormats, aResultAction));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aResultAction);


        
        
        
        
        ArrayInConverter<DnDAction_T> TmpAllowedActions(ComSafeArrayInArg(aAllowedActions));
        ArrayBSTRInConverter TmpFormats(ComSafeArrayInArg(aFormats));
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_MOVE_ENTER(this, aScreenId, aX, aY, aDefaultAction, (uint32_t)TmpAllowedActions.array().size(), NULL /*for now*/, (uint32_t)TmpFormats.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = move(aScreenId,
                       aX,
                       aY,
                       aDefaultAction,
                       TmpAllowedActions.array(),
                       TmpFormats.array(),
                       aResultAction);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_MOVE_RETURN(this, hrc, 0 /*normal*/, aScreenId, aX, aY, aDefaultAction, (uint32_t)TmpAllowedActions.array().size(), NULL /*for now*/, (uint32_t)TmpFormats.array().size(), NULL /*for now*/, *aResultAction);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_MOVE_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, aX, aY, aDefaultAction, 0, 0, 0, 0, *aResultAction);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_MOVE_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, aX, aY, aDefaultAction, 0, 0, 0, 0, *aResultAction);
#endif
    }

    LogRelFlow(("{%p} %s: leave aResultAction=%RU32 hrc=%Rhrc\n", this, "DnDTarget::move", *aResultAction, hrc));
    return hrc;
}

STDMETHODIMP DnDTargetWrap::Leave(ULONG aScreenId)
{
    LogRelFlow(("{%p} %s:enter aScreenId=%RU32\n", this, "DnDTarget::leave", aScreenId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_LEAVE_ENTER(this, aScreenId);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = leave(aScreenId);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_LEAVE_RETURN(this, hrc, 0 /*normal*/, aScreenId);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_LEAVE_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_LEAVE_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DnDTarget::leave", hrc));
    return hrc;
}

STDMETHODIMP DnDTargetWrap::Drop(ULONG aScreenId,
                                 ULONG aX,
                                 ULONG aY,
                                 DnDAction_T aDefaultAction,
                                 ComSafeArrayIn(DnDAction_T, aAllowedActions),
                                 ComSafeArrayIn(IN_BSTR, aFormats),
                                 BSTR *aFormat,
                                 DnDAction_T *aResultAction)
{
    LogRelFlow(("{%p} %s:enter aScreenId=%RU32 aX=%RU32 aY=%RU32 aDefaultAction=%RU32 aAllowedActions=%zu aFormats=%zu aFormat=%p aResultAction=%p\n", this, "DnDTarget::drop", aScreenId, aX, aY, aDefaultAction, aAllowedActions, aFormats, aFormat, aResultAction));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFormat);
        CheckComArgOutPointerValidThrow(aResultAction);


        
        
        
        
        ArrayInConverter<DnDAction_T> TmpAllowedActions(ComSafeArrayInArg(aAllowedActions));
        ArrayBSTRInConverter TmpFormats(ComSafeArrayInArg(aFormats));
        BSTROutConverter TmpFormat(aFormat);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_DROP_ENTER(this, aScreenId, aX, aY, aDefaultAction, (uint32_t)TmpAllowedActions.array().size(), NULL /*for now*/, (uint32_t)TmpFormats.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = drop(aScreenId,
                       aX,
                       aY,
                       aDefaultAction,
                       TmpAllowedActions.array(),
                       TmpFormats.array(),
                       TmpFormat.str(),
                       aResultAction);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_DROP_RETURN(this, hrc, 0 /*normal*/, aScreenId, aX, aY, aDefaultAction, (uint32_t)TmpAllowedActions.array().size(), NULL /*for now*/, (uint32_t)TmpFormats.array().size(), NULL /*for now*/, TmpFormat.str().c_str(), *aResultAction);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_DROP_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, aX, aY, aDefaultAction, 0, 0, 0, 0, 0, *aResultAction);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_DROP_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, aX, aY, aDefaultAction, 0, 0, 0, 0, 0, *aResultAction);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFormat=%ls aResultAction=%RU32 hrc=%Rhrc\n", this, "DnDTarget::drop", *aFormat, *aResultAction, hrc));
    return hrc;
}

STDMETHODIMP DnDTargetWrap::SendData(ULONG aScreenId,
                                     IN_BSTR aFormat,
                                     ComSafeArrayIn(BYTE, aData),
                                     IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aScreenId=%RU32 aFormat=%ls aData=%zu aProgress=%p\n", this, "DnDTarget::sendData", aScreenId, aFormat, aData, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        
        BSTRInConverter TmpFormat(aFormat);
        ArrayInConverter<BYTE> TmpData(ComSafeArrayInArg(aData));
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_SENDDATA_ENTER(this, aScreenId, TmpFormat.str().c_str(), (uint32_t)TmpData.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = sendData(aScreenId,
                           TmpFormat.str(),
                           TmpData.array(),
                           TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_SENDDATA_RETURN(this, hrc, 0 /*normal*/, aScreenId, TmpFormat.str().c_str(), (uint32_t)TmpData.array().size(), NULL /*for now*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_SENDDATA_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_SENDDATA_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "DnDTarget::sendData", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP DnDTargetWrap::Cancel(BOOL *aVeto)
{
    LogRelFlow(("{%p} %s:enter aVeto=%p\n", this, "DnDTarget::cancel", aVeto));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVeto);


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_CANCEL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = cancel(aVeto);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_CANCEL_RETURN(this, hrc, 0 /*normal*/, *aVeto != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_CANCEL_RETURN(this, hrc, 1 /*hrc exception*/, *aVeto != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DNDTARGET_CANCEL_RETURN(this, hrc, 9 /*unhandled exception*/, *aVeto != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aVeto=%RTbool hrc=%Rhrc\n", this, "DnDTarget::cancel", *aVeto, hrc));
    return hrc;
}

STDMETHODIMP DnDTargetWrap::InternalAndReservedMethod1IDnDTarget()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(DnDTargetWrap)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(DnDTargetWrap, IDnDTarget, IDnDBase)
#endif // VBOX_WITH_XPCOM

