// ##### ENDFILE "UnattendedWrap.cpp"


// ##### BEGINFILE "GraphicsAdapterWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IGraphicsAdapter.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_GRAPHICSADAPTER

#include "GraphicsAdapterWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(GraphicsAdapterWrap)

//
// IGraphicsAdapter properties
//

STDMETHODIMP GraphicsAdapterWrap::COMGETTER(GraphicsControllerType)(GraphicsControllerType_T *aGraphicsControllerType)
{
    LogRelFlow(("{%p} %s: enter aGraphicsControllerType=%p\n", this, "GraphicsAdapter::getGraphicsControllerType", aGraphicsControllerType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGraphicsControllerType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_GRAPHICSCONTROLLERTYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGraphicsControllerType(aGraphicsControllerType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_GRAPHICSCONTROLLERTYPE_RETURN(this, hrc, 0 /*normal*/,*aGraphicsControllerType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_GRAPHICSCONTROLLERTYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aGraphicsControllerType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_GRAPHICSCONTROLLERTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aGraphicsControllerType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aGraphicsControllerType=%RU32 hrc=%Rhrc\n", this, "GraphicsAdapter::getGraphicsControllerType", *aGraphicsControllerType, hrc));
    return hrc;
}

STDMETHODIMP GraphicsAdapterWrap::COMSETTER(GraphicsControllerType)(GraphicsControllerType_T aGraphicsControllerType)
{
    LogRelFlow(("{%p} %s: enter aGraphicsControllerType=%RU32\n", this, "GraphicsAdapter::setGraphicsControllerType", aGraphicsControllerType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_GRAPHICSCONTROLLERTYPE_ENTER(this, aGraphicsControllerType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setGraphicsControllerType(aGraphicsControllerType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_GRAPHICSCONTROLLERTYPE_RETURN(this, hrc, 0 /*normal*/,aGraphicsControllerType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_GRAPHICSCONTROLLERTYPE_RETURN(this, hrc, 1 /*hrc exception*/,aGraphicsControllerType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_GRAPHICSCONTROLLERTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,aGraphicsControllerType);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GraphicsAdapter::setGraphicsControllerType", hrc));
    return hrc;
}

STDMETHODIMP GraphicsAdapterWrap::COMGETTER(VRAMSize)(ULONG *aVRAMSize)
{
    LogRelFlow(("{%p} %s: enter aVRAMSize=%p\n", this, "GraphicsAdapter::getVRAMSize", aVRAMSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVRAMSize);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_VRAMSIZE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVRAMSize(aVRAMSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_VRAMSIZE_RETURN(this, hrc, 0 /*normal*/,*aVRAMSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_VRAMSIZE_RETURN(this, hrc, 1 /*hrc exception*/,*aVRAMSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_VRAMSIZE_RETURN(this, hrc, 9 /*unhandled exception*/,*aVRAMSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVRAMSize=%RU32 hrc=%Rhrc\n", this, "GraphicsAdapter::getVRAMSize", *aVRAMSize, hrc));
    return hrc;
}

STDMETHODIMP GraphicsAdapterWrap::COMSETTER(VRAMSize)(ULONG aVRAMSize)
{
    LogRelFlow(("{%p} %s: enter aVRAMSize=%RU32\n", this, "GraphicsAdapter::setVRAMSize", aVRAMSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_VRAMSIZE_ENTER(this, aVRAMSize);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setVRAMSize(aVRAMSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_VRAMSIZE_RETURN(this, hrc, 0 /*normal*/,aVRAMSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_VRAMSIZE_RETURN(this, hrc, 1 /*hrc exception*/,aVRAMSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_VRAMSIZE_RETURN(this, hrc, 9 /*unhandled exception*/,aVRAMSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GraphicsAdapter::setVRAMSize", hrc));
    return hrc;
}

STDMETHODIMP GraphicsAdapterWrap::COMGETTER(Accelerate3DEnabled)(BOOL *aAccelerate3DEnabled)
{
    LogRelFlow(("{%p} %s: enter aAccelerate3DEnabled=%p\n", this, "GraphicsAdapter::getAccelerate3DEnabled", aAccelerate3DEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAccelerate3DEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_ACCELERATE3DENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAccelerate3DEnabled(aAccelerate3DEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_ACCELERATE3DENABLED_RETURN(this, hrc, 0 /*normal*/,*aAccelerate3DEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_ACCELERATE3DENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aAccelerate3DEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_ACCELERATE3DENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aAccelerate3DEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAccelerate3DEnabled=%RTbool hrc=%Rhrc\n", this, "GraphicsAdapter::getAccelerate3DEnabled", *aAccelerate3DEnabled, hrc));
    return hrc;
}

STDMETHODIMP GraphicsAdapterWrap::COMSETTER(Accelerate3DEnabled)(BOOL aAccelerate3DEnabled)
{
    LogRelFlow(("{%p} %s: enter aAccelerate3DEnabled=%RTbool\n", this, "GraphicsAdapter::setAccelerate3DEnabled", aAccelerate3DEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_ACCELERATE3DENABLED_ENTER(this, aAccelerate3DEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAccelerate3DEnabled(aAccelerate3DEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_ACCELERATE3DENABLED_RETURN(this, hrc, 0 /*normal*/,aAccelerate3DEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_ACCELERATE3DENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aAccelerate3DEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_ACCELERATE3DENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aAccelerate3DEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GraphicsAdapter::setAccelerate3DEnabled", hrc));
    return hrc;
}

STDMETHODIMP GraphicsAdapterWrap::COMGETTER(Accelerate2DVideoEnabled)(BOOL *aAccelerate2DVideoEnabled)
{
    LogRelFlow(("{%p} %s: enter aAccelerate2DVideoEnabled=%p\n", this, "GraphicsAdapter::getAccelerate2DVideoEnabled", aAccelerate2DVideoEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAccelerate2DVideoEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_ACCELERATE2DVIDEOENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAccelerate2DVideoEnabled(aAccelerate2DVideoEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_ACCELERATE2DVIDEOENABLED_RETURN(this, hrc, 0 /*normal*/,*aAccelerate2DVideoEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_ACCELERATE2DVIDEOENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aAccelerate2DVideoEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_ACCELERATE2DVIDEOENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aAccelerate2DVideoEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAccelerate2DVideoEnabled=%RTbool hrc=%Rhrc\n", this, "GraphicsAdapter::getAccelerate2DVideoEnabled", *aAccelerate2DVideoEnabled, hrc));
    return hrc;
}

STDMETHODIMP GraphicsAdapterWrap::COMSETTER(Accelerate2DVideoEnabled)(BOOL aAccelerate2DVideoEnabled)
{
    LogRelFlow(("{%p} %s: enter aAccelerate2DVideoEnabled=%RTbool\n", this, "GraphicsAdapter::setAccelerate2DVideoEnabled", aAccelerate2DVideoEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_ACCELERATE2DVIDEOENABLED_ENTER(this, aAccelerate2DVideoEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAccelerate2DVideoEnabled(aAccelerate2DVideoEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_ACCELERATE2DVIDEOENABLED_RETURN(this, hrc, 0 /*normal*/,aAccelerate2DVideoEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_ACCELERATE2DVIDEOENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aAccelerate2DVideoEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_ACCELERATE2DVIDEOENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aAccelerate2DVideoEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GraphicsAdapter::setAccelerate2DVideoEnabled", hrc));
    return hrc;
}

STDMETHODIMP GraphicsAdapterWrap::COMGETTER(MonitorCount)(ULONG *aMonitorCount)
{
    LogRelFlow(("{%p} %s: enter aMonitorCount=%p\n", this, "GraphicsAdapter::getMonitorCount", aMonitorCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMonitorCount);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_MONITORCOUNT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMonitorCount(aMonitorCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_MONITORCOUNT_RETURN(this, hrc, 0 /*normal*/,*aMonitorCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_MONITORCOUNT_RETURN(this, hrc, 1 /*hrc exception*/,*aMonitorCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_MONITORCOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,*aMonitorCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMonitorCount=%RU32 hrc=%Rhrc\n", this, "GraphicsAdapter::getMonitorCount", *aMonitorCount, hrc));
    return hrc;
}

STDMETHODIMP GraphicsAdapterWrap::COMSETTER(MonitorCount)(ULONG aMonitorCount)
{
    LogRelFlow(("{%p} %s: enter aMonitorCount=%RU32\n", this, "GraphicsAdapter::setMonitorCount", aMonitorCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_MONITORCOUNT_ENTER(this, aMonitorCount);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setMonitorCount(aMonitorCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_MONITORCOUNT_RETURN(this, hrc, 0 /*normal*/,aMonitorCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_MONITORCOUNT_RETURN(this, hrc, 1 /*hrc exception*/,aMonitorCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_MONITORCOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,aMonitorCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GraphicsAdapter::setMonitorCount", hrc));
    return hrc;
}

STDMETHODIMP GraphicsAdapterWrap::COMGETTER(InternalAndReservedAttribute1IGraphicsAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GraphicsAdapterWrap::COMGETTER(InternalAndReservedAttribute2IGraphicsAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GraphicsAdapterWrap::COMGETTER(InternalAndReservedAttribute3IGraphicsAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GraphicsAdapterWrap::COMGETTER(InternalAndReservedAttribute4IGraphicsAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GraphicsAdapterWrap::COMGETTER(InternalAndReservedAttribute5IGraphicsAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GraphicsAdapterWrap::COMGETTER(InternalAndReservedAttribute6IGraphicsAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GraphicsAdapterWrap::COMGETTER(InternalAndReservedAttribute7IGraphicsAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GraphicsAdapterWrap::COMGETTER(InternalAndReservedAttribute8IGraphicsAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IGraphicsAdapter methods
//

STDMETHODIMP GraphicsAdapterWrap::InternalAndReservedMethod1IGraphicsAdapter()
{
    return E_NOTIMPL;
}

STDMETHODIMP GraphicsAdapterWrap::InternalAndReservedMethod2IGraphicsAdapter()
{
    return E_NOTIMPL;
}

STDMETHODIMP GraphicsAdapterWrap::InternalAndReservedMethod3IGraphicsAdapter()
{
    return E_NOTIMPL;
}

STDMETHODIMP GraphicsAdapterWrap::InternalAndReservedMethod4IGraphicsAdapter()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GraphicsAdapterWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(GraphicsAdapterWrap, IGraphicsAdapter)
#endif // VBOX_WITH_XPCOM

