// ##### ENDFILE "GuestWrap.h"


// ##### BEGINFILE "ProgressWrap.h"
/** @file
 * VirtualBox API class wrapper header for IProgress.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#ifndef ProgressWrap_H_
#define ProgressWrap_H_
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif

#include "VirtualBoxBase.h"
#include "Wrapper.h"

class ATL_NO_VTABLE ProgressWrap
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IProgress)
    , VBOX_SCRIPTABLE_IMPL(IInternalProgressControl)
{
    Q_OBJECT

public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(ProgressWrap, IProgress)
    DECLARE_NOT_AGGREGATABLE(ProgressWrap)
    DECLARE_PROTECT_FINAL_CONSTRUCT()

    BEGIN_COM_MAP(ProgressWrap)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IProgress)
        COM_INTERFACE_ENTRY2(IDispatch, IProgress)
        COM_INTERFACE_ENTRY(IInternalProgressControl)
        VBOX_TWEAK_INTERFACE_ENTRY(IProgress)
    END_COM_MAP()

    DECLARE_EMPTY_CTOR_DTOR(ProgressWrap)

    /** @name Public IProgress properties
     * @{ */
    STDMETHOD(COMGETTER(Id))(BSTR *aId);
    STDMETHOD(COMGETTER(Description))(BSTR *aDescription);
    STDMETHOD(COMGETTER(Initiator))(IUnknown **aInitiator);
    STDMETHOD(COMGETTER(Cancelable))(BOOL *aCancelable);
    STDMETHOD(COMGETTER(Percent))(ULONG *aPercent);
    STDMETHOD(COMGETTER(TimeRemaining))(LONG *aTimeRemaining);
    STDMETHOD(COMGETTER(Completed))(BOOL *aCompleted);
    STDMETHOD(COMGETTER(Canceled))(BOOL *aCanceled);
    STDMETHOD(COMGETTER(ResultCode))(LONG *aResultCode);
    STDMETHOD(COMGETTER(ErrorInfo))(IVirtualBoxErrorInfo **aErrorInfo);
    STDMETHOD(COMGETTER(OperationCount))(ULONG *aOperationCount);
    STDMETHOD(COMGETTER(Operation))(ULONG *aOperation);
    STDMETHOD(COMGETTER(OperationDescription))(BSTR *aOperationDescription);
    STDMETHOD(COMGETTER(OperationPercent))(ULONG *aOperationPercent);
    STDMETHOD(COMGETTER(OperationWeight))(ULONG *aOperationWeight);
    STDMETHOD(COMGETTER(Timeout))(ULONG *aTimeout);
    STDMETHOD(COMSETTER(Timeout))(ULONG aTimeout);
    STDMETHOD(COMGETTER(EventSource))(IEventSource **aEventSource);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute1IProgress))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute2IProgress))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute3IProgress))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute4IProgress))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute5IProgress))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute6IProgress))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute7IProgress))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute8IProgress))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute9IProgress))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute10IProgress))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute11IProgress))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute12IProgress))(ULONG *aReserved);
    /** @} */

    /** @name Public IProgress methods
     * @{ */
    STDMETHOD(WaitForCompletion)(LONG aTimeout);
    STDMETHOD(WaitForOperationCompletion)(ULONG aOperation,
                                          LONG aTimeout);
    STDMETHOD(Cancel)();
    STDMETHOD(InternalAndReservedMethod1IProgress)();
    STDMETHOD(InternalAndReservedMethod2IProgress)();
    STDMETHOD(InternalAndReservedMethod3IProgress)();
    STDMETHOD(InternalAndReservedMethod4IProgress)();
    STDMETHOD(InternalAndReservedMethod5IProgress)();
    STDMETHOD(InternalAndReservedMethod6IProgress)();
    STDMETHOD(InternalAndReservedMethod7IProgress)();
    STDMETHOD(InternalAndReservedMethod8IProgress)();
    /** @} */

    /** @name Public IInternalProgressControl properties
     * @{ */
    STDMETHOD(COMGETTER(InternalAndReservedAttribute1IInternalProgressControl))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute2IInternalProgressControl))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute3IInternalProgressControl))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute4IInternalProgressControl))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute5IInternalProgressControl))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute6IInternalProgressControl))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute7IInternalProgressControl))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute8IInternalProgressControl))(ULONG *aReserved);
    /** @} */

    /** @name Public IInternalProgressControl methods
     * @{ */
    STDMETHOD(SetCurrentOperationProgress)(ULONG aPercent);
    STDMETHOD(WaitForOtherProgressCompletion)(IProgress *aProgressOther,
                                              ULONG aTimeoutMS);
    STDMETHOD(SetNextOperation)(IN_BSTR aNextOperationDescription,
                                ULONG aNextOperationsWeight);
    STDMETHOD(NotifyPointOfNoReturn)();
    STDMETHOD(NotifyComplete)(LONG aResultCode,
                              IVirtualBoxErrorInfo *aErrorInfo);
    STDMETHOD(InternalAndReservedMethod1IInternalProgressControl)();
    STDMETHOD(InternalAndReservedMethod2IInternalProgressControl)();
    STDMETHOD(InternalAndReservedMethod3IInternalProgressControl)();
    STDMETHOD(InternalAndReservedMethod4IInternalProgressControl)();
    STDMETHOD(InternalAndReservedMethod5IInternalProgressControl)();
    STDMETHOD(InternalAndReservedMethod6IInternalProgressControl)();
    STDMETHOD(InternalAndReservedMethod7IInternalProgressControl)();
    STDMETHOD(InternalAndReservedMethod8IInternalProgressControl)();
    /** @} */

private:
    /** @name Wrapped IProgress properties
     * @{ */
    virtual HRESULT getId(com::Guid &aId) = 0;
    virtual HRESULT getDescription(com::Utf8Str &aDescription) = 0;
    virtual HRESULT getInitiator(ComPtr<IUnknown> &aInitiator) = 0;
    virtual HRESULT getCancelable(BOOL *aCancelable) = 0;
    virtual HRESULT getPercent(ULONG *aPercent) = 0;
    virtual HRESULT getTimeRemaining(LONG *aTimeRemaining) = 0;
    virtual HRESULT getCompleted(BOOL *aCompleted) = 0;
    virtual HRESULT getCanceled(BOOL *aCanceled) = 0;
    virtual HRESULT getResultCode(LONG *aResultCode) = 0;
    virtual HRESULT getErrorInfo(ComPtr<IVirtualBoxErrorInfo> &aErrorInfo) = 0;
    virtual HRESULT getOperationCount(ULONG *aOperationCount) = 0;
    virtual HRESULT getOperation(ULONG *aOperation) = 0;
    virtual HRESULT getOperationDescription(com::Utf8Str &aOperationDescription) = 0;
    virtual HRESULT getOperationPercent(ULONG *aOperationPercent) = 0;
    virtual HRESULT getOperationWeight(ULONG *aOperationWeight) = 0;
    virtual HRESULT getTimeout(ULONG *aTimeout) = 0;
    virtual HRESULT setTimeout(ULONG aTimeout) = 0;
    virtual HRESULT getEventSource(ComPtr<IEventSource> &aEventSource) = 0;
    /** @} */

    /** @name Wrapped IProgress methods
     * @{ */
    virtual HRESULT waitForCompletion(LONG aTimeout) = 0;
    virtual HRESULT waitForOperationCompletion(ULONG aOperation,
                                               LONG aTimeout) = 0;
    virtual HRESULT cancel() = 0;
    /** @} */

    /** @name Wrapped IInternalProgressControl properties
     * @{ */
    /** @} */

    /** @name Wrapped IInternalProgressControl methods
     * @{ */
    virtual HRESULT setCurrentOperationProgress(ULONG aPercent) = 0;
    virtual HRESULT waitForOtherProgressCompletion(const ComPtr<IProgress> &aProgressOther,
                                                   ULONG aTimeoutMS) = 0;
    virtual HRESULT setNextOperation(const com::Utf8Str &aNextOperationDescription,
                                     ULONG aNextOperationsWeight) = 0;
    virtual HRESULT notifyPointOfNoReturn() = 0;
    virtual HRESULT notifyComplete(LONG aResultCode,
                                   const ComPtr<IVirtualBoxErrorInfo> &aErrorInfo) = 0;
    /** @} */

private:
    DECLARE_CLS_COPY_CTOR_ASSIGN_NOOP(ProgressWrap); /* Shuts up MSC warning C4625. */

};

#endif // !ProgressWrap_H_

