// ##### ENDFILE "BIOSSettingsWrap.h"


// ##### BEGINFILE "RecordingScreenSettingsWrap.h"
/** @file
 * VirtualBox API class wrapper header for IRecordingScreenSettings.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#ifndef RecordingScreenSettingsWrap_H_
#define RecordingScreenSettingsWrap_H_
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif

#include "VirtualBoxBase.h"
#include "Wrapper.h"

class ATL_NO_VTABLE RecordingScreenSettingsWrap
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IRecordingScreenSettings)
{
    Q_OBJECT

public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(RecordingScreenSettingsWrap, IRecordingScreenSettings)
    DECLARE_NOT_AGGREGATABLE(RecordingScreenSettingsWrap)
    DECLARE_PROTECT_FINAL_CONSTRUCT()

    BEGIN_COM_MAP(RecordingScreenSettingsWrap)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IRecordingScreenSettings)
        COM_INTERFACE_ENTRY2(IDispatch, IRecordingScreenSettings)
        VBOX_TWEAK_INTERFACE_ENTRY(IRecordingScreenSettings)
    END_COM_MAP()

    DECLARE_EMPTY_CTOR_DTOR(RecordingScreenSettingsWrap)

    /** @name Public IRecordingScreenSettings properties
     * @{ */
    STDMETHOD(COMGETTER(Id))(ULONG *aId);
    STDMETHOD(COMGETTER(Enabled))(BOOL *aEnabled);
    STDMETHOD(COMSETTER(Enabled))(BOOL aEnabled);
    STDMETHOD(COMGETTER(Features))(ULONG *aFeatures);
    STDMETHOD(COMSETTER(Features))(ULONG aFeatures);
    STDMETHOD(COMGETTER(Destination))(RecordingDestination_T *aDestination);
    STDMETHOD(COMSETTER(Destination))(RecordingDestination_T aDestination);
    STDMETHOD(COMGETTER(Filename))(BSTR *aFilename);
    STDMETHOD(COMSETTER(Filename))(IN_BSTR aFilename);
    STDMETHOD(COMGETTER(MaxTime))(ULONG *aMaxTime);
    STDMETHOD(COMSETTER(MaxTime))(ULONG aMaxTime);
    STDMETHOD(COMGETTER(MaxFileSize))(ULONG *aMaxFileSize);
    STDMETHOD(COMSETTER(MaxFileSize))(ULONG aMaxFileSize);
    STDMETHOD(COMGETTER(Options))(BSTR *aOptions);
    STDMETHOD(COMSETTER(Options))(IN_BSTR aOptions);
    STDMETHOD(COMGETTER(AudioCodec))(RecordingAudioCodec_T *aAudioCodec);
    STDMETHOD(COMSETTER(AudioCodec))(RecordingAudioCodec_T aAudioCodec);
    STDMETHOD(COMGETTER(AudioHz))(ULONG *aAudioHz);
    STDMETHOD(COMSETTER(AudioHz))(ULONG aAudioHz);
    STDMETHOD(COMGETTER(AudioBits))(ULONG *aAudioBits);
    STDMETHOD(COMSETTER(AudioBits))(ULONG aAudioBits);
    STDMETHOD(COMGETTER(AudioChannels))(ULONG *aAudioChannels);
    STDMETHOD(COMSETTER(AudioChannels))(ULONG aAudioChannels);
    STDMETHOD(COMGETTER(VideoCodec))(RecordingVideoCodec_T *aVideoCodec);
    STDMETHOD(COMSETTER(VideoCodec))(RecordingVideoCodec_T aVideoCodec);
    STDMETHOD(COMGETTER(VideoWidth))(ULONG *aVideoWidth);
    STDMETHOD(COMSETTER(VideoWidth))(ULONG aVideoWidth);
    STDMETHOD(COMGETTER(VideoHeight))(ULONG *aVideoHeight);
    STDMETHOD(COMSETTER(VideoHeight))(ULONG aVideoHeight);
    STDMETHOD(COMGETTER(VideoRate))(ULONG *aVideoRate);
    STDMETHOD(COMSETTER(VideoRate))(ULONG aVideoRate);
    STDMETHOD(COMGETTER(VideoRateControlMode))(RecordingVideoRateControlMode_T *aVideoRateControlMode);
    STDMETHOD(COMSETTER(VideoRateControlMode))(RecordingVideoRateControlMode_T aVideoRateControlMode);
    STDMETHOD(COMGETTER(VideoFPS))(ULONG *aVideoFPS);
    STDMETHOD(COMSETTER(VideoFPS))(ULONG aVideoFPS);
    STDMETHOD(COMGETTER(VideoScalingMethod))(RecordingVideoScalingMethod_T *aVideoScalingMethod);
    STDMETHOD(COMSETTER(VideoScalingMethod))(RecordingVideoScalingMethod_T aVideoScalingMethod);
    /** @} */

    /** @name Public IRecordingScreenSettings methods
     * @{ */
    STDMETHOD(IsFeatureEnabled)(RecordingFeature_T aFeature,
                                BOOL *aEnabled);
    /** @} */

private:
    /** @name Wrapped IRecordingScreenSettings properties
     * @{ */
    virtual HRESULT getId(ULONG *aId) = 0;
    virtual HRESULT getEnabled(BOOL *aEnabled) = 0;
    virtual HRESULT setEnabled(BOOL aEnabled) = 0;
    virtual HRESULT getFeatures(ULONG *aFeatures) = 0;
    virtual HRESULT setFeatures(ULONG aFeatures) = 0;
    virtual HRESULT getDestination(RecordingDestination_T *aDestination) = 0;
    virtual HRESULT setDestination(RecordingDestination_T aDestination) = 0;
    virtual HRESULT getFilename(com::Utf8Str &aFilename) = 0;
    virtual HRESULT setFilename(const com::Utf8Str &aFilename) = 0;
    virtual HRESULT getMaxTime(ULONG *aMaxTime) = 0;
    virtual HRESULT setMaxTime(ULONG aMaxTime) = 0;
    virtual HRESULT getMaxFileSize(ULONG *aMaxFileSize) = 0;
    virtual HRESULT setMaxFileSize(ULONG aMaxFileSize) = 0;
    virtual HRESULT getOptions(com::Utf8Str &aOptions) = 0;
    virtual HRESULT setOptions(const com::Utf8Str &aOptions) = 0;
    virtual HRESULT getAudioCodec(RecordingAudioCodec_T *aAudioCodec) = 0;
    virtual HRESULT setAudioCodec(RecordingAudioCodec_T aAudioCodec) = 0;
    virtual HRESULT getAudioHz(ULONG *aAudioHz) = 0;
    virtual HRESULT setAudioHz(ULONG aAudioHz) = 0;
    virtual HRESULT getAudioBits(ULONG *aAudioBits) = 0;
    virtual HRESULT setAudioBits(ULONG aAudioBits) = 0;
    virtual HRESULT getAudioChannels(ULONG *aAudioChannels) = 0;
    virtual HRESULT setAudioChannels(ULONG aAudioChannels) = 0;
    virtual HRESULT getVideoCodec(RecordingVideoCodec_T *aVideoCodec) = 0;
    virtual HRESULT setVideoCodec(RecordingVideoCodec_T aVideoCodec) = 0;
    virtual HRESULT getVideoWidth(ULONG *aVideoWidth) = 0;
    virtual HRESULT setVideoWidth(ULONG aVideoWidth) = 0;
    virtual HRESULT getVideoHeight(ULONG *aVideoHeight) = 0;
    virtual HRESULT setVideoHeight(ULONG aVideoHeight) = 0;
    virtual HRESULT getVideoRate(ULONG *aVideoRate) = 0;
    virtual HRESULT setVideoRate(ULONG aVideoRate) = 0;
    virtual HRESULT getVideoRateControlMode(RecordingVideoRateControlMode_T *aVideoRateControlMode) = 0;
    virtual HRESULT setVideoRateControlMode(RecordingVideoRateControlMode_T aVideoRateControlMode) = 0;
    virtual HRESULT getVideoFPS(ULONG *aVideoFPS) = 0;
    virtual HRESULT setVideoFPS(ULONG aVideoFPS) = 0;
    virtual HRESULT getVideoScalingMethod(RecordingVideoScalingMethod_T *aVideoScalingMethod) = 0;
    virtual HRESULT setVideoScalingMethod(RecordingVideoScalingMethod_T aVideoScalingMethod) = 0;
    /** @} */

    /** @name Wrapped IRecordingScreenSettings methods
     * @{ */
    virtual HRESULT isFeatureEnabled(RecordingFeature_T aFeature,
                                     BOOL *aEnabled) = 0;
    /** @} */

private:
    DECLARE_CLS_COPY_CTOR_ASSIGN_NOOP(RecordingScreenSettingsWrap); /* Shuts up MSC warning C4625. */

};

#endif // !RecordingScreenSettingsWrap_H_

