// ##### ENDFILE "ProgressEventWrap.cpp"


// ##### BEGINFILE "StringArrayWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IStringArray.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_STRINGARRAY

#include "StringArrayWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(StringArrayWrap)

//
// IStringArray properties
//

STDMETHODIMP StringArrayWrap::COMGETTER(Values)(ComSafeArrayOut(BSTR, aValues))
{
    LogRelFlow(("{%p} %s: enter aValues=%p\n", this, "StringArray::getValues", aValues));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValues);
        ArrayBSTROutConverter TmpValues(ComSafeArrayOutArg(aValues));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGARRAY_GET_VALUES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getValues(TmpValues.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGARRAY_GET_VALUES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpValues.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGARRAY_GET_VALUES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGARRAY_GET_VALUES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aValues=%zu hrc=%Rhrc\n", this, "StringArray::getValues", ComSafeArraySize(*aValues), hrc));
    return hrc;
}


//
// IStringArray methods
//

STDMETHODIMP StringArrayWrap::InternalAndReservedMethod1IStringArray()
{
    return E_NOTIMPL;
}

STDMETHODIMP StringArrayWrap::InternalAndReservedMethod2IStringArray()
{
    return E_NOTIMPL;
}

STDMETHODIMP StringArrayWrap::InternalAndReservedMethod3IStringArray()
{
    return E_NOTIMPL;
}

STDMETHODIMP StringArrayWrap::InternalAndReservedMethod4IStringArray()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(StringArrayWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(StringArrayWrap, IStringArray)
#endif // VBOX_WITH_XPCOM

