// ##### ENDFILE "ExtPackManagerWrap.cpp"


// ##### BEGINFILE "BandwidthGroupWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IBandwidthGroup.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_BANDWIDTHGROUP

#include "BandwidthGroupWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(BandwidthGroupWrap)

//
// IBandwidthGroup properties
//

STDMETHODIMP BandwidthGroupWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "BandwidthGroup::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHGROUP_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHGROUP_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHGROUP_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHGROUP_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "BandwidthGroup::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP BandwidthGroupWrap::COMGETTER(Type)(BandwidthGroupType_T *aType)
{
    LogRelFlow(("{%p} %s: enter aType=%p\n", this, "BandwidthGroup::getType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHGROUP_GET_TYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getType(aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHGROUP_GET_TYPE_RETURN(this, hrc, 0 /*normal*/,*aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHGROUP_GET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHGROUP_GET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aType=%RU32 hrc=%Rhrc\n", this, "BandwidthGroup::getType", *aType, hrc));
    return hrc;
}

STDMETHODIMP BandwidthGroupWrap::COMGETTER(Reference)(ULONG *aReference)
{
    LogRelFlow(("{%p} %s: enter aReference=%p\n", this, "BandwidthGroup::getReference", aReference));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aReference);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHGROUP_GET_REFERENCE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getReference(aReference);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHGROUP_GET_REFERENCE_RETURN(this, hrc, 0 /*normal*/,*aReference);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHGROUP_GET_REFERENCE_RETURN(this, hrc, 1 /*hrc exception*/,*aReference);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHGROUP_GET_REFERENCE_RETURN(this, hrc, 9 /*unhandled exception*/,*aReference);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aReference=%RU32 hrc=%Rhrc\n", this, "BandwidthGroup::getReference", *aReference, hrc));
    return hrc;
}

STDMETHODIMP BandwidthGroupWrap::COMGETTER(MaxBytesPerSec)(LONG64 *aMaxBytesPerSec)
{
    LogRelFlow(("{%p} %s: enter aMaxBytesPerSec=%p\n", this, "BandwidthGroup::getMaxBytesPerSec", aMaxBytesPerSec));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMaxBytesPerSec);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHGROUP_GET_MAXBYTESPERSEC_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMaxBytesPerSec(aMaxBytesPerSec);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHGROUP_GET_MAXBYTESPERSEC_RETURN(this, hrc, 0 /*normal*/,*aMaxBytesPerSec);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHGROUP_GET_MAXBYTESPERSEC_RETURN(this, hrc, 1 /*hrc exception*/,*aMaxBytesPerSec);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHGROUP_GET_MAXBYTESPERSEC_RETURN(this, hrc, 9 /*unhandled exception*/,*aMaxBytesPerSec);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMaxBytesPerSec=%RI64 hrc=%Rhrc\n", this, "BandwidthGroup::getMaxBytesPerSec", *aMaxBytesPerSec, hrc));
    return hrc;
}

STDMETHODIMP BandwidthGroupWrap::COMSETTER(MaxBytesPerSec)(LONG64 aMaxBytesPerSec)
{
    LogRelFlow(("{%p} %s: enter aMaxBytesPerSec=%RI64\n", this, "BandwidthGroup::setMaxBytesPerSec", aMaxBytesPerSec));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHGROUP_SET_MAXBYTESPERSEC_ENTER(this, aMaxBytesPerSec);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setMaxBytesPerSec(aMaxBytesPerSec);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHGROUP_SET_MAXBYTESPERSEC_RETURN(this, hrc, 0 /*normal*/,aMaxBytesPerSec);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHGROUP_SET_MAXBYTESPERSEC_RETURN(this, hrc, 1 /*hrc exception*/,aMaxBytesPerSec);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHGROUP_SET_MAXBYTESPERSEC_RETURN(this, hrc, 9 /*unhandled exception*/,aMaxBytesPerSec);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "BandwidthGroup::setMaxBytesPerSec", hrc));
    return hrc;
}

STDMETHODIMP BandwidthGroupWrap::COMGETTER(InternalAndReservedAttribute1IBandwidthGroup)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP BandwidthGroupWrap::COMGETTER(InternalAndReservedAttribute2IBandwidthGroup)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP BandwidthGroupWrap::COMGETTER(InternalAndReservedAttribute3IBandwidthGroup)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP BandwidthGroupWrap::COMGETTER(InternalAndReservedAttribute4IBandwidthGroup)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IBandwidthGroup methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(BandwidthGroupWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(BandwidthGroupWrap, IBandwidthGroup)
#endif // VBOX_WITH_XPCOM

