// ##### ENDFILE "PerformanceCollectorWrap.cpp"


// ##### BEGINFILE "ExtPackPlugInWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IExtPackPlugIn.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_EXTPACKPLUGIN

#include "ExtPackPlugInWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(ExtPackPlugInWrap)

//
// IExtPackPlugIn properties
//

STDMETHODIMP ExtPackPlugInWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "ExtPackPlugIn::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKPLUGIN_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKPLUGIN_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKPLUGIN_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKPLUGIN_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "ExtPackPlugIn::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP ExtPackPlugInWrap::COMGETTER(Description)(BSTR *aDescription)
{
    LogRelFlow(("{%p} %s: enter aDescription=%p\n", this, "ExtPackPlugIn::getDescription", aDescription));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDescription);
        BSTROutConverter TmpDescription(aDescription);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKPLUGIN_GET_DESCRIPTION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDescription(TmpDescription.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKPLUGIN_GET_DESCRIPTION_RETURN(this, hrc, 0 /*normal*/,TmpDescription.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKPLUGIN_GET_DESCRIPTION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKPLUGIN_GET_DESCRIPTION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDescription=%ls hrc=%Rhrc\n", this, "ExtPackPlugIn::getDescription", *aDescription, hrc));
    return hrc;
}

STDMETHODIMP ExtPackPlugInWrap::COMGETTER(Frontend)(BSTR *aFrontend)
{
    LogRelFlow(("{%p} %s: enter aFrontend=%p\n", this, "ExtPackPlugIn::getFrontend", aFrontend));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFrontend);
        BSTROutConverter TmpFrontend(aFrontend);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKPLUGIN_GET_FRONTEND_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFrontend(TmpFrontend.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKPLUGIN_GET_FRONTEND_RETURN(this, hrc, 0 /*normal*/,TmpFrontend.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKPLUGIN_GET_FRONTEND_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKPLUGIN_GET_FRONTEND_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFrontend=%ls hrc=%Rhrc\n", this, "ExtPackPlugIn::getFrontend", *aFrontend, hrc));
    return hrc;
}

STDMETHODIMP ExtPackPlugInWrap::COMGETTER(ModulePath)(BSTR *aModulePath)
{
    LogRelFlow(("{%p} %s: enter aModulePath=%p\n", this, "ExtPackPlugIn::getModulePath", aModulePath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aModulePath);
        BSTROutConverter TmpModulePath(aModulePath);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKPLUGIN_GET_MODULEPATH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getModulePath(TmpModulePath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKPLUGIN_GET_MODULEPATH_RETURN(this, hrc, 0 /*normal*/,TmpModulePath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKPLUGIN_GET_MODULEPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKPLUGIN_GET_MODULEPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aModulePath=%ls hrc=%Rhrc\n", this, "ExtPackPlugIn::getModulePath", *aModulePath, hrc));
    return hrc;
}

STDMETHODIMP ExtPackPlugInWrap::COMGETTER(InternalAndReservedAttribute1IExtPackPlugIn)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackPlugInWrap::COMGETTER(InternalAndReservedAttribute2IExtPackPlugIn)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackPlugInWrap::COMGETTER(InternalAndReservedAttribute3IExtPackPlugIn)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackPlugInWrap::COMGETTER(InternalAndReservedAttribute4IExtPackPlugIn)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IExtPackPlugIn methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(ExtPackPlugInWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(ExtPackPlugInWrap, IExtPackPlugIn)
#endif // VBOX_WITH_XPCOM

