// ##### ENDFILE "SharedFolderWrap.h"


// ##### BEGINFILE "SessionWrap.h"
/** @file
 * VirtualBox API class wrapper header for ISession.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#ifndef SessionWrap_H_
#define SessionWrap_H_
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif

#include "VirtualBoxBase.h"
#include "Wrapper.h"

class ATL_NO_VTABLE SessionWrap
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(ISession)
    , VBOX_SCRIPTABLE_IMPL(IInternalSessionControl)
{
    Q_OBJECT

public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(SessionWrap, ISession)
    DECLARE_NOT_AGGREGATABLE(SessionWrap)
    DECLARE_PROTECT_FINAL_CONSTRUCT()

    BEGIN_COM_MAP(SessionWrap)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(ISession)
        COM_INTERFACE_ENTRY2(IDispatch, ISession)
        COM_INTERFACE_ENTRY(IInternalSessionControl)
        VBOX_TWEAK_INTERFACE_ENTRY(ISession)
    END_COM_MAP()

    DECLARE_EMPTY_CTOR_DTOR(SessionWrap)

    /** @name Public ISession properties
     * @{ */
    STDMETHOD(COMGETTER(State))(SessionState_T *aState);
    STDMETHOD(COMGETTER(Type))(SessionType_T *aType);
    STDMETHOD(COMGETTER(Name))(BSTR *aName);
    STDMETHOD(COMSETTER(Name))(IN_BSTR aName);
    STDMETHOD(COMGETTER(Machine))(IMachine **aMachine);
    STDMETHOD(COMGETTER(Console))(IConsole **aConsole);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute1ISession))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute2ISession))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute3ISession))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute4ISession))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute5ISession))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute6ISession))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute7ISession))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute8ISession))(ULONG *aReserved);
    /** @} */

    /** @name Public ISession methods
     * @{ */
    STDMETHOD(UnlockMachine)();
    STDMETHOD(InternalAndReservedMethod1ISession)();
    STDMETHOD(InternalAndReservedMethod2ISession)();
    STDMETHOD(InternalAndReservedMethod3ISession)();
    STDMETHOD(InternalAndReservedMethod4ISession)();
    /** @} */

    /** @name Public IInternalSessionControl properties
     * @{ */
    STDMETHOD(COMGETTER(PID))(ULONG *aPID);
    STDMETHOD(COMGETTER(RemoteConsole))(IConsole **aRemoteConsole);
    STDMETHOD(COMGETTER(NominalState))(MachineState_T *aNominalState);
    /** @} */

    /** @name Public IInternalSessionControl methods
     * @{ */
#ifndef VBOX_WITH_XPCOM
    STDMETHOD(AssignMachine)(IMachine *aMachine,
                             LockType_T aLockType,
                             IN_BSTR aTokenId);
#endif /* !VBOX_WITH_XPCOM */
#ifdef VBOX_WITH_XPCOM
    STDMETHOD(AssignMachine)(IMachine *aMachine,
                             LockType_T aLockType,
                             IToken *aToken);
#endif /* VBOX_WITH_XPCOM */
    STDMETHOD(AssignRemoteMachine)(IMachine *aMachine,
                                   IConsole *aConsole);
    STDMETHOD(UpdateMachineState)(MachineState_T aMachineState);
    STDMETHOD(Uninitialize)();
    STDMETHOD(OnNetworkAdapterChange)(INetworkAdapter *aNetworkAdapter,
                                      BOOL aChangeAdapter);
    STDMETHOD(OnAudioAdapterChange)(IAudioAdapter *aAudioAdapter);
    STDMETHOD(OnSerialPortChange)(ISerialPort *aSerialPort);
    STDMETHOD(OnParallelPortChange)(IParallelPort *aParallelPort);
    STDMETHOD(OnStorageControllerChange)(IN_BSTR aMachineId,
                                         IN_BSTR aControllerName);
    STDMETHOD(OnMediumChange)(IMediumAttachment *aMediumAttachment,
                              BOOL aForce);
    STDMETHOD(OnStorageDeviceChange)(IMediumAttachment *aMediumAttachment,
                                     BOOL aRemove,
                                     BOOL aSilent);
    STDMETHOD(OnVMProcessPriorityChange)(VMProcPriority_T aPriority);
    STDMETHOD(OnClipboardModeChange)(ClipboardMode_T aClipboardMode);
    STDMETHOD(OnClipboardFileTransferModeChange)(BOOL aEnabled);
    STDMETHOD(OnDnDModeChange)(DnDMode_T aDndMode);
    STDMETHOD(OnCPUChange)(ULONG aCpu,
                           BOOL aAdd);
    STDMETHOD(OnCPUExecutionCapChange)(ULONG aExecutionCap);
    STDMETHOD(OnVRDEServerChange)(BOOL aRestart);
    STDMETHOD(OnRecordingChange)(BOOL aEnable);
    STDMETHOD(OnUSBControllerChange)();
    STDMETHOD(OnSharedFolderChange)(BOOL aGlobal);
    STDMETHOD(OnUSBDeviceAttach)(IUSBDevice *aDevice,
                                 IVirtualBoxErrorInfo *aError,
                                 ULONG aMaskedInterfaces,
                                 IN_BSTR aCaptureFilename);
    STDMETHOD(OnUSBDeviceDetach)(IN_BSTR aId,
                                 IVirtualBoxErrorInfo *aError);
    STDMETHOD(OnShowWindow)(BOOL aCheck,
                            BOOL *aCanShow,
                            LONG64 *aWinId);
    STDMETHOD(OnBandwidthGroupChange)(IBandwidthGroup *aBandwidthGroup);
    STDMETHOD(AccessGuestProperty)(IN_BSTR aName,
                                   IN_BSTR aValue,
                                   IN_BSTR aFlags,
                                   ULONG aAccessMode,
                                   BSTR *aRetValue,
                                   LONG64 *aRetTimestamp,
                                   BSTR *aRetFlags);
    STDMETHOD(EnumerateGuestProperties)(IN_BSTR aPatterns,
                                        ComSafeArrayOut(BSTR, aKeys),
                                        ComSafeArrayOut(BSTR, aValues),
                                        ComSafeArrayOut(LONG64, aTimestamps),
                                        ComSafeArrayOut(BSTR, aFlags));
    STDMETHOD(OnlineMergeMedium)(IMediumAttachment *aMediumAttachment,
                                 ULONG aSourceIdx,
                                 ULONG aTargetIdx,
                                 IProgress *aProgress);
    STDMETHOD(ReconfigureMediumAttachments)(ComSafeArrayIn(IMediumAttachment *, aAttachments));
    STDMETHOD(EnableVMMStatistics)(BOOL aEnable);
    STDMETHOD(PauseWithReason)(Reason_T aReason);
    STDMETHOD(ResumeWithReason)(Reason_T aReason);
    STDMETHOD(SaveStateWithReason)(Reason_T aReason,
                                   IProgress *aProgress,
                                   ISnapshot *aSnapshot,
                                   IN_BSTR aStateFilePath,
                                   BOOL aPauseVM,
                                   BOOL *aLeftPaused);
    STDMETHOD(CancelSaveStateWithReason)();
    /** @} */

private:
    /** @name Wrapped ISession properties
     * @{ */
    virtual HRESULT getState(SessionState_T *aState) = 0;
    virtual HRESULT getType(SessionType_T *aType) = 0;
    virtual HRESULT getName(com::Utf8Str &aName) = 0;
    virtual HRESULT setName(const com::Utf8Str &aName) = 0;
    virtual HRESULT getMachine(ComPtr<IMachine> &aMachine) = 0;
    virtual HRESULT getConsole(ComPtr<IConsole> &aConsole) = 0;
    /** @} */

    /** @name Wrapped ISession methods
     * @{ */
    virtual HRESULT unlockMachine() = 0;
    /** @} */

    /** @name Wrapped IInternalSessionControl properties
     * @{ */
    virtual HRESULT getPID(ULONG *aPID) = 0;
    virtual HRESULT getRemoteConsole(ComPtr<IConsole> &aRemoteConsole) = 0;
    virtual HRESULT getNominalState(MachineState_T *aNominalState) = 0;
    /** @} */

    /** @name Wrapped IInternalSessionControl methods
     * @{ */
#ifndef VBOX_WITH_XPCOM
    virtual HRESULT assignMachine(const ComPtr<IMachine> &aMachine,
                                  LockType_T aLockType,
                                  const com::Utf8Str &aTokenId) = 0;
#endif /* !VBOX_WITH_XPCOM */
#ifdef VBOX_WITH_XPCOM
    virtual HRESULT assignMachine(const ComPtr<IMachine> &aMachine,
                                  LockType_T aLockType,
                                  const ComPtr<IToken> &aToken) = 0;
#endif /* VBOX_WITH_XPCOM */
    virtual HRESULT assignRemoteMachine(const ComPtr<IMachine> &aMachine,
                                        const ComPtr<IConsole> &aConsole) = 0;
    virtual HRESULT updateMachineState(MachineState_T aMachineState) = 0;
    virtual HRESULT uninitialize() = 0;
    virtual HRESULT onNetworkAdapterChange(const ComPtr<INetworkAdapter> &aNetworkAdapter,
                                           BOOL aChangeAdapter) = 0;
    virtual HRESULT onAudioAdapterChange(const ComPtr<IAudioAdapter> &aAudioAdapter) = 0;
    virtual HRESULT onSerialPortChange(const ComPtr<ISerialPort> &aSerialPort) = 0;
    virtual HRESULT onParallelPortChange(const ComPtr<IParallelPort> &aParallelPort) = 0;
    virtual HRESULT onStorageControllerChange(const com::Guid &aMachineId,
                                              const com::Utf8Str &aControllerName) = 0;
    virtual HRESULT onMediumChange(const ComPtr<IMediumAttachment> &aMediumAttachment,
                                   BOOL aForce) = 0;
    virtual HRESULT onStorageDeviceChange(const ComPtr<IMediumAttachment> &aMediumAttachment,
                                          BOOL aRemove,
                                          BOOL aSilent) = 0;
    virtual HRESULT onVMProcessPriorityChange(VMProcPriority_T aPriority) = 0;
    virtual HRESULT onClipboardModeChange(ClipboardMode_T aClipboardMode) = 0;
    virtual HRESULT onClipboardFileTransferModeChange(BOOL aEnabled) = 0;
    virtual HRESULT onDnDModeChange(DnDMode_T aDndMode) = 0;
    virtual HRESULT onCPUChange(ULONG aCpu,
                                BOOL aAdd) = 0;
    virtual HRESULT onCPUExecutionCapChange(ULONG aExecutionCap) = 0;
    virtual HRESULT onVRDEServerChange(BOOL aRestart) = 0;
    virtual HRESULT onRecordingChange(BOOL aEnable) = 0;
    virtual HRESULT onUSBControllerChange() = 0;
    virtual HRESULT onSharedFolderChange(BOOL aGlobal) = 0;
    virtual HRESULT onUSBDeviceAttach(const ComPtr<IUSBDevice> &aDevice,
                                      const ComPtr<IVirtualBoxErrorInfo> &aError,
                                      ULONG aMaskedInterfaces,
                                      const com::Utf8Str &aCaptureFilename) = 0;
    virtual HRESULT onUSBDeviceDetach(const com::Guid &aId,
                                      const ComPtr<IVirtualBoxErrorInfo> &aError) = 0;
    virtual HRESULT onShowWindow(BOOL aCheck,
                                 BOOL *aCanShow,
                                 LONG64 *aWinId) = 0;
    virtual HRESULT onBandwidthGroupChange(const ComPtr<IBandwidthGroup> &aBandwidthGroup) = 0;
    virtual HRESULT accessGuestProperty(const com::Utf8Str &aName,
                                        const com::Utf8Str &aValue,
                                        const com::Utf8Str &aFlags,
                                        ULONG aAccessMode,
                                        com::Utf8Str &aRetValue,
                                        LONG64 *aRetTimestamp,
                                        com::Utf8Str &aRetFlags) = 0;
    virtual HRESULT enumerateGuestProperties(const com::Utf8Str &aPatterns,
                                             std::vector<com::Utf8Str> &aKeys,
                                             std::vector<com::Utf8Str> &aValues,
                                             std::vector<LONG64> &aTimestamps,
                                             std::vector<com::Utf8Str> &aFlags) = 0;
    virtual HRESULT onlineMergeMedium(const ComPtr<IMediumAttachment> &aMediumAttachment,
                                      ULONG aSourceIdx,
                                      ULONG aTargetIdx,
                                      const ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT reconfigureMediumAttachments(const std::vector<ComPtr<IMediumAttachment> > &aAttachments) = 0;
    virtual HRESULT enableVMMStatistics(BOOL aEnable) = 0;
    virtual HRESULT pauseWithReason(Reason_T aReason) = 0;
    virtual HRESULT resumeWithReason(Reason_T aReason) = 0;
    virtual HRESULT saveStateWithReason(Reason_T aReason,
                                        const ComPtr<IProgress> &aProgress,
                                        const ComPtr<ISnapshot> &aSnapshot,
                                        const com::Utf8Str &aStateFilePath,
                                        BOOL aPauseVM,
                                        BOOL *aLeftPaused) = 0;
    virtual HRESULT cancelSaveStateWithReason() = 0;
    /** @} */

private:
    DECLARE_CLS_COPY_CTOR_ASSIGN_NOOP(SessionWrap); /* Shuts up MSC warning C4625. */

};

#endif // !SessionWrap_H_

