// ##### ENDFILE "MachineEventWrap.cpp"


// ##### BEGINFILE "SnapshotEventWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for ISnapshotEvent.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_SNAPSHOTEVENT

#include "SnapshotEventWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(SnapshotEventWrap)

//
// IEvent properties
//

STDMETHODIMP SnapshotEventWrap::COMGETTER(Type)(VBoxEventType_T *aType)
{
    LogRelFlow(("{%p} %s: enter aType=%p\n", this, "SnapshotEvent::getType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_GET_TYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getType(aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_GET_TYPE_RETURN(this, hrc, 0 /*normal*/,*aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_GET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_GET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aType=%RU32 hrc=%Rhrc\n", this, "SnapshotEvent::getType", *aType, hrc));
    return hrc;
}

STDMETHODIMP SnapshotEventWrap::COMGETTER(Source)(IEventSource **aSource)
{
    LogRelFlow(("{%p} %s: enter aSource=%p\n", this, "SnapshotEvent::getSource", aSource));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSource);
        ComTypeOutConverter<IEventSource> TmpSource(aSource);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_GET_SOURCE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSource(TmpSource.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_GET_SOURCE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpSource.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_GET_SOURCE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_GET_SOURCE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSource=%p hrc=%Rhrc\n", this, "SnapshotEvent::getSource", *aSource, hrc));
    return hrc;
}

STDMETHODIMP SnapshotEventWrap::COMGETTER(Waitable)(BOOL *aWaitable)
{
    LogRelFlow(("{%p} %s: enter aWaitable=%p\n", this, "SnapshotEvent::getWaitable", aWaitable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWaitable);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_GET_WAITABLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getWaitable(aWaitable);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_GET_WAITABLE_RETURN(this, hrc, 0 /*normal*/,*aWaitable != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_GET_WAITABLE_RETURN(this, hrc, 1 /*hrc exception*/,*aWaitable != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_GET_WAITABLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aWaitable != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aWaitable=%RTbool hrc=%Rhrc\n", this, "SnapshotEvent::getWaitable", *aWaitable, hrc));
    return hrc;
}

//
// IMachineEvent properties
//

STDMETHODIMP SnapshotEventWrap::COMGETTER(MachineId)(BSTR *aMachineId)
{
    LogRelFlow(("{%p} %s: enter aMachineId=%p\n", this, "SnapshotEvent::getMachineId", aMachineId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMachineId);
        UuidOutConverter TmpMachineId(aMachineId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_GET_MACHINEID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMachineId(TmpMachineId.uuid());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_GET_MACHINEID_RETURN(this, hrc, 0 /*normal*/,TmpMachineId.uuid().toStringCurly().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_GET_MACHINEID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_GET_MACHINEID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMachineId=%ls hrc=%Rhrc\n", this, "SnapshotEvent::getMachineId", *aMachineId, hrc));
    return hrc;
}

//
// ISnapshotEvent properties
//

STDMETHODIMP SnapshotEventWrap::COMGETTER(SnapshotId)(BSTR *aSnapshotId)
{
    LogRelFlow(("{%p} %s: enter aSnapshotId=%p\n", this, "SnapshotEvent::getSnapshotId", aSnapshotId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSnapshotId);
        UuidOutConverter TmpSnapshotId(aSnapshotId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_GET_SNAPSHOTID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSnapshotId(TmpSnapshotId.uuid());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_GET_SNAPSHOTID_RETURN(this, hrc, 0 /*normal*/,TmpSnapshotId.uuid().toStringCurly().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_GET_SNAPSHOTID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_GET_SNAPSHOTID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSnapshotId=%ls hrc=%Rhrc\n", this, "SnapshotEvent::getSnapshotId", *aSnapshotId, hrc));
    return hrc;
}


//
// IEvent methods
//

STDMETHODIMP SnapshotEventWrap::SetProcessed()
{
    LogRelFlow(("{%p} %s:enter\n", this, "SnapshotEvent::setProcessed"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_SETPROCESSED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setProcessed();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_SETPROCESSED_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_SETPROCESSED_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_SETPROCESSED_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SnapshotEvent::setProcessed", hrc));
    return hrc;
}

STDMETHODIMP SnapshotEventWrap::WaitProcessed(LONG aTimeout,
                                              BOOL *aResult)
{
    LogRelFlow(("{%p} %s:enter aTimeout=%RI32 aResult=%p\n", this, "SnapshotEvent::waitProcessed", aTimeout, aResult));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aResult);


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_WAITPROCESSED_ENTER(this, aTimeout);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = waitProcessed(aTimeout,
                                aResult);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_WAITPROCESSED_RETURN(this, hrc, 0 /*normal*/, aTimeout, *aResult != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_WAITPROCESSED_RETURN(this, hrc, 1 /*hrc exception*/, aTimeout, *aResult != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOTEVENT_WAITPROCESSED_RETURN(this, hrc, 9 /*unhandled exception*/, aTimeout, *aResult != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aResult=%RTbool hrc=%Rhrc\n", this, "SnapshotEvent::waitProcessed", *aResult, hrc));
    return hrc;
}

//
// IMachineEvent methods
//

//
// ISnapshotEvent methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(SnapshotEventWrap)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(SnapshotEventWrap, ISnapshotEvent, IMachineEvent, IEvent)
#endif // VBOX_WITH_XPCOM

