// ##### ENDFILE "MediumWrap.cpp"


// ##### BEGINFILE "MediumFormatWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IMediumFormat.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_MEDIUMFORMAT

#include "MediumFormatWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(MediumFormatWrap)

//
// IMediumFormat properties
//

STDMETHODIMP MediumFormatWrap::COMGETTER(Id)(BSTR *aId)
{
    LogRelFlow(("{%p} %s: enter aId=%p\n", this, "MediumFormat::getId", aId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aId);
        BSTROutConverter TmpId(aId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMFORMAT_GET_ID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getId(TmpId.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMFORMAT_GET_ID_RETURN(this, hrc, 0 /*normal*/,TmpId.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMFORMAT_GET_ID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMFORMAT_GET_ID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aId=%ls hrc=%Rhrc\n", this, "MediumFormat::getId", *aId, hrc));
    return hrc;
}

STDMETHODIMP MediumFormatWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "MediumFormat::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMFORMAT_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMFORMAT_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMFORMAT_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMFORMAT_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "MediumFormat::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP MediumFormatWrap::COMGETTER(Capabilities)(ComSafeArrayOut(MediumFormatCapabilities_T, aCapabilities))
{
    LogRelFlow(("{%p} %s: enter aCapabilities=%p\n", this, "MediumFormat::getCapabilities", aCapabilities));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCapabilities);
        ArrayOutConverter<MediumFormatCapabilities_T> TmpCapabilities(ComSafeArrayOutArg(aCapabilities));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMFORMAT_GET_CAPABILITIES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCapabilities(TmpCapabilities.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMFORMAT_GET_CAPABILITIES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpCapabilities.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMFORMAT_GET_CAPABILITIES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMFORMAT_GET_CAPABILITIES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCapabilities=%zu hrc=%Rhrc\n", this, "MediumFormat::getCapabilities", ComSafeArraySize(*aCapabilities), hrc));
    return hrc;
}

STDMETHODIMP MediumFormatWrap::COMGETTER(InternalAndReservedAttribute1IMediumFormat)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumFormatWrap::COMGETTER(InternalAndReservedAttribute2IMediumFormat)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumFormatWrap::COMGETTER(InternalAndReservedAttribute3IMediumFormat)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumFormatWrap::COMGETTER(InternalAndReservedAttribute4IMediumFormat)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IMediumFormat methods
//

STDMETHODIMP MediumFormatWrap::DescribeFileExtensions(ComSafeArrayOut(BSTR, aExtensions),
                                                      ComSafeArrayOut(DeviceType_T, aTypes))
{
    LogRelFlow(("{%p} %s:enter aExtensions=%p aTypes=%p\n", this, "MediumFormat::describeFileExtensions", aExtensions, aTypes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aExtensions);
        CheckComArgOutPointerValidThrow(aTypes);


        ArrayBSTROutConverter TmpExtensions(ComSafeArrayOutArg(aExtensions));
        ArrayOutConverter<DeviceType_T> TmpTypes(ComSafeArrayOutArg(aTypes));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMFORMAT_DESCRIBEFILEEXTENSIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = describeFileExtensions(TmpExtensions.array(),
                                         TmpTypes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMFORMAT_DESCRIBEFILEEXTENSIONS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpExtensions.array().size(), NULL /*for now*/, (uint32_t)TmpTypes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMFORMAT_DESCRIBEFILEEXTENSIONS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMFORMAT_DESCRIBEFILEEXTENSIONS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aExtensions=%zu *aTypes=%zu hrc=%Rhrc\n", this, "MediumFormat::describeFileExtensions", ComSafeArraySize(*aExtensions), ComSafeArraySize(*aTypes), hrc));
    return hrc;
}

STDMETHODIMP MediumFormatWrap::DescribeProperties(ComSafeArrayOut(BSTR, aNames),
                                                  ComSafeArrayOut(BSTR, aDescriptions),
                                                  ComSafeArrayOut(DataType_T, aTypes),
                                                  ComSafeArrayOut(ULONG, aFlags),
                                                  ComSafeArrayOut(BSTR, aDefaults))
{
    LogRelFlow(("{%p} %s:enter aNames=%p aDescriptions=%p aTypes=%p aFlags=%p aDefaults=%p\n", this, "MediumFormat::describeProperties", aNames, aDescriptions, aTypes, aFlags, aDefaults));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNames);
        CheckComArgOutPointerValidThrow(aDescriptions);
        CheckComArgOutPointerValidThrow(aTypes);
        CheckComArgOutPointerValidThrow(aFlags);
        CheckComArgOutPointerValidThrow(aDefaults);


        ArrayBSTROutConverter TmpNames(ComSafeArrayOutArg(aNames));
        ArrayBSTROutConverter TmpDescriptions(ComSafeArrayOutArg(aDescriptions));
        ArrayOutConverter<DataType_T> TmpTypes(ComSafeArrayOutArg(aTypes));
        ArrayOutConverter<ULONG> TmpFlags(ComSafeArrayOutArg(aFlags));
        ArrayBSTROutConverter TmpDefaults(ComSafeArrayOutArg(aDefaults));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMFORMAT_DESCRIBEPROPERTIES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = describeProperties(TmpNames.array(),
                                     TmpDescriptions.array(),
                                     TmpTypes.array(),
                                     TmpFlags.array(),
                                     TmpDefaults.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMFORMAT_DESCRIBEPROPERTIES_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpNames.array().size(), NULL /*for now*/, (uint32_t)TmpDescriptions.array().size(), NULL /*for now*/, (uint32_t)TmpTypes.array().size(), NULL /*for now*/, (uint32_t)TmpFlags.array().size(), NULL /*for now*/, (uint32_t)TmpDefaults.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMFORMAT_DESCRIBEPROPERTIES_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMFORMAT_DESCRIBEPROPERTIES_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNames=%zu *aDescriptions=%zu *aTypes=%zu *aFlags=%zu *aDefaults=%zu hrc=%Rhrc\n", this, "MediumFormat::describeProperties", ComSafeArraySize(*aNames), ComSafeArraySize(*aDescriptions), ComSafeArraySize(*aTypes), ComSafeArraySize(*aFlags), ComSafeArraySize(*aDefaults), hrc));
    return hrc;
}

STDMETHODIMP MediumFormatWrap::InternalAndReservedMethod1IMediumFormat()
{
    return E_NOTIMPL;
}

STDMETHODIMP MediumFormatWrap::InternalAndReservedMethod2IMediumFormat()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(MediumFormatWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(MediumFormatWrap, IMediumFormat)
#endif // VBOX_WITH_XPCOM

