// ##### ENDFILE "GuestWrap.cpp"


// ##### BEGINFILE "MediumWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IMedium.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_MEDIUM

#include "MediumWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(MediumWrap)

//
// IMedium properties
//

STDMETHODIMP MediumWrap::COMGETTER(Id)(BSTR *aId)
{
    LogRelFlow(("{%p} %s: enter aId=%p\n", this, "Medium::getId", aId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aId);
        UuidOutConverter TmpId(aId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_ID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getId(TmpId.uuid());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_ID_RETURN(this, hrc, 0 /*normal*/,TmpId.uuid().toStringCurly().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_ID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_ID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aId=%ls hrc=%Rhrc\n", this, "Medium::getId", *aId, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::COMGETTER(Description)(BSTR *aDescription)
{
    LogRelFlow(("{%p} %s: enter aDescription=%p\n", this, "Medium::getDescription", aDescription));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDescription);
        BSTROutConverter TmpDescription(aDescription);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_DESCRIPTION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDescription(autoCaller, TmpDescription.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_DESCRIPTION_RETURN(this, hrc, 0 /*normal*/,TmpDescription.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_DESCRIPTION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_DESCRIPTION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDescription=%ls hrc=%Rhrc\n", this, "Medium::getDescription", *aDescription, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::COMSETTER(Description)(IN_BSTR aDescription)
{
    LogRelFlow(("{%p} %s: enter aDescription=%ls\n", this, "Medium::setDescription", aDescription));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpDescription(aDescription);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SET_DESCRIPTION_ENTER(this, TmpDescription.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setDescription(autoCaller, TmpDescription.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SET_DESCRIPTION_RETURN(this, hrc, 0 /*normal*/,TmpDescription.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SET_DESCRIPTION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SET_DESCRIPTION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Medium::setDescription", hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::COMGETTER(State)(MediumState_T *aState)
{
    LogRelFlow(("{%p} %s: enter aState=%p\n", this, "Medium::getState", aState));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aState);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_STATE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getState(aState);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_STATE_RETURN(this, hrc, 0 /*normal*/,*aState);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_STATE_RETURN(this, hrc, 1 /*hrc exception*/,*aState);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_STATE_RETURN(this, hrc, 9 /*unhandled exception*/,*aState);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aState=%RU32 hrc=%Rhrc\n", this, "Medium::getState", *aState, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::COMGETTER(Variant)(ComSafeArrayOut(MediumVariant_T, aVariant))
{
    LogRelFlow(("{%p} %s: enter aVariant=%p\n", this, "Medium::getVariant", aVariant));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVariant);
        ArrayOutConverter<MediumVariant_T> TmpVariant(ComSafeArrayOutArg(aVariant));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_VARIANT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVariant(TmpVariant.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_VARIANT_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpVariant.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_VARIANT_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_VARIANT_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVariant=%zu hrc=%Rhrc\n", this, "Medium::getVariant", ComSafeArraySize(*aVariant), hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::COMGETTER(Location)(BSTR *aLocation)
{
    LogRelFlow(("{%p} %s: enter aLocation=%p\n", this, "Medium::getLocation", aLocation));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLocation);
        BSTROutConverter TmpLocation(aLocation);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_LOCATION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLocation(TmpLocation.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_LOCATION_RETURN(this, hrc, 0 /*normal*/,TmpLocation.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_LOCATION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_LOCATION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLocation=%ls hrc=%Rhrc\n", this, "Medium::getLocation", *aLocation, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::COMSETTER(Location)(IN_BSTR aLocation)
{
    LogRelFlow(("{%p} %s: enter aLocation=%ls\n", this, "Medium::setLocation", aLocation));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpLocation(aLocation);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SET_LOCATION_ENTER(this, TmpLocation.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setLocation(TmpLocation.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SET_LOCATION_RETURN(this, hrc, 0 /*normal*/,TmpLocation.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SET_LOCATION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SET_LOCATION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Medium::setLocation", hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "Medium::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "Medium::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::COMGETTER(DeviceType)(DeviceType_T *aDeviceType)
{
    LogRelFlow(("{%p} %s: enter aDeviceType=%p\n", this, "Medium::getDeviceType", aDeviceType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDeviceType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_DEVICETYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDeviceType(aDeviceType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_DEVICETYPE_RETURN(this, hrc, 0 /*normal*/,*aDeviceType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_DEVICETYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aDeviceType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_DEVICETYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aDeviceType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDeviceType=%RU32 hrc=%Rhrc\n", this, "Medium::getDeviceType", *aDeviceType, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::COMGETTER(HostDrive)(BOOL *aHostDrive)
{
    LogRelFlow(("{%p} %s: enter aHostDrive=%p\n", this, "Medium::getHostDrive", aHostDrive));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHostDrive);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_HOSTDRIVE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHostDrive(aHostDrive);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_HOSTDRIVE_RETURN(this, hrc, 0 /*normal*/,*aHostDrive != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_HOSTDRIVE_RETURN(this, hrc, 1 /*hrc exception*/,*aHostDrive != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_HOSTDRIVE_RETURN(this, hrc, 9 /*unhandled exception*/,*aHostDrive != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHostDrive=%RTbool hrc=%Rhrc\n", this, "Medium::getHostDrive", *aHostDrive, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::COMGETTER(Size)(LONG64 *aSize)
{
    LogRelFlow(("{%p} %s: enter aSize=%p\n", this, "Medium::getSize", aSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSize);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_SIZE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSize(aSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_SIZE_RETURN(this, hrc, 0 /*normal*/,*aSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_SIZE_RETURN(this, hrc, 1 /*hrc exception*/,*aSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_SIZE_RETURN(this, hrc, 9 /*unhandled exception*/,*aSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSize=%RI64 hrc=%Rhrc\n", this, "Medium::getSize", *aSize, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::COMGETTER(Format)(BSTR *aFormat)
{
    LogRelFlow(("{%p} %s: enter aFormat=%p\n", this, "Medium::getFormat", aFormat));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFormat);
        BSTROutConverter TmpFormat(aFormat);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_FORMAT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFormat(TmpFormat.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_FORMAT_RETURN(this, hrc, 0 /*normal*/,TmpFormat.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_FORMAT_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_FORMAT_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFormat=%ls hrc=%Rhrc\n", this, "Medium::getFormat", *aFormat, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::COMGETTER(MediumFormat)(IMediumFormat **aMediumFormat)
{
    LogRelFlow(("{%p} %s: enter aMediumFormat=%p\n", this, "Medium::getMediumFormat", aMediumFormat));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMediumFormat);
        ComTypeOutConverter<IMediumFormat> TmpMediumFormat(aMediumFormat);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_MEDIUMFORMAT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMediumFormat(TmpMediumFormat.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_MEDIUMFORMAT_RETURN(this, hrc, 0 /*normal*/,(void *)TmpMediumFormat.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_MEDIUMFORMAT_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_MEDIUMFORMAT_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMediumFormat=%p hrc=%Rhrc\n", this, "Medium::getMediumFormat", *aMediumFormat, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::COMGETTER(Type)(MediumType_T *aType)
{
    LogRelFlow(("{%p} %s: enter aType=%p\n", this, "Medium::getType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_TYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getType(autoCaller, aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_TYPE_RETURN(this, hrc, 0 /*normal*/,*aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aType=%RU32 hrc=%Rhrc\n", this, "Medium::getType", *aType, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::COMSETTER(Type)(MediumType_T aType)
{
    LogRelFlow(("{%p} %s: enter aType=%RU32\n", this, "Medium::setType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SET_TYPE_ENTER(this, aType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setType(autoCaller, aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SET_TYPE_RETURN(this, hrc, 0 /*normal*/,aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Medium::setType", hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::COMGETTER(AllowedTypes)(ComSafeArrayOut(MediumType_T, aAllowedTypes))
{
    LogRelFlow(("{%p} %s: enter aAllowedTypes=%p\n", this, "Medium::getAllowedTypes", aAllowedTypes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAllowedTypes);
        ArrayOutConverter<MediumType_T> TmpAllowedTypes(ComSafeArrayOutArg(aAllowedTypes));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_ALLOWEDTYPES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAllowedTypes(TmpAllowedTypes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_ALLOWEDTYPES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpAllowedTypes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_ALLOWEDTYPES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_ALLOWEDTYPES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAllowedTypes=%zu hrc=%Rhrc\n", this, "Medium::getAllowedTypes", ComSafeArraySize(*aAllowedTypes), hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::COMGETTER(Parent)(IMedium **aParent)
{
    LogRelFlow(("{%p} %s: enter aParent=%p\n", this, "Medium::getParent", aParent));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aParent);
        ComTypeOutConverter<IMedium> TmpParent(aParent);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_PARENT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getParent(autoCaller, TmpParent.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_PARENT_RETURN(this, hrc, 0 /*normal*/,(void *)TmpParent.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_PARENT_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_PARENT_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aParent=%p hrc=%Rhrc\n", this, "Medium::getParent", *aParent, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::COMGETTER(Children)(ComSafeArrayOut(IMedium *, aChildren))
{
    LogRelFlow(("{%p} %s: enter aChildren=%p\n", this, "Medium::getChildren", aChildren));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aChildren);
        ArrayComTypeOutConverter<IMedium> TmpChildren(ComSafeArrayOutArg(aChildren));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_CHILDREN_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getChildren(autoCaller, TmpChildren.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_CHILDREN_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpChildren.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_CHILDREN_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_CHILDREN_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aChildren=%zu hrc=%Rhrc\n", this, "Medium::getChildren", ComSafeArraySize(*aChildren), hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::COMGETTER(Base)(IMedium **aBase)
{
    LogRelFlow(("{%p} %s: enter aBase=%p\n", this, "Medium::getBase", aBase));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBase);
        ComTypeOutConverter<IMedium> TmpBase(aBase);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_BASE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getBase(autoCaller, TmpBase.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_BASE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpBase.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_BASE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_BASE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aBase=%p hrc=%Rhrc\n", this, "Medium::getBase", *aBase, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::COMGETTER(ReadOnly)(BOOL *aReadOnly)
{
    LogRelFlow(("{%p} %s: enter aReadOnly=%p\n", this, "Medium::getReadOnly", aReadOnly));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aReadOnly);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_READONLY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getReadOnly(autoCaller, aReadOnly);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_READONLY_RETURN(this, hrc, 0 /*normal*/,*aReadOnly != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_READONLY_RETURN(this, hrc, 1 /*hrc exception*/,*aReadOnly != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_READONLY_RETURN(this, hrc, 9 /*unhandled exception*/,*aReadOnly != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aReadOnly=%RTbool hrc=%Rhrc\n", this, "Medium::getReadOnly", *aReadOnly, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::COMGETTER(LogicalSize)(LONG64 *aLogicalSize)
{
    LogRelFlow(("{%p} %s: enter aLogicalSize=%p\n", this, "Medium::getLogicalSize", aLogicalSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLogicalSize);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_LOGICALSIZE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLogicalSize(aLogicalSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_LOGICALSIZE_RETURN(this, hrc, 0 /*normal*/,*aLogicalSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_LOGICALSIZE_RETURN(this, hrc, 1 /*hrc exception*/,*aLogicalSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_LOGICALSIZE_RETURN(this, hrc, 9 /*unhandled exception*/,*aLogicalSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLogicalSize=%RI64 hrc=%Rhrc\n", this, "Medium::getLogicalSize", *aLogicalSize, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::COMGETTER(AutoReset)(BOOL *aAutoReset)
{
    LogRelFlow(("{%p} %s: enter aAutoReset=%p\n", this, "Medium::getAutoReset", aAutoReset));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAutoReset);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_AUTORESET_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAutoReset(aAutoReset);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_AUTORESET_RETURN(this, hrc, 0 /*normal*/,*aAutoReset != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_AUTORESET_RETURN(this, hrc, 1 /*hrc exception*/,*aAutoReset != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_AUTORESET_RETURN(this, hrc, 9 /*unhandled exception*/,*aAutoReset != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAutoReset=%RTbool hrc=%Rhrc\n", this, "Medium::getAutoReset", *aAutoReset, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::COMSETTER(AutoReset)(BOOL aAutoReset)
{
    LogRelFlow(("{%p} %s: enter aAutoReset=%RTbool\n", this, "Medium::setAutoReset", aAutoReset));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SET_AUTORESET_ENTER(this, aAutoReset != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAutoReset(aAutoReset != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SET_AUTORESET_RETURN(this, hrc, 0 /*normal*/,aAutoReset != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SET_AUTORESET_RETURN(this, hrc, 1 /*hrc exception*/,aAutoReset != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SET_AUTORESET_RETURN(this, hrc, 9 /*unhandled exception*/,aAutoReset != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Medium::setAutoReset", hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::COMGETTER(LastAccessError)(BSTR *aLastAccessError)
{
    LogRelFlow(("{%p} %s: enter aLastAccessError=%p\n", this, "Medium::getLastAccessError", aLastAccessError));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLastAccessError);
        BSTROutConverter TmpLastAccessError(aLastAccessError);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_LASTACCESSERROR_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLastAccessError(TmpLastAccessError.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_LASTACCESSERROR_RETURN(this, hrc, 0 /*normal*/,TmpLastAccessError.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_LASTACCESSERROR_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_LASTACCESSERROR_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLastAccessError=%ls hrc=%Rhrc\n", this, "Medium::getLastAccessError", *aLastAccessError, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::COMGETTER(MachineIds)(ComSafeArrayOut(BSTR, aMachineIds))
{
    LogRelFlow(("{%p} %s: enter aMachineIds=%p\n", this, "Medium::getMachineIds", aMachineIds));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMachineIds);
        ArrayUuidOutConverter TmpMachineIds(ComSafeArrayOutArg(aMachineIds));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_MACHINEIDS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMachineIds(TmpMachineIds.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_MACHINEIDS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpMachineIds.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_MACHINEIDS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GET_MACHINEIDS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMachineIds=%zu hrc=%Rhrc\n", this, "Medium::getMachineIds", ComSafeArraySize(*aMachineIds), hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::COMGETTER(InternalAndReservedAttribute1IMedium)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumWrap::COMGETTER(InternalAndReservedAttribute2IMedium)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumWrap::COMGETTER(InternalAndReservedAttribute3IMedium)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumWrap::COMGETTER(InternalAndReservedAttribute4IMedium)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumWrap::COMGETTER(InternalAndReservedAttribute5IMedium)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumWrap::COMGETTER(InternalAndReservedAttribute6IMedium)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumWrap::COMGETTER(InternalAndReservedAttribute7IMedium)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumWrap::COMGETTER(InternalAndReservedAttribute8IMedium)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumWrap::COMGETTER(InternalAndReservedAttribute9IMedium)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumWrap::COMGETTER(InternalAndReservedAttribute10IMedium)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumWrap::COMGETTER(InternalAndReservedAttribute11IMedium)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumWrap::COMGETTER(InternalAndReservedAttribute12IMedium)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IMedium methods
//

STDMETHODIMP MediumWrap::SetIds(BOOL aSetImageId,
                                IN_BSTR aImageId,
                                BOOL aSetParentId,
                                IN_BSTR aParentId)
{
    LogRelFlow(("{%p} %s:enter aSetImageId=%RTbool aImageId=%ls aSetParentId=%RTbool aParentId=%ls\n", this, "Medium::setIds", aSetImageId, aImageId, aSetParentId, aParentId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        UuidInConverter TmpImageId(aImageId);
        
        UuidInConverter TmpParentId(aParentId);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SETIDS_ENTER(this, aSetImageId != FALSE, TmpImageId.uuid().toStringCurly().c_str(), aSetParentId != FALSE, TmpParentId.uuid().toStringCurly().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setIds(autoCaller,
                     aSetImageId != FALSE,
                         TmpImageId.uuid(),
                         aSetParentId != FALSE,
                         TmpParentId.uuid());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SETIDS_RETURN(this, hrc, 0 /*normal*/, aSetImageId != FALSE, TmpImageId.uuid().toStringCurly().c_str(), aSetParentId != FALSE, TmpParentId.uuid().toStringCurly().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SETIDS_RETURN(this, hrc, 1 /*hrc exception*/, aSetImageId != FALSE, 0, aSetParentId != FALSE, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SETIDS_RETURN(this, hrc, 9 /*unhandled exception*/, aSetImageId != FALSE, 0, aSetParentId != FALSE, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Medium::setIds", hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::RefreshState(MediumState_T *aState)
{
    LogRelFlow(("{%p} %s:enter aState=%p\n", this, "Medium::refreshState", aState));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aState);


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_REFRESHSTATE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = refreshState(autoCaller,
                           aState);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_REFRESHSTATE_RETURN(this, hrc, 0 /*normal*/, *aState);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_REFRESHSTATE_RETURN(this, hrc, 1 /*hrc exception*/, *aState);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_REFRESHSTATE_RETURN(this, hrc, 9 /*unhandled exception*/, *aState);
#endif
    }

    LogRelFlow(("{%p} %s: leave aState=%RU32 hrc=%Rhrc\n", this, "Medium::refreshState", *aState, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::GetSnapshotIds(IN_BSTR aMachineId,
                                        ComSafeArrayOut(BSTR, aSnapshotIds))
{
    LogRelFlow(("{%p} %s:enter aMachineId=%ls aSnapshotIds=%p\n", this, "Medium::getSnapshotIds", aMachineId, aSnapshotIds));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSnapshotIds);


        UuidInConverter TmpMachineId(aMachineId);
        ArrayUuidOutConverter TmpSnapshotIds(ComSafeArrayOutArg(aSnapshotIds));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GETSNAPSHOTIDS_ENTER(this, TmpMachineId.uuid().toStringCurly().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSnapshotIds(TmpMachineId.uuid(),
                                 TmpSnapshotIds.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GETSNAPSHOTIDS_RETURN(this, hrc, 0 /*normal*/, TmpMachineId.uuid().toStringCurly().c_str(), (uint32_t)TmpSnapshotIds.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GETSNAPSHOTIDS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GETSNAPSHOTIDS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aSnapshotIds=%zu hrc=%Rhrc\n", this, "Medium::getSnapshotIds", ComSafeArraySize(*aSnapshotIds), hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::LockRead(IToken **aToken)
{
    LogRelFlow(("{%p} %s:enter aToken=%p\n", this, "Medium::lockRead", aToken));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aToken);


        ComTypeOutConverter<IToken> TmpToken(aToken);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_LOCKREAD_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = lockRead(TmpToken.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_LOCKREAD_RETURN(this, hrc, 0 /*normal*/, (void *)TmpToken.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_LOCKREAD_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_LOCKREAD_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aToken=%p hrc=%Rhrc\n", this, "Medium::lockRead", *aToken, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::LockWrite(IToken **aToken)
{
    LogRelFlow(("{%p} %s:enter aToken=%p\n", this, "Medium::lockWrite", aToken));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aToken);


        ComTypeOutConverter<IToken> TmpToken(aToken);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_LOCKWRITE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = lockWrite(TmpToken.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_LOCKWRITE_RETURN(this, hrc, 0 /*normal*/, (void *)TmpToken.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_LOCKWRITE_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_LOCKWRITE_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aToken=%p hrc=%Rhrc\n", this, "Medium::lockWrite", *aToken, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::Close()
{
    LogRelFlow(("{%p} %s:enter\n", this, "Medium::close"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CLOSE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = close(autoCaller);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CLOSE_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CLOSE_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CLOSE_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Medium::close", hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::GetProperty(IN_BSTR aName,
                                     BSTR *aValue)
{
    LogRelFlow(("{%p} %s:enter aName=%ls aValue=%p\n", this, "Medium::getProperty", aName, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValue);


        BSTRInConverter TmpName(aName);
        BSTROutConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GETPROPERTY_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProperty(TmpName.str(),
                              TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GETPROPERTY_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GETPROPERTY_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GETPROPERTY_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aValue=%ls hrc=%Rhrc\n", this, "Medium::getProperty", *aValue, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::SetProperty(IN_BSTR aName,
                                     IN_BSTR aValue)
{
    LogRelFlow(("{%p} %s:enter aName=%ls aValue=%ls\n", this, "Medium::setProperty", aName, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);
        BSTRInConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SETPROPERTY_ENTER(this, TmpName.str().c_str(), TmpValue.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setProperty(TmpName.str(),
                              TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SETPROPERTY_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SETPROPERTY_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SETPROPERTY_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Medium::setProperty", hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::GetProperties(IN_BSTR aNames,
                                       ComSafeArrayOut(BSTR, aReturnNames),
                                       ComSafeArrayOut(BSTR, aReturnValues))
{
    LogRelFlow(("{%p} %s:enter aNames=%ls aReturnNames=%p aReturnValues=%p\n", this, "Medium::getProperties", aNames, aReturnNames, aReturnValues));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aReturnNames);
        CheckComArgOutPointerValidThrow(aReturnValues);


        BSTRInConverter TmpNames(aNames);
        ArrayBSTROutConverter TmpReturnNames(ComSafeArrayOutArg(aReturnNames));
        ArrayBSTROutConverter TmpReturnValues(ComSafeArrayOutArg(aReturnValues));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GETPROPERTIES_ENTER(this, TmpNames.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProperties(TmpNames.str(),
                                TmpReturnNames.array(),
                                TmpReturnValues.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GETPROPERTIES_RETURN(this, hrc, 0 /*normal*/, TmpNames.str().c_str(), (uint32_t)TmpReturnNames.array().size(), NULL /*for now*/, (uint32_t)TmpReturnValues.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GETPROPERTIES_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GETPROPERTIES_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aReturnNames=%zu aReturnValues=%zu hrc=%Rhrc\n", this, "Medium::getProperties", ComSafeArraySize(*aReturnNames), ComSafeArraySize(*aReturnValues), hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::SetProperties(ComSafeArrayIn(IN_BSTR, aNames),
                                       ComSafeArrayIn(IN_BSTR, aValues))
{
    LogRelFlow(("{%p} %s:enter aNames=%zu aValues=%zu\n", this, "Medium::setProperties", aNames, aValues));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ArrayBSTRInConverter TmpNames(ComSafeArrayInArg(aNames));
        ArrayBSTRInConverter TmpValues(ComSafeArrayInArg(aValues));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SETPROPERTIES_ENTER(this, (uint32_t)TmpNames.array().size(), NULL /*for now*/, (uint32_t)TmpValues.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setProperties(TmpNames.array(),
                                TmpValues.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SETPROPERTIES_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpNames.array().size(), NULL /*for now*/, (uint32_t)TmpValues.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SETPROPERTIES_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_SETPROPERTIES_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Medium::setProperties", hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::CreateBaseStorage(LONG64 aLogicalSize,
                                           ComSafeArrayIn(MediumVariant_T, aVariant),
                                           IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aLogicalSize=%RI64 aVariant=%zu aProgress=%p\n", this, "Medium::createBaseStorage", aLogicalSize, aVariant, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        
        ArrayInConverter<MediumVariant_T> TmpVariant(ComSafeArrayInArg(aVariant));
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CREATEBASESTORAGE_ENTER(this, aLogicalSize, (uint32_t)TmpVariant.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = createBaseStorage(aLogicalSize,
                                    TmpVariant.array(),
                                    TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CREATEBASESTORAGE_RETURN(this, hrc, 0 /*normal*/, aLogicalSize, (uint32_t)TmpVariant.array().size(), NULL /*for now*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CREATEBASESTORAGE_RETURN(this, hrc, 1 /*hrc exception*/, aLogicalSize, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CREATEBASESTORAGE_RETURN(this, hrc, 9 /*unhandled exception*/, aLogicalSize, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Medium::createBaseStorage", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::DeleteStorage(IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aProgress=%p\n", this, "Medium::deleteStorage", aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_DELETESTORAGE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = deleteStorage(TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_DELETESTORAGE_RETURN(this, hrc, 0 /*normal*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_DELETESTORAGE_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_DELETESTORAGE_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Medium::deleteStorage", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::CreateDiffStorage(IMedium *aTarget,
                                           ComSafeArrayIn(MediumVariant_T, aVariant),
                                           IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aTarget=%p aVariant=%zu aProgress=%p\n", this, "Medium::createDiffStorage", aTarget, aVariant, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeInConverter<IMedium> TmpTarget(aTarget);
        ArrayInConverter<MediumVariant_T> TmpVariant(ComSafeArrayInArg(aVariant));
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CREATEDIFFSTORAGE_ENTER(this, (void *)TmpTarget.ptr(), (uint32_t)TmpVariant.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = createDiffStorage(autoCaller,
                                TmpTarget.ptr(),
                                    TmpVariant.array(),
                                    TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CREATEDIFFSTORAGE_RETURN(this, hrc, 0 /*normal*/, (void *)TmpTarget.ptr(), (uint32_t)TmpVariant.array().size(), NULL /*for now*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CREATEDIFFSTORAGE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CREATEDIFFSTORAGE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Medium::createDiffStorage", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::MergeTo(IMedium *aTarget,
                                 IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aTarget=%p aProgress=%p\n", this, "Medium::mergeTo", aTarget, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeInConverter<IMedium> TmpTarget(aTarget);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_MERGETO_ENTER(this, (void *)TmpTarget.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = mergeTo(TmpTarget.ptr(),
                          TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_MERGETO_RETURN(this, hrc, 0 /*normal*/, (void *)TmpTarget.ptr(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_MERGETO_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_MERGETO_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Medium::mergeTo", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::CloneTo(IMedium *aTarget,
                                 ComSafeArrayIn(MediumVariant_T, aVariant),
                                 IMedium *aParent,
                                 IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aTarget=%p aVariant=%zu aParent=%p aProgress=%p\n", this, "Medium::cloneTo", aTarget, aVariant, aParent, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeInConverter<IMedium> TmpTarget(aTarget);
        ArrayInConverter<MediumVariant_T> TmpVariant(ComSafeArrayInArg(aVariant));
        ComTypeInConverter<IMedium> TmpParent(aParent);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CLONETO_ENTER(this, (void *)TmpTarget.ptr(), (uint32_t)TmpVariant.array().size(), NULL /*for now*/, (void *)TmpParent.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = cloneTo(TmpTarget.ptr(),
                          TmpVariant.array(),
                          TmpParent.ptr(),
                          TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CLONETO_RETURN(this, hrc, 0 /*normal*/, (void *)TmpTarget.ptr(), (uint32_t)TmpVariant.array().size(), NULL /*for now*/, (void *)TmpParent.ptr(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CLONETO_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CLONETO_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Medium::cloneTo", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::CloneToBase(IMedium *aTarget,
                                     ComSafeArrayIn(MediumVariant_T, aVariant),
                                     IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aTarget=%p aVariant=%zu aProgress=%p\n", this, "Medium::cloneToBase", aTarget, aVariant, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeInConverter<IMedium> TmpTarget(aTarget);
        ArrayInConverter<MediumVariant_T> TmpVariant(ComSafeArrayInArg(aVariant));
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CLONETOBASE_ENTER(this, (void *)TmpTarget.ptr(), (uint32_t)TmpVariant.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = cloneToBase(TmpTarget.ptr(),
                              TmpVariant.array(),
                              TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CLONETOBASE_RETURN(this, hrc, 0 /*normal*/, (void *)TmpTarget.ptr(), (uint32_t)TmpVariant.array().size(), NULL /*for now*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CLONETOBASE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CLONETOBASE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Medium::cloneToBase", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::MoveTo(IN_BSTR aLocation,
                                IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aLocation=%ls aProgress=%p\n", this, "Medium::moveTo", aLocation, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpLocation(aLocation);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_MOVETO_ENTER(this, TmpLocation.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = moveTo(autoCaller,
                     TmpLocation.str(),
                         TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_MOVETO_RETURN(this, hrc, 0 /*normal*/, TmpLocation.str().c_str(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_MOVETO_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_MOVETO_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Medium::moveTo", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::Compact(IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aProgress=%p\n", this, "Medium::compact", aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_COMPACT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = compact(TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_COMPACT_RETURN(this, hrc, 0 /*normal*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_COMPACT_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_COMPACT_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Medium::compact", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::Resize(LONG64 aLogicalSize,
                                IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aLogicalSize=%RI64 aProgress=%p\n", this, "Medium::resize", aLogicalSize, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_RESIZE_ENTER(this, aLogicalSize);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = resize(aLogicalSize,
                         TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_RESIZE_RETURN(this, hrc, 0 /*normal*/, aLogicalSize, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_RESIZE_RETURN(this, hrc, 1 /*hrc exception*/, aLogicalSize, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_RESIZE_RETURN(this, hrc, 9 /*unhandled exception*/, aLogicalSize, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Medium::resize", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::Reset(IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aProgress=%p\n", this, "Medium::reset", aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_RESET_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = reset(autoCaller,
                    TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_RESET_RETURN(this, hrc, 0 /*normal*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_RESET_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_RESET_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Medium::reset", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::ChangeEncryption(IN_BSTR aCurrentPassword,
                                          IN_BSTR aCipher,
                                          IN_BSTR aNewPassword,
                                          IN_BSTR aNewPasswordId,
                                          IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aCurrentPassword=%ls aCipher=%ls aNewPassword=%ls aNewPasswordId=%ls aProgress=%p\n", this, "Medium::changeEncryption", aCurrentPassword, aCipher, aNewPassword, aNewPasswordId, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpCurrentPassword(aCurrentPassword);
        BSTRInConverter TmpCipher(aCipher);
        BSTRInConverter TmpNewPassword(aNewPassword);
        BSTRInConverter TmpNewPasswordId(aNewPasswordId);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CHANGEENCRYPTION_ENTER(this, TmpCurrentPassword.str().c_str(), TmpCipher.str().c_str(), TmpNewPassword.str().c_str(), TmpNewPasswordId.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = changeEncryption(TmpCurrentPassword.str(),
                                   TmpCipher.str(),
                                   TmpNewPassword.str(),
                                   TmpNewPasswordId.str(),
                                   TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CHANGEENCRYPTION_RETURN(this, hrc, 0 /*normal*/, TmpCurrentPassword.str().c_str(), TmpCipher.str().c_str(), TmpNewPassword.str().c_str(), TmpNewPasswordId.str().c_str(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CHANGEENCRYPTION_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CHANGEENCRYPTION_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Medium::changeEncryption", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::GetEncryptionSettings(BSTR *aCipher,
                                               BSTR *aPasswordId)
{
    LogRelFlow(("{%p} %s:enter aCipher=%p aPasswordId=%p\n", this, "Medium::getEncryptionSettings", aCipher, aPasswordId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCipher);
        CheckComArgOutPointerValidThrow(aPasswordId);


        BSTROutConverter TmpCipher(aCipher);
        BSTROutConverter TmpPasswordId(aPasswordId);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GETENCRYPTIONSETTINGS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEncryptionSettings(autoCaller,
                                    TmpCipher.str(),
                                        TmpPasswordId.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GETENCRYPTIONSETTINGS_RETURN(this, hrc, 0 /*normal*/, TmpCipher.str().c_str(), TmpPasswordId.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GETENCRYPTIONSETTINGS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_GETENCRYPTIONSETTINGS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCipher=%ls aPasswordId=%ls hrc=%Rhrc\n", this, "Medium::getEncryptionSettings", *aCipher, *aPasswordId, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::CheckEncryptionPassword(IN_BSTR aPassword)
{
    LogRelFlow(("{%p} %s:enter aPassword=%ls\n", this, "Medium::checkEncryptionPassword", aPassword));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpPassword(aPassword);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CHECKENCRYPTIONPASSWORD_ENTER(this, TmpPassword.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = checkEncryptionPassword(TmpPassword.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CHECKENCRYPTIONPASSWORD_RETURN(this, hrc, 0 /*normal*/, TmpPassword.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CHECKENCRYPTIONPASSWORD_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_CHECKENCRYPTIONPASSWORD_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Medium::checkEncryptionPassword", hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::OpenForIO(BOOL aWritable,
                                   IN_BSTR aPassword,
                                   IMediumIO **aMediumIO)
{
    LogRelFlow(("{%p} %s:enter aWritable=%RTbool aPassword=%ls aMediumIO=%p\n", this, "Medium::openForIO", aWritable, aPassword, aMediumIO));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMediumIO);


        
        BSTRInConverter TmpPassword(aPassword);
        ComTypeOutConverter<IMediumIO> TmpMediumIO(aMediumIO);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_OPENFORIO_ENTER(this, aWritable != FALSE, TmpPassword.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = openForIO(aWritable != FALSE,
                            TmpPassword.str(),
                            TmpMediumIO.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_OPENFORIO_RETURN(this, hrc, 0 /*normal*/, aWritable != FALSE, TmpPassword.str().c_str(), (void *)TmpMediumIO.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_OPENFORIO_RETURN(this, hrc, 1 /*hrc exception*/, aWritable != FALSE, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUM_OPENFORIO_RETURN(this, hrc, 9 /*unhandled exception*/, aWritable != FALSE, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aMediumIO=%p hrc=%Rhrc\n", this, "Medium::openForIO", *aMediumIO, hrc));
    return hrc;
}

STDMETHODIMP MediumWrap::InternalAndReservedMethod1IMedium()
{
    return E_NOTIMPL;
}

STDMETHODIMP MediumWrap::InternalAndReservedMethod2IMedium()
{
    return E_NOTIMPL;
}

STDMETHODIMP MediumWrap::InternalAndReservedMethod3IMedium()
{
    return E_NOTIMPL;
}

STDMETHODIMP MediumWrap::InternalAndReservedMethod4IMedium()
{
    return E_NOTIMPL;
}

STDMETHODIMP MediumWrap::InternalAndReservedMethod5IMedium()
{
    return E_NOTIMPL;
}

STDMETHODIMP MediumWrap::InternalAndReservedMethod6IMedium()
{
    return E_NOTIMPL;
}

STDMETHODIMP MediumWrap::InternalAndReservedMethod7IMedium()
{
    return E_NOTIMPL;
}

STDMETHODIMP MediumWrap::InternalAndReservedMethod8IMedium()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(MediumWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(MediumWrap, IMedium)
#endif // VBOX_WITH_XPCOM

