// ##### ENDFILE "BooleanFormValueWrap.cpp"


// ##### BEGINFILE "StringFormValueWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IStringFormValue.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_STRINGFORMVALUE

#include "StringFormValueWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(StringFormValueWrap)

//
// IFormValue properties
//

STDMETHODIMP StringFormValueWrap::COMGETTER(Type)(FormValueType_T *aType)
{
    LogRelFlow(("{%p} %s: enter aType=%p\n", this, "StringFormValue::getType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_TYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getType(aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_TYPE_RETURN(this, hrc, 0 /*normal*/,*aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aType=%RU32 hrc=%Rhrc\n", this, "StringFormValue::getType", *aType, hrc));
    return hrc;
}

STDMETHODIMP StringFormValueWrap::COMGETTER(Generation)(LONG *aGeneration)
{
    LogRelFlow(("{%p} %s: enter aGeneration=%p\n", this, "StringFormValue::getGeneration", aGeneration));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGeneration);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_GENERATION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGeneration(aGeneration);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_GENERATION_RETURN(this, hrc, 0 /*normal*/,*aGeneration);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_GENERATION_RETURN(this, hrc, 1 /*hrc exception*/,*aGeneration);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_GENERATION_RETURN(this, hrc, 9 /*unhandled exception*/,*aGeneration);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aGeneration=%RI32 hrc=%Rhrc\n", this, "StringFormValue::getGeneration", *aGeneration, hrc));
    return hrc;
}

STDMETHODIMP StringFormValueWrap::COMGETTER(Enabled)(BOOL *aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%p\n", this, "StringFormValue::getEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_ENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEnabled(aEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_ENABLED_RETURN(this, hrc, 0 /*normal*/,*aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEnabled=%RTbool hrc=%Rhrc\n", this, "StringFormValue::getEnabled", *aEnabled, hrc));
    return hrc;
}

STDMETHODIMP StringFormValueWrap::COMGETTER(Visible)(BOOL *aVisible)
{
    LogRelFlow(("{%p} %s: enter aVisible=%p\n", this, "StringFormValue::getVisible", aVisible));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVisible);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_VISIBLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVisible(aVisible);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_VISIBLE_RETURN(this, hrc, 0 /*normal*/,*aVisible != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_VISIBLE_RETURN(this, hrc, 1 /*hrc exception*/,*aVisible != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_VISIBLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aVisible != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVisible=%RTbool hrc=%Rhrc\n", this, "StringFormValue::getVisible", *aVisible, hrc));
    return hrc;
}

STDMETHODIMP StringFormValueWrap::COMGETTER(Label)(BSTR *aLabel)
{
    LogRelFlow(("{%p} %s: enter aLabel=%p\n", this, "StringFormValue::getLabel", aLabel));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLabel);
        BSTROutConverter TmpLabel(aLabel);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_LABEL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLabel(TmpLabel.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_LABEL_RETURN(this, hrc, 0 /*normal*/,TmpLabel.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_LABEL_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_LABEL_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLabel=%ls hrc=%Rhrc\n", this, "StringFormValue::getLabel", *aLabel, hrc));
    return hrc;
}

STDMETHODIMP StringFormValueWrap::COMGETTER(Description)(BSTR *aDescription)
{
    LogRelFlow(("{%p} %s: enter aDescription=%p\n", this, "StringFormValue::getDescription", aDescription));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDescription);
        BSTROutConverter TmpDescription(aDescription);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_DESCRIPTION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDescription(TmpDescription.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_DESCRIPTION_RETURN(this, hrc, 0 /*normal*/,TmpDescription.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_DESCRIPTION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_DESCRIPTION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDescription=%ls hrc=%Rhrc\n", this, "StringFormValue::getDescription", *aDescription, hrc));
    return hrc;
}

STDMETHODIMP StringFormValueWrap::COMGETTER(Help)(BSTR *aHelp)
{
    LogRelFlow(("{%p} %s: enter aHelp=%p\n", this, "StringFormValue::getHelp", aHelp));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHelp);
        BSTROutConverter TmpHelp(aHelp);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_HELP_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHelp(TmpHelp.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_HELP_RETURN(this, hrc, 0 /*normal*/,TmpHelp.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_HELP_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_HELP_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHelp=%ls hrc=%Rhrc\n", this, "StringFormValue::getHelp", *aHelp, hrc));
    return hrc;
}

STDMETHODIMP StringFormValueWrap::COMGETTER(InternalAndReservedAttribute1IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP StringFormValueWrap::COMGETTER(InternalAndReservedAttribute2IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP StringFormValueWrap::COMGETTER(InternalAndReservedAttribute3IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP StringFormValueWrap::COMGETTER(InternalAndReservedAttribute4IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP StringFormValueWrap::COMGETTER(InternalAndReservedAttribute5IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP StringFormValueWrap::COMGETTER(InternalAndReservedAttribute6IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP StringFormValueWrap::COMGETTER(InternalAndReservedAttribute7IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP StringFormValueWrap::COMGETTER(InternalAndReservedAttribute8IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

//
// IStringFormValue properties
//

STDMETHODIMP StringFormValueWrap::COMGETTER(Multiline)(BOOL *aMultiline)
{
    LogRelFlow(("{%p} %s: enter aMultiline=%p\n", this, "StringFormValue::getMultiline", aMultiline));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMultiline);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_MULTILINE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMultiline(aMultiline);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_MULTILINE_RETURN(this, hrc, 0 /*normal*/,*aMultiline != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_MULTILINE_RETURN(this, hrc, 1 /*hrc exception*/,*aMultiline != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GET_MULTILINE_RETURN(this, hrc, 9 /*unhandled exception*/,*aMultiline != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMultiline=%RTbool hrc=%Rhrc\n", this, "StringFormValue::getMultiline", *aMultiline, hrc));
    return hrc;
}

STDMETHODIMP StringFormValueWrap::COMGETTER(InternalAndReservedAttribute1IStringFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP StringFormValueWrap::COMGETTER(InternalAndReservedAttribute2IStringFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP StringFormValueWrap::COMGETTER(InternalAndReservedAttribute3IStringFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP StringFormValueWrap::COMGETTER(InternalAndReservedAttribute4IStringFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IFormValue methods
//

STDMETHODIMP StringFormValueWrap::InternalAndReservedMethod1IFormValue()
{
    return E_NOTIMPL;
}

STDMETHODIMP StringFormValueWrap::InternalAndReservedMethod2IFormValue()
{
    return E_NOTIMPL;
}

STDMETHODIMP StringFormValueWrap::InternalAndReservedMethod3IFormValue()
{
    return E_NOTIMPL;
}

STDMETHODIMP StringFormValueWrap::InternalAndReservedMethod4IFormValue()
{
    return E_NOTIMPL;
}

//
// IStringFormValue methods
//

STDMETHODIMP StringFormValueWrap::GetString(BSTR *aText)
{
    LogRelFlow(("{%p} %s:enter aText=%p\n", this, "StringFormValue::getString", aText));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aText);


        BSTROutConverter TmpText(aText);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GETSTRING_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getString(TmpText.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GETSTRING_RETURN(this, hrc, 0 /*normal*/, TmpText.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GETSTRING_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_GETSTRING_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aText=%ls hrc=%Rhrc\n", this, "StringFormValue::getString", *aText, hrc));
    return hrc;
}

STDMETHODIMP StringFormValueWrap::SetString(IN_BSTR aText,
                                            IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aText=%ls aProgress=%p\n", this, "StringFormValue::setString", aText, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpText(aText);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_SETSTRING_ENTER(this, TmpText.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setString(TmpText.str(),
                            TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_SETSTRING_RETURN(this, hrc, 0 /*normal*/, TmpText.str().c_str(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_SETSTRING_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STRINGFORMVALUE_SETSTRING_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "StringFormValue::setString", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP StringFormValueWrap::InternalAndReservedMethod1IStringFormValue()
{
    return E_NOTIMPL;
}

STDMETHODIMP StringFormValueWrap::InternalAndReservedMethod2IStringFormValue()
{
    return E_NOTIMPL;
}

STDMETHODIMP StringFormValueWrap::InternalAndReservedMethod3IStringFormValue()
{
    return E_NOTIMPL;
}

STDMETHODIMP StringFormValueWrap::InternalAndReservedMethod4IStringFormValue()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(StringFormValueWrap)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(StringFormValueWrap, IStringFormValue, IFormValue)
#endif // VBOX_WITH_XPCOM

