/*-
 * Copyright (c) 2003 Peter Wemm <peter@FreeBSD.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <machine/asm.h>
__FBSDID("$FreeBSD: releng/12.0/lib/libc/i386/sys/getcontext.S 258451 2013-11-21 22:31:18Z andreast $");

#include <SYS.h>

/*
 * This has to be magic to handle the multiple returns.
 * Otherwise, the setcontext() syscall will return here and we'll
 * pop off the return address and go to the *setcontext* call.
 */
	WEAK_REFERENCE(__sys_getcontext, _getcontext) 
	WEAK_REFERENCE(__sys_getcontext, getcontext)
ENTRY(__sys_getcontext)
	movl	(%esp),%ecx	/* save getcontext return address */
	mov	$SYS_getcontext,%eax
	KERNCALL
	jb	HIDENAME(cerror)
	addl	$4,%esp		/* remove stale (setcontext) return address */
	jmp	*%ecx		/* restore return address */
END(__sys_getcontext)

	.section .note.GNU-stack,"",%progbits
